#!/bin/sh

# Script to configure the SP
# This script MUST be customized before executing
# This script is executed as root on the system to be used as SP
# It requires following files:
# spmetadata.xml
# fedChannel.xml
# fedChannel.template

####################**IMPORTANT**#####################
# All these values must be specified before running the script
# Edit these values and then run the script
######################################################
ORG_DN="dc=sun,dc=com"
IDP_HOST_DOMAIN="hostB.sun.com"
IDP_PORT="58080"
SP_HOST_DOMAIN="hostA.sun.com"
SP_PORT="58080"
PROTOCOL="http"
PASSWORD="11111111"    #amAdmin password
IDSAME_BASEDIR="/opt"
PORTAL_BASEDIR="/opt"
IS_DEPLOY_DESCRIPTOR="amserver"
PS_DEPLOY_DESCRIPTOR="portal"
COOKIE_DOMAIN=".sun.com"

######################################################
# These values may be edited, if required.
######################################################
ADMIN_DN="uid=amAdmin,ou=People,$ORG_DN"

######################################################
# Command definitions
######################################################
AMADMIN=$IDSAME_BASEDIR/SUNWam/bin/amadmin
DPADMIN=$PORTAL_BASEDIR/SUNWps/bin/dpadmin
RM="/usr/bin/rm -f"
CP=/usr/bin/cp
MKDIR=/usr/bin/mkdir
SED=/usr/bin/sed
CAT=/usr/bin/cat

######################################################
# Load sp metadata
######################################################
load_sp_metadata() {
echo "Loading SP metadata..."

FILE="/tmp/spmetadata.xml"
$SED -e "s/\$ORG_DN/$ORG_DN/g" \
     -e "s/\$PROTOCOL/$PROTOCOL/g" \
     -e "s/\$SP_HOST_DOMAIN/$SP_HOST_DOMAIN/g" \
     -e "s/\$SP_PORT/$SP_PORT/g" \
     -e "s/\$IS_DEPLOY_DESCRIPTOR/$IS_DEPLOY_DESCRIPTOR/g" \
     -e "s/\$PS_DEPLOY_DESCRIPTOR/$PS_DEPLOY_DESCRIPTOR/g" \
     -e "s/\$IDP_HOST_DOMAIN/$IDP_HOST_DOMAIN/g" \
     -e "s/\$IDP_PORT/$IDP_PORT/g" \
     -e "s/\$COOKIE_DOMAIN/$COOKIE_DOMAIN/g" \
     spmetadata.xml > $FILE

$AMADMIN --runasdn $ADMIN_DN --password "$PASSWORD" --data $FILE
$RM $FILE
}

######################################################
# Create Federation Channel
######################################################
create_fed_channel() {
echo "Creating Federation Channel..."

FILE="/tmp/fedChannel.xml"
$SED -e "s/\$PROTOCOL/$PROTOCOL/g" \
     -e "s/\$SP_HOST_DOMAIN/$SP_HOST_DOMAIN/g" \
     -e "s/\$SP_PORT/$SP_PORT/g" \
     -e "s/\$IS_DEPLOY_DESCRIPTOR/$IS_DEPLOY_DESCRIPTOR/g" \
     fedChannel.xml > $FILE

#modify dp
$DPADMIN modify -u "$ADMIN_DN" -w "$PASSWORD" -d "$ORG_DN" -m $FILE
$RM $FILE

#copy the channel template
FILE="/etc/opt/SUNWps/desktop/sampleportal/Federation/display.template"
if [ -f $FILE ]; then
    echo "Federation channel template already exists."
    return
else
    echo "Creating federation channel template..."
    $MKDIR /etc/opt/SUNWps/desktop/sampleportal/Federation
    $CP fedChannel.template $FILE
fi
}

######################################################
# Set Global Attributes for Desktop Service
######################################################
set_desktop_svc_attrs() {
echo "Setting desktop service attributes..."

FILE="/tmp/request.xml"
$CAT > $FILE << EOF
<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE Requests PUBLIC "-//iPlanet//iDSAME 5.0 Admin CLI DTD//EN"
  "file:$IDSAME_BASEDIR/SUNWam/dtd/amAdmin.dtd">

<Requests>
  <SchemaRequests serviceName="SunPortalDesktopService" SchemaType="Global">
    <ModifyDefaultValues>
      <AttributeValuePair>
        <Attribute name="sunPortalDesktopEnableAuthlessDesktop"/>
        <Value>false</Value>
      </AttributeValuePair>
      <AttributeValuePair>
        <Attribute name="sunPortalDesktopEnableFederation"/>
        <Value>true</Value>
      </AttributeValuePair>
      <AttributeValuePair>
        <Attribute name="sunPortalDesktopDisableAuthlessForFederatedUsers"/>
        <Value>true</Value>
      </AttributeValuePair>
      <AttributeValuePair>
        <Attribute name="sunPortalDesktopHostedProviderID"/>
        <Value>$PROTOCOL://$SP_HOST_DOMAIN</Value>
      </AttributeValuePair>
    </ModifyDefaultValues>
  </SchemaRequests>
</Requests>
EOF

$AMADMIN --runasdn $ADMIN_DN --password "$PASSWORD" -v --data $FILE
$RM $FILE
}

######################################################
# Create a portal server user "psuser" on SP hostA
######################################################
create_sp_user() {
echo "Creating user=psuser with password=psuser..."

FILE="/tmp/request.xml"
$CAT > $FILE << EOF 
<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE Requests
    PUBLIC "-//iPlanet//Sun ONE Identity Server 6.0 Admin CLI DTD//EN"
    "file:$IDSAME_BASEDIR/SUNWam/dtd/amAdmin.dtd">

<Requests>    
    <PeopleContainerRequests DN="ou=People,$ORG_DN">
      <CreateUser createDN="psuser">
        <AttributeValuePair>
          <Attribute name="userPassword"/>
          <Value>psuser</Value>
        </AttributeValuePair>
        <AttributeValuePair>
          <Attribute name="sn"/>
          <Value>psuser</Value>
        </AttributeValuePair>
        <AttributeValuePair>
          <Attribute name="cn"/>
          <Value>psuser</Value>
        </AttributeValuePair>
      </CreateUser>
    </PeopleContainerRequests>
</Requests>
EOF

$AMADMIN --runasdn $ADMIN_DN --password "$PASSWORD" -v --data $FILE
$RM $FILE
}


######################################################
#  Main
######################################################
load_sp_metadata
create_fed_channel
set_desktop_svc_attrs
create_sp_user

