package com.sun.portal.sample.j2ee.count.provider;

import com.sun.portal.providers.context.ProviderContext;
import com.sun.portal.providers.jsp.JSPProvider;
import com.sun.portal.providers.ProviderException;

import com.sun.portal.sample.j2ee.count.ejb.Count;
import com.sun.portal.sample.j2ee.count.ejb.CountHome;

import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import javax.ejb.CreateException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import java.rmi.RemoteException;


public class CountProvider extends JSPProvider {

    public StringBuffer getContent(HttpServletRequest req, HttpServletResponse res)
                        throws ProviderException {

        Count count = null;
        String errMsg = null;
        try {
           InitialContext ic = new InitialContext();
           Object objRef = ic.lookup("java:comp/env/ejb/counter");
           CountHome home = (CountHome)PortableRemoteObject.narrow(objRef, CountHome.class);
           count = home.create();
        } catch (RemoteException ex) {
              errMsg = "Couldn't create count bean."+ ex.getMessage();
        } catch (CreateException ex) {
              errMsg = "Couldn't create count bean."+ ex.getMessage();
        } catch (NamingException ex) {
              errMsg = "Unable to lookup home: "+ "ejb/counter "+ ex.getMessage();
        }

        ProviderContext ctx = getProviderContext();
        if (count != null) {
            try {
                ctx.setSessionProperty("ejbcounter", new Integer(count.getCount()));
            } catch (java.rmi.RemoteException ex) {
                errMsg = "Failed to access counter bean method. "+ ex.getMessage();
                ctx.setSessionProperty("ejbcounter", errMsg);
            }
        } else {
            ctx.setSessionProperty("ejbcounter", errMsg);
        }

        return super.getContent(req, res);

    }
}

