package com.sun.portal.sample.j2ee.chat.provider;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;

import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOTokenManager;

import com.sun.portal.providers.context.ProviderContext;
import com.sun.portal.providers.jsp.JSPProvider;
import com.sun.portal.providers.ProviderException;

import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import javax.naming.InitialContext;
import javax.naming.NamingException;

import javax.jms.JMSException;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;

public class ChatProvider extends JSPProvider {

    private static final String LOOKUP_STRING_FACTORY = "java:comp/env/jms/sampleTCF";
    private static final String LOOKUP_STRING_TOPIC   = "java:comp/env/jms/sampleTopic";
    private static TopicConnectionFactory TCFactory = null;
    private static Topic topic = null;

    private boolean init() {
        boolean result = true;
        InitialContext ic = null;

        try {
            ic = new InitialContext();
            TCFactory = (TopicConnectionFactory) ic.lookup(LOOKUP_STRING_FACTORY);
            topic = (Topic) ic.lookup(LOOKUP_STRING_TOPIC);
        } catch (Exception e) {
            result = false;
        }

        return result;
    }

    private String getCommonName(HttpServletRequest req) {
        String result = null;

        try {
            SSOTokenManager tokenManager = SSOTokenManager.getInstance();

            if (tokenManager != null) {
                SSOToken token = tokenManager.createSSOToken(req);
                AMStoreConnection conn = new AMStoreConnection(token);
                AMUser user = conn.getUser(token.getPrincipal().getName());
                Set s = user.getAttribute("cn");
                Iterator i = s.iterator();
                if (i.hasNext()) {
                    result = (String)i.next();
                }
            }
        } catch (SSOException ssoe) {
        } catch (AMException ame) {
        }

        return result;
    }

    public StringBuffer getContent(HttpServletRequest req, HttpServletResponse res)
                        throws ProviderException {
  
        String              principal    = getCommonName(req);
        TopicSession        tSession     = null;
        TopicConnection     tConnection  = null;
        TopicPublisher      tPublisher   = null;
        TopicSubscriber     tSubscriber  = null;
        TextMessage         msgReceived  = null;
        StringWriter sw = new StringWriter(); 
        PrintWriter pw = new PrintWriter(sw);
        ProviderContext ctx = getProviderContext();

        if ((TCFactory == null) || (topic == null)) {
            if (!init()) {
                ctx.setSessionProperty("errMsg", "Failed to initialize TopicConnectionFactory or Topic object. Check JNDI registration.");
                return super.getContent(req, res);
            } 
        } 

                try {
                    tConnection = TCFactory.createTopicConnection();
                    tSession = tConnection.createTopicSession(true, TopicSession.CLIENT_ACKNOWLEDGE);
                    tPublisher = tSession.createPublisher(topic);
                    if (principal != null) {
                        tSubscriber = tSession.createDurableSubscriber(topic, principal);
                    } else {
                        tSubscriber = tSession.createSubscriber(topic);
                    }

                    // get any message that needs to be published
                    String  mesg = (String) req.getParameter("chat_mesg");
                    if (mesg != null) {
       
                        TextMessage msgPublised = tSession.createTextMessage();
                        if (principal != null) {
                            msgPublised.setText(principal + ": [" + new Date()+"] : " + mesg);
                            tPublisher.setDeliveryMode(javax.jms.DeliveryMode.PERSISTENT);
                        } else {
                            msgPublised.setText("[" + new Date()+"] : " + mesg);
                            tPublisher.setDeliveryMode(javax.jms.DeliveryMode.NON_PERSISTENT);
                        } 
                        // publishing the message to the topic destination
                        tPublisher.publish(msgPublised);
                        tSession.commit();
                    }

                    tConnection.start();
                    while (true) {
                        msgReceived = (TextMessage) tSubscriber.receive(2000);
                        if (msgReceived != null) {
                            pw.println(msgReceived.getText());
                        } else {
                            break;
                        }
                    }
                    pw.flush();
                    sw.flush();
                    ctx.setSessionProperty("msgReceived", sw.toString());
                } catch (JMSException e) {
                    ctx.setSessionProperty("errMsg", "Failed to publish or recieve msg, error="+e.getLinkedException().toString());
                } finally {
                   if (tConnection != null) {
                       try {
                           if (tPublisher != null) {
                               tPublisher.close();
                           }

                           if (tSubscriber != null) {
                               tSubscriber.close();
                           }

                           if (tSession != null) {
                               tSession.close();
                           } 

                           tConnection.close();
                       } catch (JMSException e) {
                           ctx.setSessionProperty("errMsg", "Failed to cleanup, error="+e.getLinkedException().toString());
                       }
                   }
                   try {
                       pw.close();
                       sw.close();
                   } catch (java.io.IOException ioe) {}
                }
        return super.getContent(req, res);
    }
}

