/*
 * Please read the License Agreement and other supplemental license terms, if 
 * any, accompanying this software package before using any of the software 
 * provided.  If you do not agree to the terms of the License Agreement or any 
 * other supplemental terms, please promptly destroy or return the software to 
 * Sun Microsystems, Inc. 
 * 
 * "CONFIDENTIAL AND PROPRIETARY" Copyright  2003 Sun Microsystems, Inc. 
 * All rights reserved. 
 */ 
 
package com.sun.portal.providers.login;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Cookie;
import java.util.Hashtable;
import java.net.URL;
import java.net.MalformedURLException;
import java.util.Enumeration;

import com.sun.portal.providers.context.ProviderContext;
import com.sun.portal.providers.ProfileProviderAdapter;
import com.sun.portal.providers.ProviderException;
import com.sun.portal.providers.context.ProviderContextException;

public class LoginProvider extends ProfileProviderAdapter {
    public StringBuffer getContent(HttpServletRequest request,
				   HttpServletResponse response) 
				  throws ProviderException 
    {

        if(getProviderContext().isDebugMessageEnabled()) {
	    getProviderContext().debugMessage("LoginProvider.getContent()");
	}

	StringBuffer content = new StringBuffer();
	Hashtable tagTable = new Hashtable();

        String fontFace = "";
        URL loginHelpUrl = null;         
	fontFace = getStringProperty("fontFace1","sans-serif");
	tagTable.put("fontFace1", fontFace);
        loginHelpUrl = getHelp(request, "loginHelpUrl");

        // are persistent cookies enabled? 
	// note: if the property returns true, it
	// must also be the case the the authentication
	// service is set to accept persistent cookies
	
	StringBuffer persistent = new StringBuffer();
	boolean pc = getBooleanProperty("persistentCookie");

        if (pc) {
	    if(getProviderContext().isDebugMessageEnabled()) { 
	         getProviderContext().debugMessage("LoginProvider.getContent(): enabling persistent cookie");
	    }
	    persistent = getTemplate("persistentCookie.template",tagTable);
        } else
            persistent.append("");
	    
	tagTable.put("persistentCookie", persistent.toString());
	if (loginHelpUrl != null) {
	  tagTable.put("loginHelpUrl", loginHelpUrl.toString());
	}
        
        StringBuffer libertyLogin = new StringBuffer();
        boolean federationEnabled = false;
		try {
			if (getProviderContext().getProviderVersion(getName()) >= 2) {
         		federationEnabled = getBooleanProperty("federationEnabled");
			}
		} catch (ProviderContextException pce) {
			if (getProviderContext().isDebugWarningEnabled()) {
				getProviderContext().debugWarning("LoginProvider.getContent():Exception getting login provider version", pce);
			}
			throw new ProviderException("LoginProvider.getContent():Exception getting login provider version", pce);
		}

        if (federationEnabled) {
            String preLoginURL = getStringProperty("preLoginURL", "/portal/dt");
            tagTable.put("preLoginURL", preLoginURL);

            if(getProviderContext().isDebugMessageEnabled()) { 
                 getProviderContext().debugMessage("LoginProvider.getContent(): enabling liberty login");
            }
            libertyLogin = getTemplate("libertyLogin.template", tagTable);
        } else {
            libertyLogin.append("");
        }
        
        tagTable.put("libertyLogin", libertyLogin.toString());

        //get the login url from provider context
	String loginUrl = getProviderContext().getLoginURL();

	/*
	 * Bug # 5085361
	 * get the LBProtocol and use it to create the login URL
	 */
	 
	String reqHost = request.getHeader("host");
	String hostname = null;
	int port = -1;
	if (reqHost != null)
	{
		int idx1, idx2;
		idx1 = reqHost.indexOf(':');
		if (idx1 == -1) 
  		    hostname = new String(reqHost);
		else
		    hostname = reqHost.substring(0,idx1);
	} else {
		hostname = request.getServerName();
	}		
			  
        StringBuffer loginUrlLB = new StringBuffer();
	String lbProtocol = getProviderContext().getConfigProperty("lb." + hostname + ".protocol");
	String lbPort = getProviderContext().getConfigProperty("lb." + hostname + ".port");
		
	if (lbProtocol != null)
        {
                int index = loginUrl.indexOf("://");
		index = loginUrl.indexOf('/' , index + 3);	
                loginUrlLB.append(lbProtocol);
		loginUrlLB.append("://");
		loginUrlLB.append(hostname);
		if (lbPort != null) {
		   loginUrlLB.append(":" + lbPort); 
		}
                loginUrlLB.append(loginUrl.substring(index));
        }
        else
                loginUrlLB.append(loginUrl);

	if (getProviderContext().isDebugMessageEnabled()) {
		getProviderContext().debugMessage("loginURL-->" + loginUrlLB.toString());
	}

        tagTable.put("loginURL", loginUrlLB.toString());
        tagTable.put("channelName", getName());
        content = getTemplate("display.template", tagTable);
        return content;
        
    }

    /**
     * isPresentable() returns true if the template for the front page
     * of the provider exists and returns false if it doesn't exist
     */
    public boolean isPresentable(HttpServletRequest request) {
        boolean isPresentable = false;
        ProviderContext pc = getProviderContext();
        try {
	    if ((getTemplatePath("display.template") != null)) {
              isPresentable = true;
            }
        }
        catch (Exception pe) {
            if (getProviderContext().isDebugMessageEnabled()) {
                getProviderContext().debugMessage("LoginProvider.isPresentable(): Unable to get display.template", pe);
            }
        }
        return isPresentable;
    }

}
