<?xml version="1.0"?>

<!--
  Copyright 2003 Sun Microsystems, Inc. All rights reserved
  Use is subject to license terms.

  $RCSfile: stockquote.xsl,v $ $Revision: 1.2 $ $Date: 2003/08/04 19:43:08 $
-->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" indent="yes"/>

<xsl:template match="/">
<xsl:for-each select="market-data/quote-set/quote">

  <xsl:element name="AmlText">
    <xsl:attribute name="text"> <xsl:value-of select="./@name"/> </xsl:attribute>
    <xsl:apply-templates/>
  </xsl:element>

  <AmlBr />

  <xsl:element name="AmlText">
    <xsl:attribute name="text"> <xsl:value-of select="./@exchange-code"/>, <xsl:value-of select="./@hyperfeed-time"/></xsl:attribute>
    <xsl:apply-templates/>
  </xsl:element>

  <AmlBr />
  <AmlText text="Last "/>

  <xsl:element name="AmlText">
    <xsl:attribute name="text"> <xsl:value-of select="./@last"/> </xsl:attribute>
    <xsl:apply-templates/>
  </xsl:element>

  <AmlBr />
  <AmlText text="Open "/>

  <xsl:element name="AmlText">
    <xsl:attribute name="text"> <xsl:value-of select="./@open"/> </xsl:attribute>
    <xsl:apply-templates/>
  </xsl:element>

  <AmlBr />
  <AmlText text="Change "/>

  <xsl:element name="AmlText">
    <xsl:attribute name="text"> <xsl:value-of select="./@change"/> </xsl:attribute>
    <xsl:apply-templates/>
  </xsl:element>

  <AmlBr />
  <AmlText text="Previous Close "/>

  <xsl:element name="AmlText">
    <xsl:attribute name="text"> <xsl:value-of select="./@close"/> </xsl:attribute>
    <xsl:apply-templates/>
  </xsl:element>

  <AmlBr />
  <AmlText text="% Change "/>

  <xsl:element name="AmlText">
    <xsl:attribute name="text"> <xsl:value-of select="./@percent-change"/> </xsl:attribute>
    <xsl:apply-templates/>
  </xsl:element>

  <AmlBr />
  <AmlText text="Bid "/>

  <xsl:element name="AmlText">
    <xsl:attribute name="text"> <xsl:value-of select="./@bid"/> </xsl:attribute>
    <xsl:apply-templates/>
  </xsl:element>

  <AmlBr />
  <AmlText text="Volume "/>

  <xsl:element name="AmlText">
    <xsl:attribute name="text"> <xsl:value-of select="./@volume"/> </xsl:attribute>
    <xsl:apply-templates/>
  </xsl:element>

  <AmlBr />
  <AmlText text="Ask "/>

  <xsl:element name="AmlText">
    <xsl:attribute name="text"> <xsl:value-of select="./@ask"/> </xsl:attribute>
    <xsl:apply-templates/>
  </xsl:element>

  <AmlBr />
  <AmlText text="Day's High "/>

  <xsl:element name="AmlText">
    <xsl:attribute name="text"> <xsl:value-of select="./@high"/> </xsl:attribute>
    <xsl:apply-templates/>
  </xsl:element>

  <AmlBr />
  <AmlText text="52 Week High "/>

  <xsl:element name="AmlText">
    <xsl:attribute name="text"> <xsl:value-of select="./@high-52-week"/> </xsl:attribute>
    <xsl:apply-templates/>
  </xsl:element>

  <AmlBr />
  <AmlText text="Day's Low "/>

  <xsl:element name="AmlText">
    <xsl:attribute name="text"> <xsl:value-of select="./@low"/> </xsl:attribute>
    <xsl:apply-templates/>
  </xsl:element>

  <AmlBr />
  <AmlText text="52 Week Low "/>

  <xsl:element name="AmlText">
    <xsl:attribute name="text"> <xsl:value-of select="./@low-52-week"/> </xsl:attribute>
    <xsl:apply-templates/>
  </xsl:element>

</xsl:for-each>
</xsl:template>
</xsl:stylesheet>
