<%-- Perform the checks for number of channels tht can be added or remove --%>
<%
  List    selectedChannels      = wcp.getOrderedSelectedChannels(request);
  List    availableChannels     = wcp.getAvailableChannels(request);

  int numVoiceChannelsThatCanBeAdded = 0;
  int numVoiceChannelsThatCanBeRemoved = 0;
      
  int numAvailableChannels = 0;
  if (availableChannels != null) {
    numAvailableChannels = availableChannels.size();
  }

  List pfList = wcp.getProviderContext().getClientAndLocalePropertiesFilters();
  pageContext.setAttribute("pfList", pfList);
      
  for (int i=0; i<numAvailableChannels; i++) {
    String channelName      = (String)availableChannels.get(i);
    
    // For voice desktop, we check tht the required grammarURL and promptURL
    // properties are present

    if ((wcp.getProviderContext().getStringProperty(channelName, "grammarURL", pfList) != null) &&
	(wcp.getProviderContext().getStringProperty(channelName, "promptRoot", pfList) != null) &&
	(wcp.getProviderContext().getStringProperty(channelName, "persona", pfList) != null) &&
	(wcp.getProviderContext().getStringProperty(channelName, "channelPrompt", pfList) != null)) {
	
      if ((selectedChannels != null) && (selectedChannels.contains(channelName))) {
        ++numVoiceChannelsThatCanBeRemoved;
      } else {
        ++numVoiceChannelsThatCanBeAdded;
      }
    } else {
      // Remove from the orderedChannelList, if necessary
      if ((orderedChannelList != null) && (orderedChannelList.contains(channelName))) {
        orderedChannelList.remove(channelName);
      }
    }
  }

  boolean isAuthless = wcp.getProviderContext().isAuthless(request);
  if (isAuthless) {
    pageContext.setAttribute("isAuthless", "true");
  } else {
    pageContext.setAttribute("isAuthless", "false");
  }
	
  // Do we end up with an empty list?
  if ((orderedChannelList != null) && (orderedChannelList.size() > 0 )) {
    pageContext.setAttribute("isEmpty", "false");
  } else {
    pageContext.setAttribute("isEmpty", "true");
  }

  // Transfer our findings into pageContext
  if ((numVoiceChannelsThatCanBeAdded > 0) && (! isAuthless)) {
    pageContext.setAttribute("isAdd", "true");
  } else {
    pageContext.setAttribute("isAdd", "false");
  }

  if ((numVoiceChannelsThatCanBeRemoved > 1) && (! isAuthless)) {
    pageContext.setAttribute("isRemove", "true");
  } else {
    pageContext.setAttribute("isRemove", "false");
  }
	
  if (((numVoiceChannelsThatCanBeAdded > 0) || (numVoiceChannelsThatCanBeRemoved > 1)) && (! isAuthless)) {
    pageContext.setAttribute("isAddOrRemove", "true");
  } else {
    pageContext.setAttribute("isAddOrRemove", "false");
  }
%>
