<?xml version="1.0"?>
<%@ include file="docTypeDeclaration.jsp" %>

<%@ taglib uri="/tld/wireless_util.tld" prefix="util" %>

<%-- Get top level common setup --%>
<%@ include file="dtSetup.jsp" %>

<%-- Voice setup --%>
<%@ include file="voiceSetup.jsp" %>

<%-- Obtain the container in taglib context --%>
<dt:obtainContainer container="$JSPProvider">
<dtpc:getStringProperty id="persona"    pfList="$pfList" key="persona"/>
<dtpc:getStringProperty id="promptRoot" pfList="$pfList" key="promptRoot"/>
<dtpc:getStringProperty id="grammarURL" pfList="$pfList" key="grammarURL"/>

<%-- main voice desktop --%>
<vxml version="2.0" application="<util:url comp="voiceDt" file="dialogs/dtVoiceRoot.jsp" deferLookup="true"/>">
<%-- util:url should translate to /portal/ma?comp=voiceDt&amp;file=dialogs/dtVoiceRoot.jsp --%>
	  
  <%-- document variables --%>
  <var name="currCmdGreeting"/>
  <var name="currAckGreeting"/>
  <var name="currDelayGreeting"/>
  <var name="looped" expr="'false'"/>
  <var name="promptPath" expr="'<jx:expr value="$promptRoot"/>/<jx:expr value="$persona"/>/'"/>   

  <%-- Some script to do prompt rotation --%>
  <script>
    var cmdGreetings = [ "which_channel_would_you_like.wav", 
                         "which_channel_do_you_want.wav",
                         "what_can_i_get_for_you.wav",
                         "what_else_can_i_get_for_you.wav",
                         "whats_next.wav", 
                         "what_channel_would_you_like_next.wav" ];

    var ackGreetings = [ "ok.wav",
                         "all_right.wav",
                         "you_bet.wav",
                         "you_got_it.wav",
                         "sure.wav",
                         "great.wav" ];

    var delayGreetings = [
	                 "hang_on.wav",
	                 "hold_on.wav",
			 "just_a_moment.wav" ];

    function getRandom(x) {
      var len = x.length;
      var idx = Math.round(Math.random() * (len-1));
      return x[idx];
   }
  </script>


  <%-- Document grammar --%>  
  <link event="whatAreMyChoices">
    <grammar src="<dtpc:getStaticContentPath/>/<jx:expr value="$grammarURL"/>#Choices"/>
  </link>

    
  <%-- Welcome Msg --%>
  <form id="announceSignIn">
    <var name="user" expr="'<dtpc:getStringAttribute key="givenname"/>'"/>
    <block>
      <%-- Set the random prompt --%>
      <script>
        currCmdGreeting = getRandom(cmdGreetings);
        currAckGreeting = getRandom(ackGreetings);
        currDelayGreeting = getRandom(delayGreetings);
      </script>
    </block>

    <block>
      <if cond="user != 'null'">
        <audio expr="promptPath + 'hello.wav'"/>
        <audio><value expr="user"/>.</audio>
        <audio expr="promptPath + 'youre_signed_in.wav'"/>
      <else/>
        <audio expr="promptPath + 'hello.wav'"/>
        <audio expr="promptPath + 'youre_signed_in.wav'"/>
      </if>
      <goto next="#chooserMain"/>
    </block>
  </form>

  <%-- re-entry into channel chooser --%>
  <form id="returningToMain">
    <block>
      <%-- Set the random prompt --%>
      <script>
        currCmdGreeting = getRandom(cmdGreetings);
        currAckGreeting = getRandom(ackGreetings);
        currDelayGreeting = getRandom(delayGreetings);
      </script>

      <assign name="looped" expr="'true'"/>
      <audio expr="promptPath + 'were_back_at_the_portal_main_menu.wav'"/>
      <goto next="#chooserMain"/>
    </block>
  </form>

  <%-- Main Menu --%>
  <jx:choose>
  <jx:when test="$isEmpty == 'false'">
  <menu id="chooserMain" dtmf="true">
    <prompt cond="looped != 'true'" bargein="true">
      <audio expr="promptPath + 'here_are_the_portal_channels_you_can_choose_from.wav'"/>
      <enumerate>
        <value expr="_prompt"/>
      </enumerate>
      <audio expr="promptPath + 'thats_it.wav'"/>
      <jx:if test="$isAdd == 'true'">
        <audio expr="promptPath + 'you_can_also_say_add_a_channel.wav'"/>
      </jx:if>
      <audio expr="promptPath + 'which_would_you_like.wav'"/>
    </prompt>

    <prompt cond="looped == 'true'">
      <audio expr="promptPath + currCmdGreeting"/>
    </prompt>
		  
    <jx:forEach var="channel" items="$orderedChannelList">
      <dtcpc:obtainChannelFromContainer channel="$channel">
        <dtpc:providerContext>
          <choice next="#<dt:getName/>">
            <grammar src="<dtpc:getStaticContentPath/>/<dtpc:getStringProperty pfList="$pfList" key="grammarURL"/>"/>
            <audio src="<dtpc:getStringProperty pfList="$pfList" key="promptRoot"/>/<dtpc:getStringProperty pfList="$pfList" key="persona"/>/<dtpc:getStringProperty pfList="$pfList" key="channelPrompt"/>">
              <dt:getTitle/>
            </audio>
          </choice>
        </dtpc:providerContext>
      </dtcpc:obtainChannelFromContainer>
    </jx:forEach>

    <%-- Silent choices/grammar --%>
    <choice next="#removeChannel">
      <grammar src="<dtpc:getStaticContentPath/>/<jx:expr value="$grammarURL"/>#RemoveChannel"/>
    </choice>

    <choice next="#addChannel">
      <grammar src="<dtpc:getStaticContentPath/>/<jx:expr value="$grammarURL"/>#AddChannel"/>
    </choice>

    <%-- Deal with no input, no match --%>
    <noinput count="1">
      <audio expr="promptPath + 'sorry_i_didnt_hear_anything.wav'"/>
      <audio expr="promptPath + 'please_say_the_name_of_a_channel_or_say_what_are_m.wav'"/>
    </noinput>

    <noinput count="2">
      <audio expr="promptPath + 'sorry_i_still_didnt_hear_anything.wav'"/>
      <prompt>
        <audio expr="promptPath + 'please_say_one_of_these_channels.wav'"/>
        <enumerate>
          <value expr="_prompt"/>
        </enumerate>
        <jx:if test="$isAdd == 'true'">
          <audio expr="promptPath + 'you_can_also_say_add_a_channel_mid_.wav'"/>
        </jx:if>
        <audio expr="promptPath + 'or_to_find_out_more_say_help.wav'"/>
      </prompt>
    </noinput>

    <noinput count="5">
      <goto next="#tooManyNo"/>
    </noinput>

    <nomatch count="1">
      <audio expr="promptPath + 'sorry_i_didnt_get_that.wav'"/>
      <audio expr="promptPath + 'please_say_the_name_of_a_channel_or_to_hear_the_li.wav'"/>
    </nomatch>

    <nomatch count="2">
      <audio expr="promptPath + 'sorry_i_still_didnt_get_that.wav'"/>
      <prompt>
        <audio expr="promptPath + 'please_say_one_of_these_channels.wav'"/>
        <enumerate>
          <value expr="_prompt"/>
        </enumerate>
        <jx:if test="$isAdd == 'true'">
          <audio expr="promptPath + 'you_can_also_say_add_a_channel_mid_.wav'"/>
        </jx:if>
        <audio expr="promptPath + 'or_to_find_out_more_say_help.wav'"/>
      </prompt>
    </nomatch>		

    <nomatch count="5">
      <goto next="#tooManyNo"/>
    </nomatch>

    <help>
      <%-- Super long winded message --%>
      <audio expr="promptPath + 'ok_heres_some_help.wav'"/>
      <audio expr="promptPath + 'were_at_the_portal_main_menu_here_you_can_choose_f.wav'"/>
      <audio expr="promptPath + 'and_when_youre_done_you_can_say_main_menu_to_come_.wav'"/>
      <audio expr="promptPath + 'you_can_also_customize_your_list_of_channels_just_.wav'"/>
      <audio expr="promptPath + 'now_what_can_i_help_you_with.wav'"/>
    </help>

    <catch event="whatAreMyChoices">
      <prompt bargein="true">
        <audio expr="promptPath + 'here_are_the_portal_channels_you_can_choose_from.wav'"/>
        <enumerate>
          <value expr="_prompt"/>
        </enumerate>
        <audio expr="promptPath + 'thats_it.wav'"/>
        <jx:if test="$isAddOrRemove == 'true'">
          <audio expr="promptPath + 'you_can_also_say_add_a_channel_or_remove_a_channel.wav'"/>
        </jx:if>
        <audio expr="promptPath + 'which_would_you_like.wav'"/>
      </prompt>
    </catch>
  </menu>
  </jx:when>
  <jx:otherwise>
  <menu id="chooserMain">
    <prompt bargein="true">
      <audio expr="promptPath + 'you_dont_have_any_portal_channels_in_your_list_to_.wav'"/>
    </prompt>

    <%-- Silent choices/grammar --%>
    <choice next="#removeChannel">
      <grammar src="<dtpc:getStaticContentPath/>/<jx:expr value="$grammarURL"/>#RemoveChannel"/>
    </choice>

    <choice next="#addChannel">
      <grammar src="<dtpc:getStaticContentPath/>/<jx:expr value="$grammarURL"/>#AddChannel"/>
    </choice>

    <%-- Deal with no input, no match --%>
    <noinput count="1">
      <audio expr="promptPath + 'to_use_voice_portal_you_need_to_add_some_portal_ch.wav'"/>
    </noinput>

    <noinput count="2">
      <audio expr="promptPath + 'sorry_i_didnt_hear_anything.wav'"/>
      <audio expr="promptPath + 'to_get_started_just_say_add_a_channel.wav'"/>
    </noinput>

    <noinput count="3">
      <audio expr="promptPath + 'sorry_i_still_didnt_hear_anything.wav'"/>
      <audio expr="promptPath + 'to_use_voice_portal_you_need_to_add_some_portal_ch.wav'"/>
    </noinput>

    <noinput count="5">
      <goto next="#tooManyNo"/>
    </noinput>

    <nomatch count="1">
      <audio expr="promptPath + 'sorry_i_didnt_get_that.wav'"/>
      <audio expr="promptPath + 'to_use_voice_portal_you_need_to_add_some_portal_ch.wav'"/>
    </nomatch>

    <nomatch count="2">
      <audio expr="promptPath + 'sorry_i_still_didnt_get_that.wav'"/>
      <audio expr="promptPath + 'to_get_started_just_say_add_a_channel.wav'"/>
    </nomatch>		

    <nomatch count="3">
      <audio expr="promptPath + 'sorry_i_still_didnt_get_that.wav'"/>
      <audio expr="promptPath + 'to_use_voice_portal_you_need_to_add_some_portal_ch.wav'"/>
    </nomatch>		

    <nomatch count="5">
      <goto next="#tooManyNo"/>
    </nomatch>

    <help>
      <audio expr="promptPath + 'to_use_voice_portal_you_need_to_add_some_portal_ch.wav'"/>
    </help>

    <catch event="whatAreMyChoices">
      <audio expr="promptPath + 'to_use_voice_portal_you_need_to_add_some_portal_ch.wav'"/>
    </catch>
  </menu>
  </jx:otherwise>
  </jx:choose>

  <%-- Going to choosen channel --%>
  <jx:if test="$isEmpty == 'false'">
  <jx:forEach var="channel" items="$orderedChannelList">
    <dtcpc:obtainChannelFromContainer channel="$channel">
      <form id="<dt:getName/>">
        <block>
          <script>
            currAckGreeting = getRandom(ackGreetings);
            currDelayGreeting = getRandom(delayGreetings);
          </script>

          <audio expr="promptPath + currAckGreeting"/>
          <audio src="<dtpc:getStringProperty pfList="$pfList" key="promptRoot"/>/<dtpc:getStringProperty pfList="$pfList" key="persona"/>/<dtpc:getStringProperty pfList="$pfList" key="channelPrompt"/>">
            <dt:getTitle/>
          </audio>
          <audio expr="promptPath + 'when_youre_done_say_main_menu.wav'"/>
          <audio expr="promptPath + currDelayGreeting"/>
        </block>

        <dt:getName id="dtgn" />
        <%
	  Map map = new HashMap();
		    
          map.put("provider", pageContext.getAttribute("dtgn"));		    
	  map.put("last", "false");
		    
          pageContext.setAttribute("qmap", map);
	%>
        <subdialog name="<dt:getName/>" src="<dtpc:getDesktopURL querymap="$qmap" escape="true"/>">
          <filled>
            <goto next="#dispatchDone"/>
          </filled>
        </subdialog>
      </form>
    </dtcpc:obtainChannelFromContainer>
  </jx:forEach>
  </jx:if>
	    
  <%-- Add channel --%>
  <form id="addChannel">
    <jx:choose>
      <jx:when test="$isAdd == 'true'">
        <block>
          <dt:getName id="dtgn" />
          <%
            Map map = new HashMap();
		      
	    map.put("mode", "add");
	    map.put("action", "edit");
	    map.put("provider", "WirelessJSPContentChannel");
	    map.put("container", pageContext.getAttribute("dtgn"));

            pageContext.setAttribute("qmap", map);
	  %>
          <goto next="<dtpc:getDesktopURL querymap="$qmap" escape="true"/>" />
        </block>
      </jx:when>
      <jx:otherwise>
        <block>
          <audio expr="promptPath + 'sorry_but_there_are_no_more_channels_we_can_add_ri.wav'"/>
          <goto next="#returningToMain"/>
        </block>
      </jx:otherwise>
    </jx:choose>
  </form>

  <%-- Remove channel --%>
  <form id="removeChannel">
    <jx:choose>
      <jx:when test="$isRemove == 'true'">
        <block>
          <dt:getName id="dtgn" />
          <%
            Map map = new HashMap();
		      
	    map.put("mode", "remove");
	    map.put("action", "edit");
	    map.put("provider", "WirelessJSPContentChannel");
	    map.put("container", pageContext.getAttribute("dtgn"));

            pageContext.setAttribute("qmap", map);
	  %>
          <goto next="<dtpc:getDesktopURL querymap="$qmap" escape="true"/>" />
        </block>
      </jx:when>
      <jx:otherwise>
        <block>
          <audio expr="promptPath + 'sorry_but_there_are_no_channels_that_can_be_remove.wav'">
            <break time="75ms"/>
          </audio>
          <goto next="#returningToMain"/>
        </block>
      </jx:otherwise>
    </jx:choose>
  </form>

  <%-- Return to main menu after subdialog or action is completed --%>
  <form id="dispatchDone">
    <block>
      <goto next="#returningToMain"/>
    </block>
  </form>

  <%-- Acknowledgement --%>
  <form id="ack">
    <block>
      <audio expr="promptPath + 'ok.wav'" />
      <goto next="#returningToMain"/>
    </block>
  </form>

  <%-- Canceled --%>
  <form id="canceled">
    <block>
      <audio expr="promptPath + 'ok_canceled.wav'" />
      <goto next="#returningToMain"/>
    </block>
  </form>

  <%-- Start Over --%>
  <form id="startOver">
    <block>
      <audio expr="promptPath + 'ok_lets_start_over.wav'" />
      <goto next="#returningToMain"/>
    </block>
  </form>

  <%-- Goodbye --%>
  <form id="goodbye">
    <subdialog src="#unloadVoicelets"/>
		
    <block>
      <audio expr="promptPath + 'thanks_for_calling_voice_portal_gbye.wav'" />
      <goto next="#disconnect"/>
    </block>
  </form>

  <%-- Disconnect --%>
  <form id="disconnect">
    <block>
      <jx:choose>
        <jx:when test="$isAuthless == 'false'">
          <goto next="<dtpc:getLogoutURL/>"/>
        </jx:when>
	<jx:otherwise>
	  <exit/>
	</jx:otherwise>
      </jx:choose>
    </block>
  </form>
	    
  <%-- Too Many NoMatch or NoInputs --%>
  <form id="tooManyNo">
    <block>
      <audio expr="promptPath + 'im_sorry_were_having_trouble_lets_try_again_from_t.wav'" />
      <goto next="#returningToMain"/>
    </block>
  </form>

  <%-- Unload Voicelets --%>
  <form id="unloadVoicelets">
    <jx:if test="$isAuthless == 'false'">
      <%
        // for unloading of voicelets
        String urlForUnloadingVoicelets = null;
  	      
        try {
          com.iplanet.sso.SSOToken sso_token = com.iplanet.sso.SSOTokenManager.getInstance().createSSOToken(request);
          if (sso_token != null) {
            urlForUnloadingVoicelets = sso_token.encodeURL("/jsp/default/launchVoicelet.jsp?action=unload");
  	  }
        } catch (Exception e) {
        }
  	      
        if (urlForUnloadingVoicelets != null) {
      %>
      <subdialog src="<dtpc:getStaticContentPath/><%= urlForUnloadingVoicelets %>#unloadApp">
        <param name="p_root"    value="<jx:expr value="$promptRoot"/>"/>
        <param name="p_persona" value="<jx:expr value="$persona"/>"/>
      </subdialog>
      <%
        }
      %>
    </jx:if>
	      
    <block>
      <return/>
    </block>
  </form>		
	      
  <%-- Catching global grammars --%>

  <%-- Leaving --%>
  <catch event="goBye">
    <goto next="#goodbye"/>
  </catch>

  <%-- Main Menu --%>
  <catch event="goMain">
    <goto next="#ack"/>
  </catch>

  <%-- Cancel --%>
  <catch event="goCancel">
    <goto next="#canceled"/>
  </catch>

</vxml>

</dt:obtainContainer>
