<%-- Generate the add channel dialogs --%>
  <%-- Documents variables --%>
  <var name="action" expr="'process'"/>
  <var name="provider" expr="'WirelessJSPContentChannel'"/>
  <var name="container" expr="'<%=container%>'"/>
  <var name="mode" expr="'<%=mode%>'"/>
  <var name="channel"/>
  <var name="nextURL"/>
		
  <link event="whatAreMyChoices">
    <grammar src="<dtpc:getStaticContentPath/>/<jx:expr value="$grammarURL"/>#Choices"/>
  </link>

<jx:choose>
  <jx:when test="$isMultiAdd == 'true'">

  <%-- Main Menu --%>
  <menu id="addMenu" dtmf="true">
    <prompt>
      <audio expr="promptPath + 'sure.wav'" />
      <audio expr="promptPath + 'heres_the_list_of_channels_you_can_add.wav'"/>
      <enumerate>
        <value expr="_prompt"/>
      </enumerate>
      <audio expr="promptPath + 'thats_it.wav'"/>
      <audio expr="promptPath + 'tell_me_which_one_you_want_to_add_or_say_cancel.wav'"/>
    </prompt>
		  
    <jx:forEach var="channel" items="$adjustedAddChannels">
      <dtcpc:obtainChannelFromContainer channel="$channel">
        <dtpc:providerContext>
          <choice next="#<dt:getName/>">
            <grammar src="<dtpc:getStaticContentPath/>/<dtpc:getStringProperty pfList="$pfList" key="grammarURL"/>"/>
            <audio src="<dtpc:getStringProperty pfList="$pfList" key="promptRoot"/>/<dtpc:getStringProperty pfList="$pfList" key="persona"/>/<dtpc:getStringProperty pfList="$pfList" key="channelPrompt"/>">
              <dt:getTitle/>
            </audio>
          </choice>
        </dtpc:providerContext>
      </dtcpc:obtainChannelFromContainer>
    </jx:forEach>

    <%-- Deal with no input, no match --%>
    <noinput count="1">
      <audio expr="promptPath + 'sorry_i_didnt_hear_anything.wav'"/>
      <audio expr="promptPath + 'please_say_the_name_of_the_channel_you_want_to_add.wav'"/>
    </noinput>

    <noinput count="2">
      <audio expr="promptPath + 'sorry_i_still_didnt_hear_anything.wav'"/>
      <prompt>
        <audio expr="promptPath + 'please_add_one_of_these_channels.wav'"/>
        <enumerate>
          <value expr="_prompt"/>
        </enumerate>
        <audio expr="promptPath + 'tell_me_which_one_you_want_to_add_or_say_cancel.wav'"/>
      </prompt>
    </noinput>
	
    <nomatch count="1">
      <audio expr="promptPath + 'sorry_i_didnt_get_that.wav'"/>
      <audio expr="promptPath + 'please_say_the_name_of_the_channel_you_want_to_add.wav'"/>
    </nomatch>

    <nomatch count="2">
      <audio expr="promptPath + 'sorry_but_i_still_didnt_get_that.wav'"/>
      <prompt>
        <audio expr="promptPath + 'please_add_one_of_these_channels.wav'"/>
        <enumerate>
          <value expr="_prompt"/>
        </enumerate>
        <audio expr="promptPath + 'tell_me_which_channel_you_want_to_add_or_say_cance.wav'"/>
      </prompt>
    </nomatch>		

    <help>
      <%-- Super long winded message --%>
      <audio expr="promptPath + 'ok_heres_some_help.wav'"/>
      <audio expr="promptPath + 'were_in_the_process_of_adding_a_channel.wav'"/>
      <audio expr="promptPath + 'you_can_say_the_name_of_any_of_any_of_the_channels.wav'"/>
      <audio expr="promptPath + 'if_you_didnt_want_to_add_a_channel_say_cancel.wav'"/>
    </help>

    <catch event="whatAreMyChoices">
      <prompt>
        <audio expr="promptPath + 'here_are_the_portal_channels_you_can_add.wav'"/>
        <enumerate>
          <value expr="_prompt"/>
        </enumerate>
        <audio expr="promptPath + 'say_one_of_these_channels_or_say_cancel.wav'"/>
        <audio expr="promptPath + 'which_would_you_like.wav'"/>
      </prompt>
    </catch>

  </menu>
  </jx:when>
  <jx:otherwise>
  <%-- Single Channel --%>
  <jx:forEach var="channel" items="$adjustedAddChannels">
    <dtcpc:obtainChannelFromContainer channel="$channel">
      <dtpc:providerContext>
        <form id="addMenu">
          <var name="promptURL" expr="'<dtpc:getStringProperty pfList="$pfList" key="promptRoot"/>/<dtpc:getStringProperty pfList="$pfList" key="persona"/>/<dtpc:getStringProperty pfList="$pfList" key="channelPrompt"/>'"/>
		      
          <field name="yesno">
            <grammar src="<dtpc:getStaticContentPath/>/<jx:expr value="$grammarURL"/>#YesNo"/>

            <prompt>
              <audio expr="promptPath + 'theres_one_more_channel_you_can_add.wav'"/>
              <audio expr="promptURL">
                <dt:getTitle/>
              </audio>
              <audio expr="promptPath + 'would_you_like_to_add_it.wav'"/>
            </prompt>

            <filled>
              <if cond="yesno == 'yes'">
                <goto next="#<dt:getName/>"/>
              <elseif cond="yesno == 'no'"/>
                <throw event="goMain"/>
              <else/>
                <throw event="nomatch"/>
              </if>
            </filled>
          </field>

          <%-- Deal with no input, no match --%>
          <noinput count="1">
            <audio expr="promptPath + 'sorry_i_didnt_hear_anything.wav'"/>
            <audio expr="promptPath + 'did_you_want_to_add.wav'"/>
            <audio expr="promptURL">
              <dt:getTitle/>
            </audio>
            <audio expr="promptPath + 'to_your_personalized_list_of_channels.wav'"/>
          </noinput>

          <noinput count="2">
            <audio expr="promptPath + 'sorry_i_still_didnt_hear_anything.wav'"/>
            <audio expr="promptPath + 'did_you_want_to_add_this_channel_please_say_yes_or.wav'"/>
          </noinput>
	
          <nomatch count="1">
            <audio expr="promptPath + 'sorry_i_didnt_get_that.wav'"/>
            <audio expr="promptPath + 'did_you_want_to_add.wav'"/>
            <audio expr="promptURL">
              <dt:getTitle/>
            </audio>
            <audio expr="promptPath + 'to_your_personalized_list_of_channels.wav'"/>
          </nomatch>

          <nomatch count="2">
            <audio expr="promptPath + 'sorry_but_i_still_didnt_get_that.wav'"/>
            <audio expr="promptPath + 'did_you_want_to_add_this_channel_please_say_yes_or.wav'"/>
          </nomatch>
    
          <help>
            <%-- Super long winded message --%>
            <audio expr="promptPath + 'ok_heres_some_help.wav'"/>
            <audio expr="promptPath + 'right_now_were_in_the_process_of_adding_a_channel_.wav'"/>
            <audio expr="promptPath + 'theres_just_one_more_channel_you_can_add.wav'"/>
            <audio expr="promptURL">
              <dt:getTitle/>
            </audio>
            <audio expr="promptPath + 'did_you_want_to_add_it_please_say_yes_or_no.wav'"/>
          </help>

          <catch event="whatAreMyChoices">
            <audio expr="promptPath + 'did_you_want_to_add.wav'"/>
            <audio expr="promptURL">
              <dt:getTitle/>
            </audio>
            <audio expr="promptPath + 'to_your_list_of_channels_at_the_main_menu.wav'"/>
            <audio expr="promptPath + 'please_say_yes_or_no_or_say_help.wav'"/>
          </catch>
        </form>
      </dtpc:providerContext>
    </dtcpc:obtainChannelFromContainer>
  </jx:forEach>
  </jx:otherwise>
</jx:choose>

  <%-- Choosen channel --%>
  <jx:forEach var="channel" items="$adjustedAddChannels">
    <dtcpc:obtainChannelFromContainer channel="$channel">
      <form id="<dt:getName/>">
        <block>
          <assign name="channel" expr="'<dt:getName/>'"/>

          <dt:getName id="dtgn" />
          <%
            Map map = new HashMap();

            map.put("mode", "add");
            map.put("action", "edit");
            map.put("provider", "WirelessJSPContentChannel");
	    map.put("container", container);
            map.put("c", pageContext.getAttribute("dtgn"));

            pageContext.setAttribute("qmap", map);
          %>
          <assign name="nextURL" expr="'<dtpc:getDesktopURL querymap="$qmap" escape="true"/>'" />
	    
          <goto next="#processEdit"/>
        </block>
      </form>
    </dtcpc:obtainChannelFromContainer>
  </jx:forEach>

  <form id="processEdit">
    <block>
      <submit method="get" namelist="action provider mode container channel nextURL" next="<dtpc:getDesktopURL/>" />
    </block>
  </form>

  <%-- Catching global grammars --%>
    
  <%-- Leaving --%>
  <catch event="goBye">
    <%
      pageContext.setAttribute("qstr", new StringBuffer("provider=").append(container).append("#goodbye").toString());
    %>
    <goto next="<dtpc:getDesktopURL querystring="$qstr" escape="true"/>" />
  </catch>

  <%-- Main Menu --%>
  <catch event="goMain">
    <%
      pageContext.setAttribute("qstr", new StringBuffer("provider=").append(container).append("#ack").toString());
    %>
    <goto next="<dtpc:getDesktopURL querystring="$qstr" escape="true"/>" />
  </catch>

  <%-- Cancel --%>
  <catch event="goCancel">
    <%
      pageContext.setAttribute("qstr", new StringBuffer("provider=").append(container).append("#canceled").toString());
    %>
    <goto next="<dtpc:getDesktopURL querystring="$qstr" escape="true"/>" />
  </catch>
