<?xml version="1.0"?>

<!--
  Copyright 2003 Sun Microsystems, Inc. All rights reserved
  Use is subject to license terms.

  $RCSfile: stockquote.xsl,v $ $Revision: 1.2 $ $Date: 2003/08/04 19:43:09 $
-->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" >

<!-- This is an xsl to produce stockquote in wml -->

<xsl:output omit-xml-declaration="yes" indent="yes"/>

<xsl:template match="/">
   <p>
   <xsl:for-each select="market-data/quote-set/quote">

	<b><xsl:value-of select="./@name"/></b>
    <br/>
    <b><xsl:value-of select="./@exchange-code"/>, <xsl:value-of select="./@hyperfeed-time"/></b>
    <br/>

	<table columns="2">
	<tr>
		<td><b>Symbol:</b></td>
		<td><xsl:value-of select="./@symbol"/></td>
	</tr>
	<tr>
		<td><b>Last:</b></td>
		<td ><xsl:value-of select="./@last"/></td>
	</tr>
	<tr>
		<td><b>Open:</b></td>
		<td><xsl:value-of select="./@open"/></td>
	</tr>
	<tr>
		<td><b>Change:</b></td>
		<td><xsl:value-of select="./@change"/></td>
	</tr>
	<tr>
		<td><b>Volume</b></td>
		<td><xsl:value-of select="./@volume"/></td>
	</tr>
	<tr>
		<td ><b>Day's High:</b></td>
		<td ><xsl:value-of select="./@high"/></td>
	</tr>
	<tr>
		<td ><b>Day's Low:</b></td>
		<td ><xsl:value-of select="./@low"/></td>
	</tr>
	</table>
   </xsl:for-each>
   </p>
</xsl:template>
</xsl:stylesheet>
