<%--
  Copyright 2002 Sun Microsystems, Inc.	 All rights reserved.
  PROPRIETARY/CONFIDENTIAL.  Use of this product is subject to license terms.
--%>

<%-- Get top level common setup --%>
<%@ include file="dtSetup.jsp" %>

<%-- Obtain the container in taglib context --%>
<dt:obtainContainer container="$JSPProvider">

<%-- main wml deck for desktop --%>
<AmlDocument>

<%-- Present channels inline if no maximized channels are present --%>
<jx:choose>
<jx:when test="$hasMaximizedChannel == false">

<%-- first card of deck --%>
<AmlPage next_label="none" prev_label="none" menu_pos="bottom">
  <%-- Set the softkeys --%>
  
  <AmlControlMenu url="#options" label="Options" />

  <%-- Logo and product section --%>
  <%-- logo.jsp --%>
    <AmlImage alt="<dtpc:getStringProperty key="productName"/>" src="<dt:scontent/>/images/MAP/<%=imageName%>"/>
    <AmlBr/>

  <%-- main menu --%>
       <AmlSelectList wml_select_label="View">
          <jx:choose>
            <jx:when test="$channelsAreMinimized == false">
               <%@ include file="channelMenuSection.jsp" %>
            </jx:when>
            <jx:otherwise>
               <%@ include file="minimizedChannelMenuSection.jsp" %>
            </jx:otherwise>
          </jx:choose>
 
          <AmlSelectListItem>
              <AmlLink url="<dtpc:getLogoutURL/>" text="Logout" />
          </AmlSelectListItem>
       </AmlSelectList>
</AmlPage>

<%-- Options card --%>
<%@ include file="optionsCard.jsp" %>

<%-- Channels cards only if channels are not minimized --%>
<jx:if test="$channelsAreMinimized == false">
  <%@ include file="channelsCards.jsp" %>
</jx:if>

</jx:when>

<%-- Display the maximized channel only --%>
<jx:otherwise>
   <dtcpc:obtainChannelFromContainer channel="$maximizedChannel">
     <AmlPage id="max" title="<dt:getTitle/>" next_label="none" prev_label="none" menu_pos="bottom">
            <dt:isEditable id="isEditable"/>
            <dt:getName id="channelName"/>
            <jx:if test="$isEditable == true">
		<%
                   Map map = new HashMap();
                   map.put("action", "edit");
                   map.put("targetprovider", pageContext.getAttribute("channelName"));
                   map.put("provider", wcp.getStringProperty("editContainerName"));
                   pageContext.setAttribute("desktop_qmap", map);
		%>

              <AmlControlMenu url="<dtpc:getDesktopURL querymap="$desktop_qmap" escape="true"/>" type="options" label="Edit"/>
            </jx:if>
   </dtcpc:obtainChannelFromContainer>
       <dtcpc:getContent channel="$maximizedChannel"/>
     </AmlPage>

  </jx:otherwise>
</jx:choose>

</AmlDocument>

</dt:obtainContainer>
