<%-- 
  Copyright 2003 Sun Microsystems, Inc. All rights reserved 
  Use is subject to license terms. 
--%>
<%-- This is a command jsp to parse a specific date and go to that date --%>
<%@ page errorPage="/jsp/default/errorpage.jsp" %>
<%@ page session="false" %>

<%@ taglib uri="/WEB-INF/wireless_cal.tld" prefix="cal" %>
<%@ taglib uri="/WEB-INF/wireless_util.tld" prefix="util" %>

<util:content/> 

<util:catalog resource="cal" id="i18n" />
<cal:context/>
<%
    String freq = request.getParameter("fr");
    String interval = request.getParameter("in");
    String repeatOn = request.getParameter("ro");
    String repeatUntil = request.getParameter("ru");
%>

<%-- Parse user's input and create a new datetime object  --%>
<cal:datetime id="new">
<cal:dateformat format="$[i18n:parsedatefmt]" parse="$(ru)"><%


%><%-- parse fail, provide a cal home and back button --%>
<AmlDocument>
<AmlPage>
<AmlControlMenu><%
    %><AmlURL action="<util:url file="task.jsp" comp="cal"/>"/><%
    %><AmlText text="<%= i18n.getMsg("back") %>"/><%
%></AmlControlMenu><AmlBR/><%

%><AmlControlMenu><%
    %><AmlURL action="<util:url file="taskHm.jsp" comp="cal"/>"/><%
    %><AmlText text="<%= i18n.getMsg("calhm") %>"/><%
%></AmlControlMenu><AmlBR/><%

%><%-- Any error message? --%><%
%><cal:context><%
  %><util:if property="errorCode" value="CAL_001"><%
    %><AmlText bold="true" text="<util:msg name="i18n" key="CAL_001_date"/>"/><%
  %></util:if><%
%></cal:context>
</AmlPage>
</AmlDocument>
</cal:dateformat>
</cal:datetime>


<%-- forward  to doAddRepeat page --%>
<util:forward file="doAddRepeatTask.jsp" comp="cal">
  <util:parm name="fr"><%=freq%></util:parm><%
      %><util:parm name="in"><%=interval%></util:parm><%
      %><util:parm name="ro"><%=repeatOn%></util:parm><%
      %><util:parm name="ru"><%=repeatUntil%></util:parm>
</util:forward>
