<%-- 
 Copyright 2003 Sun Microsystems, Inc. All rights reserved
 Use is subject to license terms.
--%>
<%@ page errorPage="/jsp/default/errorpage.jsp" %>
<%@ page import="com.sun.comclient.calendar.socs.SOCSTodo" %>
<%@ page session="false" %>

<%@ taglib uri="/WEB-INF/wireless_cal.tld" prefix="cal" %>
<%@ taglib uri="/WEB-INF/wireless_util.tld" prefix="util" %>

<util:content/>
<cal:context/>
<util:catalog resource="cal" id="i18n" /><%

    // NOTE: dueDate and dueTime *can be null*
    String ddate = request.getParameter("ddate");
    ddate = (ddate == null) ? "" : ddate.trim() ;

    String dtime = request.getParameter("dtime");
    dtime = (dtime == null) ? "" : dtime.trim() ;
%>

    <%-- Get the task from session  --%>
    <util:session id="new" attribute="new"/><%
    %><cal:task name="new">

    <% if (request.getParameter("mod") != null) { %>
        <cal:set property="modifier" value="$(mod)" />
    <% } %>

    <% if (request.getParameter("sum") != null) { %>
        <cal:set property="summary" value="$(sum)" />
    <% } %>

    <% if (request.getParameter("loc") != null) { %>
        <cal:set property="location" value="$(loc)" />
    <% } %>

    <% if (request.getParameter("des") != null) { %>
        <cal:set property="description" value="$(des)" />
    <% } %>


	<%-- check if task is completed, if so, set the flag --%>
    <% if (request.getParameter("iscmp").equals("1")) { %>
        <cal:set property="status" value="<%= SOCSTodo.STATUS_COMPLETED %>"/>
    <% } else { %>
        <cal:set property="status" value="<%= SOCSTodo.STATUS_IN_PROCESS %>"/>
    <% } %>



  <AmlDocument>
  <% if ((ddate == null) || (ddate.trim().equals(""))) { %>
       <cal:set property="due" value="false"/>

  <% } else {  // i.e. due date exists %>

     <cal:datetime id="dudt">
        <cal:dateformat format="$[i18n:parsedatefmt]" parse="$(ddate)"><%
           %><AmlPage menu_pos="bottom"><%
           %><AmlText bold="true" 
                text="<util:msg name="i18n" key="addTaskfail"/>"/><%

            %><cal:context><%
                %><util:if property="errorCode" value="CAL_001"><%
                    %><AmlBr/><%
                    %><AmlText 
                        bold="true" 
                        text="<util:msg name="i18n" key="CAL_001_date"/>"/><%
                %></util:if><%
            %></cal:context><%

            %><AmlBr/><%
            %><AmlForm method="post" submit_label="<util:msg name="i18n" key="back"/>"><%
        	%><AmlURL action="<util:url file="taskHm.jsp" comp="cal"/>"/><%
        
        	%><AmlInput view="hidden" name="back" value="true"/><%
        	%><AmlInput view="hidden" name="d" value="<util:get eval="$(d)"/>"/><%
        	%><AmlInput view="hidden" name="ddate" value="<util:get eval="$(ddate)"/>"/><%
        	%><AmlInput view="hidden" name="dtime" value="<util:get eval="$(dtime)"/>"/><%
        	%><AmlInput view="hidden" name="sum" value="<util:get eval="$(sum)" edit="emsg1"/>"/><%
        	%><AmlInput view="hidden" name="des" value="<util:get eval="$(des)" edit="emsg1"/>"/><%
        	%><AmlInput view="hidden" name="iscmp" value="<util:get eval="$(iscmp)"/>"/><%
           %></AmlForm><%

            %><%-- provide a calHm link --%><%
            %><AmlControlMenu type="accept"><%
                %><AmlURL action="<util:url file="dayview.jsp" comp="cal"/>"><%
                    %><AmlParam name="d" value="<util:get eval="$(d)"/>"/><%
                %></AmlURL><%
                %><AmlText text="<util:msg name="i18n" key="calhm"/>" /><%
            %></AmlControlMenu>
            </AmlPage>
            </AmlDocument>
     </cal:dateformat>
     </cal:datetime>

    <% if ((dtime != null) && (!(dtime.equals("")))) { %> 
        <cal:set property="dueTimeField" value="true"/>
        <cal:datetime id="dutm">
        <cal:dateformat format="$[i18n:timefmtedit]" parse="$(dtime)">
            <AmlPage menu_pos="bottom"><%
                %><AmlText bold="true" 
                    text="<util:msg name="i18n" key="addTaskfail"/>"/><%
                %><cal:context><%
                    %><util:if property="errorCode" value="CAL_001"><%
                        %><AmlBr/><%
                        %><AmlText text="<util:msg name="i18n" key="CAL_001_due"/>"/><AmlBr/><%
                    %></util:if><%
                %></cal:context><%

                    %><AmlBr/><%
                    %><AmlForm method="post" submit_label="<util:msg name="i18n" key="back"/>"><%
                	%><AmlURL action="<util:url file="taskHm.jsp" comp="cal"/>"/><%

                	%><AmlInput view="hidden" name="back" value="true"/><%
                	%><AmlInput view="hidden" name="d" value="<util:get eval="$(d)"/>"/><%
                	%><AmlInput view="hidden" name="ddate" value="<util:get eval="$(ddate)"/>"/><%
                	%><AmlInput view="hidden" name="dtime" value="<util:get eval="$(dtime)"/>"/><%
                	%><AmlInput view="hidden" name="sum" value="<util:get eval="$(sum)" edit="emsg1"/>"/><%
                	%><AmlInput view="hidden" name="des" value="<util:get eval="$(des)" edit="emsg1"/>"/><%
                	%><AmlInput view="hidden" name="iscmp" value="<util:get eval="$(iscmp)"/>"/><%
                   %></AmlForm><%

                %><AmlControlMenu type="accept"><%
                    %><AmlURL action="<util:url file="dayview.jsp" comp="cal"/>"><%
                        %><AmlParam name="d" value="<util:get eval="$(d)"/>"/><%
                    %></AmlURL><%
                    %><AmlText text="<util:msg name="i18n" key="calhm"/>" /><%
                %></AmlControlMenu><%

                %></AmlPage><%
                %></AmlDocument>
        </cal:dateformat>
            <util:copy property="day" source="dudt"/>
            <util:copy property="month" source="dudt"/>
            <util:copy property="year" source="dudt"/>
        </cal:datetime>
        <cal:set id="dutm" property="dueDate"/>
        <cal:set id="dutm" property="startTime"/>
        <cal:set property="allDay" value="false"/>

    <% } else { %>
        <cal:set id="dudt" property="dueDate"/>
        <cal:set property="allDay" value="true"/>
    <% } //end time processing %>
    <% } //end date processing %>

    <util:forward file="preupdateTask.jsp" comp="cal" />

</cal:task>
