<%-- 
  Copyright 2003 Sun Microsystems, Inc. All rights reserved 
  Use is subject to license terms. 
--%>
<%@ page errorPage="/jsp/default/errorpage.jsp" %>
<%@ page session="false" %>

<%@ taglib uri="/WEB-INF/wireless_cal.tld" prefix="cal" %>
<%@ taglib uri="/WEB-INF/wireless_util.tld" prefix="util" %>
<%@ taglib uri="/WEB-INF/wireless_socs.tld" prefix="socs" %>

<util:content />

<cal:context/>
<util:catalog resource="cal" id="i18n" />
    <%
	  String ad = request.getParameter("ad");
	  String amail = request.getParameter("am");
	  String ainterval = request.getParameter("ai");
	  String date = request.getParameter("date");
	  String msg = request.getParameter("msg");

	if ( amail == null ){
		amail ="";
    }

	int interval =1; // in minutes

	try {
		interval = Integer.parseInt(ainterval);
	} catch(Exception ex) {
            //throw new javax.servlet.jsp.JspException("Invalid interval");
    } 

    %>

<util:session id="new" attribute="new"/>
<cal:task name="new">
    <cal:get id="rem" property="reminderBean" />
    <socs:reminder name="rem">
	<% if ( date != null && (!date.trim().equals("") ) && ainterval != null ) { %>
	    <cal:datetime id="alarmDate">
                <cal:dateformat format="$[i18n:parsedatefmt]" parse="$(date)">
				<AmlDocument>
				<AmlPage>
				    <AmlForm>
                        <cal:context>
                            <util:if property="errorCode" value="CAL_001">
                                <AmlText text="<util:msg name="i18n" key="CAL_001_date"/> "/>
                            </util:if>
                        </cal:context>
				    </AmlForm>
                    <AmlControlMenu url="<util:url path="<%= request.getContextPath()+\"/dt\" %>"/>" type="accept" label="<util:msg name="i18n" key="portalhome"/>"/>
				</AmlPage>
				</AmlDocument>
                </cal:dateformat>
	    </cal:datetime>

	    <cal:datetime id="alarmTime">
                <cal:dateformat format="$[i18n:timefmtedit]" parse="$(ai)">
				<AmlDocument>
				    <AmlPage>
				        <AmlForm>
                            <cal:context>
                                <util:if property="errorCode" value="CAL_001">
                                    <util:msg name="i18n" key="CAL_001_start"/>
                                </util:if>
                            </cal:context>
				        </AmlForm>
                        <AmlControlMenu url="<util:url path="<%= request.getContextPath()+\"/dt\" %>"/>" type="accept" label="<util:msg name="i18n" key="portalhome"/>"/>
				    </AmlPage>
				</AmlDocument>
                </cal:dateformat>
		    <util:copy property="day" source="alarmDate"/>
	  	    <util:copy property="month" source="alarmDate"/>
      	            <util:copy property="year" source="alarmDate"/>
	    </cal:datetime>
	    <cal:set property="absAlarmTime" id="alarmTime"/>
         <% } else if ( ad !=null ) {
		     if (ad.equals("H")) { %>
		    <cal:set property="durationHour" value="<%= String.valueOf(interval) %>" />

	    <% } else if (ad.equals("M")) { %>
		    <cal:set property="durationMin" value="<%= String.valueOf(interval) %>" />

	    <% } else if (ad.equals("D")) { %>
		    <cal:set property="durationDay" value="<%= String.valueOf(interval) %>" />
	    <% } 
		}
		else {
            //should  not be here as ad is null 
        } %> 

	<cal:set property="emailAttendee" value="<%= amail %>" />
    <cal:set property="reminderNote" value="<%= msg %>" />

	</socs:reminder>

    <%-- forward to next page --%>
       <%--  <util:forward file="taskHm.jsp" comp="cal" /> --%>
       <util:forward file="preupdateTask.jsp" comp="cal" />
</cal:task>
