
<%--
  Copyright 2003 Sun Microsystems, Inc. All rights reserved 
  Use is subject to license terms.
--%><%
%><%@ page errorPage="/jsp/default/errorpage.jsp" %><%
%><%@ page session="false" %><%

%><%@ taglib uri="/WEB-INF/wireless_cal.tld" prefix="cal" %><%
%><%@ taglib uri="/WEB-INF/wireless_util.tld" prefix="util" %><%

%><util:content /><%
%><util:catalog resource="cal" id="i18n" /><%
%><cal:context/><%

        // Pass this parameter along
        String d = request.getParameter("d");

%><%-- Get current view date from parameter --%><%
%><cal:datetime id="current"><%
  %><cal:dateformat name="current" format="yyyyMMdd" parse="$(d)"/><%
%></cal:datetime><%


%><%-- set character entity escaping and truncation to 25 characters --%><%
%><util:edit id="edit1"><%
  %><util:set property="truncation" value="$/SunMobileAppCalendarService:sunMobileAppCalendarJspSummaryLength:25/"/><%
  %><util:set property="escape" value="true"/><%
%></util:edit><%


%> <%-- Calendar Dayview (Home)  --%>
<cal:context>
<AmlDocument title="<cal:get property="calendarID"/>">
<AmlPage menu_pos="bottom"><%


%><%-- Get current time object --%>
<AmlText bold="true" text="<util:msg name="i18n" key="calName"/> <cal:get property="calendarID"/>"/><AmlBr/><%
    %><AmlText bold="true" text="<cal:dateformat name="current" format="$[i18n:datefmt]"/>"/>
<AmlBr/><%


%><%-- List events --%><%

    %><%-- If there are no events --%><%
    %><util:if property="eventsEmpty"><%
        %><AmlText text=" <util:msg name="i18n" key="noevents"/>"/><AmlBr/><%
    %></util:if><%


    %><%-- If there are no tasks --%><%
    %><util:if property="tasksEmpty"><%
        %><AmlText text=" <util:msg name="i18n" key="notasks"/>"/><AmlBr/><%
    %></util:if><%


%><%-- TASKS --%><%
%><util:ifnot property="tasksEmpty"><%

    %><cal:tasks id="tasks"><%
        %><cal:set property="start" value="$(start1)"/><%
        %><cal:set property="count" value="$/SunMobileAppCalendarService:sunMobileAppCalendarJspEventNumLines:3/"/><%
    %></cal:tasks><%


    %><cal:tasks name="tasks" iterate="true"><%
      %><cal:task><%
        %><%-- if completed put a [x] --%><%
        %><util:if property="completed"><%
            %><AmlText text="<util:msg name="i18n" key="compl"/> "/><%
        %></util:if><%

        %><%-- if overdue put an [o] --%><%
        %><util:if property="overDue"><%
            %><AmlText text="<util:msg name="i18n" key="overdue"/> "/><%
        %></util:if><%

        %><%-- if all day task put "Due Today" message for all day--%><%
        %><util:if property="allDay"><%
            %><AmlText text="<util:msg name="i18n" key="alldaytask"/> "/><%
        %></util:if><%

        %><%-- if not all day task and if due date print --%><%
        %><util:ifnot property="allDay"><%
           %><util:if property="due"><%
           %><AmlText text="<cal:get id="start" property="dueDate"/> <cal:dateformat name="start" format="$[i18n:timefmt]"/> "/><%
           %></util:if><%
        %></util:ifnot><%

        %><%-- make task link --%><%
        %><AmlLink>
            <AmlURL action="<util:url file="task.jsp" comp="cal"/>">
	            <AmlParam name="d" value="<%= d %>"/>
                    <AmlParam name="tid" value="<cal:get name="tasks" property="index"/>"/>
            </AmlURL><%

            %><%-- summary --%><%
            %><util:if property="summary"><%
                %><AmlText text="<cal:get property="summary" edit="edit1"/>"/></AmlLink><AmlBr/><%
            %></util:if><%

            %><%-- no summary --%><%
            %><util:ifnot property="summary"><%
                %><AmlText text="<util:msg name="i18n" key="nosummary"/>"/></AmlLink><AmlBr/><%
            %></util:ifnot><%
      %></cal:task><%
    %></cal:tasks><%

    %><%-- If there are more tasks --%><%
    %><cal:tasks name="tasks"><%
      %><util:if property="nextPage"><%
          %><AmlLink><%
              %><AmlURL action="<util:url file="dayview.jsp" comp="cal"/>"><%
                 %><AmlParam name="start1" value="<util:get property="nextStart"/>"/><%
                 %><AmlParam name="d" value="<%= d %>"/><%
              %></AmlURL><%
        %><AmlText text="<util:msg name="i18n" key="moreTsks"/>"/></AmlLink><AmlBr/><%
      %></util:if><%
    %></cal:tasks><%

%></util:ifnot><%

%><%-- if there are events --%><%
%><util:ifnot property="eventsEmpty"><%

    %><cal:events id="events"><%
        %><cal:set property="start" value="$(start)"/><%
        %><cal:set property="count" value="$/SunMobileAppCalendarService:sunMobileAppCalendarJspEventNumLines:7/"/><%
    %></cal:events><%

    %><cal:events name="events" iterate="true"><%
    %><cal:event><%

      %><%-- is this an allday event? --%><%
      %><util:if property="allDay"><%
        %><AmlText text="<util:msg name="i18n" key="allday"/> "/> <%
      %></util:if><%

      %><%-- datetime of event --%><%
      %><util:ifnot property="allDay">
        <AmlText text="<cal:get id="start" property="start"/> <cal:dateformat name="start" format="$[i18n:timefmt] "/>"/> <%
      %></util:ifnot><%

      %><%-- event --%><%
      %><AmlLink>
		<AmlURL action="<util:url file="event.jsp" comp="cal"/>">
			<AmlParam name="d" value="<%= d %>"/><%
        		%><AmlParam name="eid" value="<cal:get name="events" property="index"/>"/><%
		%></AmlURL><%

      %><%-- summary --%><%
      %><util:if property="summary"><%
        %><AmlText text="<cal:get property="summary" edit="edit1"/>"/></AmlLink><AmlBr/><%
      %></util:if><%

      %><%-- no summary --%><%
      %><util:ifnot property="summary"><%
        %><AmlText text="<util:msg name="i18n" key="nosummary"/>"/></AmlLink><AmlBr/><%
      %></util:ifnot><%

    %></cal:event><%
  %></cal:events><%

  %><%-- more --%><%
  %><cal:events name="events"><%
    %><util:if property="nextPage">
      <AmlLink>
	<AmlURL action="<util:url file="dayview.jsp" comp="cal"/>">
        	<AmlParam name="d" value="<%= d %>"/>
        	<AmlParam name="start" value="<util:get property="nextStart"/>"/>
	</AmlURL><%
      %><AmlText text="<util:msg name="i18n" key="more"/>"/></AmlLink><AmlBr/><%
    %></util:if><%
  %></cal:events><%

%></util:ifnot><%

%><util:if property="userTheOwner" ><%
    %><%-- add calendar event --%><%
    %><AmlLink><%
    %><AmlURL action="<util:url file="eventSess.jsp" comp="cal"/>"><%
      %><AmlParam name="d" value="<%= d %>"/><%
    %></AmlURL><%
    %><AmlText text="<util:msg name="i18n" key="addevent"/>..."/></AmlLink><%

    %><AmlBr/><%

    %><%-- add calendar task --%><%
    %><AmlLink><%
    %><AmlURL action="<util:url file="taskSess.jsp" comp="cal"/>"><%
      %><AmlParam name="d" value="<%= d %>"/><%
    %></AmlURL><%
    %><AmlText text="<util:msg name="i18n" key="addtask"/>..."/></AmlLink><%
    %><AmlBr/><%

%></util:if><%
%></cal:context><%
    %><AmlLink><%
        %><AmlURL action="<util:url file="subscribed.jsp" comp="cal"/>"><%
        	%><AmlParam name="d" value="<util:get eval="$(d)"/>"/><%
        %></AmlURL><%
    %> <AmlText text="<%= i18n.getMsg("subscribed") %>"/></AmlLink><%
    %><AmlBr/><%
    %><%-- go to --%><%
    %><AmlLink><%
        %><AmlURL action="<util:url file="goto.jsp" comp="cal"/>"><%
            %><AmlParam name="d" value="<%= d %>"/><%
        %></AmlURL><%
    %><AmlText text="<util:msg name="i18n" key="goto"/>..."/></AmlLink><AmlBr/><%

%><%-- next 6 days. get the day object and roll to the next day. --%><%
%><cal:datetime id="view"><%
    %><util:copy property="time" source="current"/><%
%></cal:datetime><%

%><% for (int i=1; i<=6; i++) { %><%
    %><cal:dateroll name="view"/><%
        %><AmlLink><%
                %><AmlURL action="<util:url file="doRoll.jsp" comp="cal"/>"><%
                    %><AmlParam name="d" value="<%= d %>"/><%
                    %><AmlParam name="fd" value="DATE"/><%
                    %><AmlParam name="amt" value="<%= i %>"/><%
                %></AmlURL><%
    %><AmlText text=" <cal:dateformat name="view" format="$[i18n:datefmtshort]"/>"/></AmlLink><AmlBr/><%
%><% } %><%


%><%-- portal home --%><%

  %><AmlControlMenu><%
	%><AmlURL action="<util:url path="<%= request.getContextPath()+\"/dt\" %>"/>"/><%
	%><AmlText text="<util:msg name="i18n" key="portalhome"/>"/><%
  %></AmlControlMenu><AmlBr/><%


%></AmlPage>
</AmlDocument>
