/*
 * Copyright 2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

#ifndef _SYS_MACHINTREG_H
#define	_SYS_MACHINTREG_H

#pragma ident	"@(#)machintreg.h	1.1	05/06/30 SMI"

#ifdef	__cplusplus
extern "C" {
#endif

/*
 * IGN_SIZE can be defined in a platform's makefile. If it is not defined,
 * use a default of 5.
 */
#ifndef IGN_SIZE
#define	IGN_SIZE	5		/* Interrupt Group Number bit size */
#endif
#define	UPAID_TO_IGN(upaid) (upaid)

/*
 * CPU_MONDO and DEV_MONDO  registers
 * for sun4v class of cpus probably should
 * be moved to a new file
 */
#define	CPU_MONDO_Q_HD	0x3c0
#define	CPU_MONDO_Q_TL	0x3c8
#define	DEV_MONDO_Q_HD	0x3d0
#define	DEV_MONDO_Q_TL	0x3d8

/*
 * RESUMABLE_ERROR and NONRESUMABLE_ERROR registers
 * for sun4v class of cpus
 */
#define	CPU_RQ_HD		0x3e0
#define	CPU_RQ_TL		0x3e8
#define	CPU_NRQ_HD		0x3f0
#define	CPU_NRQ_TL		0x3f8

#ifdef	__cplusplus
}
#endif

#endif	/* _SYS_MACHINTREG_H */
