<%--
/*
 * Copyright 2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 *
 * ident	"@(#)DiskStatus.jsp	1.3	05/11/04 SMI"
 */
--%>

<%@page info="DiskStatus" language="java" %> 
<%@taglib uri="/WEB-INF/tld/com_iplanet_jato/jato.tld" prefix="jato"%> 
<%@taglib uri="/WEB-INF/tld/com_sun_cluster_spm/spm.tld" prefix="spm"%>
<%@taglib uri="/WEB-INF/tld/com_sun_web_ui/cc.tld" prefix="cc"%>

<!-- Set the viewbean -->
<jato:useViewBean className="com.sun.cluster.spm.disk.DiskStatusViewBean">

<!-- Page header component -->
<spm:header 	pageTitle="diskStatus.title" 
		copyrightYear="2004" 
		baseName="com.sun.cluster.spm.resources.Resources" 
		bundleID="scBundle" 
		event="ESC_cluster_dpm_">

<jato:form name="scForm" method="post">

<SCRIPT LANGUAGE="JavaScript">
 function displayConfirmation(url, key) {
  var msg = '';
  var name = '';
  var operation = '';

  var params = url.substring(url.indexOf('?') + 1).split('&');	

  for (var i = 0; i < params.length; i++) {
   var values;
   if (params[i].slice(0,params[i].indexOf('=')) == key) {
       values = params[i].slice(params[i].indexOf('=') + 1);
       operation = values.replace(/%23.*/, '');
       node = values.replace(/%23%2F.*/,'');
       node = node.replace(/^.*%23/, ''); 
       name = values.replace(/^.*%23/, '');
       name = name.replace(/%2F/g, '/');

     }

  }

  var enableMonitoring = '<cc:text name="StaticText" defaultValue="diskStatus.enable.confirmation" bundleID="scBundle"/>';

  var disableMonitoring = '<cc:text name="StaticText" defaultValue="diskStatus.disable.confirmation" bundleID="scBundle"/>';
        
  var header;
  if (operation == 'enable') {
    header = enableMonitoring;
  } else if (operation == 'disable') {
    header = disableMonitoring;
  }

  msg = header.replace('{0}', name);
  msg = msg.replace('{1}', node);

   return confirm(msg + '\n <cc:text name="StaticText" defaultValue="selectionConfirmation" bundleID="scBundle"/>');

 }	
</SCRIPT>

<!-- Status Alert -->
<spm:alertinline name="StatusAlert" bundleID="scBundle" />

<!-- Alert -->
<spm:alertinline name="CommandResultAlert" bundleID="testBundle" />

<cc:pagetitle name="GenericPageTitle" bundleID="scBundle" 
 pageTitleText="diskStatus.title" 
 showPageTitleSeparator="true" 
 pageTitleHelpMessage="diskStatus.help"/>

<BR>

<!-- Action Table -->
<cc:actiontable
name="StatusTable"
bundleID="scBundle"
title="diskStatus.title"
summary="diskStatus.information"
empty="diskStatus.emptyTable"
rowSelectionType="none"
showAdvancedSortingIcon="false"
showLowerActions="false"
showPaginationControls="true"
showPaginationIcon="true"
showSelectionIcons="false"
showSortingRow="true"
maxRows="10"
page="1"/>    

</jato:form>

</spm:header>

</jato:useViewBean>
