#!/usr/perl5/bin/perl -w
#
# Copyright 2002-2004 Sun Microsystems, Inc.  All rights reserved.
# Use is subject to license terms.
#
#ident	"@(#)oracle.pl	1.25	04/03/23 SMI"
#

use lib '/opt/SUNWscvw/lib/perl';
use Socket;
use Cluster::common;
use Cluster::Common;
use strict;
use Sun::Solaris::Utils qw(gettext);

$main::pkglist = "SUNWarc, SUNWbtool, SUNWhea, SUNWlibm, SUNWlibms, SUNWsprot, SUNWtoo";

&do_page("Configure Oracle Database"); # gettext("Configure Oracle Database")
exit;

sub cmd_mainpage {
    &wizard_start;

    print $q->_script($q->yoke_jscript("c"));
    &getscrgconfig();
    if (! $errpos) {


	if (! &checktype("SUNW.oracle_server")) {
		return;
	}
	if (! &checktype("SUNW.oracle_listener")) {
		return;
	}
    }

    if (&shmcheck == 1) {
	&errmsg(gettext("The shmsys/semsys variables need to be set in /etc/system as specified in the Oracle documentation.  You may either make these changes manually or click below to update /etc/system automatically with default values."));
	&submit("cmd_etcsystem", gettext("Modify /etc/system"));
	return;
    }

    if (! &getlh()) {
	return;
    }

    if ($errpos == 1) {
	&errmsg();
    }

    &getnodes();
    my $CMD = "/cgi-bin/ds/validate-script.pl";
    my (%args) = (pkglist => $main::pkglist);
    my $cluster = new Cluster::Common;
    my $err = $cluster->run_parallel($CMD, 1, \%args);
    if ($err) {
	# Need to install package
	print "<p>".gettext("Oracle requires various Solaris packages, which are normally installed in the Developer installation.  Some packages are missing but may now be installed from the Solaris CD.");
	&action_table_start();
	&action_table_row_start(gettext("Path to the CD:"));
	&input("pkgcd", 35);
	&action_table_row_end();
	&action_table_end();

	&submit_table_start();
	$FORM{"cmd_install_pkgs"} = 1;
	&hidden("cmd_install_pkgs");
	&submit("cmd_install_pkgs", gettext("Install Solaris packages"));
	&submit_table_end();
	return;
    }

    print "<br>".gettext("Click to install Oracle and a sample database:\n");
    &submit("cmd_install_oracle_db", gettext("Install Oracle and database"));
    if (-r "/var/opt/oracle/oraInst.loc") {
	print "<br>".gettext("Click to use an existing Oracle database:\n");
	&submit("cmd_setup_oracle", gettext("Use existing database"));
    }
}

# Install necessary Solaris packages
sub cmd_install_pkgs {
    &wizard_start;
    print $q->_script($q->yoke_jscript("c"));

    # Get the Solaris version
    my $solarisversion = Cluster::Common::get_solarisversion();

    if (defined $FORM{"pkgcd"}) {
        if (! -d $FORM{"pkgcd"}) {
            &errpage(gettext("Specified path does not exist"), 1, "cmd_mainpage");
        }
        if (! -e $FORM{"pkgcd"}."/.cdtoc") {
            &errpage(gettext("Specified path is not a CDROM image (no .cdtoc)"),
                1, "cmd_mainpage");
        }
        if (! -e $FORM{"pkgcd"}."/Solaris_$solarisversion/Product/SUNWarc") {
            &errpage(gettext("Necessary packages are missing from path"),
                1, "cmd_mainpage");
        }
    }

    # Run installation script
    &getnodes();
    my $CMD = "/cgi-bin/ds/oracle-script.pl";
    my (%args) = (mode => "installpkgs", pkglist => $main::pkglist,
	pkgcd => $FORM{"pkgcd"}."/Solaris_$solarisversion/Product");

    my ($pkglist2);
    ($pkglist2 = $main::pkglist) =~ s/,//g;
    $cmd_save = "pkgadd -d ".$FORM{"pkgcd"}." $pkglist2";
    my $cluster = new Cluster::Common;
    my $err = $cluster->run_parallel($CMD, 1, \%args);
    if ($err) {
	&errmsg(gettext("Package installation failed"));
    } else {
	&okmsg(gettext("Packages have been installed"));
	print "<br>".gettext("Click to continue:\n");
	&submit("cmd_mainpage", gettext("Continue"));
    }
}


# Set up an existing Oracle installation properly
sub cmd_setup_oracle {

    my $i;
    &wizard_start;
    print $q->_script($q->yoke_jscript("c"));
    &getscrgconfig();

    &getlh();

    &action_table_start();

    if ($errpos == 2) {
	&errmsg();
	if (! -e "/usr/ccs/bin/make") {
	    &errmsg("/usr/ccs/bin/make does not exist");
	    print gettext("Oracle install requires <tt>/usr/ccs/bin/make</tt>.  You must install the appropriate packages.\n");
	    return;
	}
    }

    &action_table_row_start(gettext("Network Resource:"));
    &hostnameoption();
    &action_table_row_end();

    if ($errpos == 3) {
	&errmsg();
    }

    &action_table_row_start(gettext("Prefix for Oracle Resources:"));
    if ($FORM{"rs"} eq "") {
	# Find a resource name that is not in use
	for ($i = 1; $i<10; $i++) {
	    $FORM{"rs"} = "oracle-$i";
	    if (! defined $rsdesc{$FORM{"rs"}."-server"}) {
		last;
	    }
	    $FORM{"rs"} = "";
	}
    }
    &input("rs");
    &action_table_row_end();

    if ($FORM{"oracle_home"} eq "") {
	my ($sid, $home, $x);
	if (open(ORATAB, "</var/opt/oracle/oratab")) {
	    while (<ORATAB>) {
		($sid, $home, $x) = split(":");
		if ($sid !~ /#/) {
		    $FORM{"oracle_home"} = $home;
		    $FORM{"dbname"} = "$sid.".&domain;
		    last;
		}
	    }
	    close(ORATAB);
	}
    }

    if ($errpos == 4) {
	&errmsg();
    }
    &action_table_row_start(gettext("ORACLE_HOME directory:"));
    &input("oracle_home", 35);
    &action_table_row_end();


    if ($errpos == 5) {
	&errmsg();
    }
    &action_table_row_start(gettext("Database Name:"));
    &input("dbname");
    &action_table_row_end();

    if ($FORM{"connect"} eq "") {
	$FORM{"connect"} = "scott/tiger";
    }
    if ($errpos == 6) {
	&errmsg();
    }
    &action_table_row_start(gettext("Connection ID/Password:"));
    &input("connect");
    &action_table_supplement(gettext("(Used by the fault monitor to access the database.  This id must have appropriate access permissions.)"));
    &action_table_row_end();

    if ($errpos == 7) {
	&errmsg();
    }
    &action_table_row_start(gettext("Alert Logfile Location:"));
    &input("logfile", 35);
    &action_table_supplement(gettext("(You can leave blank if this is <i>ORACLE_HOME</i>/../../admin/<i>sid</i>/bdump/alert_<i>sid</i>.log)"));
    &action_table_row_end();

    if ($errpos == 8) {
	&errmsg();
    }
    if ($FORM{"listener"} eq "") {
	$FORM{"listener"} = "LISTENER";
    }
    &action_table_row_start(gettext("Listener Name:"));
    &input("listener");
    &action_table_row_end();

    &action_table_end();

    &submit_table_start();
    &submit("cmd_files", gettext("Continue"));
    &submit_table_end();
    &wizard_end();
}

sub cmd_install_oracle_db {
    $FORM{"installdb"} = "yes";
    &cmd_install_oracle();
}

# Install oracle
sub cmd_install_oracle {
    &wizard_start;
    print $q->_script($q->yoke_jscript("c"));

    &action_table_start();

    if ($errpos == 2) {
	&errmsg();
    }

    # Set display to the machine requesting this page
    if ($FORM{"display"} eq "") {
	if ($ENV{"HTTP_CLIENT_IP"}) {
	    $FORM{"display"} = &iptohost($ENV{"HTTP_CLIENT_IP"}).":0";
	} else {
	    $FORM{"display"} = &iptohost($ENV{"REMOTE_ADDR"}).":0";
	}
    }
    &action_table_row_start(gettext("X Display to Use:"));
    &input("display");
    &action_table_supplement(gettext("(The cluster nodes must have xhost access in order to display Oracle installer windows.)"));
    &action_table_row_end();

    if ($errpos == 3) {
	&errmsg();
    }
    &action_table_row_start(gettext("Directory Holding Oracle CD ROM Image:"));
    &input("cdrom");
    &action_table_supplement(gettext("(i.e. the directory holding the \"runInstaller\" command.)"));
    &action_table_row_end();

    if ($FORM{"oracle_base"} eq "") {
	$FORM{"oracle_base"} = "/var/app/oracle";
    }

    if ($errpos == 4) {
	&errmsg();
    }

    &action_table_row_start(gettext("ORACLE_BASE directory:"));
    &input("oracle_base", 35);
    &action_table_row_end();

    if ($FORM{"oracle_home"} eq "") {
	$FORM{"oracle_home"} = $FORM{"oracle_base"}."/product/8.1.x";
    }

    if ($errpos == 41) {
	&errmsg();
    }

    &action_table_row_start(gettext("ORACLE_HOME directory:"));
    &input("oracle_home", 35);
    &action_table_row_end();

    if ($FORM{"dbname"} eq "") {
	$FORM{"dbname"} = "test.".&domain;
    }

    if ($errpos == 5) {
	&errmsg();
    }

    &hidden("installdb");
    if ($FORM{"installdb"}) {

	&action_table_row_start(gettext("Database Name:"));
	&input("dbname");
	&action_table_row_end();

	if ($FORM{"dbdir"} eq "") {
	    my $hostname = `hostname`;
	    chop $hostname;
	    $FORM{"dbdir"} = &getglobal()."/db";
	}

	if ($errpos == 6) {
	    &errmsg();
	}
	&action_table_row_start(gettext("Database Directory:"));
	&input("dbdir");
	&action_table_supplement(gettext("(Note: this must be a global file system on a different disk than ORACLE_BASE.)"));
	&action_table_row_end();
    }

    &action_table_end();

    &submit_table_start();
    &submit("cmd_install_oracle_1", gettext("Install"));
    &submit_table_end();

}

# Install Oracle, next part
sub cmd_install_oracle_1 {

    &wizard_start();
    print $q->_script($q->yoke_jscript("c"));

    if ($FORM{"display"} !~ /:\d/) {
	&errpage(gettext("X Display must be specified"), 2, "cmd_install_oracle");
    }

    if (! -d $FORM{"cdrom"}) {
	&errpage(gettext("Setup directory does not exist"), 3, "cmd_install_oracle");
    }

    if (! -e $FORM{"cdrom"}."/runInstaller") {
	&errpage(sprintf(gettext("%s does not exist"),
	    $FORM{"cdrom"}."/runInstaller"), 3, "cmd_install_oracle");
    }

    if (-e $FORM{"cdrom"}."/response/standard.rsp") {
	# The config file is in the Oracle 9i location
	if ($FORM{"cdrom"} !~ /1$/) {
	    # cdrom must be disk1, disk2, disk3, etc.
	    &errpage(gettext("For Oracle 9i, path must be to disk 1 and must end in '1'."),
		3, "cmd_install_oracle");
	}
    }

    $FORM{"from_location"} = $FORM{"cdrom"}."/stage/products.jar";

    if (! -e $FORM{"from_location"}) {
	&errpage(sprintf(gettext("%s does not exist"), $FORM{"from_location"}), 3, "cmd_install_oracle");
    }

    if ($FORM{"oracle_base"} eq "") {
	&errpage(gettext("ORACLE_BASE must be specified"), 4, "cmd_install_oracle");
    }

    if ($FORM{"oracle_home"} eq "") {
	&errpage(gettext("ORACLE_HOME must be specified"), 41, "cmd_install_oracle");
    }

    if (&isglobal($FORM{"oracle_base"}) &&
	    (! &isglobal($FORM{"oracle_home"}))) {
	$FORM{"oracle_home"} = "";
	&errpage(gettext("ORACLE_HOME must be global if ORACLE_BASE is global"), 41,
	    "cmd_install_oracle");
    }

    if ((! &isglobal($FORM{"oracle_base"})) &&
	    &isglobal($FORM{"oracle_home"})) {
	$FORM{"oracle_home"} = "";
	&errpage(gettext("ORACLE_HOME must be local if ORACLE_BASE is local"), 41,
	    "cmd_install_oracle");
    }

    if ($FORM{"installdb"}) {
	if ($FORM{"dbname"} eq "") {
	    &errpage(gettext("Database name must be specified"), 5, "cmd_install_oracle");
	}

	if (&isglobal($FORM{"dbdir"}) || $FORM{"dbdir"} =~ /dev/) {
	    #ok
	} else {
	    &errpage(gettext("Database must be installed to a global directory/device"),
		6, "cmd_install_oracle");
	}
    }

    &getnodes();
    my $confhost = &Cluster::Common::get_hostname;
    print "<h2>".gettext("Installing Oracle")."</h2>\n";
    print sprintf(gettext("This page will start Oracle installation on each node, and will install a database on node %s."), $confhost);
    print gettext("An Oracle installation window will pop up to show progress on each installation.  No Oracle intervention should be required, except to click \"Ok\" or \"Exit\" when the database installation completes.  Note that this process may take an hour or more (several hours for global installation), and the Oracle installation bar may remain at 100% for several minutes before completion.\n");

    # Pass information to main page
    &hidden("oracle_base");
    &hidden("oracle_home");
    &hidden("dbdir");
    &hidden("installdb");
    &hidden("dbname");

    # Make a button at the beginning just in case...
    print "<p>".gettext("When Oracle install finishes completely, press to run root.sh script:\n");
    &submit("cmd_postinstall", gettext("Continue"));
    &wizard_end();
    &wizard_start();
    # Pass information to main page
    &hidden("oracle_base");
    &hidden("oracle_home");
    &hidden("dbdir");
    &hidden("installdb");
    &hidden("dbname");

    my $gmode;
    if (&isglobal($FORM{"oracle_base"})) {
	$gmode = "global";
    } else {
	$gmode = "local";
    }

    # Run installation script
    my $CMD = "/cgi-bin/ds/oracle-script.pl";
    my (%args) = (mode => "install", confhost => $confhost,
	ORACLE_BASE => $FORM{"oracle_base"},
	ORACLE_HOME => $FORM{"oracle_home"}, CDROM => $FORM{"cdrom"},
	s_mountPoint => $FORM{"dbdir"}, s_globalDBName => $FORM{"dbname"},
	DISPLAY => $FORM{"display"}, gmode => $gmode);
    if ($FORM{"installdb"}) {
	$args{"installdb"} = "yes";
    } else {
	$args{"installdb"} = "no";
    }
    $cmd_save = $FORM{"cdrom"}."/runInstaller";
    my $cluster = new Cluster::Common;
    my $err = $cluster->run_parallel($CMD, 1, \%args);
    if ($err) {
	if ($err =~ /(Can.t connect to display \S+)/) {
	    &errmsg($1);
	    print gettext("You may need to give access with <tt>xhost</tt> or use a different display.\n");
	} else {
	    &errmsg(gettext("Install failed"));
	}
	return;
    }

    &okmsg(gettext("Oracle installed"));
    print "<p>".gettext("Press to run root.sh script:\n");
    &submit("cmd_postinstall", gettext("Continue"));

}

sub cmd_postinstall {
    &wizard_start();
    print $q->_script($q->yoke_jscript("c"));
    print "<h2>".gettext("Run Oracle root.sh postinstall")."</h2>\n";
    # Pass information to main page
    &hidden("oracle_base");
    &hidden("oracle_home");
    &hidden("dbdir");
    &hidden("dbname");

    # Run installation script
    &getnodes();
    if (&isglobal($FORM{"oracle_home"})) {
	undef @nodes;
	$nodes[0] = &Cluster::Common::get_hostname;
    }
    my $CMD = "/cgi-bin/ds/oracle-script.pl";

    my (%args) = (mode => "rootsh", "ORACLE_HOME" => $FORM{"oracle_home"});
    $cmd_save = join("\n", $cmd_save, $FORM{"oracle_home"}."/root.sh");
    my $cluster = new Cluster::Common;
    my $err = $cluster->run_parallel($CMD, 1, \%args);
    if ($err) {
	&errmsg(gettext("Install failed"));
	return;
    }

    &okmsg(gettext("Oracle root.sh script run"));
    if ($FORM{"installdb"}) {
	print "<p>".gettext("Press to set up config files:\n");
	&submit("cmd_setup_oracle", gettext("Continue"));
    } else {
	print "<p>".gettext("The base Oracle application has been installed.\n");
	print "<p>".gettext("You must manually create a database.\n");
    }
}

sub cmd_files {

    &wizard_start;
    print $q->_script($q->yoke_jscript("c"));

    if ($FORM{"lh"} eq "") {
	&errpage(gettext("Hostname must be selected"), 2, "cmd_setup_oracle");
    }

    if ($FORM{"rs"} eq "") {
	&errpage(gettext("Resource name must be specified"), 3, "cmd_setup_oracle");
    }

    if ($FORM{"oracle_home"} eq "") {
	&errpage(gettext("ORACLE_HOME must be specified"), 4, "cmd_setup_oracle");
    }

    if (! -e $FORM{"oracle_home"}) {
	&errpage(sprintf(gettext("%s does not exist"), $FORM{"oracle_home"}), 4, "cmd_setup_oracle");
    }

    if ($FORM{"dbname"} eq "") {
	&errpage(gettext("Database name must be specified"), 5, "cmd_setup_oracle");
    }

    if ($FORM{"connect"} !~ /\S\/\S/) {
	&errpage(gettext("id/password must be specified"), 6, "cmd_setup_oracle");
    }

    ($FORM{"sid"} = $FORM{"dbname"}) =~ s/\..*//;

    if ($FORM{"logfile"} eq "") {
	my $sid = $FORM{"sid"};
	$FORM{"logfile"} = $FORM{"oracle_home"};
	$FORM{"logfile"} =~ s#/[^/]+$##; # Drop last two path components
	$FORM{"logfile"} =~ s#/[^/]+$##;
	$FORM{"logfile"} .= "/admin/$sid/bdump/alert_$sid.log";
    }

    if (! -e $FORM{"logfile"}) {
	#&errpage(sprintf(gettext("%s does not exist"), $FORM{"logfile"}), 7, "cmd_setup_oracle");
    }

    if ($FORM{"listener"} eq "") {
	&errpage(gettext("Listener must be specified"), 8, "cmd_setup_oracle");
    }

    print "<h2>".gettext("Setting up Oracle configuration files")."</h2>\n";

    my ($rg, $args, $status);
    my ($lh, $lhrg, $lhrs, $lhmode) = split(/:/, $FORM{"lh"});
    my $CMD;

    my $gmode;
    if (&isglobal($FORM{"oracle_home"})) {
	$gmode = "global";
    } else {
	$gmode = "local";
    }


    # Copy init.ora to tmp dir
    my ($sid, $ora);
    ($sid = $FORM{"dbname"}) =~ s/\..*//;
    $ora = $FORM{"oracle_home"}."/dbs/init$sid.ora";

    my $tmpdir = &gettmpdir($sid, $ora);
    if ($tmpdir eq "") {
	return;
    }
    my $cmd = "/bin/cp $ora $tmpdir/init$sid.ora";
    print "$cmd<br>\n";
    if (system("/bin/pfexec $cmd")) {
	&errmsg("$cmd");
    }

    # Copy oraInst.loc to tmp dir
    $cmd = "/bin/cp /var/opt/oracle/oraInst.loc $tmpdir/oraInst.loc";
    print "$cmd<br>\n";
    if (system("/bin/pfexec $cmd")) {
	&errmsg("$cmd");
    }

    # Copy orapw to tmp dir
    $cmd = "/bin/cp ".$FORM{"oracle_home"}."/dbs/orapw$sid $tmpdir/orapw$sid";
    if (system("/bin/pfexec $cmd")) {
	&errmsg("$cmd");
    }

    &getnodes();
    my $confhost = &Cluster::Common::get_hostname;

    $CMD = "/cgi-bin/ds/oracle-script.pl";
    my (%args) = (mode => "configure", confhost => $confhost,
	ORACLE_HOME => $FORM{"oracle_home"}, s_globalDBName => $FORM{"dbname"},
	host => $lh, logfile => $FORM{"logfile"},
	listener => $FORM{"listener"}, connect => $FORM{"connect"},
	gmode => $gmode, tmpdir => $tmpdir);
    #$alarm_timeout = 60; # 1 minutes XXX Should support timeouts in run_parallel
    #$max_timeouts = 4;
    my $cluster = new Cluster::Common;
    my $err = $cluster->run_parallel($CMD, 1, \%args);
    if ($err) {
	&errmsg(gettext("Configure failed"));
	return;
    }

    # Clean up
    system("/bin/pfexec /bin/rm $tmpdir/init$sid.ora");
    system("/bin/pfexec /bin/rm $tmpdir/oraInst.loc");
    system("/bin/pfexec /bin/rm $tmpdir/orapw$sid");

    &okmsg(gettext("Config files set up"));
    print "<p>".gettext("Click to set up and run resources:\n");
    # Pass values on
    &hidden("lh");
    &hidden("logfile");
    &hidden("sid");
    &hidden("oracle_home");
    &hidden("connect");
    &hidden("rs");
    &hidden("listener");
    &hidden("dbname");
    &submit("cmd_resources", gettext("Continue"));
}

sub cmd_resources {
    &wizard_start();
    print $q->_script($q->yoke_jscript("c"));
    my ($lh, $lhrg, $lhrs, $lhmode) = split(/:/, $FORM{"lh"});
    my $rs = $FORM{"rs"};
    my $args = "-t SUNW.oracle_server".
	    " -x Alert_log_file=".$FORM{"logfile"}.
	    " -x ORACLE_SID=".$FORM{"sid"}.
	    " -x ORACLE_HOME=".$FORM{"oracle_home"}.
	    " -x Connect_string=".$FORM{"connect"};

    $FORM{"rs"} = $rs."-server";
    my $status = &createservice($args, 1);
    if ($status) {
	return;
    }

    $args = "-t SUNW.oracle_listener".
	    " -x ORACLE_HOME=".$FORM{"oracle_home"}.
	    " -x LISTENER_NAME=".$FORM{"listener"};
    $FORM{"rs"} = $rs."-listener";
    $status = &createservice($args);
    if ($status) {
	return;
    }
    print "<p>".gettext("HA-Oracle should now be running.\n");

    print "<p>".gettext("The tnsnames.ora file to use on clients:\n");
    print "<br>";
    &code_start();
    my $dbname = $FORM{"dbname"};
    my $port = 1521;
    my $sid = $FORM{"sid"};
    print << "EOF";
<pre>
$dbname =
(DESCRIPTION =
  (ADDRESS_LIST =
    (ADDRESS = (PROTOCOL = TCP)
    (HOST = $lh)
    (PORT = $port))
  )
  (CONNECT_DATA = (SID = $sid))
)
</pre>
EOF
    &code_end();

    print gettext("Connect to this with, for example,\n");
    print "<pre>sqlplus ".$FORM{"connect"}."\@".$FORM{"dbname"}."</pre>\n";
    &code_end();
    &reloadmenu();
    print $q->_script($q->yoke_jscript("rg-rs-".$FORM{"rs"}));
}

# Check that the shm stuff is in /etc/system
# Return 0: ok, 1: missing from /etc/system, 2: reboot needed?
sub shmcheck {
    my $s = system('grep -l shmsys:shminfo /etc/system > /dev/null');
    if ($s) {
	return 1;
    } elsif (-M "/etc/system" < -M "/etc/initpipe") {
	&errmsg(gettext("Warning: /etc/system may have been modified recently.  The cluster must be rebooted if the shmsys/semsys variables were changed."));
	return 2;
    }
    return 0;
}

# Get a global directory for temporary storage
sub gettmpdir {
    my ($sid, $ora) = @_;
    my $tmpdir = "";
    if (! open(ORA, "<$ora")) {
	&errmsg(sprintf(gettext("Database file %s does not exist"), $ora));
	return "";
    }
    while ((defined ($_ = <ORA>)) && $tmpdir eq "") {
	if (/control_files/ && /"([^"]+)"/) {
	    $tmpdir = $1;
	}
    }
    close(ORA);
    if ($tmpdir eq "") {
	# Pick a random global file system
	$tmpdir = &getglobal();
	if ($tmpdir eq "" || &isglobal($tmpdir) != 1) {
	    &errmsg(gettext("Could not find a global directory for temporary files"));
	}
	return "";
    } elsif (&isglobal($tmpdir) != 1) {
	&errmsg(sprintf(gettext("Database control_file %s is not global"), $tmpdir));
	return ""
    } else {
	#$tmpdir =~ s#/oradata.*##;
	$tmpdir =~ s#/control\d+.ctl##;
	return $tmpdir;
    }
}

# Update /etc/system with the shmsys/semsys info on all nodes
sub cmd_etcsystem {
    &wizard_start();
    print $q->_script($q->yoke_jscript("c"));
    print "<h2>".gettext("Update /etc/system for Oracle")."</h2>\n";

    # Run update script
    &getnodes();
    my $CMD = "/cgi-bin/ds/oracle-script.pl";

    my (%args) = (mode => "etcsystem");
    my $cluster = new Cluster::Common;
    my $err = $cluster->run_parallel($CMD, 1, \%args);
    if ($err) {
	&errmsg(gettext("/etc/system update failed"));
    } else {
	&okmsg(gettext("/etc/system has been updated.  Please verify that " .
	    "these values meet your needs.  All cluster nodes must now " .
	    "be manually rebooted for these updates to take effect."));
	&submit("cmd_mainpage", gettext("Continue"));
    }
}
