#!/usr/bin/perl -w
#
# Copyright 2001-2004 Sun Microsystems, Inc.  All rights reserved.
# Use is subject to license terms.
#
#ident	"@(#)index.pl	1.3	04/03/23 SMI"
#
# Node status page
#

require 5.005;
use strict;
use lib '/opt/SUNWscvw/lib/perl';
use Cluster::Cgi;
use Cluster::RBAC;
use Cluster::Common;
use Sun::Solaris::Utils qw(gettext);

# Set constants
use constant TRUE	   => 0;

# Create the cluster objects
my $q = new Cluster::Cgi;
my $cluster = new Cluster::Common;
my $rbac = new Cluster::RBAC;

# Set the page title
my $title = gettext("Data Services Install");

# Print the query header
print $q->header();

# Start the document
print $q->start_html({ TITLE => gettext("Data Services Install"),
		       STYLE  => { 'src' => '/css/clustmgr-style.css'},
		       CLASS  => "default-body",
		       });

# Check for app install authorization
if (!$rbac->check_auth($CL_AUTH_APPINSTALL)) {
	$rbac->auth_error($q, $title);
	exit;
}

##############################################################################
#
# Action Bar Table
#
##############################################################################

# Start the action bar table
$q->start_action_bar_table(gettext("Data Services"));

# Print the middle of the action table
$q->mid_action_bar_table();

# End the action bar table
$q->end_action_bar_table();

##############################################################################
#
# Table of data services to install
#
##############################################################################

# Create the actions menu links
my @sparcdataservicelist =
  ( 
    [ gettext("Oracle Database"), "/cgi-bin/ds/oracle.pl" ],
    [ gettext("Apache Web Server"), "/cgi-bin/ds/apache.pl" ],
    [ gettext("Sun ONE Web Server"), "/cgi-bin/ds/iplanet.pl" ],
    [ gettext("Sun ONE LDAP Server"), "/cgi-bin/ds/ldap.pl" ],
    [ gettext("DNS"), "/cgi-bin/ds/dns.pl" ],
    [ gettext("NFS"), "/cgi-bin/ds/nfs.pl" ],
  );

my @x86dataservicelist =
  ( 
    [ gettext("Sun ONE Web Server"), "/cgi-bin/ds/iplanet.pl" ],
    [ gettext("Sun ONE LDAP Server"), "/cgi-bin/ds/ldap.pl" ],
    [ gettext("DNS"), "/cgi-bin/ds/dns.pl" ],
    [ gettext("NFS"), "/cgi-bin/ds/nfs.pl" ],
  );

# Set the headers for the table. They must be passed in a list of
# pairs consisting of the header text, and the width of the column
# expressed in either percentage or absolute pixels.
my @tableheaders = (gettext("Name"), "100%");

# Determine the number of columns from the headers
my $numcols = ($#tableheaders + 1) / 2;

# Start the property table
$q->start_prop_table(gettext("Data Services"), \@tableheaders,
		     "/images/node_16.gif"); 

my @dataservicelist = ( );

if ($cluster->is_solarisx86() == TRUE) {
    @dataservicelist = @x86dataservicelist;
} else {
    @dataservicelist = @sparcdataservicelist;
}

for (my $i=0; $i<=$#dataservicelist; $i++) {

  # Start a table row for the node
  $q->start_prop_tr();

  # Print a table cell for the nodename
  $q->start_prop_td();

  # This function will print an icon and a link. It
  # takes the label text, the alt tag text, the link to
  # point to, and the icon to display before the text.

  $q->table_link_text($dataservicelist[$i][0],
		      $dataservicelist[$i][0],
		      $dataservicelist[$i][1]);

  $q->end_prop_td();

  $q->end_prop_tr();

  # If we're not on our last row, print the line row divider,
  # giving the width of the table, in columns.
  if ($i < $#dataservicelist) {
    $q->line_row($numcols);
  }

}

# End the node status table
$q->end_prop_table();
