<%--
/*
 * Copyright 2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 *
 * ident	"@(#)QuorumStatus.jsp	1.6	05/11/04 SMI"
 */
--%>

<%@page info="Quorum" language="java" %> 
<%@taglib uri="/WEB-INF/tld/com_iplanet_jato/jato.tld" prefix="jato"%> 
<%@taglib uri="/WEB-INF/tld/com_sun_cluster_spm/spm.tld" prefix="spm"%>
<%@taglib uri="/WEB-INF/tld/com_sun_web_ui/cc.tld" prefix="cc"%>

<!-- Set the viewbean -->
<jato:useViewBean className="com.sun.cluster.spm.quorum.QuorumStatusViewBean">

<!-- Page header component -->
<spm:header pageTitle="quorum.title" copyrightYear="2004"
            baseName="com.sun.cluster.spm.resources.Resources"
            bundleID="scBundle"
            event="ESC_cluster_quorum, ESC_cluster_node_config_change"
            onLoad="reloadTree()">

<jato:form name="scForm" method="post">

<!-- Hidden Field for the tree -->
<cc:hidden name="TreeNodeHiddenField"/>

<SCRIPT LANGUAGE="JavaScript">
 function displayConfirmation() {
  return confirm('<cc:text name="StaticText"
                           defaultValue="selectionConfirmation"
                           bundleID="scBundle"/>');
 }
</SCRIPT>

<!-- Status Alert -->
<spm:alertinline name="StatusAlert" bundleID="scBundle" />

<!-- Command Alert -->
<spm:alertinline name="CommandResultAlert" bundleID="scBundle" />

<cc:pagetitle name="GenericPageTitle" bundleID="scBundle"
              pageTitleText="quorum.status.pageTitle.title"
              showPageTitleSeparator="true"
              pageTitleHelpMessage="quorum.status.pageTitle.help"/>

<!-- Buttons -->
<spm:rbac auths="solaris.cluster.quorum.modify">
<BR>
<div class="ConMgn"> 
<table border="0" cellpadding="0" cellspacing="0">
  <tr>
    <td>
      <cc:wizardwindow name="AddQuorumWizard" bundleID="scBundle"/>
    </td>
    <jato:content name="InstallMode">
      <td>
        <cc:button name="ResetButton" bundleID="scBundle"
                   defaultValue="quorum.status.button.reset"
                   onClick="return displayConfirmation()"/>
      </td>
    </jato:content>
  </tr>
</table>
</div>

</spm:rbac>

<div><img src="/com_sun_web_ui/images/other/dot.gif"
          width="1" height="10" alt=""></div>


<jato:containerView name="QuorumDeviceVoteView">
  <jsp:include page="QuorumDeviceVotePagelet.jsp"/>
</jato:containerView>

<BR>

<spm:rbac auths="solaris.cluster.node.read">
  <cc:actiontable name="NodeTable"
                  bundleID="scBundle"
                  title="quorum.status.node.table.title"
                  summary="quorum.status.node.table.summary"
                  empty="quorum.status.node.table.empty"
                  rowSelectionType="none"
                  showAdvancedSortingIcon="false"
                  showLowerActions="false"
                  showPaginationControls="false"
                  showPaginationIcon="false"
                  showSelectionIcons="false"
                  showSortingRow="false"
                  page="1"/>
</spm:rbac>

<BR>
<spm:rbac auths="solaris.cluster.node.read solaris.cluster.quorum.read">
<jato:containerView name="QuorumSummaryVoteView">
  <jsp:include page="QuorumSummaryVotePagelet.jsp"/>
</jato:containerView>
</spm:rbac>

</jato:form>
</spm:header>
</jato:useViewBean>
