#!/usr/perl5/bin/perl -w
#
# Copyright 2001-2004 Sun Microsystems, Inc.  All rights reserved.
# Use is subject to license terms.

#
#ident	"@(#)apache.pl	1.15	04/03/23 SMI"
#

use lib '/opt/SUNWscvw/lib/perl';
use Sun::Solaris::Utils qw(gettext);
use Socket;
use Cluster::common;
use Cluster::Common;
use strict;

&do_page("Configure Apache Web Server"); # gettext("Configure Apache Web Server")
exit;

sub cmd_mainpage {
    my $i;
    &wizard_start;
    print $q->_script($q->yoke_jscript("c"));
    &getscrgconfig();
    if (! $errpos) {

	if (! &checktype("SUNW.apache")) {
		return;
	}
    }

    if (! &getlh("sa")) {
	return;
    }

    &action_table_start();

    if ($errpos == 1) {
	&errmsg();
    }

    &getnodes();

    my $CMD = "/cgi-bin/ds/validate-script.pl";
    my (%args) = (pkglist => "SUNWapchr, SUNWapchu");
    my $cluster = new Cluster::Common;
    my $err = $cluster->run_parallel($CMD, 0, \%args);
    if ($err) {
	&action_table_end();
	&errmsg(gettext("The packages SUNWapchr and SUNWapchu must be " .
	    "installed on all nodes"));
	return;
    }

    if ($errpos == 104) {
	&errmsg();
    }
    if ($FORM{"wport"} eq "") {
	if (!portinuse(80)) {
	    $FORM{"wport"} = 80;
	} else {
	    $FORM{"wport"} = &freeport(8080);
	}
    }
    &action_table_row_start(gettext("Web Server Port:"));
    &input("wport", 8);
    &action_table_row_end();

    if ($errpos == 3) {
	&errmsg();
    }
    if ($FORM{"loc"} eq "") {
	# Find a /usr/local/apachen not in use
	for ($i = ""; $i < 10; $i++) {
	    $FORM{"loc"} = "/usr/local/apache$i";
	    if (! -d $FORM{"loc"}) {
		last;
	    }
	}
    }
    &action_table_row_start(gettext("Installation Directory:"));
    &input("loc", 35);
    &action_table_row_end();

    if ($errpos == 4) {
	&errmsg();
    }
    if ($FORM{"root"} eq "") {
	$FORM{"root"} = &getglobal()."/docs";
    }
    &action_table_row_start(gettext("Root Directory for Web Pages:"));
    &input("root", 35);
    &action_table_row_end();

    if ($errpos == 5) {
	&errmsg();
    }
    if ($FORM{"cgi"} eq "") {
	$FORM{"cgi"} = &getglobal()."/cgi-bin";
    }
    &action_table_row_start(gettext("Web CGI Script Directory:"));
    &input("cgi", 35);
    &action_table_row_end();

    if ($errpos == 51) {
	&errmsg();
    }
    if ($FORM{"logdir"} eq "") {
	if (&isglobal($FORM{"loc"})) {
	} else {
	    $FORM{"logdir"} = $FORM{"loc"}."/logs";
	}
    }
    &action_table_row_start(gettext("Local Log Directory:"));
    &input("logdir", 35);
    &action_table_row_end();

    if ($errpos == 101) {
	&errmsg();
    }
    &action_table_row_start(gettext("Network Resource:"));
    &hostnameoption("sa");
    &action_table_row_end();

    if ($errpos == 102) {
	&errmsg();
    }
    if ($FORM{"rs"} eq "") {
	# Find a resource name that is not in use
	for ($i = 1; $i<10; $i++) {
	    $FORM{"rs"} = "apache-$i";
	    if (! defined $rsdesc{$FORM{"rs"}}) {
		last;
	    }
	    $FORM{"rs"} = "";
	}
    }
    &action_table_row_start(gettext("Resource Name:"));
    &input("rs");
    &action_table_row_end();

    if ($errpos == 103) {
	&errmsg();
    }
    if ($FORM{"rg"} eq "") {
	# Find a resource group name that is not in use
	for ($i = 1; $i<10; $i++) {
	    $FORM{"rg"} = "apache-rg-$i";
	    if (! defined $rgdesc{$FORM{"rg"}}) {
		last;
	    }
	    $FORM{"rg"} = "";
	}
    }

    &action_table_row_start(gettext("Resource Group Name:"));
    &input("rg");
    &action_table_supplement(gettext("(only used for shared address)"));
    &action_table_row_end();

    if ($FORM{"ns"} eq "") {
	# Determine which comes first in nsswitch.conf: nis or dns
	open(IN, "grep ^host: /etc/nsswitch.conf | ");
	$_ = <IN>;
	my $i1 = index($_, "nis");
	my $i2 = index($_, "dns");
	if ($i1 < $i2 || $i2 < 0) {
	    $FORM{"ns"} = "NIS";
	} else {
	    $FORM{"ns"} = "DNS";
	}
	close(IN);
    }
    &action_table_row_start(gettext("Name Service:"));
    print "<select name=\"ns\">\n";
    &option("ns", "DNS", "DNS");
    &option("ns", "NIS", "NIS");
    print "</select>\n";
    &action_table_supplement(gettext("(affects bind)"));
    &action_table_row_end();

    &action_table_row_start(gettext("Dots Demo:"));
    &checkbox("dots", "active", "", "checked");
    print gettext("Install &quot;dots&quot; demo");
    &action_table_row_end();
    &action_table_end();

    &submit_table_start();
    &submit("cmd_setup", gettext("Continue"));
    &submit_table_end();
    &wizard_end();
}

# Next part of configuration
sub cmd_setup {
    &wizard_start;
    print $q->_script($q->yoke_jscript("c"));
    &getscrgconfig();

    &validateport("cmd_mainpage", "wport");

    # Get the Solaris version
    my $solarisversion = Cluster::Common::get_solarisversion();

    if (defined $FORM{"pkgcd"}) {
	if (! -d $FORM{"pkgcd"}) {
	    &errpage(gettext("Specified path does not exist"), 1, "cmd_mainpage");
	}
	if (! -e $FORM{"pkgcd"}."/.cdtoc") {
	    &errpage(gettext("Specified path is not a CDROM image (no .cdtoc)"),
		1, "cmd_mainpage");
	}
	if (! -e $FORM{"pkgcd"}."/Solaris_$solarisversion/Product/SUNWapchu") {
	    &errpage(gettext("Apache packages are missing from path"),
		1, "cmd_mainpage");
	}
    }

    if ($FORM{"loc"} eq "") {
	&errpage(gettext("Install directory must be specified."), 3, "cmd_mainpage");
    }

    if (&isglobal($FORM{"loc"}) < 0) {
	&errpage(gettext("Bad install directory."), 3, "cmd_mainpage");
    }

    if ($FORM{"root"} eq "") {
	&errpage(gettext("Apache root directory must be specified."), 4, "cmd_mainpage");
    }

    if ($FORM{"cgi"} eq "") {
	&errpage(gettext("Apache cgi directory must be specified."), 5, "cmd_mainpage");
    }

    my($lh, $lhrg, $lhrs, $lhmode) = split(/:/, $FORM{"lh"});

    if ($FORM{"logdir"} eq "") {
	if (&isglobal($FORM{"loc"})) {
	    $FORM{"logdir"} = "/usr/local/apache/logs-$lh";
	} else {
	    $FORM{"logdir"} = $FORM{"loc"}."/logs";
	}
	&errpage(gettext("Log directory must be specified."), 51, "cmd_mainpage");
    }
    if (&isglobal($FORM{"logdir"}) != 0) {
	if (&isglobal($FORM{"loc"})) {
	    $FORM{"logdir"} = "/usr/local/apache/logs-$lh";
	} else {
	    $FORM{"logdir"} = $FORM{"loc"}."/logs";
	}
	&errpage(gettext("Log directory must be a local directory."), 51,
	    	"cmd_mainpage");
    }

    &validatelh("cmd_mainpage");

    $FORM{"server"} = $lh;

    my $bindaddr;
    if ($FORM{"ns"} eq "DNS") {
	# Bind to logical hostname if DNS in use
	$bindaddr = $lh;
    } else {
	$bindaddr = &hosttoip($lh);
	if ($bindaddr eq "") {
	    &errpage(sprintf(gettext("Can't determine address for %s"), $lh), 4, "cmd_mainpage");
	}
    }
    # print "Binding to $bindaddr XXX\n";

    &getnodes();

    my $global;
    my $codetype = "local";
    my $doctype = "local";
    my $dir = $FORM{"loc"}; # /usr/local/apache install dir
    my $confhost = &Cluster::Common::get_hostname;
    if (&isglobal($FORM{"loc"})) {
	$global = 1;
	# binary and conf installation type
	$codetype = "global";
    } else {
	$codetype = "local";
    }

    if (&isglobal($FORM{"root"})) {
	# docs installation type
	$doctype = "global";
    }

    if ($global) {
	print "<h3>".sprintf(gettext("Installing to global directory %s") ,$FORM{"loc"})."</h3>\n";
    } else {
	print "<h3>".sprintf(gettext("Installing to local directory %s") ,$FORM{"loc"})."</h3>\n";
    }
    print "<p>".gettext("This may take several minutes.")."<p>\n";

    my $CMD = "/cgi-bin/ds/apache-script.pl";
    my (%args) = (confhost => $confhost, codetype => $codetype,
	doctype => $doctype, adir => $dir,
	docdir => $FORM{"root"}, cgidir => $FORM{"cgi"},
	logdir => $FORM{"logdir"}, server => $FORM{"server"},
	bindaddr => $bindaddr, port => $FORM{"wport"});
    if (defined $FORM{"pkgcd"}) {
	$args{"pkgcd"} = $FORM{"pkgcd"}."/Solaris_$solarisversion/Product";
    }
    my $cluster = new Cluster::Common;
    my $err = $cluster->run_parallel($CMD, 1, \%args);
    if ($err) {
	&errmsg(gettext("Apache install script failed"));
	return;
    }

    if ($FORM{"dots"}) {
	my $localdir;
	$localdir = $FORM{"root"};
	&getnodes();
	if (&isglobal($localdir)) {
	    print "<h3>".gettext("Installing global dots demo")."</h3>\n";
	    $localdir = "/var/apache";
	} else {
	    print "<h3>".gettext("Installing local dots demo")."</h3>\n";
	}
	$CMD = "/cgi-bin/ds/dots-script.pl";
	%args = (docdir => $FORM{"root"}, localdir => $localdir, host => $lh,
	    port => $FORM{"wport"}, nodes => join(",", @nodes));

	$err = $cluster->run_parallel($CMD, 1, \%args);
	if ($err) {
	    print $err;
	    &errmsg(gettext("Dots installation failed"));
	    $FORM{"dots"} = "";
	}
    }

    # Pass info to the next page
    &hidden("lh");
    &hidden("root");
    &hidden("rs");
    &hidden("rg");
    &hidden("wport");
    &hidden("loc");
    &hidden("dots");
    &okmsg(gettext("Apache installed"));
    print "<p>".gettext("Press to configure and start resource:\n");
    &submit("cmd_run", gettext("Continue"));

}

sub cmd_run {
    &wizard_start;
    my ($conf, $args, $status);
    my ($lh, $lhrg, $lhrs, $lhmode) = split(/:/, $FORM{"lh"});
    print "<h2>".gettext("Configuring resources")."</h2>\n";
    $conf = $FORM{"loc"}."/conf";
    $args = "-t SUNW.apache ".
	    " -x Confdir_list=$conf".
	    " -x Bin_dir=".$FORM{"loc"}."/bin".
	    " -y Port_list=".$FORM{"wport"}."/tcp".
	    " -y Network_resources_used=$lh";

    $status = &createservice($args);
    if ($status) {
	return;
    }

    &webtestinfo();
    &reloadmenu();
    print $q->_script($q->yoke_jscript("rg-rs-".$FORM{"rg"}));
}
