<%--
/*
 * Copyright 2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 *
 * ident	"@(#)ObanDeviceProperties.jsp	1.2	05/11/04 SMI"
 */
--%>

<%@page info="ObanDeviceProperties" language="java" %> 
<%@taglib uri="/WEB-INF/tld/com_iplanet_jato/jato.tld" prefix="jato"%> 
<%@taglib uri="/WEB-INF/tld/com_sun_cluster_spm/spm.tld" prefix="spm"%>
<%@taglib uri="/WEB-INF/tld/com_sun_web_ui/cc.tld" prefix="cc"%>

<!-- Set the viewbean -->
<jato:useViewBean 
    className="com.sun.cluster.spm.devicegroup.ObanDevicePropertiesViewBean">

<!-- Page header component -->
<spm:header pageTitle="devicegroup.title"
           copyrightYear="2003" 
           baseName="com.sun.cluster.spm.resources.Resources" 
           bundleID="scBundle" onLoad="reloadTree()"
           event="ESC_cluster_dcs_primaries_changing,ESC_cluster_dcs_state_change">

<jato:form name="scForm" method="post">

<!-- Hidden Field for the tree -->
<cc:hidden name="TreeNodeHiddenField"/>

<!-- Alert -->
<spm:alertinline name="CommandResultAlert" bundleID="scBundle" />

<cc:pagetitle name="GenericPageTitle" bundleID="scBundle"
              pageTitleText="devicegroup.properties.pageTitle.title"
              showPageTitleSeparator="true"
              pageTitleHelpMessage="devicegroup.properties.pageTitle.help"/>

<spm:rbac auths="solaris.cluster.device.modify solaris.cluster.device.admin"
	      any="true">
<BR>
</spm:rbac>

<!-- Summary -->
<table border="0" cellpadding="0" cellspacing="0">
<tbody>
 <tr>
   <td valign="top">
     <div class="ConTblCl1Div">&nbsp;
       <span class="LblLev2Txt">
         <label>
           <cc:text name="StaticText" bundleID="scBundle"
                    defaultValue="devicegroup.properties.name"/>
         </label>
       </span>
     </div>
   </td>
   <td valign="top">
     <div class="ConTblCl2Div">
       <span id="psLbl2" class="ConDefTxt">
         <cc:text name="DGName"/>
       </span>
     </div>
   </td>
 </tr>
 <tr>
   <td valign="top">
     <div class="ConTblCl1Div">&nbsp;
       <span class="LblLev2Txt">
         <label>
           <cc:text name="StaticText" bundleID="scBundle"
                    defaultValue="devicegroup.properties.devicetype"/>
         </label>
       </span>
     </div>
   </td>
   <td valign="top">
     <div class="ConTblCl2Div">
       <span id="psLbl2" class="ConDefTxt">
         <cc:text name="DGType"/>
       </span>
     </div>
   </td>
 </tr>
 <tr>
   <td valign="top">
     <div class="ConTblCl1Div">&nbsp;
       <span class="LblLev2Txt">
         <label>
           <cc:text name="StaticText" bundleID="scBundle"
                    defaultValue="devicegroup.properties.status"/>
         </label>
       </span>
     </div>
   </td>
   <td>
     <div class="ConTblCl2Div">
       <span id="psLbl2" class="ConDefTxt">
         <cc:alarm name="DGStatusAlarm"/>
         <cc:text name="DGStatusText"/>
       </span>
     </div>
   </td>
 </tr>
<tbody>
</table>

<div><img src="/com_sun_web_ui/images/other/dot.gif" width="1" height="10" alt=""></div>

<!-- Action Table -->
<cc:actiontable name="DGPropertiesTable"
                bundleID="scBundle"
                title="devicegroup.properties.table.title"
                summary="devicegroup.properties.table.summary"
                empty="devicegroup.properties.table.empty"
                rowSelectionType="none"
                showAdvancedSortingIcon="false"
                showLowerActions="false"
                showPaginationControls="false"
                showPaginationIcon="false"
                showSelectionIcons="false"
                showSortingRow="false"
                maxRows="10"
                page="1"/>

</jato:form>
</spm:header>
</jato:useViewBean>
