<%@taglib uri="/WEB-INF/jato.tld" prefix="jato"%>
<jato:pagelet>

<script language="JavaScript">

  function handleTasksComplete()
  {
    if(false == isAnyTasksExists()) {
      //UWCAlert("No tasks exist - Nothing to Complete!");
      UWCAlert('<%=getLocalizedLabel(session,"i18nModel", "uwc-calclient-view-NoTasksToComplete", "No tasks exist - Nothing to Complete!")%>');      
      return false;
    }
    if(false == isAnyTasksSelected()) {
      //UWCAlert("Please select any tasks to complete!");      
      UWCAlert('<%=getLocalizedLabel(session,"i18nModel", "uwc-calclient-view-SelectTasksToComplete", "Please select any tasks to complete!")%>');      
	  
	  return false;
    }
    return true;
  }

  function handleTasksDelete()
  {
    if(false == isAnyTasksExists()) {
      //UWCAlert("No tasks exist - Nothing to delete!");
      UWCAlert('<%=getLocalizedLabel(session,"i18nModel", "uwc-calclient-view-NoTasksToDelete", "No tasks exist - Nothing to delete!")%>');      
      return false;
    }
    if(false == isAnyTasksSelected()) {
      //UWCAlert("Please select any tasks to delete!");
      UWCAlert('<%=getLocalizedLabel(session,"i18nModel", "uwc-calclient-view-SelectTasksToDelete", "Please select any tasks to delete!")%>');      
	  return false;
    }
    return UWCConfirm("<%= getLocalizedLabel(session, "i18nModel", "uwc-calclient-tasks-DeleteTasksConfirmQuestion", "Are you sure you want to delete the selected tasks?") %>");

  }
     
  function isAnyTasksExists() {
    var elementArray = document.forms[0].elements;
    for(var i=0; i < elementArray.length; i++) 
    {
      if("checkbox" == elementArray[i].type) {
        if(-1 != elementArray[i].name.indexOf("selecttask")) {
          return true;
        }
      }
    }
    return false;
  }

  function isAnyTasksSelected() {
    var elementArray = document.forms[0].elements;
    for(var i=0; i < elementArray.length; i++) 
    {
      if("checkbox" == elementArray[i].type) {
        if(-1 != elementArray[i].name.indexOf("selecttask")) {
          if(elementArray[i].checked) {
            return true;
          }
        }
      }
    }
    return false;
  }

</script>
<noscript></noscript>


<table width="100%" border="0" cellspacing="0" cellpadding="0">
  <tr>
    <td><img src="../uwc/images/spacer.gif" width="1" height="10" alt=""></td>
  </tr>
  <tr> 
    <td class="BlockHeader"><span class="BlockHeaderText"><%= getLocalizedLabel(session, "i18nModel", "uwc-calclient-view-tasks", "Tasks") %></span></td>
  </tr>
  <tr> 
    <td class="TskBtnRow"> 
      <jato:content name="isEmptyTasks">
         <jato:button styleClass="Btn1Dis" name="complete" elementId="complete" defaultValue='<%= getLocalizedLabel(session, "i18nModel", "uwc-common-complete", "Complete") %>'  onClick="return false;"/>
      </jato:content>
      <jato:content name="isNotEmptyTasks">
         <jato:button styleClass="Btn1Mni" name="complete" elementId="complete" defaultValue='<%= getLocalizedLabel(session, "i18nModel", "uwc-common-complete", "Complete") %>' onMouseOver="if (this.disabled==0) this.className='Btn1MniHov'" onFocus="if (this.disabled==0) this.className='Btn1MniHov'" onMouseOut="if (this.disabled==0) this.className='Btn1Mni'" onBlur="if (this.disabled==0) this.className='Btn1Mni'"  extraHtml='<%= getTitleForExtraHtml(session, "uwc-calclient-task-complete", "Complete Task") %>' onClick="return handleTasksComplete();" />
      </jato:content>

      <jato:content name="isEmptyTasks">
       <jato:button styleClass="Btn1Dis"  name="delete" elementId="delete" defaultValue='<%= getLocalizedLabel(session, "i18nModel", "uwc-common-delete", "Delete") %>'  onClick="return false;" />
      </jato:content>
      <jato:content name="isNotEmptyTasks">
       <jato:button styleClass="Btn2Mni"  name="delete" elementId="delete" defaultValue='<%= getLocalizedLabel(session, "i18nModel", "uwc-common-delete", "Delete") %>' onMouseOver="if (this.disabled==0) this.className='Btn2MniHov'" onFocus="if (this.disabled==0) this.className='Btn2MniHov'" onMouseOut="if (this.disabled==0) this.className='Btn2Mni'" onBlur="if (this.disabled==0) this.className='Btn2Mni'"  extraHtml='<%= getTitleForExtraHtml(session, "uwc-calclient-task-delete-alt", "Delete Task") %>' onClick="return handleTasksDelete();"/>
      </jato:content>
    </td>
  </tr>
  <tr> 
    <td class="TskTaskRow"> 
      <table width="100%" border="0" cellspacing="5" cellpadding="0">
        <tr> 
          <td colspan="2"><span class="TskOverdue"><%= getLocalizedLabel(session, "i18nModel", "uwc-calclient-view-OverDueTasksTitle", "Overdue Tasks") %></span></td>
        </tr>

        <jato:tiledView name="overdueTasksTileView" type="com.sun.uwc.calclient.TasksPaneTileView">
        <tr> 
          <td valign="top"> 
           <jato:content name="canDeleteTask" >
            <label for="selecttask"></label>
            <jato:checkbox name="selecttask" elementId="selecttask" />
            <jato:hidden name="taskid" />
            <jato:hidden name="taskrid" />
            <jato:hidden name="calid" />
           </jato:content>
          </td>
          <td>
              <jato:content name="isConfidentialEvent">
                <%= getLocalizedLabel(session, "i18nModel", "uwc-calclient-view-Busy", "Busy") %>
              </jato:content>
              <jato:content name="isNotConfidentialEvent">
                <a href="<jato:text name='opentask'/>" class="Lnk" onClick='openWinAutoHeight("<jato:text name='opentask'/>", "", "width=600,titlebar=yes,resizable=yes,scrollbars=yes"); return false;'>
                <uwc:text name="tasktitle" />
                </a>
              </jato:content>
              <br>
              <%= getLocalizedLabel(session, "i18nModel", "uwc-calclient-view-DueLabel", "Due") %>
              <jato:text name="duedate" escape="false" /><br>
              <jato:text name="calname" escape="false" />
          </td>
        </tr>
        </jato:tiledView>
        <jato:content name="noTasks">
         <tr>
            <td><%= getLocalizedLabel(session, "i18nModel", "uwc-calclient-view-NoOverDueTasksLabel", "No overdue tasks for the current day") %>
           </td>
         </tr>
        </jato:content>
        <tr> 
          <td>&nbsp;</td>
          <jato:content name="overDueMaxNumberExceeded" >
             <td>
                 <a href="<jato:text name='moretasks'/>" class="Lnk"><%= getLocalizedLabel(session, "i18nModel", "uwc-calclient-view-MoreTasksLabel", "More...") %>
                 </a>
             </td>
          </jato:content>
        </tr>
      </table>
    </td>
  </tr>

  <tr> 
    <td class="TskTaskRow"> 
      <table width="100%" border="0" cellspacing="5" cellpadding="0">
        <tr> 
          <td colspan="2"><span class="Lbl2">
            <%= getLocalizedLabel(session, "i18nModel", "uwc-calclient-view-DueLabel", "Due") %><jato:text name="today" escape="false" />
          </span></td>
        </tr>
        <jato:tiledView name="currentContextDueTasksTileView" type="com.sun.uwc.calclient.TasksPaneTileView">
        <tr> 
          <td valign="top"> 
           <jato:content name="canDeleteTask" >
            <label for="selecttask"></label>
            <jato:checkbox  name="selecttask" elementId="selecttask" />
            <jato:hidden name="taskid" />
            <jato:hidden name="taskrid" />
            <jato:hidden name="calid" />
           </jato:content>
          </td>
          <td>
              <jato:content name="isConfidentialEvent">
                <%= getLocalizedLabel(session, "i18nModel", "uwc-calclient-view-Busy", "Busy") %>
              </jato:content>
              <jato:content name="isNotConfidentialEvent">
                <a href="<jato:text name='opentask'/>" class="Lnk" onClick='openWinAutoHeight("<jato:text name='opentask'/>", "", "width=600,titlebar=yes,resizable=yes,scrollbars=yes"); return false;'>
                <uwc:text name="tasktitle" />
                </a>
              </jato:content>
              <br>
              <%= getLocalizedLabel(session, "i18nModel", "uwc-calclient-view-DueLabel", "Due") %>:
              <jato:text name="duedate" escape="false" /><br>
              <jato:text name="calname" escape="false" /><br>
          </td>
        </tr>
        </jato:tiledView>

        <jato:content name="noTasks">
         <tr>
           <td><%= getLocalizedLabel(session, "i18nModel", "uwc-calclient-view-NoDueTasksLabel", "No Tasks due for the selected date") %>
           </td>
         </tr>
        </jato:content>
        <tr> 
          <td>&nbsp;</td>
          <jato:content name="dueMaxNumberExceeded" >
            <td>
                 <a href="<jato:text name='moretasks'/>" class="Lnk"><%= getLocalizedLabel(session, "i18nModel", "uwc-calclient-view-MoreTasksLabel", "More...") %></a>
            </td>
          </jato:content>
        </tr>
      </table>
    </td>
  </tr>

  <tr> 
  <jato:content name="showCompletedTasks" >
    <td class="TskTaskRow"> 
      <table width="100%" border="0" cellspacing="5" cellpadding="0">
        <tr> 
          <td colspan="2"><span class="Lbl2">
            <%= getLocalizedLabel(session, "i18nModel", "uwc-calclient-view-CompletedLabel", "Completed") %>
          </span></td>
        </tr>
        <jato:tiledView name="completedTasksTileView" type="com.sun.uwc.calclient.TasksPaneTileView">
        <tr> 
          <td>
              <jato:content name="isConfidentialEvent">
                <%= getLocalizedLabel(session, "i18nModel", "uwc-calclient-view-Busy", "Busy") %>
              </jato:content>
              <jato:content name="isNotConfidentialEvent">
                <a href="<jato:text name='opentask'/>" class="Lnk" onClick='openWinAutoHeight("<jato:text name='opentask'/>", "", "width=600,titlebar=yes,resizable=yes,scrollbars=yes"); return false;'>
                <uwc:text name="tasktitle" />
                </a>
              </jato:content>
              <br>
              <jato:text name="calname" escape="false" /><br>
          </td>
        </tr>
        </jato:tiledView>

        <jato:content name="noTasks">
         <tr>
           <td><%= getLocalizedLabel(session, "i18nModel", "uwc-calclient-view-NoCompletedTasksLabel", "No completed tasks for the selected date") %>
           </td>
         </tr>
        </jato:content>
        <tr> 
          <td>&nbsp;</td>
          <jato:content name="completedMaxNumberExceeded" >
            <td>
                 <a href="<jato:text name='moretasks'/>" class="Lnk"><%= getLocalizedLabel(session, "i18nModel", "uwc-calclient-view-MoreTasksLabel", "More...") %></a>
            </td>
          </jato:content>
        </tr>
      </table>
    </td>
  </jato:content>
  </tr>
  <tr> 
    <td class="TskBtnRow"> 
      <jato:content name="isEmptyTasks">
         <jato:button styleClass="Btn1Dis" name="complete" elementId="complete" defaultValue='<%= getLocalizedLabel(session, "i18nModel", "uwc-common-complete", "Complete") %>'  onClick="return false;"/>
      </jato:content>
      <jato:content name="isNotEmptyTasks">
       <jato:button styleClass="Btn1Mni" name="complete" elementId="complete" defaultValue='<%= getLocalizedLabel(session, "i18nModel", "uwc-common-complete", "Complete") %>' onMouseOver="if (this.disabled==0) this.className='Btn1MniHov'" onFocus="if (this.disabled==0) this.className='Btn1MniHov'" onMouseOut="if (this.disabled==0) this.className='Btn1Mni'" onBlur="if (this.disabled==0) this.className='Btn1Mni'"  extraHtml='<%= getTitleForExtraHtml(session, "uwc-calclient-task-complete", "Complete Task") %>' onClick="return handleTasksComplete();" />
      </jato:content>

      <jato:content name="isEmptyTasks">
         <jato:button styleClass="Btn1Dis" name="delete" elementId="delete" defaultValue='<%= getLocalizedLabel(session, "i18nModel", "uwc-common-delete", "Delete") %>'  onClick="return false;"/>
      </jato:content>
      <jato:content name="isNotEmptyTasks">
       <jato:button styleClass="Btn2Mni" name="delete" elementId="delete" defaultValue='<%= getLocalizedLabel(session, "i18nModel", "uwc-common-delete", "Delete") %>' onMouseOver="if (this.disabled==0) this.className='Btn2MniHov'" onFocus="if (this.disabled==0) this.className='Btn2MniHov'" onMouseOut="if (this.disabled==0) this.className='Btn2Mni'" onBlur="if (this.disabled==0) this.className='Btn2Mni'"  extraHtml='<%= getTitleForExtraHtml(session, "uwc-calclient-task-delete-alt", "Delete Task") %>' onClick="return handleTasksDelete();" />
      </jato:content>
    </td>
  </tr>
</table>

</jato:pagelet>
