<html>

<%@page info="Events" language="java" pageEncoding="utf-8" contentType="text/html; charset=UTF-8"%>
<%@taglib uri="/WEB-INF/jato.tld" prefix="jato"%>

<%@include file="../../uwc/js/resourceBundleUtils.js"%>

<jato:useViewBean className="com.sun.uwc.calclient.EventsViewBean">

<head>
<title><%= getLocalizedLabel(session, "uwc-calclient-events-title", "Events - Sun&#153;ONE Unified Messaging Client") %></title>

<script src="../uwc/js/browserVersion.js" type="text/javascript"> </script>
<script src="../uwc/js/scripts.js" type="text/javascript"> </script>
<script src="../uwc/js/uwcUtils.js" type="text/javascript"> </script>
<script src="../uwc/js/date_utils.js" type="text/javascript"> </script>
<script type="text/javascript">
//<!--
  if (is_ie5up) // IE5
  {
   document.write("<LINK href=<%= getLocalizedLabel(session, "skinModel", "Style-Sheet-IE", "../uwc/css/css_ie5win.css") %> type=text/css rel=stylesheet>")
  }
  else if (is_gecko) // Netscape 6/7 or Mozilla
  {
   document.write("<LINK href=<%= getLocalizedLabel(session, "skinModel", "Style-Sheet-NN", "../uwc/css/css_ns6up.css") %> type=text/css rel=stylesheet>")
  }
  else  // All others
  {
   document.write("<LINK href=<%= getLocalizedLabel(session, "skinModel", "Style-Sheet-NN", "../uwc/css/css_ns6up.css") %> type=text/css rel=stylesheet>")
  }
//-->
</script>
</head>

<script>
<!--

  var dirtyCache = 0;
  var doNotShowSaveConfirmAlert = 0;

  function setDirtyCache() {
    dirtyCache = 1;
  }

  function setDoNotShowSaveConfirmAlert() {
    doNotShowSaveConfirmAlert = 1;
  }

  function handleGo() {
    var monthOptions = document.EventsInputForm.elements["monthSelect"].options;
    var theMonth = monthOptions.selectedIndex;
    var theDay = document.EventsInputForm.elements["daySelect"].value;
    var theYear = document.EventsInputForm.elements["yearSelect"].value;
 
    if(false == isValidDate(theDay ,theMonth, theYear)) {
      alert('<%= getLocalizedLabel(session, "uwc-calclient-events-invalid-date", "Invalid dates selected in events View section!") %>');
      return false;
    }
 
    return true;
  }

  function handleBackDate() {
    document.EventsInputForm.submitType.value = "BackDate";
    document.EventsInputForm.elements["GoButton"].click();  
  }

  function handleForwardDate() {
    document.EventsInputForm.submitType.value = "ForwardDate";
    document.EventsInputForm.elements["GoButton"].click(); 
  }

  function getDeleteConfirm() {
    if(false == isAnyEventsExists()) {
      window.alert("<%= getLocalizedLabel(session, "uwc-calclient-events-alertMessage-NoEventsExistsToDelete", "No events exists - Nothing to delete!") %>");
      return false;
    }
    if(false == isAnyEventsSelected()) {
      window.alert("<%= getLocalizedLabel(session, "uwc-calclient-events-alertMessage-selectEventsToDelete", "Please select some events to delete!") %>");
      return false;
    }
    return window.confirm("<%= getLocalizedLabel(session, "uwc-calclient-events-DeleteEventsConfirmQuestion", "Are you sure you want to delete the selected events?") %>");
  }

  function getSaveConfirm() {
    setDoNotShowSaveConfirmAlert();
    if(false == isAnyEventsExists()) {
      window.alert("<%= getLocalizedLabel(session, "uwc-calclient-events-alertMessage-NoEventsExistsToSave", "No events exists - Nothing to save!") %>");
      return false;
    }
    if(1 == dirtyCache) {
      return window.confirm("<%= getLocalizedLabel(session, "uwc-calclient-events-SaveEventsConfirmQuestion", "Are you sure you want to save the changed events?") %>");
    }
    else {
      window.alert("<%= getLocalizedLabel(session, "uwc-calclient-events-alertMessage-NoEventsChangedToSave", "No events changed - Nothing to save!") %>");
      return false;
    }
  }

  function unloadPage() {
    if(0 == doNotShowSaveConfirmAlert) {
      if((isAnyEventsExists()) && (1 == dirtyCache)) {
        document.EventsInputForm.elements["Events.Save"].click();
      }
    }
  }

  function handleSearch() {
    document.EventsInputForm.EnableSearchMode.value = "true";

    var inputText = document.EventsInputForm.elements["Events.SearchText"].value;
    if((null == inputText) || ("" == trim(inputText))) {
      return window.confirm("<%= getLocalizedLabel(session, "uwc-calclient-events-BlankSearchTextConfirmQuestion", "The search text entered by you is blank. Are you sure you want to proceed with searching the events?") %>");
    }

    return true;
  }

  function handleSave() {
    document.EventsInputForm.elements["Events.Save"].click();
  }

  function isAnyEventsExists() {
    var elementArray = document.EventsInputForm.elements;
    for(var i=0; i < elementArray.length; i++) 
    {
      if("checkbox" == elementArray[i].type) {
        if(-1 != elementArray[i].name.indexOf("SelectEvent")) {
          return true;
        }
      }
    }
    return false;
  }

  function isAnyEventSelected() {
    var elementArray = document.EventsInputForm.elements;
    for(var i=0; i < elementArray.length; i++) 
    {
      if("checkbox" == elementArray[i].type) {
        if(-1 != elementArray[i].name.indexOf("SelectEvent")) {
          if(elementArray[i].checked) {
            return true;
          }
        }
      }
    }
    return false;
  }

  function selectEvents(isChecked) {
    var elementArray = document.EventsInputForm.elements;
    for(var i=0; i < elementArray.length; i++) 
    {
      if("checkbox" == elementArray[i].type) {
        if(-1 != elementArray[i].name.indexOf("SelectEvent")) {
          elementArray[i].checked = isChecked;
        }
      }
    }
  }

  var SORT_CRITERIA_TITLE_ASCENDING = "TitleAscending";
  var SORT_CRITERIA_TITLE_DECENDING = "TitleDescending";
  var SORT_CRITERIA_START_DATE_ASCENDING = "StartDateAscending";
  var SORT_CRITERIA_START_DATE_DECENDING = "StartDateDescending";
  
  function getSortCriteria() {
    var sortCriteria = document.EventsInputForm.elements["Events.SortCriteria"].value;
    sortCriteria = trim(sortCriteria);
    return sortCriteria;
  }

  function setSortCriteria(theCriteria) {
    theCriteria = trim(theCriteria);
    document.EventsInputForm.elements["Events.SortCriteria"].value = theCriteria;
  }

  
  function titleSort() {
    var sortCriteria = getSortCriteria();
    if(SORT_CRITERIA_TITLE_DECENDING == sortCriteria) {
      setSortCriteria(SORT_CRITERIA_TITLE_ASCENDING);
    }
    else if(SORT_CRITERIA_TITLE_ASCENDING == sortCriteria) {
      setSortCriteria(SORT_CRITERIA_TITLE_DECENDING);
    }
    else {
      setSortCriteria(SORT_CRITERIA_TITLE_ASCENDING);
    }
    document.EventsInputForm.submitType.value = "Sorting";
    document.EventsInputForm.elements["GoButton"].click();  
  }

  function startDateSort() {
    var sortCriteria = getSortCriteria();
    if(SORT_CRITERIA_START_DATE_DECENDING == sortCriteria) {
      setSortCriteria(SORT_CRITERIA_START_DATE_ASCENDING);
    }
    else if(SORT_CRITERIA_START_DATE_ASCENDING == sortCriteria) {
      setSortCriteria(SORT_CRITERIA_START_DATE_DECENDING);
    }
    else {
      setSortCriteria(SORT_CRITERIA_START_DATE_ASCENDING);
    }
    document.EventsInputForm.submitType.value = "Sorting";
    document.EventsInputForm.elements["GoButton"].click();  
  }

  
//-->
</script>

<body leftmargin="0" topmargin="0" marginwidth="0" marginheight="0" class="Page" onUnload="return unloadPage();">

<jato:form name="EventsInputForm" method="post">

<table cellspacing=0 cellpadding=0 width="100%" border=0 bgcolor="#CCCCFF">
    <tr>
    	<td class="SkpMst"><a href=#tabs><img src="../uwc/images/spacer.gif" height="1" width="1" border="0" alt="<%=getLocalizedLabel(session, "i18nModel", "uwc-common-skiplink-Masthead-message", "Skip Masthead")%>"></a></td>
		<td class="SkpMst"><a href=#calendarviewtabs><img src="../uwc/images/spacer.gif" height="1" width="1" border="0" alt="<%=getLocalizedLabel(session, "i18nModel", "uwc-common-skiplink-GlobalTabs-message", "Skip Global Tabs")%>"></a></td>
		<td class="SkpMst"><a href=#toolbar><img src="../uwc/images/spacer.gif" height="1" width="1" border="0" alt="<%=getLocalizedLabel(session, "i18nModel", "uwc-common-skiplink-CalendarViewTabs-message", "Skip Calendar View Tabs")%>"></a></td>
		<td class="SkpMst"><a href=#searchevents><img src="../uwc/images/spacer.gif" height="1" width="1" border="0" alt="<%=getLocalizedLabel(session, "i18nModel", "uwc-common-skiplink-SearchEvents-message", "Search for Events")%>"></a></td>
		<td class="SkpMst"><a href=#jumptomenus><img src="../uwc/images/spacer.gif" height="1" width="1" border="0" alt="<%=getLocalizedLabel(session, "i18nModel","uwc-common-skiplink-jumpToDayMonthYear", "Jump to a day, month or year")%>"></a></td>
		<td class="SkpMst"><a href=#calendargrid><img src="../uwc/images/spacer.gif" height="1" width="1" border="0" alt="<%=getLocalizedLabel(session, "i18nModel","uwc-common-skiplink-calendarGrid","Skip to calendar grid")%>"></a></td>
    	<td class="SkpMst"><a href=#quickaddevent><img src="../uwc/images/spacer.gif" height="1" width="1" border="0" alt="<%=getLocalizedLabel(session, "i18nModel","uwc-common-skiplink-quickAdd","Skip to Quick Add Event")%>"></a></td>
	</tr>
</table>

<input type="hidden" name="EnableSearchMode" value="false">
<input type="hidden" name="submitType">
<jato:hidden name="SelectedDateInUTC"/>
<jato:hidden name="TimeZone"/>
<jato:hidden name="SortCriteria"/>

<jato:containerView name="MasterHead">
  <%@include file="/uwc/common/MasterHeadNormal.jsp"%>
</jato:containerView>

<jato:containerView name="CalApplBar">
  <%@include file="/uwc/calclient/CalApplBarNormal.jsp"%>
</jato:containerView>

<!-- Calendar view tabs are starting from here -->
<div class="Tab2">
    <table border="0" cellspacing="0" cellpadding="0" class="Tab2Tbl" width="100%" summary="Table that contains the Calendar View Tabs">
      <tr> 
        <td colspan="18"><img src="../uwc/images/spacer.gif" width="1" height="10" alt=""></td>
      </tr>
      <tr> 
        <td colspan="9"><img src="../uwc/images/spacer.gif" width="10" height="1" alt=""></td>
        <td colspan="5" class="Tab2LineBkgd"><img src="../uwc/images/spacer.gif" width="1" height="1" alt=""></td>
        <td colspan="4"><img src="../uwc/images/spacer.gif" width="1" height="1" alt=""></td>
      </tr>
      <tr> 
        <td><img src="../uwc/images/spacer.gif" width="10" height="1" alt=""></td>
        <td class="Tab2NotSel"> 
          <div class="Tab2NotSel"><a title="<%= getLocalizedLabel(session, "uwc-calclient-toolbar-tooltip-Day", "Calendar Day View") %>" href="<%= getContextURI(request) %>/calclient/DayView?<jato:text name='ContextQueryString' escape='false'/>" class="TabLblNormal" onmouseout="status=';'"><%= getLocalizedLabel(session, "uwc-calclient-toolbar-Day", "Day") %></a></div>
        </td>
        <td><img src="../uwc/images/dividerbar.gif" alt="" width="24" height="20"></td>
        <td class="Tab2NotSel"> 
          <div class="Tab2NotSel"><a title="<%= getLocalizedLabel(session, "uwc-calclient-toolbar-tooltip-Week", "Calendar Week View") %>" href="<%= getContextURI(request) %>/calclient/WeekView?<jato:text name='ContextQueryString' escape='false'/>" class="TabLblNormal" onmouseout="status=';'"><%= getLocalizedLabel(session, "uwc-calclient-toolbar-Week", "Week") %></a></div>
        </td>
        <td><img src="../uwc/images/dividerbar.gif" alt="" width="24" height="20"></td>
        <td class="Tab2NotSel"> 
          <div class="Tab2NotSel"><a title="<%= getLocalizedLabel(session, "uwc-calclient-toolbar-tooltip-Month", "Calendar Month View") %>" href="<%= getContextURI(request) %>/calclient/MonthView?<jato:text name='ContextQueryString' escape='false'/>" class="TabLblNormal" onmouseout="status=';'"><%= getLocalizedLabel(session, "uwc-calclient-toolbar-Month", "Month") %></a></div>
        </td>
        <td><img src="../uwc/images/dividerbar.gif" width="10" height="1" alt=""></td>
        <td class="Tab2NotSel"> 
          <div class="Tab2NotSel"><a title="<%= getLocalizedLabel(session, "uwc-calclient-toolbar-tooltip-Year", "Calendar Year View") %>" href="<%= getContextURI(request) %>/calclient/YearView?<jato:text name='ContextQueryString' escape='false'/>" class="TabLblNormal" onmouseout="status=';'"><%= getLocalizedLabel(session, "uwc-calclient-toolbar-Year", "Year") %></a></div>
        </td>
		<td><img src="../uwc/images/dividerbar.gif" width="10" height="1" alt=""></td>
		<td class="Tab2LineBkgd"><img src="../uwc/images/spacer.gif" width="1" height="12" alt=""></td>
        <td class="Tab2Sel"><img src="../uwc/images/spacer.gif" width="10" height="1" alt=""></td>
        <td class="Tab2Sel"> 
          <div class="Tab2Sel"><span class="TabLblSel" title="<%= getLocalizedLabel(session, "uwc-calclient-toolbar-tooltip-Events", "Event List") %>"><%= getLocalizedLabel(session, "uwc-calclient-toolbar-Events", "Events") %></span></div>
        </td>
        <td class="Tab2Sel"><img src="../uwc/images/spacer.gif" width="10" height="1" alt=""></td>
        <td class="Tab2LineBkgd"><img src="../uwc/images/spacer.gif" width="1" height="12" alt=""></td>
        <td><img src="../uwc/images/spacer.gif" width="10" height="1" alt=""></td>
        <td class="Tab2NotSel"> 
          <div class="Tab2NotSel">
          <jato:content name="showInvitations">
              <a title="<%= getLocalizedLabel(session, "uwc-calclient-toolbar-tooltip-Invitations", "Invitations List") %>" href="<%= getContextURI(request) %>/calclient/Invitations?<jato:text name='ContextQueryString' escape='false'/>" class="TabLblNormal" onmouseout="status=';'">
         </jato:content> 
        <%= getLocalizedLabel(session, "uwc-calclient-toolbar-Invitations", "Invitations") %>
        <jato:content name="showInvitations">
          </a>
        </jato:content>
        </div>
		</td>
		<td><img src="../uwc/images/dividerbar.gif"  width="24" height="20" alt=""></td>
        <td class="Tab2NotSel" width="90%"> 
          <div class="Tab2NotSel"><a title="<%= getLocalizedLabel(session, "uwc-calclient-toolbar-tooltip-Tasks", "Tasks List") %>" href="<%= getContextURI(request) %>/calclient/Tasks?<jato:text name='ContextQueryString' escape='false'/>" class="TabLblNormal" onmouseout="status=';'"><%= getLocalizedLabel(session, "uwc-calclient-toolbar-Tasks", "Tasks") %></a></div>
        </td>
       </tr>
      <tr> 
        <td class="Tab2LineBkgd"><img src="../uwc/images/spacer.gif" width="1" height="1" alt=""></td>
        <td colspan="9" class="Tab2LineBkgd"><img src="../uwc/images/spacer.gif" width="1" height="1" alt=""></td>
        <td colspan="3"><img src="../uwc/images/spacer.gif" width="1" height="1" alt=""></td>
        <td colspan="5" class="Tab2LineBkgd"><img src="../uwc/images/spacer.gif" width="1" height="1" alt=""></td>
      </tr>
    </table>
</div>

<jato:containerView name="FullPageErrorPlugin">
  <%@include file="/uwc/common/FullPageError.jsp"%>
</jato:containerView>

</jato:form>
</body>
</jato:useViewBean>

</html>
