<?xml version="1.0"?>
<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>

<xsl:stylesheet version='1.0' xmlns:xsl='http://www.w3.org/1999/XSL/Transform'>

  <xsl:output method="html" version="4" encoding="UTF-8"/>

  <xsl:include href="commonimages.xsl"/>
  <xsl:include href="commonjavascript.xsl"/>
  <xsl:include href="commonattributes-hidden.xsl"/>
  <xsl:include href="context.xsl"/>
  <xsl:include href="css-select.xsl"/>
  <xsl:include href="common-uielements.xsl"/>
  <xsl:include href="common-editcontact.xsl"/>

  <xsl:template match="/">
    <html>
      <head>
        <title>
          <xsl:text>_iPlanet Address Book - Add/Change Membership</xsl:text>
        </title>
        <link type="text/css" rel="stylesheet" href="{$commonCSS.css}"/> 

        <xsl:call-template name="styleSheetSelector">
          <xsl:with-param name="htmlprefs" select="/xslui/profileinfo/xmlprofile/htmlprefs"/>     
        </xsl:call-template>
        <xsl:call-template name="fontMaker">
          <xsl:with-param name="htmlprefs" select="/xslui/profileinfo/xmlprofile/htmlprefs"/>     
        </xsl:call-template>
        <script language="javascript" src="../absjs/common.js"/>
        <script language="Javascript">
          <xsl:call-template name="commonjavascript"/>
          function updateMembership() {
            var memberofbook = "<xsl:value-of select="$fieldPrefix"/>memberOfPIBook";
            var selectedBookIDs = '';
            for(i=0; i&lt;document.iabform.elements.length; i++) { 
              if( document.iabform.elements[i].name == memberofbook  &amp;&amp; document.iabform.elements[i].checked == true) 
                selectedBookIDs += document.iabform.elements[i].value + ",";
            }
            document.iabform.selectedbookid.value = selectedBookIDs.substr(0, selectedBookIDs.length - 1);
            submitForm('updatemember');
          }

          function no() {
            goToUsingForm('search.xml');
          }
        </script>
      </head>
      <body leftmargin="0" topmargin="0" rightmargin="0" marginwidth="0" marginheight="0">
        <form method="post" name="iabform" action="search.xml">
          <input type="hidden" name="j_encoding" value="{/xslui/@charset}"/>
          <input type="hidden" name="uiaction" value=""/>
          <input type="hidden" name="selectedbookid" value=""/>
          
          <table width="100&#37;" border="0" cellspacing="0" cellpadding="0">
            <tr> 
              <td colspan="3">
                <img src="{$spacer.gif}" width="1" height="18"/>
              </td>
            </tr>
            <tr align="center">
              <td>
                <img src="{$spacer.gif}" width="17" height="1"/>
              </td>
              <td>  
                <table cellpadding="0" cellspacing="0" border="0" height="0&#37;" width="70&#37;">
                  <tr> 
                    <td colspan="3" bgcolor="#FFCC33">
                      <img src="{$spacer.gif}" width="1" height="5"/>
                    </td>
                  </tr>
                  <tr> 
                    <td colspan="3">
                      <img src="{$spacer.gif}" width="1" height="12"/>
                    </td>
                  </tr>
                  <tr> 
                    <td align="center" width="10&#37;">
                      <img src="{$warning_32.gif}" width="32" height="32">
                        <xsl:attribute name="alt">
                          <xsl:text>_Warning Message</xsl:text>
                        </xsl:attribute> 
                      </img>
                    </td>
                    <td width="85&#37;">
                      <span class="large-text">
                        <b>
                          <xsl:text>Add/Change Membership of Contacts</xsl:text>
                        </b>
                      </span>
                    </td>
                    <td width="5&#37;">&nbsp;</td>
                  </tr>
                  <tr> 
                    <td colspan="3">
                      <img src="{$spacer.gif}" width="1" height="6"/>
                    </td>
                  </tr>
                  <tr>
                    <td>&nbsp;</td>
                    <td>
                      <span class="normal">
                        <xsl:text>_Choose the Address Book to which you wish to move/copy the listed contacts</xsl:text>
                      </span>
                    </td>
                    <td>&nbsp;</td>
                  </tr>
                  <tr> 
                    <td colspan="3">
                      <img src="{$spacer.gif}" width="1" height="6"/>
                    </td>
                  </tr>
                  <tr> 
                    <td colspan="3">
                      <img src="{$spacer.gif}" width="1" height="6"/>
                    </td>
                  </tr>
                  <tr> 
                    <td>&nbsp;</td>
                    <td> 
                      <table width="100&#37;" border="0" cellspacing="0" cellpadding="0">
                        <tr> 
                          <td width="17">
                            <img src="{$spacer.gif}" width="17" height="25"/>
                          </td>
                          <td>
                            <p class="colheader">
                              <xsl:text>_Name</xsl:text>
                            </p>
                          </td>
                          <td width="10">
                            <img src="{$spacer.gif}" width="17" height="1"/>
                          </td>
                          <td>
                            <p class="colheader">
                              <xsl:text>_Email</xsl:text>
                            </p>
                          </td>
                          <td>
                            <p class="colheader">
                              <xsl:text>Membership</xsl:text>
                            </p>
                          </td>
                          <td width="17">
                            <img src="{$spacer.gif}" width="17" height="1"/>
                          </td>
                        </tr>
                        <tr> 
                          <td colspan="5" bgcolor="#999999">
                            <img src="{$spacer.gif}" width="1" height="1"/>
                          </td>
                        </tr>
                        <xsl:for-each select="/xslui/iab/alreadyselected/*">
                          <xsl:variable name="rowClass">
                            <xsl:choose>
                              <xsl:when test="position() mod 2 = 0">
                                <xsl:text>third-strip</xsl:text>
                              </xsl:when>
                              <xsl:otherwise>
                                <xsl:text>white-strip</xsl:text>
                              </xsl:otherwise>
                            </xsl:choose> 
                          </xsl:variable>      
                          
                          <tr class="{$rowClass}">                                 
                            <td height="20">&nbsp;</td>
                            <td>
                              <span class="normal">
                                <xsl:value-of select="./entry/displayname" /> 
                              </span>
                            </td>
                            <td>&nbsp;</td>
                            <td>
                              <span class="normal">
                                <xsl:value-of select="./email[@priority='1']" />&nbsp;
                              </span>
                            </td>
                            <td>
                            <table>
                          <xsl:variable name="fieldPrefix">
                            <xsl:value-of select="$fieldPrefix"/>
                            <xsl:value-of select="./entry/@entryID"/>
                            <xsl:text>_</xsl:text>
                          </xsl:variable>
                          <input type="hidden" name="prefix" value="{$fieldPrefix}"/>
                          <input type="hidden" name="entryid" value="{entry/@entryID}"/>
                          <xsl:for-each select="/xslui/iab/bookentries/bookentry/abperson[entry/@entryID = current()/entry/@entryID]/memberofbook">
                            <tr> <td>
                             <input type="hidden" name="{$fieldPrefix}bookid" value="{/xslui/iab/booklist/book[entry/@entryID = current()]/entry/@entryID}"/>
                             <span class="normal">
                              <xsl:value-of select="/xslui/iab/booklist/book[entry/@entryID = current()]/entry/displayname"/>
                            </span>
                           </td>
                           <td>
                             <img height="{$lineSpacing}" src="{$spacer.gif}" width="1"/>
                           </td>
                           </tr>
                            </xsl:for-each>
                            </table>
                            </td>
                          </tr>
                        </xsl:for-each> 
                        <tr> 
                          <td colspan="5" bgcolor="#999999">
                            <img src="{$spacer.gif}" width="1" height="1"/>
                          </td>
                        </tr>
                      </table>
                    </td>
                    <td>&nbsp;</td>
                  </tr>
                  <tr> 
                    <td colspan="3">
                      <img src="{$spacer.gif}" width="1" height="12"/>
                    </td>
                  </tr>
                  <tr>
                   <td>
                     <xsl:call-template name="memberships"/>
                    </td>
                    <td>&nbsp;</td>
                  </tr>
                  <tr>
                    <td colspan="3">
                      <img src="{$spacer.gif}" width="1" height="12"/>
                    </td>
                  </tr>
                  <tr> 
                    <td>&nbsp;</td>
                    <td align="center"> 
                      <table border="0" cellspacing="0" cellpadding="0">
                        <tr>
                          <td>
                            <xsl:call-template name="button">
                              <xsl:with-param name="label">
                                <xsl:text>_Save</xsl:text>
                              </xsl:with-param>
                              <xsl:with-param name="bgColorIndex" select="'w'"/>
                              <xsl:with-param name="href" select="'javascript:updateMembership()'"/>
                            </xsl:call-template>
                          </td>
                          <td rowspan="2"><img src="{$spacer.gif}" border="0" width="5" height="1" alt=" "/></td>
                          <td>
                            <xsl:call-template name="button">
                              <xsl:with-param name="label">
                                <xsl:text>_Cancel</xsl:text>
                              </xsl:with-param>
                              <xsl:with-param name="bgColorIndex" select="'w'"/>
                              <xsl:with-param name="href" select="'javascript:no()'">
                              </xsl:with-param> 
                              
                            </xsl:call-template>
                          </td>
                          <td rowspan="2"><img src="{$spacer.gif}" border="0" width="5" height="1" alt=" "/></td>
                          <td>
                            <xsl:call-template name="button">
                              <xsl:with-param name="label">
                                <xsl:text>_Help</xsl:text>
                              </xsl:with-param>
                              <xsl:with-param name="bgColorIndex" select="'w'"/>
                            </xsl:call-template>
                          </td>
                        </tr>
                      </table>          
                    </td>
                    <td>&nbsp;</td>
                  </tr>
                  <tr> 
                    <td colspan="3">
                      <img src="{$spacer.gif}" width="1" height="12"/>
                    </td>
                  </tr>
                  <tr> 
                    <td colspan="3" bgcolor="#FFCC33">
                      <img src="{$spacer.gif}" width="1" height="5"/>
                    </td>
                  </tr>
                </table>
              </td>
              <!-- end of error message table -->
              <td width="5" height="5">
                <img src="{$spacer.gif}" width="1" height="1"/>
              </td>
            </tr>
          </table>
        </form>
      </body>
    </html>
  </xsl:template> 
</xsl:stylesheet>
