<?xml version="1.0"?>
<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:output method="html" version="4" encoding="UTF-8"/>

<xsl:include href="common-uielements.xsl"/>
<xsl:include href="css-select.xsl"/>

<xsl:variable name="iPlanet_logo.gif" select="'../absimx/iplanet_logo.gif'"/>
<xsl:variable name="grey_dot.gif" select="'../absimx/grey_dot.gif'"/>
<xsl:variable name="red_rollover_dot.gif" select="'../absimx/red_dot.gif'"/>
<xsl:variable name="left_strip.gif" select="'../absimx/left_strip.gif'"/>
<xsl:variable name="center_strip.gif" select="'../absimx/center_strip.gif'"/>
<xsl:variable name="right_strip.gif" select="'../absimx/right_strip.gif'"/>
<xsl:variable name="RedGrey_blank.gif" select="'../absimx/RedGrey_blank.gif'"/>
<xsl:variable name="AddressBook_5_01.gif" select="'../absimx/AddressBook_5_01.gif'"/>

<xsl:variable name="error_32.gif" select="'../absimx/error_32.gif'"/>
<xsl:variable name="spacer.gif" select="'../absimx/spacer.gif'"/>

<xsl:variable name="commonCSS.css" select="'../absimx/master-style.css'"/>

<xsl:variable name="requestURI" select="/xslui/@requestURI"/>

<xsl:template name="loginScripts">
 // Function to 'turn-off' all images.
 function imagesoff() {
  if (document.images) 
   {
   document.doc.src = docoff.src;
   document.support.src = supportoff.src;
   }
 }
 if (document.images) {
   supportoff = new Image();
   supportoff.src = "<xsl:value-of select="$grey_dot.gif"/>";
   docoff = new Image();
   docoff.src = "<xsl:value-of select="$grey_dot.gif"/>";
                   
   supportover = new Image();
   supportover.src = "<xsl:value-of select="$red_rollover_dot.gif"/>";
   docover = new Image();
   docover.src = "<xsl:value-of select="$red_rollover_dot.gif"/>";    
 }

 function post() {
  if(document.iabform.user.value != '' &#38;&#38; document.iabform.password.value != '')
    {
    set();
    requestURI = '<xsl:value-of select="$requestURI"/>';
    pageName   = requestURI.substring(requestURI.lastIndexOf('/')+1,requestURI.lastIndexOf('.'));
    if (pageName.toLowerCase() != 'login') {
      document.iabform.action = requestURI;
    } 
    else {
      if (requestURI.substring(0, 4)=='/cal') {
        document.iabform.action = '/cal/overview.xml';
      } 
      else {
        document.iabform.action = '/abs/search.xml';
      }
    }
    document.iabform.submit(); 
    document.iabform.user.value='';
    document.iabform.password.value='';
    }
    else alert('<xsl:text>_Please fill in both login and password fields</xsl:text>');
 }

</xsl:template> 


<xsl:template match="/">
<html>
  <head>
    <title>Address Book - Login</title>
    <link type="text/css" rel="stylesheet" href="{$commonCSS.css}"/> 

    <style type="text/css">
      A.button {font-family: Arial, Verdana; color:white; text-decoration: none; font-size: 10pt; }
      .reduced-text {font-family: Arial, Verdana; font-size: 10pt; color: #999999}
      .normal       {font-family: Arial, Verdana; font-size: 12pt; color: #666666}
      .large-text   {font-family: Arial, Verdana; font-size: 13pt; color: #666666}
    </style>

    <xsl:if test="/xslui/profileinfo/xmlprofile/htmlprefs">
      <xsl:call-template name="styleSheetSelector">
        <xsl:with-param name="htmlprefs" select="/xslui/profileinfo/xmlprofile/htmlprefs"/>     
      </xsl:call-template>
      <xsl:call-template name="fontMaker">
        <xsl:with-param name="htmlprefs" select="/xslui/profileinfo/xmlprofile/htmlprefs"/>     
      </xsl:call-template>
    </xsl:if> 
<!--
    <script language="javascript" src="../absjs/common.js"/>
-->
    <script language="javascript" src="../absjs/cookies.js"/>
    <script language="javascript" src="../absjs/login.js"/>
    <script language="javascript">
      <xsl:call-template name="loginScripts"/>

    </script>

  </head>
  <body marginwidth="0" marginheight="0" topmargin="0" leftmargin="0" rightmargin="0" bottommargin="0" bgcolor="#ffffff" onload='check();document.iabform.user.focus()'>
    <form method="post" name="iabform" onsubmit="post();">
      <xsl:attribute name="action">
        <xsl:value-of select="$requestURI"/>
      </xsl:attribute> 

      <input type="hidden" name="j_encoding" value="{/xslui/@charset}"/>
      <input type="hidden" name="uiaction" value="login"/>
      <table border="0" cellspacing="0" cellpadding="0">
        <tr> 
          <td width="190"><img src="{$spacer.gif}" width="190" height="16" alt=" "/></td>
          <td rowspan="4" valign="bottom"><img src="{$iPlanet_logo.gif}" width="96" height="66" alt="iPlanet e-commerce solutions"/></td>
          <td width="7"><img src="{$spacer.gif}" width="277" height="16" alt=" "/></td>
          <td width="5"><img src="{$spacer.gif}" width="7" height="16" alt=" "/></td>
          <td bgcolor="#cccccc" rowspan="3"><img src="{$spacer.gif}" width="1" height="16" alt=" "/></td>
          <td width="5"><img src="{$spacer.gif}" width="7" height="16" alt=" "/></td>
          <td>&nbsp;</td>
          <td><img src="{$spacer.gif}" width="17" height="16" alt=" "/></td>
        </tr>
        <tr> 
          <td></td>
          <td align="right">
            <a href="#" onMouseOver="over('support')" 
                        onMouseOut="out('support')" 
                        onClick="window.open('http://www.iplanet.com', 'loginPopup'); return true"> 
              <img name="support" src="{$grey_dot.gif}" width="7" height="8" border="0" alt=" "/>
            </a>
          </td>
          <td></td>
          <td></td>
          <td colspan="2">
            <a class="banner-link" href="#" 
                        onMouseOver="over('support')" 
                        onMouseOut="out('support')" 
                        onClick="window.open('http://www.iplanet.com', 'loginPopup'); return true"> 
              <xsl:text>_iplanet.com</xsl:text>
            </a>
          </td>
        </tr>
        <tr> 
          <td></td>
          <td align="right">
            <a href="#" onMouseOver="over('doc')" 
                        onMouseOut="out('doc')" 
                        onClick="return true"> 
              <img name="doc" src="{$grey_dot.gif}" width="7" height="8" border="0" alt=" "/>
            </a>
          </td>
          <td></td>
          <td></td>
          <td colspan="2">
            <a class="banner-link" href="#" onMouseOver="over('doc')" 
                        onMouseOut="out('doc')" 
                        onClick="return true"> 
             <xsl:text>_documentation</xsl:text>
            </a>
          </td>
        </tr>
        <tr> 
          <td><img src="{$spacer.gif}" width="190" height="30" alt=" "/></td>
          <td></td>
          <td></td>
          <td></td>
          <td></td>
          <td></td>
          <td></td>
        </tr>
      </table>
      
      <table width="100&#37;" border="0" cellspacing="0" cellpadding="0" background="{$RedGrey_blank.gif}">
        <tr> 
          <td width="100&#37;">
          <xsl:attribute name="nowrap"/>
          <img src="{$left_strip.gif}" width="190" height="94" alt=" "/><img src="{$center_strip.gif}" width="380" height="94" alt=" "/><img src="{$right_strip.gif}" width="190" height="94" alt=" "/></td>
        </tr>        
      </table>

      <table border="0" cellspacing="0" cellpadding="0">
        <tr> 
          <td><img src="{$spacer.gif}" width="180" height="1" alt=" "/></td>
          <td><img src="{$spacer.gif}" width="10" height="1" alt=" "/></td>
          <td></td>
          <td><img src="{$spacer.gif}" width="10" height="1" alt=" "/></td>
        </tr>
        <tr> 
          <td>&nbsp;</td>
          <td>&nbsp;</td>
          <td>
            <img src="{$AddressBook_5_01.gif}" width="220" height="50" alt="iPlanet Address Book"/>
          </td>
          <td>&nbsp;</td>
        </tr>
        <tr> 
          <td>&nbsp;</td>
          <td>&nbsp;</td>
          <td><span class="large-text">This is a restricted Access Server</span></td>
          <td>&nbsp;</td>
        </tr>
        <tr> 
          <td colspan="4"><img src="{$spacer.gif}" width="1" height="14" alt=" "/></td>
        </tr>
        <xsl:if test="/xslui/@uiaction='login'">
        <tr>
          <td><img src="{$spacer.gif}" width="180" height="1" alt=" "/></td>
          <td>&nbsp;</td>
          <td bgcolor="#CC3300"> 
            <table cellspacing="2" cellpadding="0" height="100&#37;" border="0">
              <tr> 
                <td> 
                 <table border="0" cellspacing="0" cellpadding="0" bgcolor="#FFFFFF" width="100&#37;" height="100&#37;">
                    <tr> 
                      <td colspan="5"><img src="{$spacer.gif}" width="1" height="6"/></td>
                    </tr>
                    <tr> 
                     <td><img src="{$spacer.gif}" width="6" height="1"/></td>
                     <td><img src="{$error_32.gif}" alt="Login Error" border="0"/> 
                      </td>
                     <td><img src="{$spacer.gif}" width="6" height="1"/></td>
                     <td> 
                       <table width="100&#37;" border="0" cellspacing="0" cellpadding="0">
                         <tr> 
                           <td><span class="tab-black"><b>Invalid User ID and Password</b></span></td>
                         </tr>
                         <tr> 
                           <td><img src="{$spacer.gif}" width="1" height="4"/></td>
                         </tr>
                         <tr> 
                           <td><span class="normal">Please try again</span></td>
                         </tr>
                       </table>
                     </td>
                     <td><img src="{$spacer.gif}" width="6" height="1"/></td>
                   </tr>
                   <tr> 
                     <td colspan="5"><img src="{$spacer.gif}" width="1" height="6"/></td>
                   </tr>
                 </table>
                </td>
           </tr>
          </table>    
          </td>
          <td>&nbsp;</td>
        </tr>
        </xsl:if> 
        <tr> 
          <td colspan="4"><img src="{$spacer.gif}" width="1" height="14" alt=" "/></td>
        </tr>
        <tr> 
          <td align="right"><span class="normal">user ID</span></td>
          <td>&nbsp;</td>
          <td> 
            <input type="text" name="user" size="25" maxlength="25"/>
          </td>
          <td>&nbsp;</td>
        </tr>
        <tr> 
          <td colspan="4"><img src="{$spacer.gif}" width="1" height="6" alt=" "/></td>
        </tr>
        <tr> 
          <td align="right"><span class="normal">password</span></td>
          <td>&nbsp;</td>
          <td> 
            <input type="password" name="password" size="25" maxlength="25"/>
          </td>
          <td>&nbsp;</td>
        </tr>
        <tr> 
          <td colspan="4"><img src="{$spacer.gif}" width="1" height="9" alt=" "/></td>
        </tr>
        <tr> 
          <td>&nbsp;</td>
          <td>&nbsp;</td>
          <td> 
            <input type="checkbox" name="remember"/>
            <span class="normal">remember user ID</span></td>
          <td>&nbsp;</td>
        </tr>
        <tr> 
          <td colspan="4"><img src="{$spacer.gif}" width="1" height="6" alt=" "/></td>
        </tr>
        <tr> 
          <td>&nbsp;</td>
          <td>&nbsp;</td>
          <td> 
            <input type="checkbox" name="remember2"/>
            <span class="normal">remember password</span></td>
          <td>&nbsp;</td>
        </tr>
        <tr> 
          <td colspan="4"><img src="{$spacer.gif}" width="1" height="9" alt=" "/></td>
        </tr>
        <tr> 
          <td>&nbsp;</td>
          <td>&nbsp;</td>
          <td> 
            <table border="0" cellspacing="0" cellpadding="0">
              <tr> 
                <td> 
                  <xsl:call-template name="button">
                    <xsl:with-param name="label">
                      <xsl:text>_Login</xsl:text>
                    </xsl:with-param>
                    <xsl:with-param name="href">
                      <xsl:text>javascript:post();</xsl:text>
                    </xsl:with-param> 
                    <xsl:with-param name="color" select="'666699'" />
                    <xsl:with-param name="bgColorIndex" select="'w'" /> 
                  </xsl:call-template>
                </td>
              </tr>
            </table>
          </td>
          <td>&nbsp;</td>
        </tr>
      </table>
      <table border="0" cellspacing="0" cellpadding="0">
        <tr> 
          <td colspan="4"><img src="{$spacer.gif}" width="1" height="18" alt=" "/></td>
        </tr>
        <tr> 
          <td><img src="{$spacer.gif}" width="190" height="1" alt=" "/></td>
          <td rowspan="2" bgcolor="#cccccc"><img src="{$spacer.gif}" width="1" height="1" alt=" "/></td>
          <td><img src="{$spacer.gif}" width="10" height="1" alt=" "/></td>
          <td><span class="reduced-text">Copyright &#169; 2002 Sun Microsystems, 
            Inc. All rights reserved. Use is subject to license terms. Third-party 
            software, including font technology, is copyrighted and licensed 
            from Sun suppliers. Sun Microsystems, the Sun logo, Forte, Java, 
            iPlanet and Forte 4GL are trademarks or registered trademarks of 
            Sun Microsystems, Inc. in the U.S. and other countries. All SPARC
            trademarks are used under license and are trademarks or registered 
            trademarks of SPARC International, Inc. in the U.S. and other
            countries.Federal Acquisitions: Commercial Software - Government 
            Users Subject to Standard License Terms and Conditions.</span></td>
          <td><img src="{$spacer.gif}" width="10" height="1" alt=" "/></td>
        </tr>
        <tr> 
          <td><img src="{$spacer.gif}" width="190" height="30" alt=" "/></td>
          <td>&nbsp;</td>
          <td>&nbsp;</td>
          <td>&nbsp;</td>
        </tr>
        <tr> 
          <td colspan="4" bgcolor="#cccccc"><img src="{$spacer.gif}" width="1" height="1" alt=" " /></td>
        </tr>
      </table>
           
      <table border="0" cellspacing="0" cellpadding="0">
        <tr> 
          <td>
            <img src="{$spacer.gif}" width="190" height="10" alt=" "/>
          </td>
          <td bgcolor="#cccccc">
            <img src="{$spacer.gif}" width="1" height="1" alt=" "/>
          </td>
          <td>
            <img src="{$spacer.gif}" width="1" height="10" alt=" "/>
          </td>
        </tr>
      </table>
      <script language="JavaScript1.2"> 
      if (document.layers)
       document.captureEvents(Event.KEYPRESS);
      document.onkeypress =
            function (evt) {
                var c = document.layers ? evt.which 
                : document.all ? event.keyCode
                : evt.keyCode;
                if (c==13)
                     {
                       var place = document.layers ? evt.target.name 
                       : document.all ? event.srcElement.name
                       : evt.target.name;
                       if(place == "password"){
                         post();
                       return true;
                       }
                     }
           };
      </script>
    </form>
  </body>
</html>
</xsl:template>
</xsl:stylesheet>

