<?xml version="1.0"?>
<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>

<xsl:stylesheet version='1.0' xmlns:xsl='http://www.w3.org/1999/XSL/Transform'>


<xsl:variable name="buttonColor">
  <xsl:variable name="htmlprefs" select="/xslui/profileinfo/xmlprofile/htmlprefs"/>
  <xsl:choose>
    <xsl:when test="$htmlprefs">
      <xsl:choose>
        <xsl:when test="$htmlprefs/@colorset = '1'"> 
          <!-- Gray theme -->
          <xsl:text>666699</xsl:text>
        </xsl:when>
        <xsl:when test="$htmlprefs/@colorset = '2'"> 
          <!-- Khaki theme -->
          <xsl:text>666600</xsl:text>
        </xsl:when>
        <xsl:when test="$htmlprefs/@colorset = '3'"> 
          <!-- Purple theme -->
          <xsl:text>663399</xsl:text>
        </xsl:when>
        <xsl:when test="$htmlprefs/@colorset = '4'"> 
          <!-- Green theme -->
          <xsl:text>006600</xsl:text>
        </xsl:when>
        <xsl:when test="$htmlprefs/@colorset = '5'"> 
          <!-- Blue theme -->
          <xsl:text>666699</xsl:text>
        </xsl:when>
        <xsl:otherwise>
          <!-- Gray theme -->
          <xsl:text>666699</xsl:text>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:when> 
    <xsl:otherwise>
      <!-- Gray theme -->
      <xsl:text>666699</xsl:text>
    </xsl:otherwise>
  </xsl:choose>
</xsl:variable> 

<xsl:variable name="colorTheme">
  <xsl:variable name="htmlprefs" select="/xslui/profileinfo/xmlprofile/htmlprefs"/>
  <xsl:choose>
    <xsl:when test="$htmlprefs">
      <xsl:choose>
        <xsl:when test="$htmlprefs/@colorset = '1'"> 
          <!-- Gray theme -->
          <xsl:value-of select="'gray'" />
        </xsl:when>
        <xsl:when test="$htmlprefs/@colorset = '2'"> 
          <!-- Khaki theme -->
          <xsl:value-of select="'khaki'" /> 
        </xsl:when>
        <xsl:when test="$htmlprefs/@colorset = '3'"> 
          <!-- Purple theme -->
          <xsl:value-of select="'purple'" /> 
        </xsl:when>
        <xsl:when test="$htmlprefs/@colorset = '4'"> 
          <!-- Green theme -->
          <xsl:value-of select="'green'" /> 
        </xsl:when>
        <xsl:when test="$htmlprefs/@colorset = '5'"> 
          <!-- Blue theme -->
          <xsl:value-of select="'blue'" />  
        </xsl:when>
        <xsl:otherwise>
          <!-- Gray theme -->
          <xsl:value-of select="'gray'" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:when> 
    <xsl:otherwise>
       <!-- Gray theme -->
       <xsl:value-of select="'gray'" />
    </xsl:otherwise>
  </xsl:choose>
</xsl:variable> 

<xsl:template name="styleSheetSelector">
  <xsl:param name="htmlprefs"/>

  <link type="text/css" rel="stylesheet" >  
    <xsl:attribute name="href">
      <xsl:choose>
        <xsl:when test="$htmlprefs">
          <xsl:choose>
            <xsl:when test="$htmlprefs/@colorset = '1'"> 
               <xsl:text>../absimx/gray.css</xsl:text>
            </xsl:when>
            <xsl:when test="$htmlprefs/@colorset = '2'"> 
              <xsl:text>../absimx/khaki.css</xsl:text>
            </xsl:when>
            <xsl:when test="$htmlprefs/@colorset = '3'"> 
              <xsl:text>../absimx/purple.css</xsl:text>
            </xsl:when>
            <xsl:when test="$htmlprefs/@colorset = '4'"> 
              <xsl:text>../absimx/green.css</xsl:text>
            </xsl:when>
            <xsl:when test="$htmlprefs/@colorset = '5'"> 
              <xsl:text>../absimx/blue.css</xsl:text>           
            </xsl:when>
            <xsl:otherwise>
               <xsl:text>../absimx/gray.css</xsl:text>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:when> 
        <xsl:otherwise>
          <xsl:text>../absimx/gray.css</xsl:text>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:attribute> 
  </link>
</xsl:template>


<xsl:template name="fontMaker">
  <xsl:param name="htmlprefs" select="/xslui/profileinfo/xmlprofile/htmlprefs"/>
  <xsl:variable name="fontSize"> 
    <xsl:choose>
     <xsl:when test="$htmlprefs">
       <xsl:choose>
         <xsl:when test="$htmlprefs/@fontsize = '1'">10pt</xsl:when>
         <xsl:when test="$htmlprefs/@fontsize = '2'">11pt</xsl:when>
         <xsl:when test="$htmlprefs/@fontsize = '3'">12pt</xsl:when>
         <xsl:when test="$htmlprefs/@fontsize = '4'">13pt</xsl:when>
         <xsl:otherwise>10pt</xsl:otherwise>
       </xsl:choose>
     </xsl:when> 
     <xsl:otherwise>10pt</xsl:otherwise>
    </xsl:choose>    
  </xsl:variable>
  <xsl:variable name="fontFamily"> 
    <xsl:choose>
      <xsl:when test="$htmlprefs">
        <xsl:choose>
          <xsl:when test="$htmlprefs/@fontface = '1'">Arial, Verdana</xsl:when>
          <xsl:when test="$htmlprefs/@fontface = '2'">Times, Courier</xsl:when>
          <xsl:otherwise>Arial, Verdana</xsl:otherwise>
        </xsl:choose>
      </xsl:when> 
      <xsl:otherwise>
        <xsl:text>Arial, Verdana</xsl:text>
      </xsl:otherwise>
    </xsl:choose>    
  </xsl:variable>
    <style type="text/css">
      A.pagelink {font-family: <xsl:value-of select="$fontFamily"/>; color:blue; text-decoration: underline; font-size: <xsl:value-of select="$fontSize" />;}
      A.pagelink:hover{color: darkblue}
      A.toolbar-link {font-family: <xsl:value-of select="$fontFamily"/>; color: #000000; text-decoration: none; font-size: <xsl:value-of select="$fontSize" />;}
      A.disabled-action {font-family: <xsl:value-of select="$fontFamily"/>; text-decoration: none; color: #999999; font-size: <xsl:value-of select="$fontSize" />;}
      A.button {font-family: <xsl:value-of select="$fontFamily"/>; color:white; text-decoration: none; font-size: <xsl:value-of select="$fontSize" />; }

      body {
        background-color: #ffffff;
        font-family: <xsl:value-of select="$fontFamily"/>;
      }
      
      .normal {font-family: <xsl:value-of select="$fontFamily"/>; font-size: <xsl:value-of select="$fontSize" />}
      .white {font-family: <xsl:value-of select="$fontFamily"/>; text-decoration: none; color: #ffffff; font-size: <xsl:value-of select="$fontSize" />}
      .bold {font-family: <xsl:value-of select="$fontFamily"/>; font-weight: bold; font-size: <xsl:value-of select="$fontSize" />;}
      .colheader {font-family: <xsl:value-of select="$fontFamily"/>; font-weight: bold; font-size: <xsl:value-of select="$fontSize" />;}
      .label {font-family: <xsl:value-of select="$fontFamily"/>; font-weight: bold; font-size: <xsl:value-of select="$fontSize" />;}

      .large-text {font-family: <xsl:value-of select="$fontFamily"/>; font-size: <xsl:value-of select="number(substring-before($fontSize, 'pt'))+2"/>pt;}      
      .reduced-text {font-family: <xsl:value-of select="$fontFamily"/>; font-size: <xsl:value-of select="number(substring-before($fontSize, 'pt'))-2"/>pt}      
      .areatitle {font-family: <xsl:value-of select="$fontFamily"/>; font-weight: bold; color: #ffffff; font-size: <xsl:value-of select="number(substring-before($fontSize, 'pt'))+0.5"/>pt}
      .areatitle-large {font-family: <xsl:value-of select="$fontFamily"/>; font-weight: bold; color: #ffffff;}

      .active-filter {font-family: <xsl:value-of select="$fontFamily"/>; font-weight: bold}
    </style>
</xsl:template>


</xsl:stylesheet>