<?xml version="1.0"?>
<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>

<!--
* This Stylesheet contains templates to keep current context
-->
<xsl:stylesheet version='1.0' xmlns:xsl='http://www.w3.org/1999/XSL/Transform'>

  <!--
  * Output HTML fields to keep the current context
  * @param searchresult The current search result tree
  * @param expandedgroups A tree representing the groups that have been expanded
  -->
  <xsl:template name="contextKeeper">
    <xsl:param name="pagedSearch"/>

    <input type="hidden" name="stopsearch" value=""/>
    <input type="hidden" name="expandgroup" value=""/>
    <input type="hidden" name="expandselectedgroup" value=""/>
    <input type="hidden" name="expandonmissing" value=""/>
    <input type="hidden" name="nextview" value="{/xslui/@nextview}" />
    <input type="hidden" name="bookid">
      <xsl:attribute name="value">
        <xsl:if test="$pagedSearch and $pagedSearch/searchresult and $pagedSearch/searchresult/@bookid">
          <xsl:value-of select="$pagedSearch/searchresult/@bookid"/>
        </xsl:if> 
      </xsl:attribute> 
    </input>
    <input type="hidden" name="actionbookid">
      <xsl:attribute name="value">
        <xsl:if test="$pagedSearch and $pagedSearch/searchresult and $pagedSearch/searchresult/@bookid">
          <xsl:value-of select="$pagedSearch/searchresult/@bookid"/>
        </xsl:if> 
      </xsl:attribute> 
    </input>
    <xsl:if test="$pagedSearch/searchresult">
     <xsl:variable name="searchResult" select="$pagedSearch/searchresult"/>

      <xsl:if test="/xslui/iab/pagedsearch/searchresult/@searchid">
        <input type="hidden" name="searchid" value="{$searchResult/@searchid}"/>
      </xsl:if> 

      <input type="hidden" name="filter" value="{$searchResult/@filter}"/>
      <input type="hidden" name="firstentry" value="{$searchResult/@firstentry}"/>
      <input type="hidden" name="sortby" value="{$searchResult/@sortby}"/>

      <xsl:if test="$pagedSearch/expandedgroups">
        <xsl:variable name="expandedGroups" select="$pagedSearch/expandedgroups"/>
        <xsl:if test="$expandedGroups/expandedgroup">
          <xsl:for-each select="$expandedGroups/expandedgroup">
            <input type="hidden" name="expandedgroup" value="{@entryID}"/>
          </xsl:for-each>
        </xsl:if> 
      </xsl:if> 
    </xsl:if> 
  </xsl:template>
</xsl:stylesheet>
