<?xml version="1.0"?>
<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>

<xsl:stylesheet version='1.0' xmlns:xsl='http://www.w3.org/1999/XSL/Transform'>

  <xsl:output method="html" version="4" encoding="UTF-8"/>

  <xsl:variable name="smiPlanet_logo.gif" select="'../absimx/smiPlanet_logo.gif'"/>
  <xsl:variable name="Address_smBan.gif" select="'../absimx/Address_smBan.gif'"/>
  <xsl:variable name="banner_home.gif" select="'../absimx/banner_home.gif'"/>
  <xsl:variable name="banner_logout.gif" select="'../absimx/banner_logout.gif'"/>
  <xsl:variable name="banner_help.gif" select="'../absimx/banner_help.gif'"/>
  <xsl:variable name="Address_UL_login.gif" select="'../absimx/Address_UL_login.gif'"/>
  <xsl:variable name="Address_UR_login.gif" select="'../absimx/Address_UR_login.gif'"/>
  <xsl:variable name="Address_LL_login.gif" select="'../absimx/Address_LL_login.gif'"/>
  <xsl:variable name="loginButton_blue.gif" select="'../absimx/loginButton_blue.gif'"/>
  <xsl:variable name="AddressBook_banner.gif" select="'../absimx/AddressBook_banner.gif'"/>
  <xsl:variable name="white_bannerdot.gif" select="'../absimx/white_bannerdot.gif'"/>
  <xsl:variable name="red_rollover_bannerdot.gif" select="'../absimx/red_rollover_bannerdot.gif'"/>

  <xsl:template name="bannerScripts">
   // Function to 'turn-off' all images.
    function imagesoff() {
      if (document.images) 
      {
        document.homepage.src = homepageoff.src;
        document.documentation.src = documentationoff.src;
        document.userlogout.src = userlogoutoff.src;
          }
    }
    if (document.images) {
      homepageoff = new Image();
      homepageoff.src = "<xsl:value-of select="$white_bannerdot.gif"/>";
      documentationoff = new Image();
      documentationoff.src = "<xsl:value-of select="$white_bannerdot.gif"/>";
      userlogoutoff = new Image();
      userlogoutoff.src = "<xsl:value-of select="$white_bannerdot.gif"/>";
                  
      homepageover = new Image();
      homepageover.src = "<xsl:value-of select="$red_rollover_bannerdot.gif"/>";
      documentationover = new Image();
      documentationover.src = "<xsl:value-of select="$red_rollover_bannerdot.gif"/>";
      userlogoutover = new Image();
      userlogoutover.src = "<xsl:value-of select="$red_rollover_bannerdot.gif"/>";
   }
  </xsl:template> 

  <xsl:template name="banner">
    <xsl:param name="displayWelcome" select="false()" />
    <xsl:param name="application" select="'iABS'" />
    
    <table width="100&#37;" border="0" cellspacing="0" cellpadding="0">
      <tr> 
        <td bgcolor="#CC0000" width="500">
          <img src="../absimx/spacer.gif" width="1" height="5"/>
        </td>
        <td bgcolor="#ffffff" width="1"></td>
        <td bgcolor="#CC0000">
          <img src="../absimx/spacer.gif" width="1" height="5"/>
        </td>
      </tr>
      <tr> 
        <td bgcolor="#999999">
          <table border="0" cellspacing="0" cellpadding="0">
            <tr>
              <td>
                <xsl:choose>
                  <xsl:when test="$application='iCS'">
                    <img src="../calimx/CalendarEx_banner.gif" width="250" height="29" alt="iPlanet Calendar"/>
                  </xsl:when>
                  <xsl:otherwise>
                    <img src="{$AddressBook_banner.gif}" width="200" height="29" alt="iPlanet Address Book"/>
                  </xsl:otherwise>
                </xsl:choose> 
              </td>
              <td width="700">&nbsp;</td>
              <td align="right">
                <xsl:choose>
                  <xsl:when test="$displayWelcome">
                    <table width="100&#37;" border="0" cellspacing="0" cellpadding="0">
                      <tr align="right"> 
                        <td>
                          <span class="banner-text">
                            <xsl:text>_Welcome</xsl:text>
                          </span>
                        </td>
                      </tr>
                      <tr align="right"> 
                        <td>
                          <xsl:attribute name="nowrap"/>
                          <span class="banner-text">
                            <xsl:value-of select="/xslui/usersession/@displayname"/>&nbsp;(<xsl:value-of select="/xslui/usersession/@uid"/>)
                          </span>
                        </td>
                      </tr>
                    </table>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:text>&nbsp;</xsl:text>
                  </xsl:otherwise>
                </xsl:choose> 
              </td>
              <td>
                <img src="../absimx/spacer.gif" width="10" height="1"/>
              </td>
            </tr>
          </table>
        </td>
        <td bgcolor="#ffffff" width="1"></td>
        <td bgcolor="#cccccc" align="right" width="183">
          <table border="0" cellspacing="0" cellpadding="0" align="left">
            <tr> 
              <td>
                <a href="javascript:goTo('search.xml','')" onMouseOver="over('homepage')" onMouseOut="out('homepage')">
                  <img name="homepage" src="{$white_bannerdot.gif}" width="13" height="9" border="0"/>
                </a>
              </td>
              <td>
                <a href="javascript:goTo('search.xml','')" class="banner-link" onMouseOver="over('homepage')" onMouseOut="out('homepage')">
                  <xsl:text>_home</xsl:text>
                </a> 
              </td>
              <td>
                <img src="../absimx/spacer.gif" width="20" height="1"/>
              </td>
              <td>
                <a href="login.xml?uiaction=logout" onMouseOver="over('userlogout')" onMouseOut="out('userlogout')">
                  <img name="userlogout" src="{$white_bannerdot.gif}" width="13" height="9" border="0"/>
                </a>
              </td>
              <td>
                <a href="login.xml?uiaction=logout" class="banner-link" onMouseOver="over('userlogout')" onMouseOut="out('userlogout')"> 
                  <xsl:text>_logout</xsl:text>
                </a>
              </td>
            </tr>
            <tr> 
              <td>
                <a onMouseOver="over('documentation')" onMouseOut="out('documentation')"> 
                  <xsl:attribute name= "href">javascript:openhelp('../help/<xsl:text>_en/help.htm</xsl:text>')</xsl:attribute>
                  <img name="documentation" src="{$white_bannerdot.gif}" width="13" height="9" border="0"/>
                </a>
              </td>
              <td>
                <a class="banner-link" onMouseOver="over('documentation')" onMouseOut="out('documentation')" > 
                  <xsl:attribute name= "href">javascript:openhelp('../help/<xsl:text>_en/help.htm</xsl:text>')</xsl:attribute>
                  <xsl:text>_help</xsl:text>
                </a>
              </td>
              <td>&nbsp;</td>
              <td>&nbsp;</td>
              <td>&nbsp;</td>
            </tr>
          </table>
        </td>
      </tr>
    </table>
  </xsl:template>


</xsl:stylesheet>
