<?xml version="1.0"?>
<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>

<xsl:stylesheet version='1.0' xmlns:xsl='http://www.w3.org/1999/XSL/Transform'>

<xsl:output method="html" version="4" encoding="UTF-8"/>

<xsl:include href="banner.xsl"/>
<xsl:include href="commonimages.xsl"/>
<xsl:include href="viewcontact-images.xsl"/>
<xsl:include href="commonattributes.xsl"/>
<xsl:include href="common-uielements.xsl"/>
<xsl:include href="commonjavascript.xsl"/>
<xsl:include href="commonattributes-hidden.xsl"/>
<xsl:include href="css-select.xsl"/>

<!--
*******************************************************************************
* Core of the template stylesheet addcontact.xsl
*******************************************************************************
-->
<xsl:template match="/">
  <xsl:variable name="group" select="/xslui/iab/bookentry/group" /> 

  <html>
    <head>
      <title>
        <xsl:text>_SunONE Address Book</xsl:text> - <xsl:text>_View group</xsl:text>
      </title>

      <script language="javascript" src="../absjs/common.js"/>
      <script language="javascript" src="../absjs/integration.js"/>
      <script language="javascript" src="../absjs/entries.js"/>
      <script language="javascript">
        <xsl:call-template name="commonjavascript"/>
        <xsl:call-template name="bannerScripts"/>
        function goBack() {
          goToUsingForm('search.xml');
        }

        var typesByIds = new Object();
        var fromViewGroup = false;
        var memberDeletedFlag = false;
        var entryID = "<xsl:call-template name="escape"><xsl:with-param name="text" select="$group/entry/@entryID"/></xsl:call-template>";
        <xsl:for-each select="/xslui/iab/groupmembers/*">
          typesByIds["<xsl:call-template name="escape"><xsl:with-param name="text" select="entry/@entryID"/></xsl:call-template>"]='<xsl:value-of select="name()"/>';
        </xsl:for-each>
	var queryString='<xsl:value-of select="/xslui/@querystring"/>';
	var sOpenerPopupLevel = getQueryStringArgVal(queryString, "openerPopupLevel");
	var popupLevel;
	if(sOpenerPopupLevel == "" || sOpenerPopupLevel == "undefined")
		popupLevel = 1;
	else
		popupLevel = parseInt(sOpenerPopupLevel) + 1;

        function onViewDetailClick(){
          id = getSelectValue(document.iabform.groupMembers);
          if ((id != '') &#38;&#38; (id != null)) {
            fromViewGroup = true; 
            viewEntry(id, typesByIds[id], popupLevel);
          }
          else
            alert("<xsl:text>_No group member selected</xsl:text>")
        }

        function sendGroupMail()
        {
          <!-- This avoid a useless server hit when there is no group inside the current group-->
          <xsl:choose>
            <xsl:when test="not(/xslui/iab/groupmembers/group)">
              var emailArray = new Array(            	
              <xsl:for-each select="/xslui/iab/groupmembers/*">
                <xsl:if test="string-length(email[@priority='1']) > 0">
                  '<xsl:value-of select="email[@priority='1']"/>',
                </xsl:if>
              </xsl:for-each>'');
              sendMail('<xsl:value-of select="/xslui/usersession/@mailurl"/>','<xsl:value-of select="/xslui/profileinfo/xmlprofile/generalprefs/@webmail"/>',emailArray);
            </xsl:when> 
            <xsl:otherwise>
              document.iabform.action = "viewgroup.xml"
              document.iabform.expandgroupforaction.value=1
              submitForm('sendemail')
            </xsl:otherwise>
          </xsl:choose>
        }

        function viewCalendarFromGroup()
        {
          document.iabform.action = "viewgroup.xml"
          document.iabform.expandgroupforaction.value=1
          submitForm('viewcalendar')
        }

       function editSelectedGroup() {
        var url = 'editgroup-main.xml?entryid=' + unescape("<xsl:call-template name="escape"><xsl:with-param name="text" select="$group/entry/@entryID"/></xsl:call-template>");
        url += '&amp;bookid=<xsl:value-of select="/xslui/iab/pagedsearch/searchresult/@bookid"/>'; 
        if( memberDeletedFlag )
          url += "&amp;memberdeleted=true";
        parent.location = url;
       }

       function deleteSelectedGroup() {
          if( confirm(i18n['Are you sure you want to delete this group'] + "?") ) {
             deleteEntry(document.iabform.entryid.value);
          }
       }
      
       function memberContactDeleted()
       {
         document.iabform.action="viewgroup.xml";
         document.iabform.entryid.value = entryID;
         submitForm("memberdeleted");
       }
 
       function cancel() {
          parent.opener.focus();
          if( memberDeletedFlag ) {
            reloadParent(true);
          }
 
          parent.close();
       }

       function openHelp() {
         var helpurl = '<xsl:value-of select="/xslui/@contexturi"/>/help/<xsl:text>_languagepath</xsl:text>/addressbk/viewgrpd.html';
         openhelp(helpurl);
       }

       function initPage() {
          var uiaction = '<xsl:value-of select="/xslui/@uiaction"/>';

          if( uiaction != null &#38;&#38; uiaction == "memberdeleted" )
            memberDeletedFlag = true;
          else { 
            var errornum = '<xsl:value-of select="/xslui/errormessages/error/@errnum"/>';
            if( errornum != null &#38;&#38;  errornum != '' &#38;&#38;  errornum == '5' ) {
              reloadParent(true);
              parent.close();
            } 
         } 
         <xsl:variable name="isRemoteAB" select="boolean(/xslui/iab/booklist/book[entry/@entryID = /xslui/iab/pagedsearch/searchresult/@bookid]/@bookremoteurl)"/>
         <xsl:choose>
        <xsl:when test="$isRemoteAB = true()">
          parent.bottom.location.href="popup-bottom.xml";
        </xsl:when>
        <xsl:otherwise>
          parent.bottom.location.href="view-popup-bottom.xml";
        </xsl:otherwise>
        </xsl:choose>
      }

      </script>
      <script src="../absjs/browserVersion.js"></script>
      <script src="../absjs/scripts.js"></script>
      <script>
      if (is_ie5up) // IE5
      {
         document.write('&lt;link type="text/css" rel="stylesheet" href="../absimx/ab_css_ie5win.css"&gt;');
      }
      else if (is_gecko) // Netscape 6/7 or Mozilla
      {
          document.write('&lt;link type="text/css" rel="stylesheet" href="../absimx/ab_css_ns6up.css"&gt;');      }
      else  // All others
      {
         document.write('&lt;link type="text/css" rel="stylesheet" href="../absimx/ab_css_ns6up.css"&gt;');
      }
      </script>

<!--
      <xsl:call-template name="processAction">
        <xsl:with-param name="action">
          <xsl:value-of select="/xslui/@uiaction"/>
        </xsl:with-param>
        <xsl:with-param name="rootnode" select="/xslui/iab/expandedgroupmembers"/>
      </xsl:call-template>
-->
    </head>
    <body class="Popup" leftmargin="0" topmargin="0" marginwidth="0" marginheight="0" onLoad="initPage()">
      <form method="post" name="iabform" action="viewgroup.xml">
        <input type="hidden" name="j_encoding" value="{/xslui/@charset}"/>
        <input type="hidden" name="uiaction" value=""/>
        <input type="hidden" name="entryid" value="{$group/entry/@entryID}"/>
        <input type="hidden" name="expandgroupforaction" value=""/>
        <input type="hidden" name="nextview" value="viewgroup.xml"/>

        <xsl:call-template name="contextKeeper">
          <xsl:with-param name="pagedSearch" select="/xslui/iab/pagedsearch"/>
        </xsl:call-template>


       <table width="100%" border="0" cellspacing="0" cellpadding="0">
         <xsl:attribute name="summary">
            <xsl:text>_This table contains group properties</xsl:text>
         </xsl:attribute>
         <tr> 
           <td class="PopupTitle" colspan="5">
             <table width="100%" border="0" cellspacing="0" cellpadding="0">
               <tr> 
                  <td>
                    <span class="PopupTitleText">
                        <xsl:value-of select="$group/entry/displayname" /> 
                    </span>
                  </td>
                  <td> 
                  </td>
               </tr>
             </table>
           </td>
         </tr>
        <tr> 
          <td class="PropLabelAb" align="top" width="22%" valign="top">
             <span class="Lbl2">
                 <xsl:text>_Description</xsl:text>
             </span>
           </td>
           <td class="PropInput" width="55%"> 
            <xsl:call-template name="break-new-lines">
               <xsl:with-param name="text" select="$group/entry/description"/>
           </xsl:call-template>
           </td>
           <td width="6%">&nbsp;</td>
           <td width="11%">&nbsp;</td>
           <td width="6%">&nbsp;</td>
        </tr>
        <tr> 
          <td class="PropLabelAb" width="22%">
            <span class="Lbl2">
              <xsl:text>_Web Address</xsl:text>
            </span>
           </td>
           <td class="PropInput" width="55%">
              <a class="Lnk">
                <xsl:variable name="weburladdress">
                <xsl:choose>
                        <xsl:when test="starts-with($group/weburl[@priority='1']/urladdr,'http:')">
                                <xsl:value-of select="$group/weburl[@priority='1']/urladdr" />
                        </xsl:when>
                 <xsl:otherwise>
                 <xsl:choose>
                    <xsl:when test="starts-with($group/weburl[@priority='1']/urladdr,'https:')">
                         <xsl:value-of select="$group/weburl[@priority='1']/urladdr" />
                    </xsl:when>
                 <xsl:otherwise>
                     <xsl:text>http:&#47;&#47;</xsl:text>
                     <xsl:value-of select="$group/weburl[@priority='1']/urladdr" />
                 </xsl:otherwise>
                </xsl:choose>
                </xsl:otherwise>
                </xsl:choose>
                </xsl:variable>
                <xsl:attribute name="href">
                  <xsl:text>javascript:;</xsl:text>
                </xsl:attribute>
                <xsl:attribute name="onClick">
                  <xsl:text>javascript:window.open('</xsl:text>
                  <xsl:value-of select="$weburladdress" />
                  <xsl:text>');return false</xsl:text>
                </xsl:attribute>
                  <xsl:value-of select="$group/weburl[@priority='1']/urladdr" />
              </a>
           </td>
           <td width="6%">&nbsp;</td>
           <td width="11%">&nbsp;</td>
           <td width="6%">&nbsp;</td>
         </tr>
         <tr> 
           <td class="PropLabelAb" width="22%">
             <span class="Lbl2">
               <xsl:text>_Calendar Address</xsl:text>
             </span>
           </td>
           <td class="PropInput" width="55%">
             <a class="Lnk">
                <xsl:variable name="calurladdress">
                <xsl:choose>
                        <xsl:when test="starts-with($group/calendar[@type='calendar']/urladdr,'http:')">
                                <xsl:value-of select="$group/calendar[@type='calendar']/urladdr" />
                        </xsl:when>
                 <xsl:otherwise>
                        <xsl:choose>
                                <xsl:when test="starts-with($group/calendar[@type='calendar']/urladdr,'https:')">
                                        <xsl:value-of select="$group/calendar[@type='calendar']/urladdr"/>
                                </xsl:when>
                        <xsl:otherwise>
                                <xsl:text>http:&#47;&#47;</xsl:text>
                                <xsl:value-of select="$group/calendar[@type='calendar']/urladdr" />
                        </xsl:otherwise>
                        </xsl:choose>
                </xsl:otherwise>
                </xsl:choose>
                </xsl:variable>
                <xsl:attribute name="href">
                    <xsl:text>javascript:;</xsl:text>
                </xsl:attribute>
                <xsl:attribute name="onClick">
                  <xsl:text>javascript:window.open('</xsl:text>
                  <xsl:value-of select="$calurladdress" />
                  <xsl:text>');return false</xsl:text>
                </xsl:attribute>
                <xsl:value-of select="$group/calendar[@type='calendar']/urladdr" />
             </a>
           </td>
           <td width="6%">&nbsp;</td>
           <td width="11%">&nbsp;</td>
           <td width="6%">&nbsp;</td>
    </tr>
    <tr> 
      <td class="PropLabel" colspan="5"><img src="{$spacer.gif}" width="10" height="8" alt=""/></td>
    </tr>
    <tr> 
      <td colspan="5"> 
        <table width="100%" border="0" cellspacing="0" cellpadding="0">

          <tr> 
            <td width="1%"><img src="{$spacer.gif}" width="10" height="5" alt=""/></td>
            <td width="100%" class="SectionDivider"><img src="{$spacer.gif}" width="1" height="5" alt=""/></td>
            <td width="1%"><img src="{$spacer.gif}" width="10" height="5" alt=""/></td>
          </tr>
        </table>
      </td>
    </tr>
    <tr> 
      <td class="SectionHeader" colspan="5">
          <span class="SectionHeader">
            <xsl:text>_Group Members</xsl:text>
          </span>
      </td>
    </tr>
    <tr> 
      <td colspan="5" > 
        <table width="100%" border="0" cellspacing="0" cellpadding="0">
          <tr> 
            <td class="PropLabelAb" width="20%"><span class="Lbl2"><xsl:text>_Members</xsl:text></span><br/>
              <select class="normal" name="groupMembers" size="10" style="font-size: 10pt">
                  <xsl:choose>
                    <xsl:when test="not(/xslui/iab/groupmembers/*)">
                      <option value="">
                        <xsl:text>_-- Group contains no member --</xsl:text>
                      </option>
                    </xsl:when>
                    <xsl:otherwise>
                    <xsl:for-each select="/xslui/iab/groupmembers/*">
                      <option>
                        <xsl:attribute name="value">
                          <xsl:value-of select="current()/entry/@entryID"/>
                        </xsl:attribute>
                        <xsl:value-of select="current()/entry/displayname"/>
                        <xsl:if test="current()//email[@priority='1']">
                          <xsl:text> (</xsl:text>
                          <xsl:value-of select="current()//email[@priority='1']" />
                          <xsl:text>)</xsl:text>
                        </xsl:if>
                      </option>
                    </xsl:for-each>
                     <option value="">______________________________</option>
                    </xsl:otherwise>
                  </xsl:choose> 
              </select>
           </td>
            <td class="PropLabel" width="80%"> 
              <div class="ShwDetails"> 
                <xsl:call-template name="uwcbutton">
                   <xsl:with-param name="value">
	              <xsl:text>_Show Details</xsl:text>
                  </xsl:with-param>
                  <xsl:with-param name="name">
                     <xsl:text>Show Details</xsl:text>
                  </xsl:with-param>
                  <xsl:with-param name="id">
                     <xsl:text>Show Details</xsl:text>
                  </xsl:with-param>
                  <xsl:with-param name="title">
                     <xsl:text>_Show Details</xsl:text>
                  </xsl:with-param>
                  <xsl:with-param name="class">
                     <xsl:text>Btn1</xsl:text>
                  </xsl:with-param>
                   <xsl:with-param name="type" select="'button'"/>
                  <xsl:with-param name="onclick" select="'javascript:onViewDetailClick()'"/>
                  <xsl:with-param name="tabindex" select="7"/>
                </xsl:call-template>
               <br/>
             </div>
            </td>
          </tr>
        </table>
      </td>
    </tr>
  </table>

   <!-- These calls keeps the already selected context -->
   <xsl:for-each select="/xslui/iab/alreadyselected/*">
          <input type="hidden" name="selectedentry" value="{entry/@entryID}"/>
   </xsl:for-each>
   <xsl:apply-templates select="/xslui/iab/alreadyselected" mode="hidden"/>
  </form>
 </body>
 </html>
</xsl:template>
</xsl:stylesheet>
