<?xml version="1.0"?>
<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>

<xsl:stylesheet version='1.0' xmlns:xsl='http://www.w3.org/1999/XSL/Transform'>

<xsl:output method="html" version="4" encoding="UTF-8"/>

<xsl:include href="banner.xsl"/>
<xsl:include href="commonimages.xsl"/>
<xsl:include href="commonjavascript.xsl"/>
<xsl:include href="commonattributes-hidden.xsl"/>
<xsl:include href="common-uielements.xsl"/>
<xsl:include href="common-tabs.xsl"/>
<xsl:include href="css-select.xsl"/>
<xsl:include href="context.xsl"/>

<!--
*****************************************************************************
* This template prints the Appearance option menu
*****************************************************************************
-->
<xsl:template name="optionsAppearance">
  <xsl:param name="uiprefs" select="/xslui/profileinfo"/>
  <xsl:param name="psprefs" select="/xslui/iab/profileinfo"/>
  <xsl:param name="calprefs" select="/xslui/calendar/profileinfo"/>

  <table border="0" cellspacing="0" cellpadding="0" class="white-strip"> 
    <tr class="white-strip">  
      <td width="8">
        <img src="{$spacer.gif}" width="8" height="1"/>
      </td>
      <td> 
        <xsl:call-template name="tab">
          <xsl:with-param name="label">
            <xsl:text>_Appearance</xsl:text>
          </xsl:with-param>
          <xsl:with-param name="labelClass" select="'tab-white'"/>
          <xsl:with-param name="color" select="$activeTabColor"/>
        </xsl:call-template>
      </td>
      <td> 
        <xsl:call-template name="tab">
          <xsl:with-param name="label">
            <xsl:text>_Settings</xsl:text>
          </xsl:with-param>
          <xsl:with-param name="href">
            <xsl:text>javascript:document.iabform.tabid.value='settings';submitForm('');</xsl:text>
          </xsl:with-param> 
          <xsl:with-param name="labelClass" select="'tab-black'"/>
          <xsl:with-param name="color" select="$inactiveTabColor"/>
        </xsl:call-template>
      </td>
      <td> 
        <xsl:call-template name="tab">
          <xsl:with-param name="label">
            <xsl:text>_Calendar</xsl:text>
          </xsl:with-param>
          <xsl:with-param name="labelClass" select="'tab-black'"/>
          <xsl:with-param name="color" select="$inactiveTabColor"/>
          <xsl:with-param name="href">
            <xsl:text>javascript:document.iabform.tabid.value='calendar';submitForm('');</xsl:text>
          </xsl:with-param> 
        </xsl:call-template>
      </td>
    </tr>
  </table>
  <table border="0" cellspacing="0" cellpadding="0" width="100&#37;" class="second-strip"> 
    <tr> 
      <td colspan="5" class="first-strip"><img src="{$spacer.gif}" width="1" height="9"/></td>
    </tr>
    <tr> 
      <td colspan="5"><img src="{$spacer.gif}" width="1" height="6"/></td>
    </tr>
    <tr> 
      <td colspan="5"> 
        <table border="0" cellspacing="0" cellpadding="0">
          <tr> 
            <td width="17">&nbsp;</td>
            <td>
              <span class="normal">
                <xsl:text>_Modify global appearance options for iPlanet Address Book. These options apply to all Address Books.</xsl:text>
              </span>
            </td>
          </tr>
        </table>
      </td>
    </tr>
    <tr> 
      <td colspan="5" ><img src="{$spacer.gif}" width="1" height="6"/></td>
    </tr>
    <tr class="fourth-strip"> 
      <td colspan="5"> 
        <table border="0" cellspacing="0" cellpadding="0">
          <tr> 
            <td><img src="{$spacer.gif}" width="17" height="1" /></td>
            <td class="areatitle"><xsl:text>_Color</xsl:text></td>
          </tr>
        </table>
      </td>
    </tr>
    <tr> 
      <td colspan="5"><img src="{$spacer.gif}" width="1" height="12" /></td>
    </tr>
    <tr> 
      <td width="17">&nbsp;</td>
      <td align="right">
        <p class="label">
          <xsl:text>_Color Scheme</xsl:text>
        </p>
      </td>
      <td width="10">&nbsp;</td>
      <td> 
        <table border="0" cellspacing="1" cellpadding="1">
          <tr> 
            <td width="20"> 
              <input type="radio" name="uiprefs_colorset" value="1">
                 <xsl:if test="$uiprefs/xmlprofile/htmlprefs/@colorset = '1'">
                    <xsl:attribute name="checked" />
                 </xsl:if>   
              </input>
            </td>
            <td width="20" bgcolor="#6666cc">&nbsp;</td>
            <td width="20" bgcolor="#cccccc">&nbsp;</td>
            <td width="20" bgcolor="#e4e4e4">&nbsp;</td>
            <td width="20" bgcolor="#999999">&nbsp;</td>
            <td width="20" bgcolor="#666699">&nbsp;</td>
          </tr>
          <tr> 
            <td> 
              <input type="radio" name="uiprefs_colorset" value="2">            
                <xsl:if test="$uiprefs/xmlprofile/htmlprefs/@colorset = '2'">
                  <xsl:attribute name="checked"/>
                </xsl:if>   
              </input>
            </td>
            <td bgcolor="#666666">&nbsp;</td>
            <td bgcolor="#cccc99">&nbsp;</td>
            <td bgcolor="#666600">&nbsp;</td>
            <td bgcolor="#e4e4e4">&nbsp;</td>
            <td bgcolor="#666666">&nbsp;</td>
          </tr>
          <tr> 
            <td> 
              <input type="radio" name="uiprefs_colorset" value="3">
                <xsl:if test="$uiprefs/xmlprofile/htmlprefs/@colorset = '3'">
                  <xsl:attribute name="checked" />
                </xsl:if> 
              </input>
            </td>
            <td bgcolor="#666699">&nbsp;</td>
            <td bgcolor="#cc99cc">&nbsp;</td>
            <td bgcolor="#663399">&nbsp;</td>
            <td bgcolor="#e4e4e4">&nbsp;</td>
            <td bgcolor="#666699">&nbsp;</td>
          </tr>
          <tr> 
            <td> 
              <input type="radio" name="uiprefs_colorset" value="4">
                <xsl:if test="$uiprefs/xmlprofile/htmlprefs/@colorset = '4'">
                  <xsl:attribute name="checked" />
                </xsl:if>   
              </input>
            </td>
            <td bgcolor="#666699">&nbsp;</td>
            <td bgcolor="#99cc99">&nbsp;</td>
            <td bgcolor="#006600">&nbsp;</td>
            <td bgcolor="#ffffcc">&nbsp;</td>
            <td bgcolor="#666699">&nbsp;</td>
          </tr>
    	    <tr> 
            <td width="20"> 
              <input type="radio" name="uiprefs_colorset" value="5">
                 <xsl:if test="$uiprefs/xmlprofile/htmlprefs/@colorset = '5'">
                    <xsl:attribute name="checked" />
                 </xsl:if>   
              </input>
            </td>
            <td width="20" bgcolor="#666699">&nbsp;</td>
            <td width="20" bgcolor="#99ccff">&nbsp;</td>
            <td width="20" bgcolor="#666699">&nbsp;</td>
            <td width="20" bgcolor="#ffffcc">&nbsp;</td>
            <td width="20" bgcolor="#666699">&nbsp;</td>
          </tr>	 
        </table>
      </td>
      <td width="17">&nbsp;</td>
    </tr>
    <tr> 
      <td colspan="5"><img src="{$spacer.gif}" width="1" height="12"/></td>
    </tr>
    <tr class="fourth-strip"> 
      <td colspan="5"> 
        <table border="0" cellspacing="0" cellpadding="0">
          <tr> 
            <td><img src="{$spacer.gif}" width="17" height="1" /></td>
            <td class="areatitle"><xsl:text>_Other</xsl:text></td>
          </tr>
        </table>
      </td>
    </tr>
    <tr> 
      <td colspan="5"><img src="{$spacer.gif}" width="1" height="12" /></td>
    </tr>
    <tr> 
      <td>&nbsp;</td>
      <td align="right">
        <p class="label">
          <xsl:text>_Toolbar</xsl:text>
        </p>
      </td>
      <td>&nbsp;</td>
      <td> 
        <table border="0" cellspacing="1" cellpadding="1">
          <tr> 
            <td> 
              <input type="radio" name="uiprefs_icondisplay" value="1">
                 <xsl:if test="$uiprefs/xmlprofile/htmlprefs/@icondisplay = '1'">
                   <xsl:attribute name="checked" />
                 </xsl:if>
              </input>
            </td>
            <td>
              <xsl:attribute name="nowrap" />
              <span class="normal"><xsl:text>_Show icons and text</xsl:text></span>
            </td>
          </tr>
          <tr> 
            <td> 
              <input type="radio" name="uiprefs_icondisplay" value="2">
                <xsl:if test="$uiprefs/xmlprofile/htmlprefs/@icondisplay = '2'">
                  <xsl:attribute name="checked" />
                </xsl:if>
              </input>            
            </td>
            <td>
              <span class="normal"><xsl:text>_Show icons only</xsl:text></span>
            </td>
          </tr>
          <tr> 
            <td> 
              <input type="radio" name="uiprefs_icondisplay" value="3"> 
                <xsl:if test="$uiprefs/xmlprofile/htmlprefs/@icondisplay = '3'">
                  <xsl:attribute name="checked" />
                </xsl:if>
              </input>
            </td>
            <td>       
              <span class="normal"><xsl:text>_Show text only</xsl:text></span>
            </td>
          </tr>
        </table>
      </td>
      <td>&nbsp;</td>
    </tr>
    <tr> 
      <td colspan="5"><img src="{$spacer.gif}" width="1" height="6" /></td>
    </tr>
    <tr> 
      <td>&nbsp;</td>
      <td align="right">
        <p class="label">
          <xsl:text>_Display Font</xsl:text>
        </p>
      </td>
      <td>&nbsp;</td>
      <td> 
        <table border="0" cellspacing="1" cellpadding="1">
          <tr> 
            <td align="left"><span class="normal"><xsl:text>_Font Face</xsl:text></span></td>
            <td>
              <span class="normal">
                <select class="normal" name="uiprefs_fontface">
                  <option value="1">  
                    <xsl:if test="not ($uiprefs/xmlprofile/htmlprefs/@fontface) or $uiprefs/xmlprofile/htmlprefs/@fontface = '1'">
                      <xsl:attribute name="selected" />
                    </xsl:if>
                    <xsl:text>Arial</xsl:text>
                  </option>
                  <option value="2">  
                    <xsl:if test="$uiprefs/xmlprofile/htmlprefs/@fontface = '2'">
                      <xsl:attribute name="selected" />
                    </xsl:if>
                    <xsl:text>Times</xsl:text>
                  </option>
                </select>
              </span>
             </td>
          </tr>
          <tr> 
            <td align="left"><span class="normal"><xsl:text>_Font Size</xsl:text></span></td>
            <td>
              <span class="normal">
                <select class="normal" name="uiprefs_fontsize">
                  <option value="1">
                    <xsl:if test="$uiprefs/xmlprofile/htmlprefs/@fontsize = '1'">
                      <xsl:attribute name="selected" />
                    </xsl:if>              
                    <span class="normal"><xsl:text>_Small</xsl:text></span>
                  </option>
                  <option value="2">
                    <xsl:if test="$uiprefs/xmlprofile/htmlprefs/@fontsize = '2'">
                       <xsl:attribute name="selected" />
                    </xsl:if>
                    <span class="normal"><xsl:text>_Medium</xsl:text></span>
                  </option>
                  <option value="3">
                    <xsl:if test="$uiprefs/xmlprofile/htmlprefs/@fontsize = '3'">
                       <xsl:attribute name="selected" />
                    </xsl:if>
                   <span class="normal"><xsl:text>_Large</xsl:text></span>
                  </option>
                  <option value="4">
                    <xsl:if test="$uiprefs/xmlprofile/htmlprefs/@fontsize = '4'">
                      <xsl:attribute name="selected" />
                    </xsl:if>  
                    <span class="normal"><xsl:text>_Larger</xsl:text></span>
                  </option>
                </select>
              </span>
            </td>
          </tr>
        </table>
      </td>
      <td>&nbsp;</td>
    </tr>
    <tr> 
      <td colspan="5"><img src="{$spacer.gif}" width="1" height="18" /></td>
    </tr>
    <tr>  
      <td colspan="5" class="first-strip"><img src="{$spacer.gif}" width="1" height="2" /></td>
    </tr>
  </table>

  <input type="hidden" name="uiprefs_displayname" value="{$uiprefs/entry/displayname}"/>
  <input type="hidden" name="psprefs_displayname" value="{$psprefs/entry/displayname}"/>    
  <xsl:choose>
    <xsl:when test="string-length($calprefs/entry/displayname)&lt;0">
      <input type="hidden" name="calprefs_displayname" value="{$calprefs/entry/displayname}"/>
    </xsl:when>
    <xsl:otherwise>
      <input type="hidden" name="calprefs_displayname" value="iPlanet Calendar"/>
    </xsl:otherwise>
  </xsl:choose> 

  <input type="hidden" name="tabid" value="appearance"/>     
  <input type="hidden" name="uiprefs_dateorder"
                       value="{$uiprefs/xmlprofile/generalprefs/@dateorder}"/>  
  <input type="hidden" name="uiprefs_dateseparator"
                       value="{$uiprefs/xmlprofile/generalprefs/@dateseparator}"/>  
  <input type="hidden" name="uiprefs_webmail"
                       value="{$uiprefs/xmlprofile/generalprefs/@webmail}"/>     
  <input type="hidden" name="uiprefs_quickAddPosition" 
                       value="{$uiprefs/xmlprofile/generalprefs/@quickaddpos}"/>  
  <input type="hidden" name="psprefs_bookid" value ="{$psprefs/xmlprofile/defaultbook/@bookid}"/> 
  <input type="hidden" name="psprefs_booktype" value ="{$psprefs/xmlprofile/defaultbook/@booktype}"/> 
  <input type="hidden" name="psprefs_confirmdelete" value="{$psprefs/xmlprofile/psprefs/@confirmdelete}"/>
  <input type="hidden" name="psprefs_entriesperpage" value="{$psprefs/xmlprofile/layoutinfo/@entriesperpage}"/> 

  <input type="hidden" name="calprefs_ceClock" value="{$calprefs/xmlprofile/calprefs/@ceClock}"/>
  <input type="hidden" name="calprefs_icsFirstDay" value="{$calprefs/xmlprofile/calprefs/@icsFirstDay}"/>
  <input type="hidden" name="calprefs_weekWorkDays" value="{$calprefs/xmlprofile/calprefs/@ceWeekWorkDays}"/>
  <input type="hidden" name="calprefs_ceDayHead" value="{$calprefs/xmlprofile/calprefs/@ceDayHead}"/>
  <input type="hidden" name="calprefs_ceDayTail" value="{$calprefs/xmlprofile/calprefs/@ceDayTail}"/>
  <input type="hidden" name="calprefs_ceInterval" value="{$calprefs/xmlprofile/calprefs/@ceInterval}"/>
</xsl:template>


<!--
*****************************************************************************
* This template prints the Settings option menu
*****************************************************************************
-->
<xsl:template name="optionsSettings">
  <xsl:param name="uiprefs"/>
  <xsl:param name="psprefs"/>
  <xsl:param name="calprefs"/>

  <table border="0" cellspacing="0" cellpadding="0" class="white-strip"> 
    <tr class="white-strip"> 
      <td width="8">
        <img src="{$spacer.gif}" width="8" height="1"/>
      </td>
      <td> 
        <xsl:call-template name="tab">
          <xsl:with-param name="label">
            <xsl:text>_Appearance</xsl:text>
          </xsl:with-param>
          <xsl:with-param name="labelClass" select="'tab-black'"/>
          <xsl:with-param name="color" select="$inactiveTabColor"/>
          <xsl:with-param name="href">
            <xsl:text>javascript:document.iabform.tabid.value='appearance';submitForm('');</xsl:text>
          </xsl:with-param> 
        </xsl:call-template>
      </td>
      <td> 
        <xsl:call-template name="tab">
          <xsl:with-param name="label">
            <xsl:text>_Settings</xsl:text>
          </xsl:with-param>
          <xsl:with-param name="labelClass" select="'tab-white'"/>
          <xsl:with-param name="color" select="$activeTabColor"/>
        </xsl:call-template>
      </td>
      <td> 
        <xsl:call-template name="tab">
          <xsl:with-param name="label">
            <xsl:text>_Calendar</xsl:text>
          </xsl:with-param>
          <xsl:with-param name="labelClass" select="'tab-black'"/>
          <xsl:with-param name="color" select="$inactiveTabColor"/>
          <xsl:with-param name="href">
            <xsl:text>javascript:document.iabform.tabid.value='calendar';submitForm('');</xsl:text>
          </xsl:with-param> 
        </xsl:call-template>
      </td>
    </tr>
  </table>
  <table border="0" cellspacing="0" cellpadding="0" width="100&#37;" class="second-strip">   
    <tr> 
      <td colspan="5" class="first-strip">
        <img src="{$spacer.gif}" width="1" height="9"/>
      </td>
    </tr>
    <tr> 
      <td colspan="5">
        <img src="{$spacer.gif}" width="1" height="6"/>
      </td>
    </tr>
    <tr> 
      <td colspan="5"> 
        <table border="0" cellspacing="0" cellpadding="0">
          <tr> 
            <td width="17">&nbsp;</td>
            <td>
              <span class="normal">
                <xsl:text>_Modify global settings that control how Address Books are displayed. These settings apply to all Address Books.</xsl:text>
              </span>
            </td>
          </tr>
        </table>
      </td>
    </tr>
    <tr> 
      <td colspan="5" ><img src="{$spacer.gif}" width="1" height="6"/></td>
    </tr>
    <tr class="fourth-strip"> 
      <td colspan="5"> 
        <table border="0" cellspacing="0" cellpadding="0">
          <tr> 
            <td><img src="{$spacer.gif}" width="17" height="1" /></td>
            <td class="areatitle">
              <xsl:text>_Date</xsl:text>
            </td>
          </tr>
        </table>
      </td>
    </tr>
    <tr> 
      <td colspan="5"><img src="{$spacer.gif}" width="1" height="12" /></td>
    </tr>
    <tr> 
      <td width="17">&nbsp;</td>
      <td align="right" valign="top">
        <p class="label">
          <xsl:text>_Default Date Format</xsl:text>
        </p>
      </td>
      <td width="10">&nbsp;</td>
      <td valign="top"> 
        <span class="normal">
          <select class="normal" name="uiprefs_dateorder">
            <option value="M/D/Y">
              <xsl:if test="$uiprefs/xmlprofile/generalprefs/@dateorder='M/D/Y'">
                <xsl:attribute name="selected"/>
              </xsl:if>
              <xsl:text>_Month</xsl:text>, <xsl:text>_Date</xsl:text>, <xsl:text>_Year</xsl:text></option>
            <option value="D/M/Y">
              <xsl:if test="$uiprefs/xmlprofile/generalprefs/@dateorder='D/M/Y'">
                <xsl:attribute name="selected"/>
              </xsl:if>
              <xsl:text>_Date</xsl:text>, <xsl:text>_Month</xsl:text>, <xsl:text>_Year</xsl:text></option>
            <option value="Y/M/D">
              <xsl:if test="$uiprefs/xmlprofile/generalprefs/@dateorder='Y/M/D'">
                <xsl:attribute name="selected"/>
              </xsl:if>
              <xsl:text>_Year</xsl:text>, <xsl:text>_Month</xsl:text>, <xsl:text>_Date</xsl:text></option>
          </select>
        </span>
        <br/>
        <span class="normal"><xsl:text>_(Display brief dates using the above format)</xsl:text></span></td>
      <td width="17">&nbsp;</td>
    </tr>
    <tr> 
      <td colspan="5"><img src="{$spacer.gif}" width="1" height="18" /></td>
    </tr>
    <tr> 
      <td>&nbsp;</td>
      <td align="right" valign="top">
        <p class="label">
          <xsl:text>_Date Delimiter</xsl:text>
        </p>
      </td>
      <td>&nbsp;</td>
      <td valign="top" class="mediumfont"> 
        <input type="text" name="uiprefs_dateseparator" size="1" maxlength="1">
          <xsl:attribute name="value">
            <xsl:value-of select="$uiprefs/xmlprofile/generalprefs/@dateseparator"/>
          </xsl:attribute>
          <br/>
          <span class="normal"><font class="mediumfont"><xsl:text>_(Use the above character to delimit brief dates)</xsl:text></font></span>
        </input>
      </td>
      <td>&nbsp;</td>
    </tr>
    <tr> 
      <td colspan="5"><img src="{$spacer.gif}" width="1" height="12"/></td>
    </tr>
    <tr> 
      <td colspan="5"  class="fourth-strip"> 
        <table border="0" cellspacing="0" cellpadding="0">
          <tr> 
            <td><img src="{$spacer.gif}" width="17" height="1" /></td>
            <td class="areatitle"><xsl:text>_Address Book Defaults</xsl:text></td>
          </tr>
        </table>
      </td>
    </tr>
    <tr> 
      <td colspan="5"><img src="{$spacer.gif}" width="1" height="12"/></td>
    </tr>
    <tr> 
      <td>&nbsp;</td>
      <td align="right" valign="top">
        <p class="label">
          <xsl:text>_Default Address Book</xsl:text>
        </p>
      </td>
      <td>&nbsp;</td>
      <td valign="top">
        <span class="normal">
          <select class="normal" name="psprefs_bookid">
            <xsl:for-each select="/xslui/iab/booklist/book">
              <option>
                <xsl:attribute name="value">
                  <xsl:value-of select="entry/@entryID"/>
                </xsl:attribute>
                <xsl:if test="entry/@entryID = $psprefs/xmlprofile/defaultbook/@bookid">
                  <xsl:attribute name="selected"/>
                </xsl:if>
               <xsl:value-of select="entry/displayname"/>
              </option>
            </xsl:for-each>
          </select>
        </span>
        <br/>
        <span class="normal"><xsl:text>_(Always display this Address Book after login)</xsl:text></span></td>
      <td>&nbsp;</td>
    </tr>
    <tr> 
      <td colspan="5"><img src="{$spacer.gif}" width="1" height="6"/></td>
    </tr>
<!--
TODO
    <tr> 
      <td>&nbsp;</td>
      <td align="right" valign="top">
        <p class="label">
          <xsl:text>_Confirm Deletes</xsl:text>
        </p>
      </td>
      <td>&nbsp;</td>
      <td valign="top">
        <span class="normal">
          <select class="normal" name="psprefs_confirmdelete">
            <option value="0">
              <xsl:if test="$psprefs/xmlprofile/psprefs/@confirmdelete='0'">
               <xsl:attribute name="selected" />
              </xsl:if>
            <xsl:text>_No</xsl:text>
            </option>
            <option value="1">
              <xsl:if test="$psprefs/xmlprofile/psprefs/@confirmdelete='1'">
               <xsl:attribute name="selected" />
              </xsl:if>
              <xsl:text>_Yes</xsl:text>
            </option>
          </select>
        </span>
        <br/>
        <span class="normal"><xsl:text>_(Display a confirmation before deleting a Contact, Group, or Address Book)</xsl:text></span></td>
      <td>&nbsp;</td>
    </tr>
    <tr> 
      <td colspan="5"><img src="{$spacer.gif}" width="1" height="6"/></td>
    </tr>
-->
    <tr> 
      <td>&nbsp;</td>
      <td align="right" valign="top">
        <p class="label">
          <xsl:text>_Default Email Client</xsl:text>
        </p>
      </td>
      <td>&nbsp;</td>
      <td valign="top">
        <span class="normal">
          <select class="normal" name="uiprefs_webmail">
            <option value="mailto">
              <xsl:if test="$uiprefs/xmlprofile/generalprefs/@webmail='mailto'">
                <xsl:attribute name="selected"/>
              </xsl:if>
              <xsl:text>_Browser Default</xsl:text>
            </option>
            <option value="Yahoo">
              <xsl:if test="$uiprefs/xmlprofile/generalprefs/@webmail='Yahoo'">
                <xsl:attribute name="selected"/>
              </xsl:if>
              <xsl:text>_Yahoo Mail</xsl:text>
            </option>
            <option value="iPlanet">
              <xsl:if test="$uiprefs/xmlprofile/generalprefs/@webmail='iplanet'">
                <xsl:attribute name="selected"/>
              </xsl:if>
              <xsl:text>_iPlanet Web Mail</xsl:text>
            </option>
          </select>
        </span>
        <br/>
        <span class="normal"><xsl:text>_(Email client used to send email from iPlanet Address Book)</xsl:text></span></td>
      <td>&nbsp;</td>
    </tr>
    <tr> 
      <td colspan="5">
        <img src="{$spacer.gif}" width="1" height="9"/>
      </td>
    </tr>
    <tr> 
      <td>&nbsp;</td>
      <td align="right" valign="top">
        <span class="label">
          <xsl:text>_Add Contact Section</xsl:text>
        </span>
      </td>
      <td>&nbsp;</td>
      <td>
        <span class="normal">
          <xsl:text>_Show the Add Contact section at the top or bottom of the main page</xsl:text>:
        </span>
      </td>
      <td>&nbsp;</td>
    </tr>
    <tr> 
      <td>&nbsp;</td>
      <td>&nbsp;</td>
      <td>&nbsp;</td>
      <td> 
        <table border="0" cellspacing="0" cellpadding="0">
          <tr> 
            <td> 
              <xsl:attribute name="nowrap"/>
              <input type="radio" name="uiprefs_quickAddPosition" value="top">
                <xsl:if test="$uiprefs/xmlprofile/generalprefs/@quickaddpos='top'">
                  <xsl:attribute name="checked"/>
                </xsl:if> 
              </input>
              <span class="normal">
                <xsl:text>_Show 'Add Contact' at the top</xsl:text>
              </span>
            </td>
          </tr>
          <tr> 
            <td>
              <xsl:attribute name="nowrap"/>
              <input type="radio" name="uiprefs_quickAddPosition" value="bottom">
                <xsl:if test="not($uiprefs/xmlprofile/generalprefs/@quickaddpos) or $uiprefs/xmlprofile/generalprefs/@quickaddpos='bottom'">
                  <xsl:attribute name="checked"/>
                </xsl:if> 
              </input>
              <span class="normal">
                <xsl:text>_Show 'Add Contact' at the bottom</xsl:text>
              </span>
            </td>
          </tr>
          <tr> 
            <td>
              <xsl:attribute name="nowrap"/>
              <input type="radio" name="uiprefs_quickAddPosition" value="dontshow">
                <xsl:if test="$uiprefs/xmlprofile/generalprefs/@quickaddpos='dontshow'">
                  <xsl:attribute name="checked"/>
                </xsl:if> 
              </input>
              <span class="normal">
                <xsl:text>_Don't show 'Add Contact'</xsl:text>
              </span>
            </td>
          </tr>
          <tr>
            <td>
              <span class="normal">
                <xsl:text>_(Change the default position of the Add Contact section on the main address book screen.)</xsl:text>
              </span>
            </td>
          </tr>
        </table>
      </td>
      <td>&nbsp;</td>
    </tr>
    <tr> 
      <td colspan="5"><img src="{$spacer.gif}" width="1" height="18" /></td>
    </tr>
    <tr>  
      <td colspan="5" class="first-strip"><img src="{$spacer.gif}" width="1" height="2" /></td>
    </tr>

  </table>

  <input type="hidden" name="uiprefs_displayname" value="{$uiprefs/entry/displayname}"/>
  <input type="hidden" name="psprefs_displayname" value="{$psprefs/entry/displayname}"/>
  <xsl:choose>
    <xsl:when test="string-length($calprefs/entry/displayname)&lt;0">
      <input type="hidden" name="calprefs_displayname" value="{$calprefs/entry/displayname}"/>
    </xsl:when>
    <xsl:otherwise>
      <input type="hidden" name="calprefs_displayname" value="iPlanet Calendar"/>
    </xsl:otherwise>
  </xsl:choose> 
  
  <input type="hidden" name="tabid" value="settings"/>
  <input type="hidden" name="uiprefs_fontsize" 
                       value="{$uiprefs/xmlprofile/htmlprefs/@fontsize}"/>
  <input type="hidden" name="uiprefs_colorset"
                       value="{$uiprefs/xmlprofile/htmlprefs/@colorset}"/>
  <input type="hidden" name="uiprefs_icondisplay" 
                       value="{$uiprefs/xmlprofile/htmlprefs/@icondisplay}"/>
  <input type="hidden" name="uiprefs_fontface"
                       value="{$uiprefs/xmlprofile/htmlprefs/@fontface}"/>
  <input type="hidden" name="psprefs_booktype" value ="{$psprefs/xmlprofile/defaultbook/@booktype}"/> 

  <input type="hidden" name="calprefs_ceClock" value="{$calprefs/xmlprofile/calprefs/@ceClock}"/>
  <input type="hidden" name="calprefs_icsFirstDay" value="{$calprefs/xmlprofile/calprefs/@icsFirstDay}"/>
  <input type="hidden" name="calprefs_weekWorkDays" value="{$calprefs/xmlprofile/calprefs/@ceWeekWorkDays}"/>
  <input type="hidden" name="calprefs_ceDayHead" value="{$calprefs/xmlprofile/calprefs/@ceDayHead}"/>
  <input type="hidden" name="calprefs_ceDayTail" value="{$calprefs/xmlprofile/calprefs/@ceDayTail}"/>
  <input type="hidden" name="calprefs_ceInterval" value="{$calprefs/xmlprofile/calprefs/@ceInterval}"/>
  
</xsl:template>

<!--
*****************************************************************************
* This template prints the Calendar Options menu
*****************************************************************************
-->
<xsl:template name="calSettings">
  <xsl:param name="uiprefs"/>
  <xsl:param name="psprefs"/>
  <xsl:param name="calprefs"/>
  
  <script language="Javascript">
    <!-- 
    * Sun = 1, Mon = 2, Tue = 4, Wed = 8, Thu = 16, Fri = 32, Sat = 64
    -->
    function onWorkWeekChange() {
      selection = 0;
      for (i=0; i&lt;7; i++) {
        if (eval("document.iabform.workweekday"+i).checked) {
          selection = parseInt(selection) + Math.pow(2,i);
        }
      }
      document.iabform.calprefs_weekWorkDays.value = selection;
    }
    function initWorkWeekCheckboxes () {
      selection = document.iabform.calprefs_weekWorkDays.value;
      for (i=0; i&lt;7; i++) {
        eval("document.iabform.workweekday"+i).checked = (selection &amp; Math.pow(2,i))
      }
    }
  </script>


  <table border="0" cellspacing="0" cellpadding="0" class="white-strip"> 
    <tr class="white-strip"> 
      <td width="8">
        <img src="{$spacer.gif}" width="8" height="1"/>
      </td>
      <td> 
        <xsl:call-template name="tab">
          <xsl:with-param name="label">
            <xsl:text>_Appearance</xsl:text>
          </xsl:with-param>
          <xsl:with-param name="labelClass" select="'tab-black'"/>
          <xsl:with-param name="color" select="$inactiveTabColor"/>
          <xsl:with-param name="href">
            <xsl:text>javascript:document.iabform.tabid.value='appearance';submitForm('');</xsl:text>
          </xsl:with-param> 
        </xsl:call-template>
      </td>
      <td> 
        <xsl:call-template name="tab">
          <xsl:with-param name="label">
            <xsl:text>_Settings</xsl:text>
          </xsl:with-param>
          <xsl:with-param name="labelClass" select="'tab-black'"/>
          <xsl:with-param name="color" select="$inactiveTabColor"/>
          <xsl:with-param name="href">
          <xsl:text>javascript:document.iabform.tabid.value='settings';submitForm('');</xsl:text>
          </xsl:with-param> 
        </xsl:call-template>
      </td>
      <td> 
        <xsl:call-template name="tab">
          <xsl:with-param name="label">
            <xsl:text>_Calendar</xsl:text>
          </xsl:with-param>
          <xsl:with-param name="labelClass" select="'tab-white'"/>
          <xsl:with-param name="color" select="$activeTabColor"/>
        </xsl:call-template>
      </td>
    </tr>
  </table>
  <table border="0" cellspacing="0" cellpadding="0" width="100&#37;" class="second-strip">   
    <tr> 
      <td colspan="5" class="first-strip">
        <img src="{$spacer.gif}" width="1" height="9"/>
      </td>
    </tr>
    <tr> 
      <td colspan="5">
        <img src="{$spacer.gif}" width="1" height="6"/>
      </td>
    </tr>
    <tr> 
      <td colspan="5"> 
        <table border="0" cellspacing="0" cellpadding="0">
          <tr> 
            <td width="17">&nbsp;</td>
            <td>
              <span class="normal">
                <xsl:text>_Modify settings that control how Calendar is displayed.</xsl:text>
              </span>
            </td>
          </tr>
        </table>
      </td>
    </tr>
    <tr> 
      <td colspan="5" >
        <img src="{$spacer.gif}" width="1" height="6"/>
      </td>
    </tr>
    <tr class="fourth-strip"> 
      <td colspan="5"> 
        <table border="0" cellspacing="0" cellpadding="0">
          <tr> 
            <td><img src="{$spacer.gif}" width="17" height="1" /></td>
            <td class="areatitle">
              <xsl:text>_Time</xsl:text>
            </td>
          </tr>
        </table>
      </td>
    </tr>
    <tr> 
      <td colspan="5"><img src="{$spacer.gif}" width="1" height="12" /></td>
    </tr>
    <tr> 
      <td width="17">&nbsp;</td>
      <td>&nbsp;</td>
      <td width="10">&nbsp;</td>
      <td valign="top"> 
        <span class="normal">
          <input type="radio" name="calprefs_ceClock" value="12">
            <xsl:if test="$calprefs/xmlprofile/calprefs/@ceClock='12'">
              <xsl:attribute name="checked"/>
            </xsl:if> 
          </input>
          <xsl:text>&nbsp;</xsl:text>
          <xsl:text>_Use 12 hour clock.</xsl:text>
          <br/>
          <input type="radio" name="calprefs_ceClock" value="24">
            <xsl:if test="$calprefs/xmlprofile/calprefs/@ceClock='24'">
              <xsl:attribute name="checked"/>
            </xsl:if> 
          </input>
          <xsl:text>&nbsp;</xsl:text>
          <xsl:text>_Use 24 hour clock.</xsl:text>
        </span>
      </td>
      <td>&nbsp;</td>
    </tr>
    <tr> 
      <td colspan="5" >
        <img src="{$spacer.gif}" width="1" height="6"/>
      </td>
    </tr>
    <tr class="fourth-strip"> 
      <td colspan="5"> 
        <table border="0" cellspacing="0" cellpadding="0">
          <tr> 
            <td><img src="{$spacer.gif}" width="17" height="1" /></td>
            <td class="areatitle">
              <xsl:text>_Work week</xsl:text>
            </td>
          </tr>
        </table>
      </td>
    </tr>
    <tr> 
      <td colspan="5"><img src="{$spacer.gif}" width="1" height="12" /></td>
    </tr>
    <tr> 
      <td width="17">&nbsp;</td>
      <td align="right" valign="top" class="label">
        <xsl:text>_First day of week</xsl:text>
      </td>
      <td width="10">&nbsp;</td>
      <td valign="top"> 
        <span class="normal">
          <select class="normal" name="calprefs_icsFirstDay">
            <option value="1">
              <xsl:if test="$calprefs/xmlprofile/calprefs/@icsFirstDay='1'">
                <xsl:attribute name="selected"/>
              </xsl:if> 
              <xsl:text>_Sunday</xsl:text>
            </option>
            <option value="2">
              <xsl:if test="$calprefs/xmlprofile/calprefs/@icsFirstDay='2'">
                <xsl:attribute name="selected"/>
              </xsl:if> 
              <xsl:text>_Monday</xsl:text>
            </option>
            <option value="3">
              <xsl:if test="$calprefs/xmlprofile/calprefs/@icsFirstDay='3'">
                <xsl:attribute name="selected"/>
              </xsl:if> 
              <xsl:text>_Tuesday</xsl:text>
            </option>
            <option value="4">
              <xsl:if test="$calprefs/xmlprofile/calprefs/@icsFirstDay='4'">
                <xsl:attribute name="selected"/>
              </xsl:if> 
              <xsl:text>_Wednesday</xsl:text>
            </option>
            <option value="5">
              <xsl:if test="$calprefs/xmlprofile/calprefs/@icsFirstDay='5'">
                <xsl:attribute name="selected"/>
              </xsl:if> 
              <xsl:text>_Thursday</xsl:text>
            </option>
            <option value="6">
              <xsl:if test="$calprefs/xmlprofile/calprefs/@icsFirstDay='6'">
                <xsl:attribute name="selected"/>
              </xsl:if> 
              <xsl:text>_Friday</xsl:text>
            </option>
            <option value="7">
              <xsl:if test="$calprefs/xmlprofile/calprefs/@icsFirstDay='7'">
                <xsl:attribute name="selected"/>
              </xsl:if> 
              <xsl:text>_Saturday</xsl:text>
            </option>
          </select>
        </span>
      </td>
      <td width="17">&nbsp;</td>
    </tr>
    <tr> 
      <td colspan="5">
        <img src="{$spacer.gif}" width="1" height="18" />
      </td>
    </tr>
    <tr> 
      <td>&nbsp;</td>
      <td align="right" valign="top" class="label">
        <xsl:text>_Work week days</xsl:text>
      </td>
      <td>&nbsp;</td>
      <td valign="top"> 
        <table  cellpadding="0" cellspacing="0" border="0">
          <tr>
            <td width="80" class="normal">
              <input type="checkbox" name="workweekday0" onClick="onWorkWeekChange()"/>
              <xsl:text>&nbsp;</xsl:text>
              <xsl:text>_Sun</xsl:text>
            </td>
            <td width="80" class="normal">
              <input type="checkbox" name="workweekday1" onClick="onWorkWeekChange()"/>
              <xsl:text>&nbsp;</xsl:text>
              <xsl:text>_Mon</xsl:text>
            </td>
            <td width="80" class="normal">
              <input type="checkbox" name="workweekday2" onClick="onWorkWeekChange()"/>
              <xsl:text>&nbsp;</xsl:text>
              <xsl:text>_Tue</xsl:text>
            </td>
            <td width="80" class="normal">
              <input type="checkbox" name="workweekday3" onClick="onWorkWeekChange()"/>
              <xsl:text>&nbsp;</xsl:text>
              <xsl:text>_Wed</xsl:text>
            </td>
            <td width="80" class="normal">
              <input type="checkbox" name="workweekday4" onClick="onWorkWeekChange()"/>
              <xsl:text>&nbsp;</xsl:text>
              <xsl:text>_Thu</xsl:text>
            </td>
            <td width="80" class="normal">
              <input type="checkbox" name="workweekday5" onClick="onWorkWeekChange()"/>
              <xsl:text>&nbsp;</xsl:text>
              <xsl:text>_Fri</xsl:text>
            </td>
            <td width="80" class="normal">
              <input type="checkbox" name="workweekday6" onClick="onWorkWeekChange()"/>
              <xsl:text>&nbsp;</xsl:text>
              <xsl:text>_Sat</xsl:text>
            </td>
          </tr>
        </table>
        <input type="hidden" name="calprefs_weekWorkDays">
          <xsl:choose>
            <xsl:when test="string-length($calprefs/xmlprofile/calprefs/@ceWeekWorkDays)">
              <xsl:attribute name="value">
                <xsl:value-of select="$calprefs/xmlprofile/calprefs/@ceWeekWorkDays"/>
              </xsl:attribute>
            </xsl:when>
            <xsl:otherwise>
              <xsl:attribute name="value">
                <!-- Default value is Mon, Tue, Wed, Thu, Fri -->
                <xsl:value-of select="'62'"/>
              </xsl:attribute> 
            </xsl:otherwise>
          </xsl:choose> 
        </input>

        <script language="Javascript">
          initWorkWeekCheckboxes();
        </script>
      </td>
      <td>&nbsp;</td>
    </tr>
    <tr> 
      <td colspan="5"><img src="{$spacer.gif}" width="1" height="12"/></td>
    </tr>
    <tr> 
      <td colspan="5"  class="fourth-strip"> 
        <table border="0" cellspacing="0" cellpadding="0">
          <tr> 
            <td><img src="{$spacer.gif}" width="17" height="1" /></td>
            <td class="areatitle"><xsl:text>_Day</xsl:text></td>
          </tr>
        </table>
      </td>
    </tr>
    <tr> 
      <td colspan="5"><img src="{$spacer.gif}" width="1" height="12"/></td>
    </tr>
    <tr> 
      <td>&nbsp;</td>
      <td align="right" valign="top">
        <p class="label">
          <xsl:text>_Day starts at:</xsl:text>
        </p>
      </td>
      <td>&nbsp;</td>
      <td valign="top">
        <span class="normal">
          <select class="normal" name="calprefs_ceDayHead">
            <xsl:call-template name="options-hours">
              <xsl:with-param name="time" select="$calprefs/xmlprofile/calprefs/@ceDayHead"/>
            </xsl:call-template>
          </select>
        </span>
       </td>
      <td>&nbsp;</td>
    </tr>
    <tr> 
      <td colspan="5"><img src="{$spacer.gif}" width="1" height="6"/></td>
    </tr>
    <tr> 
      <td>&nbsp;</td>
      <td align="right" valign="top" class="label">
        <xsl:text>_Day stops at:</xsl:text>
      </td>
      <td>&nbsp;</td>
      <td valign="top">
        <span class="normal">
          <select class="normal" name="calprefs_ceDayTail">
            <xsl:call-template name="options-hours">
              <xsl:with-param name="time" select="$calprefs/xmlprofile/calprefs/@ceDayTail"/>
            </xsl:call-template>
          </select>
        </span>
      </td>
      <td>&nbsp;</td>
    </tr>
    <tr> 
      <td colspan="5"><img src="{$spacer.gif}" width="1" height="6"/></td>
    </tr>
    <tr> 
      <td>&nbsp;</td>
      <td align="right" valign="top" class="label">
        <xsl:text>_Split days</xsl:text>
      </td>
      <td>&nbsp;</td>
      <td valign="top">
        <span class="normal">
          <select class="normal" name="calprefs_ceInterval">'
            <option value="PT0H15M">
              <xsl:if test="$calprefs/xmlprofile/calprefs/@ceInterval='PT0H15M'">
                <xsl:attribute name="selected"/>
              </xsl:if>
              <xsl:text>_every fifteen minutes</xsl:text>
            </option>
            <option value="PT0H30M">
              <xsl:if test="$calprefs/xmlprofile/calprefs/@ceInterval='PT0H30M'">
                <xsl:attribute name="selected"/>
              </xsl:if>
              <xsl:text>_every half hour</xsl:text>
            </option>
            <option value="PT1H0M">
              <xsl:if test="$calprefs/xmlprofile/calprefs/@ceInterval='PT1H0M'">
                <xsl:attribute name="selected"/>
              </xsl:if>
              <xsl:text>_every hour</xsl:text>
            </option>
            <option value="PT2H0M">
              <xsl:if test="$calprefs/xmlprofile/calprefs/@ceInterval='PT2H0M'">
                <xsl:attribute name="selected"/>
              </xsl:if>
              <xsl:text>_every two hours</xsl:text>
            </option>
            <option value="PT4H0M">
              <xsl:if test="$calprefs/xmlprofile/calprefs/@ceInterval='PT4H0M'">
                <xsl:attribute name="selected"/>
              </xsl:if>
              <xsl:text>_every four hours</xsl:text>
            </option>            
          </select>
        </span>
      </td>
      <td>&nbsp;</td>
    </tr>
    <tr> 
      <td colspan="5"><img src="{$spacer.gif}" width="1" height="18" /></td>
    </tr>
    <tr>  
      <td colspan="5" class="first-strip">
        <img src="{$spacer.gif}" width="1" height="2" />
      </td>
    </tr>

  </table>

  <input type="hidden" name="uiprefs_displayname" value="{$uiprefs/entry/displayname}"/>
  <input type="hidden" name="psprefs_displayname" value="{$psprefs/entry/displayname}"/>  
  <xsl:choose>
    <xsl:when test="string-length($calprefs/entry/displayname)&lt;0">
      <input type="hidden" name="calprefs_displayname" value="{$calprefs/entry/displayname}"/>
    </xsl:when>
    <xsl:otherwise>
      <input type="hidden" name="calprefs_displayname" value="iPlanet Calendar"/>
    </xsl:otherwise>
  </xsl:choose> 
  
  <input type="hidden" name="tabid" value="calendar"/>
  <input type="hidden" name="uiprefs_fontsize" 
                       value="{$uiprefs/xmlprofile/htmlprefs/@fontsize}"/>
  <input type="hidden" name="uiprefs_colorset"
                       value="{$uiprefs/xmlprofile/htmlprefs/@colorset}"/>
  <input type="hidden" name="uiprefs_icondisplay" 
                       value="{$uiprefs/xmlprofile/htmlprefs/@icondisplay}"/>
  <input type="hidden" name="uiprefs_fontface"
                       value="{$uiprefs/xmlprofile/htmlprefs/@fontface}"/>

  <input type="hidden" name="uiprefs_dateorder"
                       value="{$uiprefs/xmlprofile/generalprefs/@dateorder}"/>  
  <input type="hidden" name="uiprefs_dateseparator"
                       value="{$uiprefs/xmlprofile/generalprefs/@dateseparator}"/>  
  <input type="hidden" name="uiprefs_webmail"
                       value="{$uiprefs/xmlprofile/generalprefs/@webmail}"/>     
  <input type="hidden" name="uiprefs_quickAddPosition" 
                       value="{$uiprefs/xmlprofile/generalprefs/@quickaddpos}"/>  

  <input type="hidden" name="psprefs_bookid" value ="{$psprefs/xmlprofile/defaultbook/@bookid}"/> 
  <input type="hidden" name="psprefs_booktype" value ="{$psprefs/xmlprofile/defaultbook/@booktype}"/> 
  <input type="hidden" name="psprefs_confirmdelete" value="{$psprefs/xmlprofile/psprefs/@confirmdelete}"/>
  <input type="hidden" name="psprefs_entriesperpage" value="{$psprefs/xmlprofile/layoutinfo/@entriesperpage}"/> 
  <input type="hidden" name="psprefs_booktype" value ="{$psprefs/xmlprofile/defaultbook/@booktype}"/> 
</xsl:template>

<xsl:template name="options-hours">
  <xsl:param name="time" select="'0'"/>
  <xsl:choose>
    <xsl:when test="/xslui/calendar/profileinfo/xmlprofile/calprefs/@ceClock='12'">
      <option value="0">
        <xsl:if test="$time='0'">
          <xsl:attribute name="selected"/>
        </xsl:if> 
        <xsl:text>_0:00am (midnight)</xsl:text>
      </option>
      <option value="1">
        <xsl:if test="$time='1'">
          <xsl:attribute name="selected"/>
        </xsl:if> 
        <xsl:text>_1:00am</xsl:text>
      </option>
      <option value="2">
        <xsl:if test="$time='2'">
          <xsl:attribute name="selected"/>
        </xsl:if> 
        <xsl:text>_2:00am</xsl:text>
      </option>
      <option value="3">
        <xsl:if test="$time='3'">
          <xsl:attribute name="selected"/>
        </xsl:if> 
        <xsl:text>_3:00am</xsl:text>
      </option>
      <option value="4">
        <xsl:if test="$time='4'">
          <xsl:attribute name="selected"/>
        </xsl:if> 
        <xsl:text>_4:00am</xsl:text>
      </option>
      <option value="5">
        <xsl:if test="$time='5'">
          <xsl:attribute name="selected"/>
        </xsl:if> 
        <xsl:text>_5:00am</xsl:text>
      </option>
      <option value="6">
        <xsl:if test="$time='6'">
          <xsl:attribute name="selected"/>
        </xsl:if> 
        <xsl:text>_6:00am</xsl:text>
      </option>
      <option value="7">
        <xsl:if test="$time='7'">
          <xsl:attribute name="selected"/>
        </xsl:if> 
        <xsl:text>_7:00am</xsl:text>
      </option>
      <option value="8">
        <xsl:if test="$time='8'">
          <xsl:attribute name="selected"/>
        </xsl:if> 
        <xsl:text>_8:00am</xsl:text>
      </option>
      <option value="9">
        <xsl:if test="$time='9'">
          <xsl:attribute name="selected"/>
        </xsl:if> 
        <xsl:text>_9:00am</xsl:text>
      </option>
      <option value="10">
        <xsl:if test="$time='10'">
          <xsl:attribute name="selected"/>
        </xsl:if> 
        <xsl:text>_10:00am</xsl:text>
      </option>
      <option value="11">
        <xsl:if test="$time='11'">
          <xsl:attribute name="selected"/>
        </xsl:if> 
        <xsl:text>_11:00am</xsl:text>
      </option>
      <option value="12">
        <xsl:if test="$time='12'">
          <xsl:attribute name="selected"/>
        </xsl:if> 
        <xsl:text>_12:00pm (noon)</xsl:text>
      </option>
      <option value="13">
        <xsl:if test="$time='13'">
          <xsl:attribute name="selected"/>
        </xsl:if> 
        <xsl:text>_1:00pm</xsl:text>
      </option>
      <option value="14">
        <xsl:if test="$time='14'">
          <xsl:attribute name="selected"/>
        </xsl:if> 
        <xsl:text>_2:00pm</xsl:text>
      </option>
      <option value="15">
        <xsl:if test="$time='15'">
          <xsl:attribute name="selected"/>
        </xsl:if> 
        <xsl:text>_3:00pm</xsl:text>
      </option>
      <option value="16">
        <xsl:if test="$time='16'">
          <xsl:attribute name="selected"/>
        </xsl:if> 
        <xsl:text>_4:00pm</xsl:text>
      </option>
      <option value="17">
        <xsl:if test="$time='17'">
          <xsl:attribute name="selected"/>
        </xsl:if> 
        <xsl:text>_5:00pm</xsl:text>
      </option>
      <option value="18">
        <xsl:if test="$time='18'">
          <xsl:attribute name="selected"/>
        </xsl:if> 
        <xsl:text>_6:00pm</xsl:text>
      </option>
      <option value="19">
        <xsl:if test="$time='19'">
          <xsl:attribute name="selected"/>
        </xsl:if> 
        <xsl:text>_7:00pm</xsl:text>
      </option>
      <option value="20">
        <xsl:if test="$time='20'">
          <xsl:attribute name="selected"/>
        </xsl:if> 
        <xsl:text>_8:00pm</xsl:text>
      </option>
      <option value="21">
        <xsl:if test="$time='21'">
          <xsl:attribute name="selected"/>
        </xsl:if> 
        <xsl:text>_9:00pm</xsl:text>
      </option>
      <option value="22">
        <xsl:if test="$time='22'">
          <xsl:attribute name="selected"/>
        </xsl:if> 
        <xsl:text>_10:00pm</xsl:text>
      </option>
      <option value="23">
        <xsl:if test="$time='23'">
          <xsl:attribute name="selected"/>
        </xsl:if> 
        <xsl:text>_11:00pm</xsl:text>
      </option>
    </xsl:when>
    <xsl:otherwise>
      <option value="0">
        <xsl:if test="$time='0'">
          <xsl:attribute name="selected"/>
        </xsl:if> 
        <xsl:text>_0:00</xsl:text>
      </option>
      <option value="1">
        <xsl:if test="$time='1'">
          <xsl:attribute name="selected"/>
        </xsl:if> 
        <xsl:text>_1:00</xsl:text>
      </option>
      <option value="2">
        <xsl:if test="$time='2'">
          <xsl:attribute name="selected"/>
        </xsl:if> 
        <xsl:text>_2:00</xsl:text>
      </option>
      <option value="3">
        <xsl:if test="$time='3'">
          <xsl:attribute name="selected"/>
        </xsl:if> 
        <xsl:text>_3:00</xsl:text>
      </option>
      <option value="4">
        <xsl:if test="$time='4'">
          <xsl:attribute name="selected"/>
        </xsl:if> 
        <xsl:text>_4:00</xsl:text>
      </option>
      <option value="5">
        <xsl:if test="$time='5'">
          <xsl:attribute name="selected"/>
        </xsl:if> 
        <xsl:text>_5:00</xsl:text>
      </option>
      <option value="6">
        <xsl:if test="$time='6'">
          <xsl:attribute name="selected"/>
        </xsl:if> 
        <xsl:text>_6:00</xsl:text>
      </option>
      <option value="7">
        <xsl:if test="$time='7'">
          <xsl:attribute name="selected"/>
        </xsl:if> 
        <xsl:text>_7:00</xsl:text>
      </option>
      <option value="8">
        <xsl:if test="$time='8'">
          <xsl:attribute name="selected"/>
        </xsl:if> 
        <xsl:text>_8:00</xsl:text>
      </option>
      <option value="9">
        <xsl:if test="$time='9'">
          <xsl:attribute name="selected"/>
        </xsl:if> 
        <xsl:text>_9:00</xsl:text>
      </option>
      <option value="10">
        <xsl:if test="$time='10'">
          <xsl:attribute name="selected"/>
        </xsl:if> 
        <xsl:text>_10:00</xsl:text>
      </option>
      <option value="11">
        <xsl:if test="$time='11'">
          <xsl:attribute name="selected"/>
        </xsl:if> 
        <xsl:text>_11:00</xsl:text>
      </option>
      <option value="12">
        <xsl:if test="$time='12'">
          <xsl:attribute name="selected"/>
        </xsl:if> 
        <xsl:text>_12:00</xsl:text>
      </option>
      <option value="13">
        <xsl:if test="$time='13'">
          <xsl:attribute name="selected"/>
        </xsl:if> 
        <xsl:text>_13:00</xsl:text>
      </option>
      <option value="14">
        <xsl:if test="$time='14'">
          <xsl:attribute name="selected"/>
        </xsl:if> 
        <xsl:text>_14:00</xsl:text>
      </option>
      <option value="15">
        <xsl:if test="$time='15'">
          <xsl:attribute name="selected"/>
        </xsl:if> 
        <xsl:text>_15:00</xsl:text>
      </option>
      <option value="16">
        <xsl:if test="$time='16'">
          <xsl:attribute name="selected"/>
        </xsl:if> 
        <xsl:text>_16:00</xsl:text>
      </option>
      <option value="17">
        <xsl:if test="$time='17'">
          <xsl:attribute name="selected"/>
        </xsl:if> 
        <xsl:text>_17:00</xsl:text>
      </option>
      <option value="18">
        <xsl:if test="$time='18'">
          <xsl:attribute name="selected"/>
        </xsl:if> 
        <xsl:text>_18:00</xsl:text>
      </option>
      <option value="19">
        <xsl:if test="$time='19'">
          <xsl:attribute name="selected"/>
        </xsl:if> 
        <xsl:text>_19:00</xsl:text>
      </option>
      <option value="20">
        <xsl:if test="$time='20'">
          <xsl:attribute name="selected"/>
        </xsl:if> 
        <xsl:text>_20:00</xsl:text>
      </option>
      <option value="21">
        <xsl:if test="$time='21'">
          <xsl:attribute name="selected"/>
        </xsl:if> 
        <xsl:text>_21:00</xsl:text>
      </option>
      <option value="22">
        <xsl:if test="$time='22'">
          <xsl:attribute name="selected"/>
        </xsl:if> 
        <xsl:text>_22:00</xsl:text>
      </option>
      <option value="23">
        <xsl:if test="$time='23'">
          <xsl:attribute name="selected"/>
        </xsl:if> 
        <xsl:text>_23:00</xsl:text>
      </option>
    </xsl:otherwise>
  </xsl:choose> 
</xsl:template> 



<!--
*****************************************************************************
* This template prints the user otpions page.
* It calls either the "appearence" template either the "setting template"
* depending on the tab the user selects
*****************************************************************************
-->
<xsl:template match="/">  
  <html>
    <head> 
      <title>
        <xsl:text>_iPlanet Address Book</xsl:text> - <xsl:text>_Options</xsl:text>
      </title>
      <link type="text/css" rel="stylesheet" href="{$commonCSS.css}"/>   
      <xsl:variable name="htmlprefs" select="/xslui/profileinfo/xmlprofile/htmlprefs"/>
      <xsl:call-template name="styleSheetSelector">
        <xsl:with-param name="htmlprefs" select="$htmlprefs"/>     
      </xsl:call-template>
      <xsl:call-template name="fontMaker">
        <xsl:with-param name="htmlprefs" select="$htmlprefs"/>     
      </xsl:call-template>

      <script language="javascript" src="../absjs/common.js"/>
      <script language="javascript">
        <xsl:call-template name="commonjavascript"/>
        <xsl:call-template name="bannerScripts"/>

        function save() {
          <xsl:choose>
            <xsl:when test="string-length(/xslui/@nextview) &gt; 0">
              document.iabform.action = '<xsl:value-of select="/xslui/@nextview"/>'
            </xsl:when>
            <xsl:otherwise>
              document.iabform.action = 'search.xml';
            </xsl:otherwise>
          </xsl:choose> 
          submitForm('saveuseroptions');
        }
        function cancel() {
          <xsl:choose>
            <xsl:when test="string-length(/xslui/@nextview) &gt; 0">
              goToUsingForm('<xsl:value-of select="/xslui/@nextview"/>');
            </xsl:when>
            <xsl:otherwise>
              goToUsingForm('search.xml')
            </xsl:otherwise>
          </xsl:choose> 
        }
      </script>        
    </head> 
    <body leftmargin="0" topmargin="0" rightmargin="0" marginwidth="0" marginheight="0">
      <form method="post" action="useroptions.xml" name="iabform">
        <input type="hidden" name="j_encoding" value="{/xslui/@charset}"/>
        <input type="hidden" name="uiaction" value=""/>
        <input type="hidden" name="prefix" value="uiprefs_"/>
        <input type="hidden" name="prefix" value="psprefs_"/>
        <input type="hidden" name="prefix" value="calprefs_"/>
        <input type="hidden" name="uiprefs_entrytype" value="uiprefs"/>
        <input type="hidden" name="psprefs_entrytype" value="psprefs"/>
        <input type="hidden" name="calprefs_entrytype" value="calprefs"/>
        <xsl:call-template name="contextKeeper">
          <xsl:with-param name="pagedSearch" select="/xslui/iab/pagedsearch"/>
        </xsl:call-template>

        <xsl:call-template name="banner"/> 
        <xsl:call-template name="contextBanner">
          <xsl:with-param name="text">
            <xsl:text>_Options</xsl:text>
          </xsl:with-param>
        </xsl:call-template>
        
        <table border="0" cellspacing="0" cellpadding="0" width="100&#37;">
          <tbody>
            <tr> 
              <td colspan="3" ><img src="{$spacer.gif}" width="1" height="9"/></td>
            </tr>
            <tr align="center"> 
              <td colspan="3"> 
                <xsl:call-template name="save-cancel-help-bar">
                   <xsl:with-param name="helpurl">../help/<xsl:text>_languagepath</xsl:text>/help8.htm</xsl:with-param>
                </xsl:call-template>
              </td>
            </tr>
            <tr>
              <td colspan="3"><img src="{$spacer.gif}" width="1" height="6"/></td>
            </tr>
          </tbody>
        </table>
        
        <xsl:variable name="uiform" select="/xslui/iab/entrycontext[@formentryname='uiprefs']"/>
        <xsl:choose>                                                 
          <xsl:when test="$uiform/@tabid='appearance'">
            <xsl:call-template name="optionsAppearance">
              <xsl:with-param name="uiprefs" select="/xslui/iab/entrycontext[@formentryname='uiprefs']/profileinfo"/>
              <xsl:with-param name="psprefs" select="/xslui/iab/entrycontext[@formentryname='psprefs']/profileinfo"/>
              <xsl:with-param name="calprefs" select="/xslui/calendar/entrycontext[@formentryname='calprefs']/profileinfo"/>
            </xsl:call-template>
          </xsl:when>
          <xsl:when test="$uiform/@tabid='settings'">
            <xsl:call-template name="optionsSettings">
              <xsl:with-param name="uiprefs" select="/xslui/iab/entrycontext[@formentryname='uiprefs']/profileinfo"/>
              <xsl:with-param name="psprefs" select="/xslui/iab/entrycontext[@formentryname='psprefs']/profileinfo"/>
              <xsl:with-param name="calprefs" select="/xslui/calendar/entrycontext[@formentryname='calprefs']/profileinfo"/>
            </xsl:call-template>
          </xsl:when>
          <xsl:when test="$uiform/@tabid='calendar'">
            <xsl:call-template name="calSettings">
              <xsl:with-param name="uiprefs" select="/xslui/iab/entrycontext[@formentryname='uiprefs']/profileinfo"/>
              <xsl:with-param name="psprefs" select="/xslui/iab/entrycontext[@formentryname='psprefs']/profileinfo"/>
              <xsl:with-param name="calprefs" select="/xslui/calendar/entrycontext[@formentryname='calprefs']/profileinfo"/>
            </xsl:call-template>
          </xsl:when>
          <xsl:otherwise>
            <xsl:call-template name="optionsAppearance"/>
          </xsl:otherwise>
        </xsl:choose>

        <table border="0" cellspacing="0" cellpadding="0" width="100&#37;">
          <tbody>
            <tr> 
              <td colspan="3" ><img src="{$spacer.gif}" width="1" height="9"/></td>
            </tr>
            <tr align="center"> 
              <td colspan="3"> 
                <xsl:call-template name="save-cancel-help-bar">
                    <xsl:with-param name="helpurl">../help/<xsl:text>_languagepath</xsl:text>/help8.htm</xsl:with-param>
                </xsl:call-template>
              </td>
            </tr>
            <tr>
              <td colspan="3"><img src="{$spacer.gif}" width="1" height="6"/></td>
            </tr>
          </tbody>
        </table>

        <xsl:for-each select="/xslui/iab/alreadyselected/*">
          <input type="hidden" name="selectedentry" value="{entry/@entryID}"/>
        </xsl:for-each>
          
        <xsl:apply-templates select="/xslui/iab/alreadyselected" mode="hidden"/>
      </form>
    </body>
  </html>
</xsl:template>

</xsl:stylesheet>