<?xml version="1.0"?>
<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>

<xsl:stylesheet version='1.0' xmlns:xsl='http://www.w3.org/1999/XSL/Transform'>

<xsl:template name="search-template-javascript">
  <script language="javascript" src="../absjs/search.js"/><noscript></noscript>
  <script language="javascript" src="../absjs/entries.js"/><noscript></noscript>
</xsl:template>

<!--
*******************************************************************************
* This template prints the javascript used to communicate between a popup and its opener
*******************************************************************************
-->
<xsl:template name="search-popup-javascript">
function buildArray(selectedTable, entryArray, fieldName)
{
  <!-- first build the arrays of things we are interested in -->
  if (selectedTable == null) return;
  var nbEntries = (selectedTable == null)?null:selectedTable.length;
  var selectedEntry = null;
  if (nbEntries == null) {
    nbEntries = 1;
  }

  var lastEntryIndex = entryArray.length;
  for (var i = 0;i &lt; nbEntries; i++) {
    if (nbEntries == 1)
      selectedEntry = selectedTable;
    else
      selectedEntry = selectedTable[i];

    if (selectedEntry.checked) {
      type = document.iabform["id_" + selectedEntry.value + "_entrytype"].value;
      entryid = document.iabform["id_" + selectedEntry.value + "_entryid"].value;

      if( type == 'group' )
      {
         getGroupMembers(entryid, fieldName, entryArray, true);
         lastEntryIndex = entryArray.length;
      } else {
        obj = document.iabform["id_" + selectedEntry.value + "_" + fieldName];
        if (obj != null) {
           if ((obj.length != null) &amp;&amp; (obj.length > 0)) 
             entryArray[lastEntryIndex++] = obj[0].value;
           else
             entryArray[lastEntryIndex++] = obj.value;
        } else 
          entryArray[lastEntryIndex++] = null;
      }
    }
  }
}
</xsl:template> 

<!--
*******************************************************************************
* Prints the query field and the search button.
* Contains also the keypress handler for search on return.
*******************************************************************************
-->
<xsl:template name="search-template-search">
  <xsl:param name="selectedBook" />
  <xsl:param name="bookList"/>
  <xsl:param name="searchmode"/>
  <xsl:param name="selectedBookID"/>
  <xsl:param name="popup" select="false()"/>
  <xsl:param name="bookType"/>
  <xsl:param name="showBookList" select="true()" />
  
  <script language="javascript">

    function linkHandler(evt) {
	/* Hack to fix bug#4937851
	 * For IE, dont let the event bubble up to the document scope 
	 * onkeypress handler (below).
	 * document scope onkeypress handler blocks all enter keys if 
	 * the browser is IE and the target is not on the search bar
	 */
	if(is_ie5up) {
	  event.cancelBubble = true;
	} 
	return true;
    }
    function quickAddHandler(evt) {
        var c = document.layers ? evt.which 
                : document.all ? event.keyCode
                : evt.keyCode;
        var t = document.layers ? evt.target
                : document.all ? event.srcElement
                : evt.target;
	if (c == 13) {
          quickAdd();
	  if(is_ie5up) {
	    event.cancelBubble = true;
	  }
	  return false;	
        } else {
	  if(is_ie5up) {
	    event.cancelBubble = true;
	  }
	  return true;
        }
    }
    document.onkeypress =
      function (evt) {
        var c = document.layers ? evt.which 
                : document.all ? event.keyCode
                : evt.keyCode;
        var t = document.layers ? evt.target
                : document.all ? event.srcElement
                : evt.target;
        if ((c == 13) &#38;&#38; (t.name == 'searchstring')) {
          document.iabform.bookid.value='<xsl:value-of select="$selectedBookID"/>';
          launchSearch(t.value);
        }
	/* Hack to fix bug#4937851
	 * For IE, make sure that the event's default action is not done. 
	 */	
    	if (is_ie5up) { 
	   if(c != 13)
        	return true;
           else	
	        return false;
        } else {
	    return true;
	}
      };

    if (document.layers)
      document.captureEvents(Event.KEYPRESS);
      
    var search_click = 0;
    function MM_openBrWindow(theURL,winName,features) { //v2.0
      window.open(theURL,winName,features);
    }

    function clearSearch() {
	  if (search_click &lt; 1) {
	    document.iabform.searchstring.value = "";	    
	    search_click = 1;
	  }
	}
  </script><noscript></noscript>
   <table cellspacing="0" cellpadding="0" width="100%" border="0">
    <tr> 
     <td colspan="2">
      <xsl:attribute name="nowrap"/>
      <img src="{$spacer.gif}" width="10" height="1" alt=""/>      
      <input type="text" name="searchstring" size="25" onClick="clearSearch()" onKeyPress="clearSearch()">
        <xsl:attribute name="title">
          <xsl:text>_Search For</xsl:text>
        </xsl:attribute>
      </input>
      <img src="{$spacer.gif}" width="4" height="1" alt=""/>            
                         
      <xsl:if test="$showBookList">        
        <span class="Lbl2">
            <xsl:text>_in</xsl:text> 
        </span>        
        <img src="{$spacer.gif}" width="4" height="1" alt=""/>                        
         <xsl:apply-templates select="$bookList" mode="list">
           <xsl:with-param name="selectedEntryID" select="$selectedBookID"/>                      
           <xsl:with-param name="bookType" select="$bookType"/>
           <xsl:with-param name="name" select="'searchbookid'"/>
         </xsl:apply-templates>             
      </xsl:if>                              

      <img src="{$spacer.gif}" width="4" height="1" alt=""/>
      <input class="Btn1" id="go" onBlur="if (this.disabled==0) this.className='Btn1'" onMouseOver="if (this.disabled==0) this.className='Btn1Hov'" onFocus="if (this.disabled==0) this.className='Btn1Hov'" onMouseOut="if (this.disabled==0) this.className='Btn1'" type="button" name="search">
        <xsl:attribute name="onClick"> 
        <xsl:choose>
         <xsl:when test="$popup">                  
            <xsl:text>javascript: document.iabform.bookid.value='</xsl:text>
            <xsl:value-of select="$selectedBookID"/>            
            <xsl:text>';launchSearch(document.iabform.searchstring.value)</xsl:text>
         </xsl:when>
         <xsl:otherwise>
            <xsl:text>javascript:launchSearch(document.iabform.searchstring.value)</xsl:text>
         </xsl:otherwise>
        </xsl:choose>
        </xsl:attribute>
        <xsl:attribute name="onKeyPress"> 
        <xsl:choose>
         <xsl:when test="$popup">                  
            <xsl:text>javascript: document.iabform.bookid.value='</xsl:text>
            <xsl:value-of select="$selectedBookID"/>            
            <xsl:text>';launchSearch(document.iabform.searchstring.value)</xsl:text>
         </xsl:when>
         <xsl:otherwise>
            <xsl:text>javascript:launchSearch(document.iabform.searchstring.value)</xsl:text>
         </xsl:otherwise>
        </xsl:choose>
        </xsl:attribute>        <xsl:attribute name="value">
          <xsl:text>   </xsl:text><xsl:text>_Search</xsl:text><xsl:text>   </xsl:text>
        </xsl:attribute>
        <xsl:attribute name="title">
          <xsl:text>_Search Address Book</xsl:text>
        </xsl:attribute>
      </input>    
<!--          
       <img src="{$spacer.gif}" width="4" height="1" alt=""/>       
       <xsl:if test="$popup">
           <img src="../absimx/Separator_dark_plus10_centered.gif" width="22" height="12"/> 
           <input class="Btn1" type="button" name="search2" id="search" value=" Show All " onMouseOver="if (this.disabled==0) this.className='Btn1Hov'" onFocus="if (this.disabled==0) this.className='Btn1Hov'" onMouseOut="if (this.disabled==0) this.className='Btn1'" onBlur="if (this.disabled==0) this.className='Btn1'" title="Show All Cards" tabindex="3">
           <xsl:attribute name="onClick"> 
            <xsl:choose>
             <xsl:when test="$popup">                  
                <xsl:text>javascript:document.iabform.bookid.value='</xsl:text>                                                         
                <xsl:value-of select="$selectedBookID"/>            
                <xsl:text>';launchSearch('*')</xsl:text>
             </xsl:when>
             <xsl:otherwise>
                <xsl:text>javascript:launchSearch('*')</xsl:text>
             </xsl:otherwise>
            </xsl:choose>
            </xsl:attribute>
          </input>    
       </xsl:if>
-->
      </td>
      <td>
        <img src="{$spacer.gif}" width="4" height="1" alt=""/>
      </td>
    </tr>
  </table>
<xsl:if test="$searchmode">
   <script language="javascript">
     var filter = document.iabform.filter.value;
     var extractedFilter = extractMatchFromFilter(filter);
     if( extractedFilter != null &#38;&#38; extractedFilter.length &gt; 0 )
       document.iabform.searchstring.value = extractMatchFromFilter(filter); 
   </script><noscript></noscript>
</xsl:if>
</xsl:template>

<!--
*******************************************************************************
* This template prints the quick filter in the search page
* It prints the filter "All" then the alphabet and then the filter "Groups"
* @param disabled If true then all the links are disable. Case of a remote address book.
*******************************************************************************
-->
<xsl:template name="search-template-alphabet">
  <xsl:param name="disabled" select="false()"/>

  <script>
    function showGroup() {
      document.iabform.firstentry.value = 1;
      document.iabform.filter.value = "entry/displayname=*";
      document.iabform.stopsearch.value = 1;
      
      if( document.iabform.expandedgroup )
        document.iabform.expandedgroup.value = "";
      document.iabform.type.value = "group";
      document.iabform.action = "search.xml";
      if( document.iabform.wcfg_searchmode != null ) document.iabform.wcfg_searchmode.value = "true";
      submitForm('');
   }
 
    function buildAlphabet() 
    {
      var alphabet = new Array('A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z');
      var alltext = '<xsl:text>_All</xsl:text>';
      var azlinktext = '<xsl:text>_A-Z links</xsl:text>';
      var grplinktext = '<xsl:text>_Groups links</xsl:text>';
      var showGroup = false;
      if( document.iabform.type != null &#38;&#38; document.iabform.type.value == "group" )
         showGroup = true;
      <xsl:choose>
      <xsl:when test="$disabled">
        document.write('&lt;span class="Lbl2" title="' + azlinktext + '"&gt;');
        document.write(alltext + '&nbsp;&nbsp;&nbsp;');
        for (i = 0; i &lt; alphabet.length;i++) {
          document.write(alphabet[i] + '&nbsp;');
        }
        document.write('&lt;/span&gt;');
      </xsl:when>
      <xsl:otherwise>
        <!-- Highlight the All filter if active -->
        current = "entry/displayname=*";
        if (document.iabform.filter.value == current &#38;&#38; !showGroup) {
          document.write('&lt;span class="Lbl2" title="' + azlinktext + '"&gt;' + alltext + '&lt;/span&gt;');
        }
        else {
          document.write('&lt;span class="Lbl2"&gt;&lt;a title="' + azlinktext + '"href="javascript:setFilter(');
          document.write("'*','allEntries');document.iabform.stopsearch.value = 1;document.iabform.type.value='';document.iabform.action = 'search.xml';submitForm('');");
      
          document.write('" title="' + azlinktext + '"');
          document.write('&gt;' + alltext + '&lt;/a&gt;&lt;/span&gt;\n');
        }
        document.write('&nbsp;&nbsp;&nbsp;');
        <!-- Highlight the current letter if one active -->
        for (i = 0; i &lt; alphabet.length;i++) {
          current = "entry/displayname=" + alphabet[i] + "*";
          if (document.iabform.filter.value == current &#38;&#38; !showGroup) { 
            document.write(alphabet[i] + '&nbsp;\n');
          }
          else { 
            document.write('&lt;a class="Lnk" title="' + azlinktext + '" href="javascript:setFilter(');
            document.write("'" + alphabet[i] + "','startsWith');document.iabform.stopsearch.value = 1;document.iabform.type.value='';document.iabform.action = 'search.xml';submitForm('');");
            document.write('" title="' + azlinktext + '"&gt;' + alphabet[i] + '&lt;/a&gt;&nbsp;\n');
          }
        }    
       </xsl:otherwise>
       </xsl:choose>

      grouptext = '<xsl:text>_Groups</xsl:text>';
      if ( showGroup ) {
        document.write('&lt;span class="Lbl2" title="' + grplinktext + '"&gt;' + grouptext + '&lt;/span&gt;');
      }
      else {
        document.write('&lt;a class="Lnk" href="javascript:showGroup();"');
        document.write('" title="' + grplinktext + '"&gt;' + grouptext + '&lt;/a&gt;');      
      }
    }

  </script><noscript></noscript>
  <script>
    buildAlphabet();
  </script><noscript></noscript>

</xsl:template>

<!--
*****************************************************************************
* This template formats and prints the current book bar
*
* @param bookList The list of books (/xslui/iab/booklist)
* @param selectedBook The current book.
*****************************************************************************
-->
<xsl:template name="search-template-bookbar">
<xsl:param name="bookList"/>
<xsl:param name="selectedBook"/>
<xsl:param name="isIntegration" select="false()"/>
<xsl:param name="onlyLocals" select="false()"/>
<table width="100&#37;" border="0" cellspacing="0" cellpadding="0" class="MstTbl" summary="This table contains the global tabs">
  <xsl:attribute name="title">
    <xsl:text>_Global Tabs</xsl:text>
  </xsl:attribute>
  <tr><td colspan="3"><img height="2" src="{$spacer.gif}" width="1" alt=""/></td></tr>
  <tr>       
    <td width="41&#37;"> 
     <xsl:if test="$isIntegration">
       <table border="0" cellspacing="0" cellpadding="0" class="Tab1Tbl">
       <tr> 
        <td colspan="12"><img height="2" src="{$spacer.gif}" width="1" alt=""/></td>
       </tr>
       <tr> 
        <td class="Tab1Gutter" colspan="7"><img height="3" src="{$spacer.gif}" width="1" alt=""/></td>
        <td class="Tab1Sel" rowspan="3"> 
         <xsl:attribute name="nowrap"/>
         <div class="Tab1Sel">
         <span class="Tab1LblSel">
          <xsl:attribute name="title">
           <xsl:text>_Address Book</xsl:text>
          </xsl:attribute>
          <xsl:text>_Address Book</xsl:text>
         </span>
         </div>
        </td>
        <td class="Tab1Sel" rowspan="3">
         <img height="1" src="{$spacer.gif}" width="10" alt=""/>
        </td>
        <td class="Tab1Gutter" colspan="3">
         <img height="3" src="{$spacer.gif}" width="1" alt=""/>
        </td>
       </tr>
       <tr> 
        <xsl:choose>
        <xsl:when test="/xslui/usersession/@mailenabled='true'">
        <td class="Tab1Gutter">
         <img height="1" src="{$spacer.gif}" width="10" alt=""/>
        </td>
        <td class="Tab1NotSel"> 
         <div class="Tab1NotSel">
         <a name="tabs"></a>
         <a class="Tab1LblNormal" onMouseOver="status='Mail'; return true;" onFocus="status='Mail'; return true;" title="Mail" onMouseOut="status=';'" onBlur="status=';'" target="historyFrame">
         <xsl:attribute name="href">
           <xsl:value-of select="/xslui/usersession/@mailurl"/>
           <xsl:if test="/xslui/usersession/@hosteddomain='true'">
             <xsl:text>/</xsl:text>
             <xsl:value-of select="/xslui/usersession/@domain"/>
           </xsl:if>
           <xsl:text>/history.html?cfg.msc?fromuwc=1</xsl:text>
         </xsl:attribute>
         <xsl:attribute name="title">
           <xsl:text>_Mail</xsl:text>
         </xsl:attribute>
         <xsl:text>_Mail</xsl:text>
         </a>
         </div>
        </td>
        <td class="Tab1NotSel">
         <img height="1" src="{$spacer.gif}" width="10" alt=""/>
        </td>
        </xsl:when>
        <xsl:otherwise>
          <td class="Tab1Gutter" colspan="3"></td>
        </xsl:otherwise>
        </xsl:choose>
        <xsl:choose>
        <xsl:when test="/xslui/usersession/@calendarenabled='true'">
        <td class="Tab1Gutter">
         <img height="1" src="{$spacer.gif}" width="3" alt=""/>
        </td>
        <td class="Tab1NotSel"> 
         <xsl:attribute name="nowrap"/>
         <div class="Tab1NotSel">
         <a class="Tab1LblNormal" onMouseOver="status='Calendar'; return true;" 
                      onFocus="status='Calendar'; return true;"
  		      onMouseOut="status=';'" onBlur="status=';'" target="_parent">
            <xsl:attribute name="title">
              <xsl:text>_Calendar</xsl:text>
            </xsl:attribute>
            <xsl:attribute name="href">
              <xsl:value-of select="/xslui/@contexturi"/>
              <xsl:text>/base/UWCMain?forwardtodefview=true</xsl:text>
            </xsl:attribute>
            <xsl:text>_Calendar</xsl:text>
         </a>
         </div>
        </td>
        <td class="Tab1NotSel">
         <img height="1" src="{$spacer.gif}" width="10" alt=""/>
        </td>
        <td class="Tab1Gutter">
         <img height="1" src="{$spacer.gif}" width="3" alt=""/>
        </td>
        </xsl:when>
        <xsl:otherwise>
          <td class="Tab1Gutter" colspan="3"></td>
        </xsl:otherwise>
        </xsl:choose>
        <td class="Tab1Gutter">
         <img height="1" src="{$spacer.gif}" width="3" alt=""/>
        </td>
        <td class="Tab1NotSel"> 
         <div class="Tab1NotSel">
         <a class="Tab1LblNormal" onMouseOver="status='Options'; return true;" 
            onFocus="status='Options'; return true;" 
            onMouseOut="status=';'" target="_parent" onBlur="status=';'">
            <xsl:attribute name="title">
              <xsl:text>_Options</xsl:text>
            </xsl:attribute>
            <xsl:attribute name="href"><xsl:value-of  select="/xslui/@contexturi"/><xsl:text>/base/ABPreferences</xsl:text></xsl:attribute>
            <xsl:text>_Options</xsl:text>
         </a>
         </div>
        </td>
        <td class="Tab1NotSel">
         <img height="1"  src="{$spacer.gif}" width="10" alt=""/>
        </td>        
       </tr>
       <tr> 
        <td class="Tab1Gutter" colspan="7">
         <img height="1" src="{$spacer.gif}" width="1" alt=""/>
        </td>
        <td class="Tab1Gutter" colspan="3">
         <img height="1" src="{$spacer.gif}" width="1" alt=""/>
        </td>
       </tr>
       </table>
     </xsl:if>  
    </td>
    <td align="right" width="58&#37;">
     <label for="current_addressbook"><span class="Lbl2"><xsl:text>_Current Address Book:</xsl:text>&nbsp;</span></label> 
     <font size="2">
     <xsl:choose>
      <xsl:when test="$onlyLocals">
          <xsl:apply-templates select="$bookList" mode="list">
          <xsl:with-param name="selectedEntryID" select="$selectedBook/entry/@entryID"/>
          <xsl:with-param name="name" select="'curbookid'"/>
          <xsl:with-param name="onlyLocals" select="$onlyLocals"/>
          <xsl:with-param name="onChangeAction">
            <xsl:text>javascript:switchBook(getSelectValue(this), 'search.xml')</xsl:text>
          </xsl:with-param>
          <xsl:with-param name="forid" select="'current_addressbook'"/>
        </xsl:apply-templates>
      </xsl:when>
      <xsl:otherwise>
        <xsl:apply-templates select="$bookList" mode="list">
          <xsl:with-param name="selectedEntryID" select="$selectedBook/entry/@entryID"/>
          <xsl:with-param name="name" select="'curbookid'"/>
          <xsl:with-param name="onChangeAction">
            <xsl:text>javascript:switchBook(getSelectValue(this), 'search.xml')</xsl:text>
          </xsl:with-param>
        </xsl:apply-templates>
      </xsl:otherwise>
     </xsl:choose>        
     </font>
    </td>
    <td align="right">&nbsp;</td>
  </tr>
  <xsl:if test="not($isIntegration)">
    <tr>
      <td colspan="2"><img height="5" src="{$spacer.gif}" alt=""/></td>
    </tr>
  </xsl:if>
</table>
</xsl:template> 

<!--
*****************************************************************************
* This template formats and prints the search bar
*
* @param bookList The list of books (/xslui/iab/booklist)
* @param selectedBook The current book.
* @param showBookList Whether or not to display the list of books pulldown.
*
*    For a popup we need to set the selectedBook based on the 
*    query parameter wcfg_abtype (0-PAB, 1-CORP, 2-ALL). If param passed is
*    after a result of <xsl:choose>... then the value is not a node-set but
*    becomes a result-tree-fragment. Struggeled so much to get it in correct
*    node-set format so that can get sub-node values but couldn't get success
*    hence ended up computing selected book related stuff for popup in this template 
*    again.
*****************************************************************************
-->
<xsl:template name="search-template-searchbar">
  <xsl:param name="bookList"/>
  <xsl:param name="selectedBook"/>
  <xsl:param name="searchmode"/>  
  <xsl:param name="selectedBookID"/>
  <xsl:param name="bookType"/>
  <xsl:param name="popup" select="false()"/>
  <xsl:param name="showBookList" select="true()"/>
  <xsl:param name="wildcardsearch" select="0"/>
     
  <table border="0" cellspacing="0" cellpadding="0" width="100&#37;">
    <tr> 
      <td>
        <img src="{$spacer.gif}" width="1" height="4" alt=""/>
      </td>
    </tr>
    <tr> 
      <td>
        <img src="{$spacer.gif}" width="1" height="6" alt=""/>
      </td>
    </tr>
    <tr> 
      <td align="left">                       
        <xsl:call-template name="search-template-search">
          <xsl:with-param name="bookList" select="$bookList"/>
          <xsl:with-param name="bookType" select="$bookType"/>   
          <xsl:with-param name="searchmode" select="$searchmode"/>  
          <xsl:with-param name="selectedBookID" select="$selectedBookID"/>  
          <xsl:with-param name="popup" select="$popup"/>
          <xsl:with-param name="selectedBook" select="$selectedBook"/>
          <xsl:with-param name="showBookList" select="$showBookList"/>
        </xsl:call-template>        
      </td>
    </tr>
    <tr> 
      <td>
        <img src="{$spacer.gif}" width="1" height="6" alt=""/>
      </td>
    </tr>
  </table>
  <xsl:if test="not($popup)">
    <xsl:if test="not($wildcardsearch) or $wildcardsearch &lt; 1">
    <table width="100%" border="0" cellspacing="0" cellpadding="0" summary="This table contains the A to Z links">
    <xsl:attribute name="title"><xsl:text>_A-Z links</xsl:text></xsl:attribute>
      <tr> 
        <td colspan="2"><xsl:attribute name="nowrap"/><img src="{$spacer.gif}" width="1" height="12"  alt=""/></td>
      </tr>
      <tr> 
        <td width="1%"><img src="{$spacer.gif}" width="10" height="1"  alt=""/></td>
        <td width="99%">            
          <label for="event_search"><span class="Lbl2"><xsl:text>_View</xsl:text>:</span></label> 
            &nbsp;                      
            <xsl:call-template name="search-template-alphabet"/>                     
        &nbsp;
        </td>
      </tr>
    </table>  
    </xsl:if>    
  </xsl:if>
</xsl:template> 


<!--
*******************************************************************************
* This template prints the search page header
* @param selectedbook The current selected book
* @param popup whether the window if a popup
*******************************************************************************
-->
<xsl:template name="search-template-header">
  <xsl:param name="header"/>
  <xsl:param name="searchmode" select="false()"/>
  <xsl:param name="searchCriteria"/>
  <xsl:param name="popup" select="false()"/>
  <xsl:param name="colspan" select="5"/>

<!-- for popups we show Search Result text -->   
  <tr>   
    <td class="TblTtlTd" scope="col">         
    <xsl:attribute name="colspan"><xsl:value-of select="$colspan"/></xsl:attribute>
    <span class="TblTtlTxt">    
      <xsl:choose>
        <xsl:when test="$searchmode and string-length($searchCriteria) &gt; 0">
          <script>
            var header = "<xsl:call-template name="escape"><xsl:with-param name="text" select="$header"/></xsl:call-template>";
            var searchstring = document.iabform.searchstring;               
            if( searchstring != null &#38;&#38; searchstring.value.length > 0 ) {
                var sourceString = '<xsl:text>_Search Result Message</xsl:text>';
                var filter = document.iabform.filter.value;
                var extractedFilter = extractMatchFromFilter(filter);
                if( extractedFilter == null )
                  extractedFilter = "";
                var params = new Array(header,
                                        extractedFilter);
                printLocalizedLabel(sourceString, params);
             } else {
                document.write(header);
             }                
          </script><noscript></noscript>                    
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$header" />
        </xsl:otherwise>
      </xsl:choose>
    </span>
    </td>           
  </tr>
<!--  </table> -->
<script>
  var searchstring = document.iabform.searchstring;  
  if( searchstring != null &#38;&#38; searchstring.value.length == 0 )
     searchstring.value='<xsl:text>_Search For</xsl:text>';
</script><noscript></noscript>
</xsl:template>
<!--
*******************************************************************************
* This template prints the page navigation links
* @param searchresult The current searchresult node
*******************************************************************************
-->
<xsl:template name="search-template-paging">
  <xsl:param name="searchresult"/>
  <xsl:param name="colspan" select="5"/>
  <xsl:param name="tdClass" select="TblActTd"/>
  <xsl:param name="popup" select="true()"/>

  <xsl:variable name="firstentry"
              select="number($searchresult/@firstentry)"/>
  <xsl:variable name="lastentry"
              select="number($searchresult/@lastentry)"/>
  <xsl:variable name="totalentries"
              select="number($searchresult/@totalentries)"/>
  <xsl:variable name="entriesperpage"
              select="number($searchresult/@entriesperpage)"/>

<xsl:choose>              
  <xsl:when test="$lastentry &gt; 0">
    <td align="right">                
    <xsl:attribute name="class"><xsl:value-of select="$tdClass"/></xsl:attribute>    
    <xsl:attribute name="colspan"><xsl:value-of select="$colspan"/></xsl:attribute>     
      <xsl:if test="$firstentry > 1">                    
        <a class="Lnk">
          <xsl:attribute name="href">
            <xsl:text>javascript:document.iabform.firstentry.value=</xsl:text>
            <xsl:value-of select="$firstentry - $entriesperpage"/>
            <xsl:if test="not($popup)">
              <xsl:text>;document.iabform.action="search.xml"</xsl:text>
            </xsl:if>
            <xsl:text>;submitForm('');</xsl:text>
          </xsl:attribute>
        <xsl:text>_Previous</xsl:text>
        </a>                                        
        <xsl:text>&nbsp;|&nbsp;</xsl:text>  
      </xsl:if>
      
      <xsl:text>_Showing</xsl:text>&nbsp;<xsl:value-of select="$firstentry"/>&nbsp;-&nbsp;<xsl:value-of select="$lastentry"/>&nbsp;<xsl:text>_of</xsl:text>&nbsp;<xsl:value-of select="$totalentries"/>        
      <xsl:if test="$lastentry != $totalentries">
        <xsl:text> &nbsp;|&nbsp;</xsl:text>              
        <a class="Lnk">
          <xsl:attribute name="href">
            <xsl:text>javascript:document.iabform.firstentry.value=</xsl:text>
            <xsl:value-of select="$firstentry + $entriesperpage"/>
            <xsl:if test="not($popup)">
              <xsl:text>;document.iabform.action="search.xml"</xsl:text>
            </xsl:if>
            <xsl:text>;submitForm('');</xsl:text>
          </xsl:attribute>
        <xsl:text>_Next</xsl:text>
        </a>&nbsp;
      </xsl:if>        
    </td>
  </xsl:when>
  <xsl:otherwise>
    <td align="right">
      <xsl:attribute name="colspan"><xsl:value-of select="$colspan"/></xsl:attribute> 
      <xsl:attribute name="class"><xsl:value-of select="$tdClass"/></xsl:attribute>        
      
    </td>       
  </xsl:otherwise>   
</xsl:choose>         

</xsl:template>

<!--
*******************************************************************************
* This template formats and prints the results of a search
* @param pagedSearch Element containing both nodes searchresult and expandedgroups
* @param selectedbook The book currently browsed by the user
*******************************************************************************
-->
<xsl:template name="search-template-searchresult">
<xsl:param name="pagedSearch"/>
<xsl:param name="selectedbook"/>
<xsl:param name="xmlprofile"/>
<xsl:param name="searchmode" select="false()"/>
<xsl:param name="formaction"/>
<xsl:param name="popup" select="false()"/>
<xsl:param name="showResult" select="'1'"/>
<xsl:param name="displayMode" select="'normal'" />
<xsl:param name="linkOnIcon" select="true()" />

<!--
* First determine which field to display in each column
-->  
<xsl:param name="displayAttr1">
  <xsl:call-template name="getColumnFieldName">
    <xsl:with-param name="id" select="1"/>
    <xsl:with-param name="xmlprofile" select="$xmlprofile"/>
  </xsl:call-template>
</xsl:param>
<xsl:param name="displayAttr2">
  <xsl:call-template name="getColumnFieldName">
    <xsl:with-param name="id" select="2"/>
    <xsl:with-param name="xmlprofile" select="$xmlprofile"/>
  </xsl:call-template>
</xsl:param>
<xsl:param name="displayAttr3">
  <xsl:call-template name="getColumnFieldName">
    <xsl:with-param name="id" select="3"/>
    <xsl:with-param name="xmlprofile" select="$xmlprofile"/>
  </xsl:call-template>
</xsl:param>
<xsl:param name="displayAttr4">
  <xsl:call-template name="getColumnFieldName">
    <xsl:with-param name="id" select="4"/>
    <xsl:with-param name="xmlprofile" select="$xmlprofile"/>
  </xsl:call-template>
</xsl:param>
<xsl:param name="displayAttr5">
  <xsl:call-template name="getColumnFieldName">
    <xsl:with-param name="id" select="5"/>
   <xsl:with-param name="xmlprofile" select="$xmlprofile"/>
  </xsl:call-template>
</xsl:param>
<xsl:param name="displayAttr6">
  <xsl:call-template name="getColumnFieldName">
    <xsl:with-param name="id" select="6"/>
    <xsl:with-param name="xmlprofile" select="$xmlprofile"/>
  </xsl:call-template>
</xsl:param>
<xsl:param name="displayAttr7">
  <xsl:call-template name="getColumnFieldName">
    <xsl:with-param name="id" select="7"/>
    <xsl:with-param name="xmlprofile" select="$xmlprofile"/>
  </xsl:call-template>
</xsl:param>

<xsl:variable name="totalentries" select="number($pagedSearch/searchresult/@totalentries)"/> 
<xsl:variable name="displayResult">
  <xsl:choose>
  <xsl:when test="$popup and $searchmode and $totalentries != 0">
    <xsl:value-of select="'true'"/>
  </xsl:when>
  <xsl:when test="$showResult='1' and $totalentries != 0">
    <xsl:value-of select="'true'"/>
  </xsl:when>
  <xsl:otherwise>
    <xsl:value-of select="'false'"/>
  </xsl:otherwise>
  </xsl:choose>
</xsl:variable>
<xsl:variable name="searchresult" select="$pagedSearch/searchresult"/>   
<tr>
<xsl:if test="$displayResult='true'">  
<xsl:choose>    
 <xsl:when test="$displayMode = 'to-cc-bcc'">                
    <th class="TblThCl1" scope="col" width="4%">         
      <xsl:attribute name="nowrap"/>
       <xsl:text>_To:</xsl:text>         
    </th>
    <th class="TblThCcBcc" scope="col" width="4%" align="center">   
      <xsl:attribute name="nowrap"/>      
       <xsl:text>_Cc:</xsl:text>         
    </th>
    <th class="TblThCcBcc" scope="col" width="4%" align="center">             
      <xsl:attribute name="nowrap"/>
      <xsl:text>_Bcc:</xsl:text>         
    </th>
 </xsl:when>
 <xsl:otherwise>
 <th width="5%" class="TblThCl1" scope="col">
   <xsl:attribute name="nowrap"/>
   <xsl:if test="not(/xslui/iab/entrycontext/layoutinfo/showradio/@value='true')"> 
   <div style="text-align:center"> 
      <input name="select-all" onClick="javascript:checkAll(document.iabform.selectedentry,true)"  onKeyPress="javascript:checkAll(document.iabform.selectedentry,true)" type="image" src="{$selectall_16.gif}" align="top" width="15" height="13" border="0">
         <xsl:attribute name="alt">
            <xsl:text>_Select All Items Displayed in Table</xsl:text>  
         </xsl:attribute> 
         <xsl:attribute name="title">
            <xsl:text>_Select All Items Displayed in Table</xsl:text>  
         </xsl:attribute>               
      </input>               
      <input name="deselect-all" onClick="javascript:checkAll(document.iabform.selectedentry,false)" onKeyPress="javascript:checkAll(document.iabform.selectedentry,false)" type="image" src="{$deselectall_16.gif}" align="top" width="15" height="13" border="0">
         <xsl:attribute name="alt">
            <xsl:text>_Deselect All Items Displayed in Table</xsl:text>  
         </xsl:attribute> 
         <xsl:attribute name="title">
            <xsl:text>_Deselect All Items Displayed in Table</xsl:text>                  
         </xsl:attribute>  
      </input>   
      </div>
    </xsl:if>   
  </th>
  </xsl:otherwise>
 </xsl:choose> 
 </xsl:if>

<xsl:variable name="showsortby" select="not($popup) and $showResult='1' and $totalentries != 0"/>

<!--
 * Then prints the column headers
-->
<th scope="col">
 <xsl:choose>
 <xsl:when test="$displayResult='true'">
    <xsl:attribute name="class">
      <xsl:value-of select="'TblThSrt'"/>
    </xsl:attribute>
 </xsl:when>
 <xsl:otherwise> 
  <xsl:attribute name="class">
    <xsl:value-of select="'TblThCl1'"/>
  </xsl:attribute>
 </xsl:otherwise> 
 </xsl:choose>
 <xsl:choose>
    <xsl:when test="string-length($displayAttr1)">
      <xsl:call-template name="attr_display_name">
        <xsl:with-param name="attr" select="$displayAttr1" />
        <xsl:with-param name="sortby" select="$searchresult/@sortby" />
        <xsl:with-param name="showsortby" select="$showsortby"/>
      </xsl:call-template>
    </xsl:when>
    <xsl:otherwise>
        <xsl:text>&nbsp;</xsl:text>
      </xsl:otherwise>
    </xsl:choose> 
</th>

  <xsl:call-template name="print-display-col">
     <xsl:with-param name="displayAttr" select="$displayAttr2"/>
     <xsl:with-param name="searchresult" select="$searchresult"/>
     <xsl:with-param name="showsortby" select="$showsortby"/>
  </xsl:call-template>

  <xsl:call-template name="print-display-col">
     <xsl:with-param name="displayAttr" select="$displayAttr3"/>
     <xsl:with-param name="searchresult" select="$searchresult"/>
     <xsl:with-param name="showsortby" select="$showsortby"/>
  </xsl:call-template>

  <xsl:call-template name="print-display-col">
     <xsl:with-param name="displayAttr" select="$displayAttr4"/>
     <xsl:with-param name="searchresult" select="$searchresult"/>
     <xsl:with-param name="showsortby" select="$showsortby"/>
  </xsl:call-template>

  <xsl:call-template name="print-display-col">
     <xsl:with-param name="displayAttr" select="$displayAttr5"/>
     <xsl:with-param name="searchresult" select="$searchresult"/>
     <xsl:with-param name="showsortby" select="$showsortby"/>
  </xsl:call-template>
  
  <xsl:call-template name="print-display-col">
     <xsl:with-param name="displayAttr" select="$displayAttr6"/>
     <xsl:with-param name="searchresult" select="$searchresult"/>
     <xsl:with-param name="showsortby" select="$showsortby"/>
  </xsl:call-template>

  <xsl:call-template name="print-display-col">
     <xsl:with-param name="displayAttr" select="$displayAttr7"/>
     <xsl:with-param name="searchresult" select="$searchresult"/>
     <xsl:with-param name="showsortby" select="$showsortby"/>
  </xsl:call-template>
</tr>      

<xsl:variable name="isRemote" select="boolean($selectedbook/@bookremoteurl)"/>
<!-- we print when the serachmode is on -->
<xsl:if test="$displayResult='true'">
  <!-- And finally prints the content of the search result -->
  <xsl:apply-templates mode="list" select="$searchresult/*">
    <xsl:with-param name="pagedSearch" select="$pagedSearch"/>
    <xsl:with-param name="depth" select="0" />
    <xsl:with-param name="formaction" select="$formaction"/>
    <xsl:with-param name="linkOnIcon" select="$linkOnIcon" />
    <xsl:with-param name="displayAttr1" select="$displayAttr1" />
    <xsl:with-param name="displayAttr2" select="$displayAttr2" />
    <xsl:with-param name="displayAttr3" select="$displayAttr3" />
    <xsl:with-param name="displayAttr4" select="$displayAttr4" />
    <xsl:with-param name="displayAttr5" select="$displayAttr5" />
    <xsl:with-param name="displayAttr6" select="$displayAttr6" />
    <xsl:with-param name="displayAttr7" select="$displayAttr7" />
  </xsl:apply-templates>
</xsl:if>
</xsl:template>

<xsl:template name="print-display-col">
  <xsl:param name="displayAttr"/>
  <xsl:param name="searchresult"/>
  <xsl:param name="showsortby"/>

  <xsl:if test="string-length($displayAttr)">
  <th scope="col">
        <xsl:call-template name="attr_display_name">
          <xsl:with-param name="attr" select="$displayAttr" />
          <xsl:with-param name="sortby" select="$searchresult/@sortby" />
          <xsl:with-param name="showsortby" select="$showsortby"/>
        </xsl:call-template>
  </th>
  </xsl:if>
</xsl:template>

<!--
*******************************************************************************
* This template formats and prints the already selected section
* @param alreadySelected The node containing all the already selected entries
*******************************************************************************
-->
<xsl:template name="search-template-alreadyselected">
  <xsl:param name="alreadySelected"/>
  <xsl:param name="colspan" select="5"/>

  <xsl:if test="$alreadySelected/child::node()">    
      <tr> 
        <td class="TblActTdLst">
        <xsl:attribute name="colspan"><xsl:value-of select="$colspan"/></xsl:attribute>
        <span class="Lbl4">
         <xsl:text>_Selected Cards</xsl:text></span>&nbsp;
         <input class="Btn1Mni" type="button" name="deselect" id="deselect" onMouseOver="if (this.disabled==0) this.className='Btn1MniHov'" onFocus="if (this.disabled==0) this.className='Btn1MniHov'" onMouseOut="if (this.disabled==0) this.className='Btn1Mni'" onBlur="if (this.disabled==0) this.className='Btn1Mni'" onClick="javascript:checkAll(document.iabform.alreadyselectedentry,false);return false;" onKeyPress="javascript:checkAll(document.iabform.alreadyselectedentry,false);return false;">       
          <xsl:attribute name="value"><xsl:text>_Deselect Cards</xsl:text></xsl:attribute>
          <xsl:attribute name="title"><xsl:text>_Deselect Cards</xsl:text></xsl:attribute>
        </input>
        </td>          
      </tr>         
      <xsl:for-each select="$alreadySelected/*[entry/@selectedfromui = 1]">
       <tr>          
         <td class="TblTdCl1" align="center" width="5%"> 
           <xsl:call-template name="alreadySelectedCheckBox">
             <xsl:with-param name="entryID" select="entry/@entryID"/>
           </xsl:call-template>
         </td>
         <td>
           <xsl:attribute name="colspan"><xsl:value-of select="number($colspan)-1"/></xsl:attribute>           
           <xsl:value-of select="entry/displayname"/>
           <xsl:text>&nbsp;</xsl:text>
         </td>              
         <xsl:apply-templates mode="hidden" select="."/>
        </tr>      
       </xsl:for-each>             
  </xsl:if> 
</xsl:template>

<!--
*******************************************************************************
* This template formats and prints the already selected section into hidden fields
* @param alreadySelected The node containing all the already selected entries
*******************************************************************************
-->
<xsl:template name="search-template-alreadyselected-hidden">
  <xsl:param name="alreadySelected"/>

  <xsl:if test="$alreadySelected/child::node()">
    <xsl:for-each select="$alreadySelected/*">
      <input type="hidden" name="selectedentry" value="{entry/@entryID}"/>
      <xsl:apply-templates mode="hidden" select="."/>
    </xsl:for-each>
  </xsl:if> 
</xsl:template>


<!--
*******************************************************************************
* This template displays the already selected checkboxes
* @param entryID The entryID of the already selected entry
*******************************************************************************
-->
<xsl:template name="alreadySelectedCheckBox">
  <xsl:param name="entryID" />  
  <input type="checkbox" name="alreadyselectedentry">
    <xsl:attribute name="checked"/>
    <xsl:attribute name="value">
      <xsl:value-of select="$entryID"/>
    </xsl:attribute>
  </input>
</xsl:template> 
</xsl:stylesheet>

