<?xml version="1.0"?>
<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>

<xsl:stylesheet version='1.0' xmlns:xsl='http://www.w3.org/1999/XSL/Transform'>

<xsl:output method="text" encoding="UTF-8" omit-xml-declaration="yes"/>

<!--
*******************************************************************************
* This template formats an exports an address book in a ldif format.
*******************************************************************************
-->
<xsl:template match="/">
  <xsl:for-each select="/xslui/simplesearch/searchresult/abperson">
    <xsl:text>cn:</xsl:text>
    <xsl:value-of select="entry/displayname"/>
    <xsl:text>&#xA;</xsl:text>
    <xsl:if test="person/givenname">
      <xsl:text>givenname:</xsl:text>
      <xsl:value-of select="person/givenname"/>
      <xsl:text>&#xA;</xsl:text>
    </xsl:if>
    <xsl:if test="person/surname">
      <xsl:text>sn:</xsl:text>
      <xsl:value-of select="person/surname"/>
      <xsl:text>&#xA;</xsl:text>
    </xsl:if>
    <xsl:if test="person/nickname">
      <xsl:text>xmozillanickname:</xsl:text>
      <xsl:value-of select="person/nickname"/>
      <xsl:text>&#xA;</xsl:text>
    </xsl:if>
    <xsl:if test="organization/company">
      <xsl:text>o:</xsl:text>
      <xsl:value-of select="organization/company"/>
      <xsl:text>&#xA;</xsl:text>
    </xsl:if>
    <xsl:if test="phone[@type='home']">
      <xsl:text>homephone:</xsl:text>
      <xsl:value-of select="phone[@type='home']"/>
      <xsl:text>&#xA;</xsl:text>
    </xsl:if>
    <xsl:if test="phone[@type='work']">
      <xsl:text>telephonenumber:</xsl:text>
      <xsl:value-of select="phone[@type='work']"/>
      <xsl:text>&#xA;</xsl:text>
    </xsl:if>
    <xsl:if test="phone[@type='mobile']">
      <xsl:text>cellphone:</xsl:text>
      <xsl:value-of select="phone[@type='mobile']"/>
      <xsl:text>&#xA;</xsl:text>
    </xsl:if>
    <xsl:if test="phone[@type='pager']">
      <xsl:text>pagerphone:</xsl:text>
      <xsl:value-of select="phone[@type='pager']"/>
      <xsl:text>&#xA;</xsl:text>
    </xsl:if>
    <xsl:if test="phone[@type='fax']">
    <xsl:text>facsimiletelephonenumber:</xsl:text>
      <xsl:value-of select="phone[@type='fax']"/>
      <xsl:text>&#xA;</xsl:text>
    </xsl:if>
    <xsl:if test="email[@priority='1']">
      <xsl:text>mail:</xsl:text>
      <xsl:value-of select="email[@priority='1']"/>
      <xsl:text>&#xA;</xsl:text>
    </xsl:if>
    <xsl:if test="postaladdress[@type='home']/street">
      <xsl:text>streetaddress:</xsl:text>
      <xsl:value-of select="postaladdress[@type='home']/street"/>
      <xsl:text>&#xA;</xsl:text>
    </xsl:if>
    <xsl:if test="postaladdress[@type='home']/city">
      <xsl:text>locality:</xsl:text>
      <xsl:value-of select="postaladdress[@type='home']/city"/>
      <xsl:text>&#xA;</xsl:text>
    </xsl:if>
    <xsl:if test="postaladdress[@type='home']/state">
      <xsl:text>st:</xsl:text>
      <xsl:value-of select="postaladdress[@type='home']/state"/>
      <xsl:text>&#xA;</xsl:text>
    </xsl:if>
    <xsl:if test="postaladdress[@type='home']/country">
      <xsl:text>countryname:</xsl:text>
      <xsl:value-of select="postaladdress[@type='home']/country"/>
      <xsl:text>&#xA;</xsl:text>
    </xsl:if>
    <xsl:if test="weburl[@priority='1']/urladdr">
      <xsl:text>homeurl:</xsl:text>
      <xsl:value-of select="weburl[@priority='1']/urladdr"/>
    </xsl:if>
    <xsl:text>&#xA;</xsl:text>
    <xsl:if test="organization/title">
      <xsl:text>title:</xsl:text>
      <xsl:value-of select="organization/title"/>
    </xsl:if>
    <xsl:text>&#xA;</xsl:text>
  </xsl:for-each>
</xsl:template>
</xsl:stylesheet>
