<?xml version="1.0"?>
<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>

<xsl:stylesheet version='1.0' xmlns:xsl='http://www.w3.org/1999/XSL/Transform'>
  
  <xsl:output method="html" version="4" encoding="UTF-8"/>

<!--
*******************************************************************************
* This template prints the error message in the info banner (search page)
* Only generic messages are printed by this template. Messages
*   specific to a particular page, are displayed by a template called
*   error-message which is specific to the page.
*   
*******************************************************************************
-->
<xsl:template match="error" mode="plain">
<xsl:param name="type" select="'error'"/>

<table border="0" cellpadding="0" cellspacing="0" title="">
  <tr> 
      <td valign="top" colspan="3"><img src="../absimx/spacer.gif" width="1" height="10"/></td>
  </tr>
  <tr>
    <td valign="top"><img src="../absimx/spacer.gif" width="10" height="1"/></td> 
    <xsl:choose>
    <xsl:when test="$type='error'">
     <td valign="top"><img src="../absimx/Error_Large.gif" width="21" height="22" alt="Error" vspace="3" />&#160;&#160;</td>
      <td><span class="AlrtErrTxt"><xsl:call-template name="error-message"/></span></td>
    </xsl:when>
    <xsl:when test="$type='warning'">
	    <td valign="top"><img src="../absimx/Warning_Large.gif" width="21" height="22" alt="Warning" vspace="3" />&#160;&#160;</td>
      <td><span class="AlrtWrnTxt"><xsl:call-template name="error-message"/></span></td>
    </xsl:when>
    <xsl:when test="$type='information'">
      <td valign="top"><img src="../absimx/Info_Large.gif" width="21" height="22" alt="Information" vspace="3" />&#160;&#160;</td>
      <td><span class="AlrtInfTxt"><xsl:call-template name="error-message"/></span></td>
    </xsl:when>
    </xsl:choose>
  </tr>
</table>
</xsl:template>
<xsl:template match="error" mode="banner">
  <table border="0" cellspacing="0" cellpadding="0">
    <tr>
      <td colspan="4">
        <img src="{$spacer.gif}" width="1" height="6"/>
      </td>
    </tr>
    <tr> 
      <td>
        <img src="{$spacer.gif}" width="17" height="1"/>
      </td>
      <td>
        <xsl:choose>
          <xsl:when test="@errtype = '0'">
            <img src="{$info_16.gif}" width="16" height="16">
              <xsl:attribute name="alrt">
                <xsl:text>_Information Message</xsl:text> 
              </xsl:attribute> 
            </img>
          </xsl:when>
          <xsl:when test="@errtype = '1'">
            <img src="{$warning_16.gif}" width="16" height="16">
              <xsl:attribute name="alrt">
                <xsl:text>_Warning Message</xsl:text> 
              </xsl:attribute> 
            </img>
          </xsl:when>
          <xsl:when test="@errtype = '2'">
            <img src="{$error_16.gif}" width="16" height="16">
              <xsl:attribute name="alrt">
                <xsl:text>_Error Message</xsl:text> 
              </xsl:attribute> 
            </img>
          </xsl:when>
          <xsl:otherwise>
            <img src="{$info_16.gif}" width="16" height="16"/>
          </xsl:otherwise>
        </xsl:choose> 
      </td>
      <td width="5">&nbsp;</td>
      <td width="800">
        <span class="normal">
          <xsl:choose>
            <xsl:when test="@errnum='7'">
              <xsl:text>_Enter at least</xsl:text>&nbsp;
              <xsl:value-of select="/xslui/iab/booklist/book[entry/@entryID = current()/@bookid]/@wildcardsearch" />&nbsp;
              <xsl:text>_character(s) in your search criteria when searching</xsl:text>&nbsp;
              <xsl:value-of select="/xslui/iab/booklist/book/entry[@entryID = current()/@bookid]/displayname" />&nbsp;
            </xsl:when>
            <xsl:when test="@errnum='65'">
              <xsl:text>_The number of kept entries is limited to</xsl:text>&nbsp;<xsl:value-of select="./@number" />.&nbsp;
              <xsl:text>_Only</xsl:text>&nbsp;<xsl:value-of select="./@number" />&nbsp;<xsl:text>_selected entries have been kept in your already selected section.</xsl:text>&nbsp;
            </xsl:when>
            <xsl:otherwise>
              <xsl:call-template name="error-message"/>
            </xsl:otherwise>
          </xsl:choose>
        </span>
      </td>
    </tr>
    <tr>
      <td colspan="4">
        <img src="{$spacer.gif}" width="1" height="6"/>
      </td>
    </tr>
  </table>
</xsl:template> 
</xsl:stylesheet>
