<?xml version="1.0"?>
<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>

<xsl:stylesheet version='1.0' xmlns:xsl='http://www.w3.org/1999/XSL/Transform'>

  <xsl:output method="html" version="4" encoding="UTF-8"/>

  <xsl:include href="commonimages.xsl"/>
  <xsl:include href="commonjavascript.xsl"/>
  <xsl:include href="commonattributes-hidden.xsl"/>
  <xsl:include href="context.xsl"/>
  <xsl:include href="css-select.xsl"/>
  <xsl:include href="common-uielements.xsl"/>

  <xsl:template match="/">
    <html>
      <head>
        <title>
          <xsl:text>_iPlanet Address Book - Delete Confirmation</xsl:text>
        </title>
        <link type="text/css" rel="stylesheet" href="{$commonCSS.css}"/> 

        <xsl:call-template name="styleSheetSelector">
          <xsl:with-param name="htmlprefs" select="/xslui/profileinfo/xmlprofile/htmlprefs"/>     
        </xsl:call-template>
        <xsl:call-template name="fontMaker">
          <xsl:with-param name="htmlprefs" select="/xslui/profileinfo/xmlprofile/htmlprefs"/>     
        </xsl:call-template>
        <script language="javascript" src="../absjs/common.js"/>
        <script language="javascript" src="../absjs/entries.js"/>
        <script language="Javascript">
          <xsl:call-template name="commonjavascript"/>
          function yes() {
            deleteEntry('<xsl:value-of select="/xslui/iab/bookentry//entry/@entryID"/>');
          }
          function no() {
            viewEntry('<xsl:value-of select="/xslui/iab/bookentry//entry/@entryID"/>', '<xsl:value-of select="name(/xslui/iab/bookentry/*)"/>');
          }
        </script>
      </head>
      <body leftmargin="0" topmargin="0" rightmargin="0" marginwidth="0" marginheight="0">
        <form method="post" name="iabform" action="search.xml">
          <input type="hidden" name="j_encoding" value="{/xslui/@charset}"/>
          <input type="hidden" name="uiaction" value=""/>
          <input type="hidden" name="stopalreadyselected" value=""/>
          <input type="hidden" name="entryid" value="{/xslui/iab/bookentry//entry/@entryID}"/>

          <xsl:call-template name="contextKeeper">
            <xsl:with-param name="pagedSearch" select="/xslui/iab/pagedsearch"/>
          </xsl:call-template>          

          <table width="100&#37;" border="0" cellspacing="0" cellpadding="0">
            <tr> 
              <td colspan="3">
                <img src="{$spacer.gif}" width="1" height="18"/>
              </td>
            </tr>
            <tr align="center">
              <td>
                <img src="{$spacer.gif}" width="17" height="1"/>
              </td>
              <td>  
                <table cellpadding="0" cellspacing="0" border="0">
                  <tr> 
                    <td colspan="3" bgcolor="#FFCC33">
                      <img src="{$spacer.gif}" width="5" height="5"/>
                    </td>
                  </tr>
                  <tr> 
                    <td colspan="3">
                      <img src="{$spacer.gif}" width="1" height="12"/>
                    </td>
                  </tr>
                  <tr> 
                    <td align="center" valign="top">
                      <img src="{$warning_32.gif}" width="32" height="32">
                        <xsl:attribute name="alt">
                          <xsl:text>_Warning Message</xsl:text>
                        </xsl:attribute> 
                      </img>
                    </td>
                    <td width="85&#37;">
                      <span class="large-text">
                        <b>
                          <xsl:text>_Warning</xsl:text>
                        </b>
                      </span>
                    </td>
                    <td width="5&#37;">&nbsp;</td>
                  </tr>
                  <tr> 
                    <td colspan="3">
                      <img src="{$spacer.gif}" width="1" height="6"/>
                    </td>
                  </tr>
                  <tr> 
                    <td>&nbsp;</td>
                    <td>
                      <span class="bold">
                        <xsl:value-of select="//bookentry/*/entry/displayname" />&nbsp;
                        <xsl:text>_will be deleted from all address books.</xsl:text>
                      </span>
                    </td>
                    <td>&nbsp;</td>
                  </tr>
                  <tr> 
                    <td colspan="3">
                      <img src="{$spacer.gif}" width="1" height="6"/>
                    </td>
                  </tr>
                  <tr> 
                    <td>&nbsp;</td>
                    <td>
                      <span class="normal">
                        <xsl:text>_Do you wish to continue?</xsl:text>
                      </span>
                    </td>
                    <td>&nbsp;</td>
                  </tr>
                  <tr> 
                    <td colspan="3">
                      <img src="{$spacer.gif}" width="1" height="12"/>
                    </td>
                  </tr>
                  <tr> 
                    <td>&nbsp;</td>
                    <td align="center"> 
                      <table border="0" cellspacing="0" cellpadding="0">
                        <tr>
                          <td>
                            <xsl:call-template name="button">
                              <xsl:with-param name="label">
                                <xsl:text>_Yes</xsl:text>
                              </xsl:with-param>
                              <xsl:with-param name="bgColorIndex" select="'w'"/>
                              <xsl:with-param name="href" select="'javascript:yes()'"/>
                            </xsl:call-template>
                          </td>
                          <td rowspan="2"><img src="{$spacer.gif}" border="0" width="5" height="1" alt=" "/></td>
                          <td>
                            <xsl:call-template name="button">
                              <xsl:with-param name="label">
                                <xsl:text>_No</xsl:text>
                              </xsl:with-param>
                              <xsl:with-param name="bgColorIndex" select="'w'"/>
                              <xsl:with-param name="href" select="'javascript:no()'">
                              </xsl:with-param> 
                              
                            </xsl:call-template>
                          </td>
                          <td rowspan="2"><img src="{$spacer.gif}" border="0" width="5" height="1" alt=" "/></td>
                          <td>
                            <xsl:call-template name="button">
                              <xsl:with-param name="label">
                                <xsl:text>_Help</xsl:text>
                              </xsl:with-param>
                              <xsl:with-param name="bgColorIndex" select="'w'"/>
                            </xsl:call-template>
                          </td>
                        </tr>
                      </table>          
                    </td>
                    <td>&nbsp;</td>
                  </tr>
                  <tr> 
                    <td colspan="3">
                      <img src="{$spacer.gif}" width="1" height="12"/>
                    </td>
                  </tr>
                  <tr> 
                    <td colspan="3" bgcolor="#FFCC33">
                      <img src="{$spacer.gif}" width="5" height="5"/>
                    </td>
                  </tr>
                </table>
              </td>
            <td>
              <img src="{$spacer.gif}" width="17" height="1"/>
            </td>
            </tr>
            <tr> 
              <td colspan="3">
                <img src="{$spacer.gif}" width="1" height="14"/>
              </td>
            </tr>
          </table>
          <xsl:for-each select="/xslui/iab/alreadyselected/*">
            <input type="hidden" name="selectedentry" value="{entry/@entryID}"/>
          </xsl:for-each>
            
          <xsl:apply-templates select="/xslui/iab/alreadyselected" mode="hidden"/>
        </form>
      </body>
    </html>
  </xsl:template> 
  

</xsl:stylesheet>