<?xml version="1.0"?>
<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>

<xsl:stylesheet version='1.0' xmlns:xsl='http://www.w3.org/1999/XSL/Transform'>
<xsl:output method="html" version="4" encoding="UTF-8"/>




<!--
*******************************************************************************
* This template match a calendar node then formats and prints the node as 
*  either an icon or a simple link.
* @param display 'url' or 'icon' to display one or the other.
*******************************************************************************
-->
<xsl:template match="calendar" mode="common">
  <xsl:param name="display" select="'url'" />

  <xsl:if test="string-length(urladdr) > 0">
    <xsl:variable name="urladdress">
    <xsl:choose>
    	<xsl:when test="starts-with(urladdr,'http:')">
       		<xsl:value-of select="urladdr" />
        </xsl:when>
        <xsl:otherwise>
        	<xsl:choose>
                	<xsl:when test="starts-with(urladdr,'https:')">
                        	<xsl:value-of select="urladdr" />
                        </xsl:when>
                        <xsl:otherwise>
                                <xsl:text>http:&#47;&#47;</xsl:text>
                                <xsl:value-of select="urladdr" />
                        </xsl:otherwise>
                </xsl:choose>
        </xsl:otherwise>
        </xsl:choose>
    </xsl:variable>
    <a onkeypress="linkHandler()" href="{$urladdress}" target="_blank">
    <xsl:attribute name="title">
      <xsl:text>_View Availability...</xsl:text>
    </xsl:attribute>
    <xsl:choose>
        <xsl:when test="$display = 'icon'">
          <img width="16" height="16" border="0" src="{$calendar_16.gif}">
            <xsl:attribute name="alt">
              <xsl:choose>
                <xsl:when test="@type = 'freebusy'">
                   <xsl:text>_View Availability...</xsl:text>
                </xsl:when>
                <xsl:otherwise>
                  <xsl:text>_View Calendar...</xsl:text>
                </xsl:otherwise>
              </xsl:choose>
            </xsl:attribute>
          </img>
        </xsl:when>
        <xsl:otherwise>         
          <xsl:value-of select="urladdr" />
        </xsl:otherwise>
      </xsl:choose>
    </a>
  </xsl:if>
</xsl:template>


<!--
*****************************************************************************
This template formats and prints the email node
*****************************************************************************
-->
<xsl:template match="email" mode="common">
  <xsl:if test="string-length(.) > 0">
    <xsl:variable name="mailpref">
      <xsl:choose>
        <xsl:when test="/xslui/profileinfo/xmlprofile/generalprefs/@webmail='uc' and /xslui/usersession/@mailenabled='true'">
          <xsl:value-of select="'uc'"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="'desktop'"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <a onkeypress="linkHandler()" class="Lnk">
      <xsl:attribute name="href">
        <xsl:text>javascript:sendMail("</xsl:text>
        <xsl:value-of select="/xslui/usersession/@mailurl"/>
        <xsl:text>","</xsl:text>
        <xsl:value-of select="$mailpref"/>
        <xsl:text>","</xsl:text>
        <xsl:value-of select="."/>
        <xsl:text>")</xsl:text>
      </xsl:attribute>
      <xsl:value-of select="."/>
    </a>
  </xsl:if>
</xsl:template>

<!--
*****************************************************************************
This template formats and prints the phone node
*****************************************************************************
-->
<xsl:template match="phone" mode="common">
  <xsl:if test="string-length(.) > 0">
    <xsl:value-of select="."/>
  </xsl:if>
</xsl:template>


<!--
*****************************************************************************
This template formats and prints a date node
*****************************************************************************
-->
<xsl:template match="date" mode="common">
  <xsl:if test="string-length(.) > 0">
    <xsl:variable name="sep" select="/xslui/profileinfo/xmlprofile/generalprefs/@dateseparator"/>
    <xsl:variable name="format" select="/xslui/profileinfo/xmlprofile/generalprefs/@dateorder"/>
    <xsl:variable name="year">
      <xsl:value-of select="substring(., 1, 4)"/>
    </xsl:variable>
    <xsl:variable name="month">
      <xsl:value-of select="substring(., 6, 2)"/>
    </xsl:variable>
    <xsl:variable name="day">
      <xsl:value-of select="substring(., 9, 2)"/>
    </xsl:variable>
    <xsl:choose>
      <xsl:when test="$format = 'D/M/Y'">
        <xsl:value-of select="$day"/>
        <xsl:value-of select="$sep"/>
        <xsl:value-of select="$month"/>
        <xsl:value-of select="$sep"/>
        <xsl:value-of select="$year"/>
      </xsl:when>
      <xsl:when test="$format = 'M/D/Y'">
        <xsl:value-of select="$month"/>
        <xsl:value-of select="$sep"/>
        <xsl:value-of select="$day"/>
        <xsl:value-of select="$sep"/>
        <xsl:value-of select="$year"/>
      </xsl:when>
      <xsl:when test="$format = 'Y/M/D'">
        <xsl:value-of select="$year"/>
        <xsl:value-of select="$sep"/>
        <xsl:value-of select="$month"/>
        <xsl:value-of select="$sep"/>
        <xsl:value-of select="$day"/>
      </xsl:when>

      <xsl:otherwise>
      </xsl:otherwise>
    </xsl:choose> 
  </xsl:if>
</xsl:template>


<!--
*****************************************************************************
This template formats and prints the IM node in icon mode
*****************************************************************************
-->
<xsl:template match="im" mode="common">
  <xsl:if test="string-length(.) > 0 and (./@service='Yahoo' or ./@service='AIM')">
    <a onkeypress="linkHandler()">
      <xsl:attribute name="href">
        <xsl:text>javascript:sendIM('</xsl:text>
        <xsl:value-of select="./@service"/>
        <xsl:text>','</xsl:text>
        <xsl:value-of select="."/>
        <xsl:text>')</xsl:text>
      </xsl:attribute>

      <xsl:choose>
        <xsl:when test="./@service = 'Yahoo'">
          <img border="0" width="12" height="12">
            <xsl:attribute name="src">
              <xsl:text>http://opi.yahoo.com/online?u=</xsl:text>
              <xsl:value-of select="." />
              <xsl:text>&amp;m=g&amp;t=0</xsl:text> 
            </xsl:attribute>
            <xsl:attribute name="alt">
              <xsl:text>_Send a Yahoo instant message</xsl:text>
            </xsl:attribute>
          </img>
        </xsl:when>

        <xsl:when test="./@service = 'AIM'">
          <img border="0" width="16" height="16">
            <xsl:attribute name="src">
              <xsl:text>http://big.oscar.aol.com/</xsl:text>
              <xsl:value-of select="." />
              <xsl:text>?on_url=http://ncmail.netscape.com/html/webmail/include/nc/images/online.gif&amp;off_url=http://ncmail.netscape.com/html/webmail/include/nc/images/offline.gif</xsl:text> 
            </xsl:attribute>
            <xsl:attribute name="alt">
              <xsl:text>_Send an AOL instant message</xsl:text>
            </xsl:attribute>
          </img>
<!-- Using the image from Netscape
          <script language="javascript">
            urlPrefix = location.href.substring(0,location.href.lastIndexOf("/")+1);
            document.write(
            "<xsl:text disable-output-escaping="yes">&#60;img border='0' width='13' height='17'</xsl:text>"+
            "name='<xsl:value-of select="concat(./@service, '-', .)" />'"+
            "src='http://big.oscar.aol.com/<xsl:value-of select="."/>?on_url="+urlPrefix+
            "<xsl:value-of select="$aim-online.gif"/>&#38;off_url=" + urlPrefix +"<xsl:value-of select="$aim-offline.gif"/>'"+
            "alt='<xsl:text>_Send an AOL instant message</xsl:text>'"+
            "<xsl:text disable-output-escaping="yes">&#62;</xsl:text>");
          </script>            
-->
        </xsl:when>
        
<!-- don't show anything since we do not have the way to get the presence
        <xsl:when test="./@service = 'ICQ'">
          <img border="0" width="16" height="16">
            <xsl:attribute name="src">
              <xsl:text>http://online.mirabilis.com/scripts/online.dll?icq=</xsl:text>
              <xsl:value-of select="." />
              <xsl:text>&amp;img=5</xsl:text>
            </xsl:attribute>
            <xsl:attribute name="alt">
              <xsl:text>_Send an ICQ instant message</xsl:text>
            </xsl:attribute>
          </img>
        </xsl:when> 
        <xsl:when test="./@service = 'SunONE'">
          <img border="0" width="13" height="13">
            <xsl:attribute name="src">
              <xsl:text>http://absinthe.red.iplanet.com/iim/FetchPresence?entity=</xsl:text>
              <xsl:value-of select="." />
            </xsl:attribute>
            <xsl:attribute name="alt">
              <xsl:text>_Send an iPlanet instant message</xsl:text>
            </xsl:attribute>
          </img>       
        </xsl:when> 
-->
        <xsl:otherwise>
        </xsl:otherwise>
      </xsl:choose> 
    </a>
    <xsl:text>&nbsp;</xsl:text>
  </xsl:if>
</xsl:template>

<!--
*******************************************************************************
* This template match a weburl node - prints it with an open window
*******************************************************************************
-->
<xsl:template match="weburl" mode="common">
  <xsl:choose>
      <xsl:when test="starts-with(urladdr,'http:')">
         <a href="{urladdr}" target="_blank" title="{description}">
           <xsl:value-of select="urladdr" />
             </a>&nbsp;
     </xsl:when>
     <xsl:otherwise>
     <xsl:choose>
     	<xsl:when test="starts-with(urladdr,'https:')">
         <a href="{urladdr}" target="_blank" title="{description}">
           <xsl:value-of select="urladdr" />
             </a>&nbsp;
     	</xsl:when>
     	<xsl:otherwise>
        	<a href="http:&#47;&#47;{urladdr}" target="_blank" title="{description}">
          	<xsl:value-of select="urladdr" />
          	</a>&nbsp;
     	</xsl:otherwise>
     </xsl:choose>
     </xsl:otherwise>
  </xsl:choose>
</xsl:template>


<!--
*******************************************************************************
* This template replace the newline character by the element br
* @param text The text to transform, by default it acts on the current node
*******************************************************************************
-->
<xsl:template name="break-new-lines">
  <xsl:param name="text" select="."/>
  <xsl:if test="$text">
    <xsl:choose>
      <xsl:when test="contains($text, '&#xa;')">
        <xsl:value-of select="substring-before($text, '&#xa;')"/>
        <xsl:text disable-output-escaping="yes">&#60;br&#62;</xsl:text> 

        <xsl:call-template name="break-new-lines">
          <xsl:with-param name="text" select="substring-after($text,'&#xa;')"/>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$text"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:if> 
</xsl:template>

</xsl:stylesheet>

