<?xml version="1.0"?>
<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>

<xsl:stylesheet version='1.0' xmlns:xsl='http://www.w3.org/1999/XSL/Transform'>
<xsl:variable name="lineSpacing" select="'4'"/>

<!--
*****************************************************************************
* This template prints the Name and Company part of contact detail
* @param abperson The current abperson for which we have to display the name and company part
*****************************************************************************
-->
<xsl:template name="nameAndCompany">
  <xsl:param name="abperson"/>
  <tr class="fourth-strip">
    <td>
      <img height="20" src="{$spacer.gif}" width="17"/>
    </td>
    <td colspan="8">
      <span class="areatitle">
        <xsl:text>_Name and Company</xsl:text>
      </span>
    </td>
    <td>
      <img height="20" src="{$spacer.gif}" width="17"/>
    </td>
  </tr>

  <tr>
    <td colspan="10">
      <img height="12" src="{$spacer.gif}" width="1"/>
    </td>
  </tr>

  <tr>
    <td width="17">
      <img height="1" src="{$spacer.gif}" width="17"/>
    </td>
    <td rowspan="3" valign="top" align="right">
      <img src="{$contact_username.gif}" width="36" height="33">
        <xsl:attribute name="alt">
          <xsl:text>_Contact Name and Company</xsl:text>
        </xsl:attribute>
      </img>
    </td>
    <td align="right">
      <span class="label">
        <xsl:text>_First Name</xsl:text>
      </span>
    </td>
    <td width="10">
      <img height="1" src="{$spacer.gif}" width="10"/>
    </td>
    <td>
      <span class="normal">
        <xsl:value-of select="$abperson/person/givenname" />
        <xsl:text>&nbsp;</xsl:text>
      </span>
    </td>
    <td width="10">
      <img height="1" src="{$spacer.gif}" width="10"/>
    </td>

    <td align="right">
      <span class="label">
        <xsl:text>_Middle</xsl:text>
      </span>
    </td>

    <td width="10">
      <img height="1" src="{$spacer.gif}" width="10"/>
    </td>

    <td>
      <span class="normal">
        <xsl:value-of select="$abperson/person/middlename" /> 
        <xsl:text>&nbsp;</xsl:text>
      </span>
    </td>

    <td width="17">
      <img height="1" src="{$spacer.gif}" width="17"/>
    </td>
  </tr>

  <tr>
    <td width="17">
      <img height="1" src="{$spacer.gif}" width="17"/>
    </td>
    <td colspan="8">
      <img src="{$spacer.gif}" width="1" height="{$lineSpacing}"/>
    </td>
  </tr>

  <tr>
    <td>&nbsp;</td>
    <td align="right">
      <span class="label">
        <xsl:text>_Last Name</xsl:text>
      </span>
    </td>

    <td>&nbsp;</td>

    <td>
      <span class="normal">
        <xsl:value-of select="$abperson/person/surname" />
        <xsl:text>&nbsp;</xsl:text>
      </span>
    </td>

    <td>&nbsp;</td>

    <td>&nbsp;</td>

    <td>&nbsp;</td>

    <td><img height="1" src="{$spacer.gif}" width="150"/></td>

    <td>&nbsp;</td>
  </tr>

  <tr>
    <td colspan="10">
      <img height="{$lineSpacing}" src="{$spacer.gif}" width="1"/>
    </td>
  </tr>

  <tr>
    <td>&nbsp;</td>
    <td>&nbsp;</td>
    <td align="right">
      <span class="label">
        <xsl:text>_Job Title</xsl:text>
      </span>
    </td>

    <td>&nbsp;</td>

    <td>
      <span class="normal">
        <xsl:value-of select="$abperson/organization/title" />
        <xsl:text>&nbsp;</xsl:text>
      </span>
    </td>

    <td>&nbsp;</td>

    <td align="right">
      <span class="label">
        <xsl:text>_Company</xsl:text>
      </span>
    </td>

    <td>&nbsp;</td>

    <td>
      <span class="normal">
        <xsl:value-of select="$abperson/organization/company" />
        <xsl:text>&nbsp;</xsl:text>
      </span>
    </td>

    <td>&nbsp;</td>
  </tr>

  <tr>
    <td colspan="10">
      <img height="{$lineSpacing}" src="{$spacer.gif}" width="1"/>
    </td>
  </tr>
  <tr>
    <td>&nbsp;</td>
    <td>&nbsp;</td>
    <td align="right">
      <span class="label">
        <xsl:text>_Display Name</xsl:text>
      </span>
    </td>

    <td>&nbsp;</td>

    <td colspan="5" >
      <span class="normal">
        <xsl:value-of select="$abperson/entry/displayname" />
        <xsl:text>&nbsp;</xsl:text>
      </span>
    </td>

    <td>&nbsp;</td>
  </tr>

  <tr>
    <td colspan="10">
      <img height="12" src="{$spacer.gif}" width="1"/>
    </td>
  </tr>	

  <xsl:if test="$abperson/organization">
    <xsl:call-template name="orgTemplate">
      <xsl:with-param name="abperson" select="$abperson"/>
    </xsl:call-template>
  </xsl:if>
</xsl:template> 


<!--
*****************************************************************************
* This template prints the Phone Email and IM part of contact detail
* @param abperson The node abperson to process
*****************************************************************************
-->
<xsl:template name="phoneEmailAndIM">
  <xsl:param name="abperson" />
  <tr class="fourth-strip">
    <td>
      <img height="20" src="{$spacer.gif}" width="17"/>
    </td>

    <td colspan="9">
      <xsl:attribute name="nowrap" />
      <span class="areatitle">
        <xsl:text>_Phone, Email, and Instant Messaging (IM)</xsl:text>
      </span>
    </td>
  </tr>

  <tr>
    <td colspan="10">
      <img height="12" src="{$spacer.gif}" width="1"/>
    </td>
  </tr>

  <tr>
    <td width="17">
      <img height="1" src="{$spacer.gif}" width="17"/>
    </td>
    <td rowspan="3" valign="top" align="right">
      <img src="{$contact_phone.gif}" width="36" height="33">
        <xsl:attribute name="alt">
          <xsl:text>_Phone</xsl:text>
        </xsl:attribute>
      </img>
    </td>
    <xsl:apply-templates select="$abperson/phone[1]" mode="detail"/>
    <xsl:apply-templates select="$abperson/phone[2]" mode="detail"/>
    <xsl:if test="not($abperson/phone[1])">
      <td colspan="3">&nbsp;</td>
      <td>&nbsp;</td>
    </xsl:if> 
    <xsl:if test="not($abperson/phone[2])">
      <td colspan="3">&nbsp;</td>
      <td>&nbsp;</td>
    </xsl:if> 
  </tr>
  <tr>
    <td width="17">
      <img height="1" src="{$spacer.gif}" width="17"/>
    </td>
    <td colspan="8">
      <img height="{$lineSpacing}" src="{$spacer.gif}" width="1"/>
    </td>
  </tr>

  <tr>
    <td>&nbsp;</td>
    <xsl:apply-templates select="$abperson/phone[3]" mode="detail"/>
    <xsl:apply-templates select="$abperson/phone[4]" mode="detail"/>
    <xsl:if test="not($abperson/phone[3])">
      <td colspan="3">&nbsp;</td>
      <td>&nbsp;</td>
    </xsl:if> 
    <xsl:if test="not($abperson/phone[4])">
      <td colspan="3">&nbsp;</td>
      <td>&nbsp;</td>
    </xsl:if> 
  </tr>
  <xsl:if test="$abperson/phone[5]">
    <tr>
      <td colspan="10">
        <img height="{$lineSpacing}" src="{$spacer.gif}" width="1"/>
      </td>
    </tr>
    <tr>
      <td colspan="2">&nbsp;</td>
      <xsl:apply-templates select="$abperson/phone[5]" mode="detail"/>
      <td>&nbsp;</td>
      <td>&nbsp;</td>
      <td>&nbsp;</td>
      <td>&nbsp;</td>
    </tr>
  </xsl:if>


  <!-- 
      Email part 
  -->

  <xsl:if test="$abperson and $abperson/email">
    <tr>
      <td colspan="10">
        <img height="9" src="{$spacer.gif}" width="1"/>
      </td>
    </tr>
    <tr> 
      <td colspan="10" bgcolor="#999999">
        <img height="1" src="{$spacer.gif}" width="1"/>
      </td>
    </tr>
    <tr>
      <td colspan="10">
        <img height="9" src="{$spacer.gif}" width="1"/>
      </td>
    </tr>

    <tr>
      <td width="17">
        <img height="1" src="{$spacer.gif}" width="17"/>
      </td>
      <td rowspan="3" valign="top" align="right">
        <img src="{$contact_email.gif}" width="36" height="33">
          <xsl:attribute name="alt">
            <xsl:text>_Email</xsl:text>
          </xsl:attribute>
        </img>
      </td>
      <xsl:apply-templates select="$abperson/email[1]" mode="detail"/>
      <xsl:apply-templates select="$abperson/email[2]" mode="detail"/>
      <xsl:if test="not($abperson/email[2])">
        <td colspan="3">&nbsp;</td>
        <td>&nbsp;</td>
      </xsl:if> 
    </tr>
    
    <tr>
      <td width="17">
        <img height="1" src="{$spacer.gif}" width="17"/>
      </td>
      <td colspan="8">
        <img height="{$lineSpacing}" src="{$spacer.gif}" width="1"/>
      </td>
    </tr>

    <tr>
      <td width="17">&nbsp;</td>
      <xsl:apply-templates select="$abperson/email[3]" mode="detail"/>
      <xsl:if test="not($abperson/email[3])">
        <td colspan="3">&nbsp;</td>
        <td>&nbsp;</td>
      </xsl:if> 
      <td colspan="3">&nbsp;</td>
      <td>&nbsp;</td>
    </tr>

  </xsl:if> 

  <xsl:if test="$abperson and $abperson/im">
    <tr>
      <td colspan="10">
        <img height="9" src="{$spacer.gif}" width="1"/>
      </td>
    </tr>
    <tr> 
      <td colspan="10" bgcolor="#999999">
        <img height="1" src="{$spacer.gif}" width="1"/>
      </td>
    </tr>

    <tr>
      <td colspan="10">
        <img height="9" src="{$spacer.gif}" width="1"/>
      </td>
    </tr>

    <tr>
      <td width="17">
        <img height="1" src="{$spacer.gif}" width="17"/>
      </td>
      <td rowspan="3" valign="top" align="right">
        <img src="{$contact_im.gif}" width="36" height="33">
          <xsl:attribute name="alt">
            <xsl:text>_IM</xsl:text>
          </xsl:attribute>
        </img>
      </td>
      <td>&nbsp;</td>
      <td>&nbsp;</td>
      <td colspan="5">
        <span class="bold">
          <xsl:text>_Instant Messaging (IM) Nickname and Service</xsl:text>
        </span>
      </td>
      <td>&nbsp;</td>
    </tr>
    <tr>
      <td width="17">
        <img height="1" src="{$spacer.gif}" width="17"/>
      </td>
      <td colspan="8">
        <img height="{$lineSpacing}" src="{$spacer.gif}" width="1"/>
      </td>
    </tr>
    <tr> 
      <td>&nbsp;</td>
      <xsl:apply-templates select="$abperson/im[1]" mode="detail"/>
      <xsl:apply-templates select="$abperson/im[2]" mode="detail"/>
      <xsl:if test="not($abperson/im[2])">
        <td colspan="3">&nbsp;</td>
        <td>&nbsp;</td>
      </xsl:if> 
    </tr>
    <xsl:if test="$abperson/im[3]">
      <tr>
        <td width="17">&nbsp;</td>
        <td>&nbsp;</td>
        <xsl:apply-templates select="$abperson/im[3]" mode="detail"/>
        <td colspan="3">&nbsp;</td>
        <td>&nbsp;</td>
      </tr>
    </xsl:if> 
  </xsl:if>
  <tr>
    <td colspan="10">
      <img height="12" src="{$spacer.gif}" width="1"/>
    </td>
  </tr>	

</xsl:template> 


<!--
*****************************************************************************
* This template prints the Address part of contact detail
*****************************************************************************
-->
<xsl:template name="address">
  <xsl:param name="address" />
  <xsl:variable name="title"> 
    <xsl:choose>
      <xsl:when test="$address/@type = 'work'">
         <xsl:text>_Work Address</xsl:text>
      </xsl:when>
      <xsl:when test="$address/@type = 'home'">
        <xsl:text>_Home Address</xsl:text>
      </xsl:when>
      <xsl:otherwise>
      </xsl:otherwise>
    </xsl:choose> 
  </xsl:variable>
  <tr class="fourth-strip">
    <td>
      <img height="20" src="{$spacer.gif}" width="17"/>
    </td>
    <td colspan="8">
      <xsl:attribute name="nowrap"/>
      <span class="areatitle">
        <xsl:value-of select="$title"/>
      </span>
    </td>
    <td>&nbsp;</td>
  </tr>

  <tr>
    <td colspan="10">
      <img height="12" src="{$spacer.gif}" width="1"/>
    </td>
  </tr>

  <tr>
    <td width="17">
      <img height="1" src="{$spacer.gif}" width="17"/>
    </td>
    <td rowspan="3" valign="top" align="right">
      <img width="36" height="33">
        <xsl:attribute name="src">
          <xsl:choose>
            <xsl:when test="$address/@type = 'work'">
               <xsl:value-of select="$contact_work_addr.gif"/>
            </xsl:when>
            <xsl:when test="$address/@type = 'home'">
               <xsl:value-of select="$contact_home_addr.gif"/>
            </xsl:when>
            <xsl:otherwise>
            </xsl:otherwise>
          </xsl:choose> 
        </xsl:attribute>
        <xsl:attribute name="alt">
          <xsl:value-of select="$title"/>
        </xsl:attribute>
      </img>
    </td>

    <td align="right" valign="top">
      <table cellspacing="0" cellpadding="0" border="0">
        <tbody>
          <tr>
            <td align="right">
              <xsl:call-template name="button">
                <xsl:with-param name="label">
                  <xsl:text>_Show Map</xsl:text>
                </xsl:with-param>
                <xsl:with-param name="href">
                  <xsl:text>javascript:popupLocationMap('</xsl:text>
                  <xsl:value-of select="$address/country"/>
                  <xsl:text>','</xsl:text>
                  <xsl:value-of select="$address/city"/>
                  <xsl:text>','</xsl:text>
                  <xsl:value-of select="$address/postalcode"/>
                  <xsl:text>','</xsl:text>
                  <xsl:value-of select="$address/street"/>
                  <xsl:text>','</xsl:text>
                  <xsl:value-of select="$address/state"/>
                  <xsl:text>')</xsl:text>
                </xsl:with-param> 
              </xsl:call-template>
            </td>
            <td>
              <img height="1" src="{$spacer.gif}" width="10"/>
            </td>
            <td align="right">
              <span class="label">
                <xsl:text>_Address</xsl:text>
              </span>
            </td>
          </tr>
        </tbody>
      </table>
    </td>

    <td>&nbsp;</td>

    <td colspan="5">
      <table cellspacing="0" cellpadding="0" border="0">
        <xsl:attribute name="width">
          <xsl:text>100%</xsl:text>
        </xsl:attribute> 
        <tbody>
          <tr>
            <td>
              <span class="normal">
                <xsl:call-template name="break-new-lines">
                  <xsl:with-param name="text" select="$address/street"/>
                </xsl:call-template>&nbsp;
                <xsl:text>&nbsp;</xsl:text>
              </span>
            </td>
          </tr>
        </tbody>
      </table>
    </td>

    <td>&nbsp;</td>
  </tr>

  <tr>
    <td width="17">
      <img height="1" src="{$spacer.gif}" width="17"/>
    </td>
    <td colspan="8">
      <img height="{$lineSpacing}" src="{$spacer.gif}" width="1"/>
    </td>
  </tr>

  <tr>
    <td>&nbsp;</td>

    <td align="right">
      <span class="label">
        <xsl:text>_City</xsl:text>
      </span>
    </td>

    <td>&nbsp;</td>

    <td>
      <span class="normal">
        <xsl:value-of select="$address/city"/>
        <xsl:text>&nbsp;</xsl:text>
      </span>
    </td>

    <td>&nbsp;</td>

    <td align="right">
      <span class="label">
        <xsl:text>_State / Province</xsl:text>
      </span>
    </td>

    <td>&nbsp;</td>

    <td>
      <span class="normal">
        <xsl:value-of select="$address/state"/>
        <xsl:text>&nbsp;</xsl:text>
      </span>
    </td>

    <td>&nbsp;</td>
  </tr>

  <tr>
    <td colspan="10">
      <img height="{$lineSpacing}" src="{$spacer.gif}" width="1"/>
    </td>
  </tr>

  <tr>
    <td>&nbsp;</td>
    <td>&nbsp;</td>
    <td align="right">
      <span class="label">
        <xsl:text>_Postal / Zip Code</xsl:text>
      </span>
    </td>

    <td>&nbsp;</td>

    <td>
      <span class="normal">
        <xsl:value-of select="$address/postalcode"/>
        <xsl:text>&nbsp;</xsl:text>
      </span>
    </td>

    <td>&nbsp;</td>

    <td align="right">
      <span class="label">
        <xsl:text>_Country / Region</xsl:text>
      </span>
    </td>

    <td>&nbsp;</td>

    <td>
      <span class="normal">
        <xsl:value-of select="$address/country"/>
        <xsl:text>&nbsp;</xsl:text>
      </span>
    </td>

    <td>&nbsp;</td>
  </tr>
  <tr>
    <td colspan="10">
      <img height="12" src="{$spacer.gif}" width="1"/>
    </td>
  </tr>
</xsl:template> 


<!--
*****************************************************************************
* This template prints the Online Informations part of contact detail
* @param abperson The node from which to extract the online informations
*****************************************************************************
-->
<xsl:template name="onlineInfos">
  <xsl:param name="abperson" />

  <xsl:if test="$abperson and ($abperson/weburl or $abperson/calendar)">
    <tr class="fourth-strip">
      <td>
        <img height="20" src="{$spacer.gif}" width="17"/>
      </td>
      <td colspan="8">
        <span class="areatitle">
          <xsl:text>_On-line Information</xsl:text>
        </span>
      </td>
      <td>&nbsp;</td>
    </tr>

    <tr>
      <td colspan="10">
        <img height="12" src="{$spacer.gif}" width="1"/>
      </td>
    </tr>

      <tr>
        <td width="17">
          <img height="1" src="{$spacer.gif}" width="17"/>
        </td>
        <td rowspan="3" valign="top" align="right">
          <img src="{$contact_www.gif}" width="36" height="33">
            <xsl:attribute name="alt">
              <xsl:text>_On-line Information</xsl:text>
            </xsl:attribute>
          </img>
        </td>
        <xsl:apply-templates select="$abperson/weburl[1]" mode="detail"/>
        <xsl:if test="not($abperson/weburl[1])">
          <td colspan="7">&nbsp;</td>
          <td>&nbsp;</td>
        </xsl:if> 
      </tr>

      <tr>
        <td width="17">
          <img height="{$lineSpacing}" src="{$spacer.gif}" width="17"/>
        </td>
        <td colspan="8">
          <img height="{$lineSpacing}" src="{$spacer.gif}" width="1"/>
        </td>
      </tr>

      <tr>
        <td>&nbsp;</td>
        <xsl:apply-templates select="$abperson/weburl[2]" mode="detail"/>
        <xsl:if test="not($abperson/weburl[2])">
          <td colspan="7">&nbsp;</td>
          <td>&nbsp;</td>
        </xsl:if> 
      </tr>
      <tr>
        <td colspan="10">
          <img height="{$lineSpacing}" src="{$spacer.gif}" width="1"/>
        </td>
      </tr>

    <xsl:for-each select="$abperson/calendar">
      <xsl:if test="position() mod 2 = 0">
        <tr>
          <td colspan="10">
            <img height="{$lineSpacing}" src="{$spacer.gif}" width="1"/>
          </td>
        </tr>
      </xsl:if> 
      <tr>    
        <xsl:apply-templates select="." mode="detail"/>
      </tr>
    </xsl:for-each>
    <tr>
      <td colspan="10">
        <img height="12" src="{$spacer.gif}" width="1"/>
      </td>
    </tr>
  </xsl:if> 
</xsl:template> 

<!--
*****************************************************************************
* This template prints the Important dates part of contact detail
* @person The node person to extract date info from
*****************************************************************************
-->
<xsl:template name="importantDates">
  <xsl:param name="person"/>
  
  <xsl:if test="$person and $person/date">
    <tr class="fourth-strip">
      <td>
        <img height="20" src="{$spacer.gif}" width="17"/>
      </td>
      <td colspan="8">
        <span class="areatitle">
          <xsl:text>_Important Dates</xsl:text>
        </span>
      </td>
      <td>&nbsp;</td>
    </tr>
    <tr>
      <td colspan="10">
        <img height="12" src="{$spacer.gif}" width="1"/>
      </td>
    </tr>
    <tr>
      <td>&nbsp;</td>
      <xsl:apply-templates select="$person/date[1]" mode="detail"/>
      <xsl:apply-templates select="$person/date[2]" mode="detail"/>
      <xsl:if test="not($person/date[2])">
        <td colspan="4">&nbsp;</td>
      </xsl:if> 
      <td>&nbsp;</td>
    </tr>
    <xsl:if test="$person/date[3]">
      <td >&nbsp;</td>
      <xsl:apply-templates select="$person/date[3]" mode="detail"/>
      <td colspan="4">&nbsp;</td>
      <td>&nbsp;</td>
    </xsl:if> 
    <tr>
      <td colspan="10">
        <img height="12" src="{$spacer.gif}" width="1"/>
      </td>
    </tr>
  </xsl:if> 
</xsl:template> 


<!--
*******************************************************************************
* This template prints the Memberships part of contact detail
* @param abperson The node from which to extract memberships information
*******************************************************************************
-->
<xsl:template name="memberships">
  <xsl:param name="abperson"/>
  <script language="javascript">
    function gotoAB(abID)
    {
      document.iabform.bookid.value = abID;
      document.iabform.stopsearch.value = 1;
      goToUsingForm("search.xml")
    }
  </script>
  <tr class="fourth-strip">
    <td>
      <img height="20" src="{$spacer.gif}" width="17"/>
    </td>
    <td colspan="8">
      <span class="areatitle">
        <xsl:text>_Address Book Memberships</xsl:text>
      </span>
    </td>
    <td>&nbsp;</td>
  </tr>

  <tr>
    <td colspan="10">
      <img height="12" src="{$spacer.gif}" width="1"/>
    </td>
  </tr>

  <tr>
    <td>&nbsp;</td>
    <td>&nbsp;</td>
    <td valign="top" align="right">
      <span class="label">
        <xsl:text>_Address Books</xsl:text>
      </span>
    </td>

    <td>&nbsp;</td>

    <td colspan="5" valign="top">
      <table cellspacing="0" cellpadding="0" border="0" width="100&#37;">
        <tbody>
          <xsl:for-each select="$abperson/memberofbook">
            <xsl:apply-templates select="."/>
          </xsl:for-each>
          <xsl:if test="not($abperson/memberofbook)">
          <!-- Case of corporate directory -->
          <tr>
            <td>
              <a href="javascript:gotoAB('{/xslui/iab/pagedsearch/searchresult/@bookid}')" target="_top" >
                <xsl:value-of select="/xslui/iab/booklist/book[entry/@entryID = /xslui/iab/pagedsearch/searchresult/@bookid]/entry/displayname"/>
              </a>
            </td>
          </tr>

          <tr>
            <td>
              <img height="{$lineSpacing}" src="{$spacer.gif}" width="1"/>
            </td>
          </tr>            
          </xsl:if> 
          
        </tbody>
      </table>
    </td>

    <td>&nbsp;</td>
  </tr>

  <tr>
    <td colspan="10">
      <img height="12" src="{$spacer.gif}" width="1"/>
    </td>
  </tr>	
</xsl:template> 


<!--
*****************************************************************************
This template prints the Notes part of contact detail
*****************************************************************************
-->
<xsl:template name="notes">
  <xsl:param name="abperson" />
  <xsl:if test="$abperson/entry/description">
    <tr class="fourth-strip">
      <td>
        <img height="20" src="{$spacer.gif}" width="17"/>
      </td>
      <td colspan="8">
        <span class="areatitle">
          <xsl:text>_Notes</xsl:text>
        </span>
      </td>
      <td>&nbsp;</td>
    </tr>

    <tr>
      <td colspan="10">
        <img height="12" src="{$spacer.gif}" width="1"/>
      </td>
    </tr>

    <tr>
      <td>&nbsp;</td>

      <td colspan="8">
        <span class="normal">
          <xsl:call-template name="break-new-lines">
            <xsl:with-param name="text" select="$abperson/entry/description"/>
          </xsl:call-template>&nbsp;
        </span>
      </td>

      <td>&nbsp;</td>
    </tr>
    <tr>
      <td colspan="10">
        <img height="12" src="{$spacer.gif}" width="1"/>
      </td>
    </tr>	
  </xsl:if>
</xsl:template> 


<!--
*****************************************************************************
This template prints the Phone Label in contact detail
*****************************************************************************
-->
<xsl:template name="viewcontact-phone-label">
  <xsl:param name="curPhone" />

  <xsl:if test="$curPhone/@priority = '1'">
    <xsl:text>_Phone </xsl:text>
  </xsl:if> 
  
  <xsl:choose>
    <xsl:when test = "$curPhone">
      <xsl:choose>
        <xsl:when test="$curPhone/@type = 'work'">
          <xsl:text>_work</xsl:text>
        </xsl:when>
        <xsl:when test="$curPhone/@type = 'home'">
          <xsl:text>_home</xsl:text>
        </xsl:when>
        <xsl:when test="$curPhone/@type = 'mobile'">
          <xsl:text>_Mobile</xsl:text>
        </xsl:when>
        <xsl:when test="$curPhone/@type = 'fax'">
          <xsl:text>_Fax</xsl:text>
        </xsl:when>
        <xsl:when test="$curPhone/@type = 'pager'">
          <xsl:text>_Pager</xsl:text>
        </xsl:when>
        <xsl:otherwise>
          <xsl:text>_other</xsl:text>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:when>
    <xsl:otherwise>
      <xsl:text>&nbsp;</xsl:text>
    </xsl:otherwise>
  </xsl:choose> 
  <xsl:if test="$curPhone/@priority = '1'">
    <xsl:text>_(Primary)</xsl:text>
  </xsl:if> 

</xsl:template>


<!--
*****************************************************************************
This template prints the Email Label in contact detail
*****************************************************************************
-->
<xsl:template name="viewcontact-email-label">
  <xsl:param name="curEmail" />

  <xsl:if test="$curEmail/@priority = '1'">
    <xsl:text>_Email </xsl:text>
  </xsl:if> 
  
  <xsl:choose>
    <xsl:when test = "$curEmail">
      <xsl:choose>
        <xsl:when test="$curEmail/@type = 'work'">
          <xsl:text>_work</xsl:text>
        </xsl:when>
        <xsl:when test="$curEmail/@type = 'home'">
          <xsl:text>_home</xsl:text>
        </xsl:when>
        <xsl:when test="$curEmail/@type = 'pager'">
          <xsl:text>_pager</xsl:text>
        </xsl:when>
        <xsl:when test="$curEmail/@type = 'sms'">
          <xsl:text>_sms</xsl:text>
        </xsl:when>
        <xsl:otherwise>
          <xsl:text>_other</xsl:text>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:when>
    <xsl:otherwise>
      <xsl:text>&nbsp;</xsl:text>
    </xsl:otherwise>
  </xsl:choose> 

  <xsl:if test="$curEmail/@priority = '1'">
    <xsl:text>_(Primary)</xsl:text>
  </xsl:if> 
</xsl:template>


<!--
*****************************************************************************
*****************************************************************************
              All templates are now matching templates
*****************************************************************************
*****************************************************************************
-->


<!--
*******************************************************************************
* This templates print the Lastname and Firstname in contact detail
*******************************************************************************
-->
<xsl:template match="surname" mode="detail">
  <td>
    <span class="label">
      <xsl:text>_Last Name</xsl:text>
    </span>
  </td>
  <td>
    <span class="normal">
      <xsl:value-of select="."/>
    </span>
  </td>
</xsl:template>

<xsl:template match="givenname" mode="detail">
  <td>
    <span class="label">
      <xsl:text>_First Name</xsl:text>
    </span>
  </td>
  <td>
    <span class="normal">
      <xsl:value-of select="."/>
    </span>
  </td>
</xsl:template>

<!--
*******************************************************************************
* This template formats and prints a memberofbook element
*******************************************************************************
-->
<xsl:template match="memberofbook">
  <tr>
    <td>
      <a href="javascript:gotoAB('{current()}')" target="_top">
        <xsl:value-of select="/xslui/iab/booklist/book[entry/@entryID = current()]/entry/displayname"/>
      </a>
    </td>
  </tr>

  <tr>
    <td>
      <img height="{$lineSpacing}" src="{$spacer.gif}" width="1"/>
    </td>
  </tr>
</xsl:template> 

<!--
*******************************************************************************
* This template formats and prints a memberofgroup element
*******************************************************************************
-->
<xsl:template match="memberofgroup">
  <tr>
    <td>
      <a href="javascript:urlNotYetAvailable()">
        <xsl:value-of select="/xslui/iab/groupmembership/group[entry/@entryID = current()]/entry/displayname"/>
      </a>
    </td>
  </tr>

  <tr>
    <td>
      <img height="3" src="{$spacer.gif}" width="1"/>
    </td>
  </tr>
</xsl:template> 



<!--
*****************************************************************************
This template formats and prints a phone element
*****************************************************************************
-->
<xsl:template match="phone" mode="detail">
  <td align="right">
    <span class="label">
      <xsl:text>&nbsp;</xsl:text>
      <xsl:call-template name="viewcontact-phone-label">
        <xsl:with-param name="curPhone" select="." />
      </xsl:call-template>
    </span>
  </td>

  <td>&nbsp;</td>

  <td>
    <span class="normal">
      <xsl:apply-templates select="." mode="common"/>
      <xsl:text>&nbsp;</xsl:text>
    </span>
  </td>

  <td>&nbsp;</td>
</xsl:template> 


<!--
*****************************************************************************
This template formats and prints an IM element
*****************************************************************************
-->
<xsl:template match="im" mode="detail">
  <xsl:choose>
    <xsl:when test=".">
      <td align="right">
        <span class="label">
          <xsl:choose>
            <xsl:when test="./@priority = '1'">
              <xsl:text>_Nickname</xsl:text>
              <xsl:text>_(Primary)</xsl:text>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text>_Nickname</xsl:text>
              <xsl:text> </xsl:text>
              <xsl:value-of select="./@priority"/>
            </xsl:otherwise>
          </xsl:choose> 
        </span>
      </td>

      <td>&nbsp;</td>

      <td>
        <table cellspacing="0" cellpadding="0" border="0">
          <tbody>
            <tr>
              <td>
                <a>
                  <xsl:attribute name="href">
                    <xsl:text disable-output-escaping="yes">javascript:sendIM('</xsl:text>
                    <xsl:value-of select="./@service"/>
                    <xsl:text disable-output-escaping="yes">','</xsl:text>
                    <xsl:value-of select="."/>
                    <xsl:text disable-output-escaping="yes">')</xsl:text>
                  </xsl:attribute>
                  <xsl:value-of select="."/>
                </a>
              </td>

              <td>
                <img src="{$spacer.gif}" width="8" border="0"/>
              </td>

              <td valign="middle">
                <xsl:apply-templates select="." mode="common"/>
              </td>

              <td width="5">
                <img src="{$spacer.gif}" width="5" border="0"/>
              </td>

              <td>
               <span class="normal">
                <xsl:text>(</xsl:text>
                  <xsl:value-of select="./@service" />
                <xsl:text>)</xsl:text>
               </span>
              </td>
            </tr>
          </tbody>
        </table>	        
      </td>
 
      <td>&nbsp;</td>
    </xsl:when>
    <xsl:otherwise>
      <td>&nbsp;</td>
      <td>&nbsp;</td>
      <td>&nbsp;</td>
      <td>&nbsp;</td>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template> 

<!--
*****************************************************************************
This template formats and prints an email element
*****************************************************************************
-->
<xsl:template match="email" mode="detail">
  <xsl:if test=".">
    <td align="right">
      <span class="label">
        <xsl:text>&nbsp;</xsl:text>
        <xsl:call-template name="viewcontact-email-label">
          <xsl:with-param name="curEmail" select="." />
        </xsl:call-template>
      </span>
    </td>

    <td>&nbsp;</td>

    <td>
      <xsl:apply-templates select="." mode="common"/>
      <xsl:text>&nbsp;</xsl:text>
    </td>

    <td>&nbsp;</td>
  </xsl:if>
</xsl:template> 


<!--
*******************************************************************************
* This template formats and prints a date element
*******************************************************************************
-->
<xsl:template match="date" mode="detail">
  <td>&nbsp;</td>

  <td align="right">
    <span class="label">
      <xsl:choose>
        <xsl:when test="./@type='other'">
          <xsl:value-of select="./@description"/>&nbsp;
        </xsl:when>
        <xsl:otherwise>
          <xsl:choose>
            <xsl:when test="./@type = 'birthday'">
              <xsl:text>_Birthday</xsl:text>
            </xsl:when>
            <xsl:when test="./@type = 'anniversary'">
              <xsl:text>_Anniversary</xsl:text>
            </xsl:when>
            <xsl:otherwise>
            </xsl:otherwise>
          </xsl:choose> 
        </xsl:otherwise>
      </xsl:choose> 
    </span>
  </td>
  <td>&nbsp;</td>
  <td>
    <table cellspacing="0" cellpadding="0" border="0">
      <tbody>
        <tr>
          <td>
            <span class="normal">
              <xsl:apply-templates select="." mode="common"/>
            </span>
          </td>
          <td width="10">&nbsp;</td>
          <td>&nbsp;</td>
        </tr>
      </tbody>
    </table>
  </td>

</xsl:template> 


<!--
*******************************************************************************
* This template formats and prints a weburl element
*******************************************************************************
-->
<xsl:template match="weburl" mode="detail">
  <td align="right">
    <span class="label">
      <xsl:choose>
        <xsl:when test="./description">
          <xsl:value-of select="./description"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:text>_Web Page Address</xsl:text>
          <xsl:text> </xsl:text>
          <xsl:value-of select="./@priority"/>
        </xsl:otherwise>
      </xsl:choose> 
    </span>
  </td>

  <td>&nbsp;</td>

  <td colspan="5">
    <xsl:apply-templates select="." mode="common"/>
  </td>

  <td>&nbsp;</td>
</xsl:template> 


<!--
*****************************************************************************
This template formats and prints a calendar element
*****************************************************************************
-->
<xsl:template match="calendar" mode="detail">
  <xsl:if test=".">
    <xsl:variable name="type" select="./@type"/>
      <td>&nbsp;</td>
      <td>&nbsp;</td>
  
      <td align="right">
        <span class="label">
          <xsl:choose>
            <xsl:when test="$type = 'calendar'">
              <xsl:text>_Calendar Address</xsl:text>
            </xsl:when>
            <xsl:when test="$type = 'freebusy'">
              <xsl:text>_Availability Address</xsl:text>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text>_Other Calendar</xsl:text>
            </xsl:otherwise>
          </xsl:choose> 
        </span>
      </td>

      <td>&nbsp;</td>

      <td colspan="5">
        <xsl:apply-templates select="." mode="common"/>&nbsp;
      </td>

      <td>&nbsp;</td>
  </xsl:if>
</xsl:template>
</xsl:stylesheet>

