<?xml version="1.0"?>
<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>

<xsl:stylesheet version='1.0' xmlns:xsl='http://www.w3.org/1999/XSL/Transform'>
  <xsl:output method="html" version="4" encoding="UTF-8"/>

  <xsl:variable name="activeTabColor">
    <xsl:variable name="htmlprefs" select="/xslui/profileinfo/xmlprofile/htmlprefs"/>
    <xsl:choose>
      <xsl:when test="$htmlprefs">
        <xsl:choose>
          <xsl:when test="$htmlprefs/@colorset = '1'"> 
            <!-- Gray theme -->
            <xsl:text>6666cc</xsl:text>
          </xsl:when>
          <xsl:when test="$htmlprefs/@colorset = '2'"> 
            <!-- Khaki theme -->
            <xsl:text>666666</xsl:text>
          </xsl:when>
          <xsl:when test="$htmlprefs/@colorset = '3'"> 
            <!-- Purple theme -->
            <xsl:text>666699</xsl:text>
          </xsl:when>
          <xsl:when test="$htmlprefs/@colorset = '4'"> 
            <!-- Green theme -->
            <xsl:text>666699</xsl:text>
          </xsl:when>
          <xsl:when test="$htmlprefs/@colorset = '5'"> 
            <!-- Blue theme -->
            <xsl:text>666699</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <!-- Gray theme -->
            <xsl:text>6666cc</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <xsl:otherwise>
        <!-- Gray theme -->
        <xsl:text>6666cc</xsl:text>
      </xsl:otherwise>
    </xsl:choose>    
  </xsl:variable> 

  <xsl:variable name="inactiveTabColor">
    <xsl:variable name="htmlprefs" select="/xslui/profileinfo/xmlprofile/htmlprefs"/>
    <xsl:choose>
      <xsl:when test="$htmlprefs">
        <xsl:choose>
          <xsl:when test="$htmlprefs/@colorset = '1'"> 
            <!-- Gray theme -->
            <xsl:text>99ccff</xsl:text>
          </xsl:when>
          <xsl:when test="$htmlprefs/@colorset = '2'"> 
            <!-- Khaki theme -->
            <xsl:text>cccc99</xsl:text>
          </xsl:when>
          <xsl:when test="$htmlprefs/@colorset = '3'"> 
            <!-- Purple theme -->
            <xsl:text>cc99cc</xsl:text>
          </xsl:when>
          <xsl:when test="$htmlprefs/@colorset = '4'"> 
            <!-- Green theme -->
            <xsl:text>99cc99</xsl:text>
          </xsl:when>
          <xsl:when test="$htmlprefs/@colorset = '5'"> 
            <!-- Blue theme -->
            <xsl:text>99ccff</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <!-- Gray theme -->
            <xsl:text>99ccff</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <xsl:otherwise>
        <!-- Gray theme -->
        <xsl:text>99ccff</xsl:text>
      </xsl:otherwise>
    </xsl:choose>    

  </xsl:variable> 


  <xsl:template name="tab">
    <xsl:param name="label"/>
    <xsl:param name="labelClass" select="'tab-black'" />
    <xsl:param name="href"/>
    <xsl:param name="color" select="$inactiveTabColor"/>
    <xsl:param name="bgColorIndex" select="'w'" />
    
    <xsl:variable name="L_Tab.gif" select="concat('../absimx/L_Tab_', $color, '_', $bgColorIndex, '.gif')" />
    <xsl:variable name="R_Tab.gif" select="concat('../absimx/R_Tab_', $color, '_', $bgColorIndex, '.gif')" />
    
    <table border="0" cellspacing="0" cellpadding="0">
      <tbody> 
        <tr> 
          <td width="10">
            <img src="{$L_Tab.gif}" width="10" height="20"/>
          </td>
          <td style="background-color: #{$color}">
            <xsl:attribute name="nowrap" />
            <xsl:choose>
              <xsl:when test="$href">
                <a href="{$href}" class="{$labelClass}">
                  <xsl:value-of select="$label" /> 
                </a>
              </xsl:when>
              <xsl:otherwise>
                <span class="{$labelClass}">
                  <xsl:value-of select="$label" /> 
                </span>
              </xsl:otherwise>
            </xsl:choose> 
          </td>
          <td width="10">
            <img src="{$R_Tab.gif}" width="10" height="20"/>
          </td>
        </tr>
      </tbody> 
    </table>
  </xsl:template> 

</xsl:stylesheet>