<?xml version="1.0"?>
<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>

<xsl:stylesheet version='1.0' xmlns:xsl='http://www.w3.org/1999/XSL/Transform'>

<xsl:variable name="fieldPrefix" select="'group_'"/>
<xsl:variable name="valueSeparator" select="';'"/>
<xsl:template name="groupDetails">
  <xsl:param name="group"/>
    <tr> 
      <td class="PropLabelAb" width="22%"><span class="Lbl2"><label for="groupname"><img src="../absimx/required.gif" width="7" height="14">
       <xsl:attribute name="alt">
         <xsl:text>_Indicates a required field</xsl:text>
       </xsl:attribute>
       </img>&nbsp;<xsl:text>_Group Name</xsl:text></label></span></td>
      <td class="PropInput" width="55%"> 
          <input type="text" size="30" maxlength="30" name="{$fieldPrefix}displayName" id="groupname" tabindex="1">
            <xsl:attribute name="value">
              <xsl:value-of select="/xslui/iab/bookentry/group/entry/displayname"/>
             </xsl:attribute>
           </input>
      </td>
      <td width="6%">&nbsp;</td>
      <td width="11%">&nbsp;</td>
      <td width="6%">&nbsp;</td>
    </tr>
    <tr> 
      <td class="PropLabelAb" align="top" width="22%"><span class="Lbl2"><label for="description"><xsl:text>_Description</xsl:text></label></span></td>
      <td class="PropInput" width="55%"> 
        <textarea cols="30" rows="2" tabindex="2" id="description">
              <xsl:attribute name="name">
                <xsl:value-of select="$fieldPrefix"/>
                <xsl:text>description</xsl:text>
              </xsl:attribute>
             <xsl:value-of select="/xslui/iab/bookentry/group/entry/description"/>
            </textarea>
      </td>
      <td width="6%">&nbsp;</td>
      <td width="11%">&nbsp;</td>
      <td width="6%">&nbsp;</td>
    </tr>

    <tr> 
      <td class="PropLabelAb" width="22%"><span class="Lbl2"><label for="webaddress"><xsl:text>_Web Address</xsl:text></label></span></td> 
      <td class="PropInput" width="55%"> 
           <input type="text" size="40" maxlength="256" tabindex="3" name="{$fieldPrefix}piWebSite1" id="webaddress">
                <xsl:attribute name="value">
                  <xsl:value-of select="/xslui/iab/bookentry/group/weburl[@priority='1']/urladdr"/>
                </xsl:attribute>
           </input>
      </td>
      <td width="6%">&nbsp;</td>
      <td width="11%">&nbsp;</td>
      <td width="6%">&nbsp;</td>
    </tr>

    <tr> 
      <td class="PropLabelAb" width="22%"><span class="Lbl2"><label for="caladdress"><xsl:text>_Calendar Address</xsl:text></label></span></td>
      <td class="PropInput" width="55%"> 
        <input type="text" size="40" maxlength="256" tabindex="4" name="{$fieldPrefix}inetCalendar" id="caladdress">
              <xsl:attribute name="value">
                <xsl:value-of select="/xslui/iab/bookentry/group/calendar[@type='calendar']/urladdr"/>
              </xsl:attribute>
         </input>
      </td>
      <td width="6%">&nbsp;</td>
      <td width="11%">&nbsp;</td>
      <td width="6%">&nbsp;</td>
    </tr>

    <tr> 
      <td class="PropLabel" colspan="5"><img src="{$spacer.gif}" alt="" width="10" height="8"/></td>
    </tr>

    <tr> 
      <td colspan="5"> 
        <table width="100%" border="0" cellspacing="0" cellpadding="0">
          <tr> 
            <td width="1%"><img src="{$spacer.gif}" alt="" width="10" height="5"/></td>

            <td width="100%" class="SectionDivider"><img src="{$spacer.gif}" alt="" width="1" height="5"/></td>
            <td width="1%"><img src="{$spacer.gif}" alt="" width="10" height="5"/></td>
          </tr>
        </table>
      </td>
    </tr>

  </xsl:template> 


<!--
*******************************************************************************
* This template outputs the group member part of the group edit page
*******************************************************************************
-->
  <xsl:template name="groupMembers">
    <xsl:param name="members" />
    <script language="javascript">
      function removeMember(id) {
        idsToRemove  = document.iabform.idstormv;
        idsToAdd     = document.iabform.idstoadd;
        groupMembers = document.iabform.groupMembers.options;

        re = new RegExp("\<xsl:value-of select="$valueSeparator"/>"+id+"|"+id+"\<xsl:value-of select="$valueSeparator"/>|"+id, "g");
        if ((idsToAdd.value != '') &#38;&#38; (idsToAdd.value.search(re) != -1)) {
          idsToAdd.value=idsToAdd.value.replace(re, '');
        }
        else {
          idsToRemove.value += "<xsl:value-of select="$valueSeparator"/>"+id;
          idsToRemove.value = idsToRemove.value.replace(/^\<xsl:value-of select="$valueSeparator"/>/, '');
        }

      }

      function removeSelectedMembers() {
        s = document.iabform.groupMembers; 
        v = getSelectValue(s);
        valArray = new Array();
        txtArray = new Array();
        for (var k = 0; k &lt; s.options.length; k++) {
          if (!s.options[k].selected) {
            valArray[valArray.length]=s.options[k].value;
            txtArray[txtArray.length]=s.options[k].text;
          }
        }
        s.options.selectedIndex = -1;
        if (v != null) {
          for (var i = 0; i &#60; v.length; i++) {
            removeMember(v[i]);
          }
          s.options.length = 0;
          for (var j = 0; j &lt; valArray.length; j++) {
            s.options.length++;
            s.options[j].value = valArray[j];
            s.options[j].text   = txtArray[j];
          }
          if (s.options.length == 0) {
            s.options.length ++;
            s.options[0].text  = "<xsl:text>_-- Group contains no member --</xsl:text>";
            s.options[0].value = "";
          }
        }
        else {
          alert("<xsl:text>_No member has been selected</xsl:text>")
        }
        return; 
      }

      function addMember(alreadyAdded, id, text) {
        sep          = (document.iabform.valueseparator)?document.iabform.valueseparator.value:';';
        groupMembers = document.iabform.groupMembers.options;
        idsToAdd     = document.iabform.idstoadd;
        idsToRemove  = document.iabform.idstormv;
        if (alreadyAdded[id] == null) {
          if( groupMembers[groupMembers.length-1].value == "" ) 
            groupMembers.length--;
          re = new RegExp(sep+id+"$|"+id+sep+"|^"+id, "g");          
          groupMembers.length++;
          if ((idsToRemove.value != '') &#38;&#38; (idsToRemove.value.search(re) != -1)) {
            idsToRemove.value=idsToRemove.value.replace(re, '');
          }
          else {
            idsToAdd.value += sep+id;
            if (idsToAdd.value.indexOf(sep) == 0) idsToAdd.value = idsToAdd.value.substr(1);
          }
          groupMembers[groupMembers.length-1].value = id;
          groupMembers[groupMembers.length-1].text  = text;
          alreadyAdded[id] = "1";
        }

      }

      function addToGroup(idArray, dnArray, emailArray) {
        var alreadyAdded = new Object();
        var memberAdded = 0;
        for (var i = 0; i &#60; idArray.length; i++){
          if( idArray[i] == null )
            continue;

          memberAdded++; 
          label  = dnArray[i];
          label += (emailArray[i] != null &#38;&#38; emailArray[i].length > 0)?' ('+emailArray[i]+')':'';
          addMember(alreadyAdded, idArray[i], label);
        }

        if( memberAdded == 0 )
          return;

        groupMembers = document.iabform.groupMembers.options;
        groupMembers.length++;
        groupMembers[groupMembers.length-1].value = "";
        groupMembers[groupMembers.length-1].text = "______________________________";
      }

      sharedObj = new Object();
      selectWnd = null;
      function GetSharedObject() {
        return (sharedObj);
      }

      function GetSharedObject() {
        sharedObj.expandselectedgroup = null;
        sharedObj.expandonmissing     = null;
        sharedObj.fieldsToReturn      = new Array('entryid', 'displayname', 'email_1');
        sharedObj.nid                 = new Array(
        <xsl:for-each select="/xslui/iab/bookentry/group/memberofgroup">
          '<xsl:value-of select="current()"/>',
        </xsl:for-each>
        '<xsl:value-of select="/xslui/iab/bookentry/group/entry/@entryID"/>');
        sharedObj.nid.sort();
        sharedObj.sid                 = new Array();
        groupMembers = document.iabform.groupMembers.options;
        for (var i = 0; i &#60; groupMembers.length; i++) {
          sharedObj.sid[sharedObj.sid.length] = groupMembers[i].value;
        }
        sharedObj.sid.sort();
        return (sharedObj);
      }

      function AcceptData(inputArray) {
        addToGroup(inputArray[0], inputArray[1], inputArray[2]);
      }
      
      function open_popup_selectmember() {
        if (selectWnd &amp;&amp; !selectWnd.closed) 
          selectWnd.focus();
        else
          selectWnd = window.open('select-popup-main.xml?bookid=<xsl:value-of select="/xslui/iab/pagedsearch/searchresult/@bookid"/>'+
          '&#38;wcfg_ablist=0&#38;wcfg_col1=dnnolink&#38;wcfg_col2=primemailnolink',
          'select', 'height=550,width=650,titlebar=yes,resizable=yes,scrollbars=yes');
	    }
    </script>
    <tr> 
      <td class="SectionHeader" colspan="5">
        <span class="SectionHeader">  
           <xsl:text>_Group Members</xsl:text>
        </span>
      </td>
    </tr>
    <tr> 
      <td colspan="5" >
        <table width="100%" border="0" cellspacing="0" cellpadding="0">
          <tr> 
            <td class="PropLabelAb" width="20%">
               <span class="Lbl2">
                <label for="members">
                   <xsl:text>_Members</xsl:text>
               </label>
             </span><br/>
             <select class="normal" name="groupMembers" size="10" id="members">
                <xsl:attribute name="multiple"/>
                  <xsl:choose>
                  <xsl:when test="/xslui/iab/groupmembers/*">
                  <xsl:for-each select="/xslui/iab/groupmembers/*">
                    <option>
                       <xsl:attribute name="value">
                          <xsl:value-of select="current()/entry/@entryID"/>
                       </xsl:attribute>
                       <xsl:value-of select="current()/entry/displayname"/>
                       <xsl:if test="current()//email[@priority='1']">
                          <xsl:text> (</xsl:text>
                          <xsl:value-of select="current()//email[@priority='1']" />
                          <xsl:text>)</xsl:text>
                       </xsl:if>
                    </option>
                  </xsl:for-each>
                  <option value="">
                  ______________________________ 
                  </option> 
                  </xsl:when>
                  <xsl:when test="not(/xslui/iab/groupmembers/*)">
                     <option value="">
                        <xsl:text>_-- Group contains no member --</xsl:text>
                     </option>
                  </xsl:when>
                 </xsl:choose>
             </select>
             <input type="hidden" name="idstoadd" value=""/>
             <input type="hidden" name="idstormv" value=""/>
             </td>
             <td class="PropLabel" width="80%"> 
             <div class="ShwDetails"> 
                <xsl:call-template name="uwcbutton">
                  <xsl:with-param name="value">
                     <xsl:text>         </xsl:text><xsl:text>_Add</xsl:text><xsl:text>         </xsl:text>
                  </xsl:with-param>
                  <xsl:with-param name="name">
                     <xsl:text>Add</xsl:text>
                  </xsl:with-param>
                  <xsl:with-param name="id">
                     <xsl:text>Add</xsl:text>
                  </xsl:with-param>
                  <xsl:with-param name="title">
                     <xsl:text>_Add</xsl:text>
                  </xsl:with-param>
                  <xsl:with-param name="class">
                     <xsl:text>Btn1</xsl:text>
                  </xsl:with-param>
                  <xsl:with-param name="onclick" select="'javascript:open_popup_selectmember()'"/>
                  <xsl:with-param name="tabindex" select="6"/>
                  <xsl:with-param name="type" select="'button'"/>
                 </xsl:call-template>
              <br/>
              </div>
              <div class="AddRmvHrzWin"> 
                <xsl:call-template name="uwcbutton">
                   <xsl:with-param name="value">
                     <xsl:text>     </xsl:text><xsl:text>_Remove</xsl:text><xsl:text>     </xsl:text>
                  </xsl:with-param>
                  <xsl:with-param name="name">
                     <xsl:text>Remove</xsl:text>
                  </xsl:with-param>
                  <xsl:with-param name="id">
                     <xsl:text>Remove</xsl:text>
                  </xsl:with-param>
                  <xsl:with-param name="title">
                     <xsl:text>_Remove</xsl:text>
                  </xsl:with-param>
                  <xsl:with-param name="class">
                     <xsl:text>Btn2</xsl:text>
                  </xsl:with-param>
                   <xsl:with-param name="type" select="'button'"/>
                   <xsl:with-param name="onclick" select="'javascript:removeSelectedMembers()'"/>
                   <xsl:with-param name="tabindex" select="7"/>
                </xsl:call-template>
              </div>
            </td>
          </tr>
        </table>
      </td>
    </tr>
  </xsl:template> 


<!--
*******************************************************************************
* This prints the error messages on the add/edit group page
* @param err The error element from which to extract the error code
*******************************************************************************
-->
  <xsl:template name="error-message">
    <xsl:param name="err" select="." />
    
    <xsl:choose>
      <xsl:when test="$err/@errnum = '129'">
        <ul>
          <xsl:for-each select="$err/field">
            <li class="normal">
            <xsl:call-template name="elementName-to-fieldName">
              <xsl:with-param name="eltName" select="./@elementname"/>
            </xsl:call-template>
            </li>
          </xsl:for-each> 
        </ul>
      </xsl:when>      
      <xsl:when test="$err/@errnum = '268'">
        <xsl:text>_Loop detected in the group</xsl:text>.&nbsp;
      </xsl:when>
      <xsl:when test="$err/@errnum = '256' or $err/@errnum = '264' or $err/@errnum = '261' ">
       <script>
        var eDisplayName = "<xsl:call-template name="escape"><xsl:with-param name="text" select="$err/@displayname"/></xsl:call-template>";
        printLocalizedLabel("<xsl:text>_Group Addition Failure Message</xsl:text>", new Array(eDisplayName));</script>               
      </xsl:when>
      <xsl:when test="$err/@errnum = '269'">
        <xsl:text>_You can't add a group to itself</xsl:text>.&nbsp;
      </xsl:when>
      <xsl:when test="$err/@errnum = '514'">
        <xsl:text>_Required parameters are missing</xsl:text>&nbsp;:
        <ul>
          <xsl:for-each select="./parameter">
          	<li class="normal">
              <xsl:value-of select="@paramname" /> 
            </li>
          </xsl:for-each> 
        </ul>
        <xsl:text>_Please contact your administrator</xsl:text>.
      </xsl:when>
      <xsl:otherwise>
        <xsl:text>_Unknown error (</xsl:text>
        <xsl:value-of select="$err/@errnum" /> 
        <xsl:text>)</xsl:text>
      </xsl:otherwise>
    </xsl:choose>
<!--
    <xsl:if test="$err/@rawmsg">
      <br/>
      <xsl:value-of select="$err/@rawmsg" />&nbsp;
    </xsl:if> 
-->
  </xsl:template> 

<!--
*******************************************************************************
* Translate an element name into a field name understable by user
* @param eltName The name of the element to translate
*******************************************************************************
-->
  <xsl:template name="elementName-to-fieldName">
    <xsl:param name="eltName"/>
    <xsl:if test="string-length($eltName) > 0">
      <xsl:choose>
        <xsl:when test="$eltName = 'displayname'">
          <xsl:text>_Group Name</xsl:text>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$eltName" /> 
        </xsl:otherwise>
      </xsl:choose> 
    </xsl:if> 
  </xsl:template>   
</xsl:stylesheet>
