<?xml version="1.0"?>
<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>

<xsl:stylesheet version='1.0' xmlns:xsl='http://www.w3.org/1999/XSL/Transform'>

<xsl:variable name="fieldPrefix" select="'ab_'"/>
<xsl:variable name="valueSeparator" select="';'"/>

<!--
***********************************************************************
* This template displays the main new/edit abook page
* @param ab the address book node we are working on (can be empty)
* @param edit boolean true if we are in editing mode.
***********************************************************************
-->
  <xsl:template name="abDetails">
    <xsl:param name="ab"/>
    <xsl:param name="edit" />
    <tr> 
      <td colspan="5">
        <img src="{$spacer.gif}" width="1" height="9"/>
      </td>
    </tr>
    <tr> 
      <td width="17">
        <img src="{$spacer.gif}" width="17" height="1"/>
      </td>
      <td align="right">
        <p class="label">
          <xsl:text>_Name</xsl:text>
        </p>
      </td>
      <td width="10" align="center">
        <b style="color: #0000FF">*</b>
      </td>
      <td> 
      <xsl:choose>
      <xsl:when test="$ab">
        <input type="text" name="{$fieldPrefix}displayName" size="30" maxlength="30" value="{$ab/entry/displayname}"/>
      </xsl:when>
      <xsl:otherwise>
        <input type="text" name="{$fieldPrefix}displayName" size="30" maxlength="30"/>
      </xsl:otherwise>
      </xsl:choose>
      </td>
      <td width="17">
        <img src="{$spacer.gif}" width="17" height="1"/>
      </td>
    </tr>
    <tr> 
      <td colspan="5">
        <img src="{$spacer.gif}" width="1" height="6"/>
      </td>
    </tr>
    <tr> 
      <td>&nbsp;</td>
      <td align="right">
        <p class="label">
          <xsl:text>Description</xsl:text>
        </p>
      </td>
      <td>&nbsp;</td>
      <td> 
        <textarea cols="30" rows="2"
                  name="{$fieldPrefix}description">
          <xsl:if test="$ab">
            <xsl:value-of select="$ab/entry/description" />
          </xsl:if> 
        </textarea>
      </td>
      <td>&nbsp;</td>
    </tr>
<!--
TODO
    <xsl:if test="$edit">
      <tr> 
        <td colspan="5">
          <img src="{$spacer.gif}" width="1" height="6"/>
        </td>
      </tr>
      <tr> 
        <td>&nbsp;</td>
        <td align="right">
          <p class="label">
            <xsl:text>_Owner</xsl:text>
          </p>
        </td>
        <td>&nbsp;</td>
        <td>
          <span class="normal">
            <xsl:text>owner_name</xsl:text>
          </span>
        </td>
        <td>&nbsp;</td>
      </tr>
      <tr> 
        <td colspan="5">
          <img src="{$spacer.gif}" width="1" height="6"/>
        </td>
      </tr>
      <tr> 
        <td>&nbsp;</td>
        <td align="right">
          <p class="label">
            <xsl:text>_Web Address</xsl:text>
          </p>
        </td>
        <td>&nbsp;</td>
        <td>
          <span class="normal">
            <xsl:value-of select="$ab/@bookurl"/>&nbsp;
          </span>
        </td>
        <td>&nbsp;</td>
      </tr>
    </xsl:if> 
-->
    <tr> 
      <td colspan="5">
        <img src="{$spacer.gif}" width="1" height="12"/>
      </td>
    </tr>
  </xsl:template> 

<!--
***********************************************************************
* This template prints the addressBook part of the Layout customization
* @param book The book we get info from. Can be null
***********************************************************************
-->
<xsl:template name="abLayout">
  <xsl:param name="book"/>
  
  <tr class="fourth-strip"> 
    <td colspan="5"> 
      <table border="0" cellspacing="0" cellpadding="0">
        <tr> 
          <td>
            <img src="{$spacer.gif}" width="17" height="1" />
          </td>
          <td class="areatitle">
            <xsl:text>_Customize layout</xsl:text>
          </td>
        </tr>
      </table>
    </td>
  </tr>
  <tr> 
    <td colspan="5">
      <img src="{$spacer.gif}" width="1" height="12" />
    </td>
  </tr>
  <tr> 
    <td>&nbsp;</td>
    <td align="right">
      <span class="label">
        <xsl:text>_Entries per Page</xsl:text>
      </span>
    </td>
    <td>&nbsp;</td>
    <td>
      <span class="normal">
        <select class="normal" name="{$fieldPrefix}abEntriesPerPage">
          <option value="10">
            <xsl:if test="$book and $book/layoutinfo/@entriesperpage = '10'">
              <xsl:attribute name="selected"/>
            </xsl:if> 
            <xsl:text>10</xsl:text>
          </option>
          <option value="25">
            <xsl:if test="($book and $book/layoutinfo/@entriesperpage = '25') or not($book)">
              <xsl:attribute name="selected"/>
            </xsl:if> 
            <xsl:text>25</xsl:text>
          </option>
          <option value="50">
            <xsl:if test="$book and $book/layoutinfo/@entriesperpage = '50'">
              <xsl:attribute name="selected"/>
            </xsl:if> 
            <xsl:text>50</xsl:text>
          </option>
        </select>
      </span>
      <span class="normal">&nbsp;<xsl:text>_(maximum number of entries displayed per page in this address book)</xsl:text></span>
    </td>
    <td>&nbsp;</td>
  </tr>
  <tr> 
    <td colspan="5">
      <img src="{$spacer.gif}" width="1" height="9"/>
    </td>
  </tr>
  <tr> 
    <td>&nbsp;</td>
    <td align="right">
      <span class="label">
        <xsl:text>_Columns to display</xsl:text>
      </span>
    </td>
    <td>&nbsp;</td>
    <td class="normal">
      <xsl:text>_Select up to 7 columns to show for this address book:</xsl:text>
    </td>
    <td>&nbsp;</td>
  </tr>
  <tr> 
    <td>&nbsp;</td>
    <td>&nbsp;</td>
    <td>&nbsp;</td>
    <td> 
      <xsl:choose>
        <xsl:when test="$book">
          <xsl:call-template name="print-column-selects">
            <xsl:with-param name="book" select="$book"/>
          </xsl:call-template>
        </xsl:when>
        <xsl:otherwise>
          <xsl:call-template name="print-column-selects"/>
        </xsl:otherwise>
      </xsl:choose> 
    </td>
    <td>&nbsp;</td>
  </tr>
  <tr> 
    <td colspan="5">
      <img src="{$spacer.gif}" width="1" height="12" />
    </td>
  </tr>
</xsl:template>

<!--
*******************************************************************************
* Prints the sharing paremission part of the address book details
*******************************************************************************
-->
  <xsl:template name="sharingPermissions">
<!--
TODO
    <tr class="fourth-strip"> 
      <td colspan="5"> 
        <table border="0" cellspacing="0" cellpadding="0">
          <tr> 
            <td>
              <img src="{$spacer.gif}" width="17" height="1"/>
            </td>
            <td class="areatitle">
              <xsl:attribute name="nowrap"/>                
              <xsl:text>_Sharing (Permissions)</xsl:text>
            </td>
          </tr>
        </table>
      </td>
    </tr>
    <tr> 
      <td colspan="5">
        <img src="{$spacer.gif}" width="1" height="12"/>
      </td>
    </tr>
    <tr> 
      <td width="17">
        <img src="{$spacer.gif}" width="17" height="1"/>
      </td>
      <td colspan="3">
        <span class="normal">
          <xsl:text>_Share this address book with other users in one of the following ways:</xsl:text>
        </span>
      </td>
      <td width="17">
        <img src="{$spacer.gif}" width="17" height="1"/>
      </td>
    </tr>
    <tr> 
      <td colspan="5">
        <img src="{$spacer.gif}" width="1" height="6"/>
      </td>
    </tr>
    <tr> 
      <td>&nbsp;</td>
      <td colspan="3"> 
        <table border="0" cellspacing="0" cellpadding="0">
          <tr> 
            <td> 
              <input type="radio" name="share" value="0">
                <xsl:attribute name="name">
                  <xsl:value-of select="$fieldPrefix"/>
                  <xsl:value-of select="'share'"/>
                </xsl:attribute> 
                <xsl:attribute name="checked"/>
              </input>
            </td>
            <td width="10">&nbsp;</td>
            <td>
              <span class="normal">
                <xsl:text>_Nobody can view or modify this address book</xsl:text>
              </span>
            </td>
          </tr>
          <tr> 
            <td colspan="3">
              <img src="{$spacer.gif}" width="1" height="6"/>
            </td>
          </tr>
          <tr> 
            <td> 
              <input type="radio" name="share" value="1">
                <xsl:attribute name="name">
                  <xsl:value-of select="$fieldPrefix"/>
                  <xsl:value-of select="'share'"/>
                </xsl:attribute> 
              </input>
            </td>
            <td>&nbsp;</td>
            <td>
              <span class="normal">
                <xsl:text>_Anyone can view this address book</xsl:text>
              </span>
            </td>
          </tr>
          <tr> 
            <td colspan="3">
              <img src="{$spacer.gif}" width="1" height="6"/>
            </td>
          </tr>
          <tr> 
            <td> 
              <input type="radio" name="share" value="2">
                <xsl:attribute name="name">
                  <xsl:value-of select="$fieldPrefix"/>
                  <xsl:value-of select="'share'"/>
                </xsl:attribute> 
              </input>
            </td>
            <td>&nbsp;</td>
            <td>
              <span class="normal">
                <xsl:text>_Anyone can view and modify this address book</xsl:text>
              </span>
            </td>
          </tr>
          <tr> 
            <td colspan="3">
              <img src="{$spacer.gif}" width="1" height="6"/>
            </td>
          </tr>
          <tr> 
            <td> 
              <input type="radio" name="share" value="3">
                <xsl:attribute name="name">
                  <xsl:value-of select="$fieldPrefix"/>
                  <xsl:value-of select="'share'"/>
                </xsl:attribute> 
              </input>
            </td>
            <td>&nbsp;</td>
            <td>
              <table border="0" cellspacing="0" cellpadding="0">
                <tr> 
                  <td width="475">
                    <span class="bold">
                      <xsl:text>_Advanced Permissions</xsl:text>:
                    </span>
                    <span class="normal">
                      <xsl:text>_You may set specific permissions for other users and domains</xsl:text>.
                      <xsl:text>_Note: These permissions will override the option you chose above</xsl:text>.
                    </span>    
                  </td>
                  <td width="6">&nbsp;</td>
                  <td> 
                    <xsl:call-template name="button">
                      <xsl:with-param name="label">
                        <xsl:text>_Advanced Permissions...</xsl:text>
                      </xsl:with-param>
                      <xsl:with-param name="disabled" select="true()"/>
                      <xsl:with-param name="bgColorIndex" select="'b'"/>
                    </xsl:call-template>
                  </td>
                </tr>
              </table>
            </td>
          </tr>
        </table>
      </td>
      <td>&nbsp;</td>
    </tr>
    <tr> 
      <td colspan="5">
        <img src="{$spacer.gif}" width="1" height="18"/>
      </td>
    </tr>
-->
  </xsl:template> 

<!--
*******************************************************************************
* Prints the column content
*******************************************************************************
-->
<xsl:template name="print-column-selects">
  <xsl:param name="book" select="''"/>

  <table border="0" cellspacing="2" cellpadding="2">
    <tr>
      <td class="normal">
        <xsl:text>_Column</xsl:text>&nbsp;1:
      </td>
      <td>
        <xsl:call-template name="columnSelect">
          <xsl:with-param name="id" select="'1'"/>
          <xsl:with-param name="book" select="$book"/>
        </xsl:call-template>
      </td>
    </tr>
    <tr>
      <td class="normal">
        <xsl:text>_Column</xsl:text>&nbsp;2:
      </td>
      <td>
        <xsl:call-template name="columnSelect">
          <xsl:with-param name="id" select="'2'"/>
          <xsl:with-param name="book" select="$book"/>
        </xsl:call-template>
      </td>
    </tr>
    <tr>
      <td class="normal">
        <xsl:text>_Column</xsl:text>&nbsp;3:
      </td>
      <td>
        <xsl:call-template name="columnSelect">
          <xsl:with-param name="id" select="'3'"/>
          <xsl:with-param name="book" select="$book"/>
        </xsl:call-template>
      </td>
    </tr>
    <tr>
      <td class="normal">
        <xsl:text>_Column</xsl:text>&nbsp;4:
      </td>
      <td>
        <xsl:call-template name="columnSelect">
          <xsl:with-param name="id" select="'4'"/>
          <xsl:with-param name="book" select="$book"/>
        </xsl:call-template>
      </td>
    </tr>
    <tr>
      <td class="normal">
        <xsl:text>_Column</xsl:text>&nbsp;5:
      </td>
      <td>
        <xsl:call-template name="columnSelect">
          <xsl:with-param name="id" select="'5'"/>
          <xsl:with-param name="book" select="$book"/>
        </xsl:call-template>
      </td>
    </tr>
    <tr>
      <td class="normal">
        <xsl:text>_Column</xsl:text>&nbsp;6:
      </td>
      <td>
        <xsl:call-template name="columnSelect">
          <xsl:with-param name="id" select="'6'"/>
          <xsl:with-param name="book" select="$book"/>
        </xsl:call-template>
      </td>
    </tr>
    <tr>
      <td class="normal">
        <xsl:text>_Column</xsl:text>&nbsp;7:
      </td>
      <td>
        <xsl:call-template name="columnSelect">
          <xsl:with-param name="id" select="'7'"/>
          <xsl:with-param name="book" select="$book"/>
        </xsl:call-template>
      </td>
    </tr>
  </table>
</xsl:template> 

<!--
***********************************************************************
* Prints the select for column atributes display
***********************************************************************
-->
<xsl:template name="columnSelect">
  <xsl:param name="id"/>
  <xsl:param name="book"/>

  <xsl:variable name="selectedField">
    <xsl:call-template name="getColumnFieldName">
       <xsl:with-param name="id" select="$id"/>
       <xsl:with-param name="selectedbook" select="$book"/>
    </xsl:call-template>
  </xsl:variable>
  <span class="normal">
    <select class="normal" name="{$fieldPrefix}abSearchDisplayColumn{$id}" onChange="resetDropDown(this,'{$selectedField}')">
      <option value="">
        <xsl:text>_[Don't Display Column]</xsl:text>
      </option>
      <option value="displayname">
        <xsl:if test="$selectedField='displayname'">
          <xsl:attribute name="selected"/>
        </xsl:if>
        <xsl:text>_Display Name</xsl:text>
      </option>
      <option value="company">
        <xsl:if test="$selectedField='company'">
          <xsl:attribute name="selected"/>
        </xsl:if>
        <xsl:text>_Company</xsl:text>
      </option>
      <option value="ou">
        <xsl:if test="$selectedField='ou'">
          <xsl:attribute name="selected"/>
        </xsl:if>
        <xsl:text>_Organizational Unit</xsl:text>
      </option>
      <option value="title">
        <xsl:if test="$selectedField='title'">
          <xsl:attribute name="selected"/>
        </xsl:if>
        <xsl:text>_Title</xsl:text>
      </option>
      <option value="primaryphone">
        <xsl:if test="$selectedField='primaryphone'">
          <xsl:attribute name="selected"/>
        </xsl:if>
        <xsl:text>_Primary Phone</xsl:text>
      </option>
      <option value="homephone">
        <xsl:if test="$selectedField='homephone'">
          <xsl:attribute name="selected"/>
        </xsl:if>
        <xsl:text>_phone (home)</xsl:text>
      </option>
      <option value="workphone">
        <xsl:if test="$selectedField='workphone'">
          <xsl:attribute name="selected"/>
        </xsl:if>
        <xsl:text>_phone (work)</xsl:text>
      </option>
      <option value="mobilephone">
        <xsl:if test="$selectedField='mobilephone'">
          <xsl:attribute name="selected"/>
        </xsl:if>
        <xsl:text>_Mobile</xsl:text>
      </option>
      <option value="faxphone">
        <xsl:if test="$selectedField='faxphone'">
          <xsl:attribute name="selected"/>
        </xsl:if>
        <xsl:text>_Fax</xsl:text>
      </option>
      <option value="pagerphone">
        <xsl:if test="$selectedField='pagerphone'">
          <xsl:attribute name="selected"/>
        </xsl:if>
        <xsl:text>_Pager</xsl:text>
      </option>
      <option value="otherphone">
        <xsl:if test="$selectedField='otherphone'">
          <xsl:attribute name="selected"/>
        </xsl:if>
        <xsl:text>_Other phone</xsl:text>
      </option>
      <option value="primaryemail">
        <xsl:if test="$selectedField='primaryemail'">
          <xsl:attribute name="selected"/>
        </xsl:if>
        <xsl:text>_Primary Email</xsl:text>
      </option>
      <option value="email2">
        <xsl:if test="$selectedField='email2'">
          <xsl:attribute name="selected"/>
        </xsl:if>
        <xsl:text>_Email 2</xsl:text>
      </option>
      <option value="email3">
        <xsl:if test="$selectedField='email3'">
          <xsl:attribute name="selected"/>
        </xsl:if>
        <xsl:text>_Email 3</xsl:text>
      </option>
      <option value="homeaddress">
        <xsl:if test="$selectedField='homeaddress'">
          <xsl:attribute name="selected"/>
        </xsl:if>
        <xsl:text>_Home Address</xsl:text>
      </option>
      <option value="workaddress">
        <xsl:if test="$selectedField='workaddress'">
          <xsl:attribute name="selected"/>
        </xsl:if>
        <xsl:text>_Work Address</xsl:text>
      </option>
      <option value="weburl1">
        <xsl:if test="$selectedField='weburl1'">
          <xsl:attribute name="selected"/>
        </xsl:if>
        <xsl:text>_Web Page Address</xsl:text>
      </option>
      <option value="weburl2">
        <xsl:if test="$selectedField='weburl2'">
          <xsl:attribute name="selected"/>
        </xsl:if>
        <xsl:text>_Web Page Address 2</xsl:text>
      </option>
      <option value="calendarurl">
        <xsl:if test="$selectedField='calendarurl'">
          <xsl:attribute name="selected"/>
        </xsl:if>
        <xsl:text>_Calendar Address</xsl:text>
      </option>
<!-- TODO
      <option value="freebusyurl">
        <xsl:if test="$selectedField='freebusyurl'">
          <xsl:attribute name="selected"/>
        </xsl:if>
        <xsl:text>_Availability Address</xsl:text>
      </option>
-->
      <option value="birthday">
        <xsl:if test="$selectedField='birthday'">
          <xsl:attribute name="selected"/>
        </xsl:if>
        <xsl:text>_Birthday</xsl:text>
      </option>
      <option value="anniversary">
        <xsl:if test="$selectedField='anniversary'">
          <xsl:attribute name="selected"/>
        </xsl:if>
        <xsl:text>_Anniversary Date</xsl:text>
      </option>
      <option value="otherdate">
        <xsl:if test="$selectedField='otherdate'">
          <xsl:attribute name="selected"/>
        </xsl:if>
        <xsl:text>_Other Date</xsl:text>
      </option>
      <option value="n/a">--------------------</option>
      <option value="calendar">
        <xsl:if test="$selectedField='calendar'">
          <xsl:attribute name="selected"/>
        </xsl:if>
        <xsl:text>_View Calendar Icon</xsl:text>
      </option>
<!-- TODO
      <option value="calendarevent">
        <xsl:if test="$selectedField='calendarevent'">
          <xsl:attribute name="selected"/>
        </xsl:if>
        <xsl:text>_Schedule Event Icon</xsl:text>
      </option>
-->
      <option value="im">
        <xsl:if test="$selectedField='im'">
          <xsl:attribute name="selected"/>
        </xsl:if>
        <xsl:text>_IM Presence Icon</xsl:text>
      </option>
      <option value="n/a">--------------------</option>
      <option value="edit">
        <xsl:if test="$selectedField='edit'">
          <xsl:attribute name="selected"/>
        </xsl:if>
        <xsl:text>_Edit/Copy Contact or Group</xsl:text>
      </option>
    </select>
  </span>
</xsl:template> 

<!--
*******************************************************************************
* This prints the error messages on the search page
* @param err The error element from which to extract the error code
*******************************************************************************
-->
  <xsl:template name="error-message">
    <xsl:param name="err" select="." />
    
    <xsl:choose>
      <xsl:when test="$err/@errnum = '129'">
        <ul>
          <xsl:for-each select="$err/field">
            <li class="normal">
            <xsl:call-template name="elementName-to-fieldName">
              <xsl:with-param name="eltName" select="./@elementname"/>
            </xsl:call-template>
            </li>
          </xsl:for-each> 
        </ul>
      </xsl:when>
      <xsl:when test="$err/@errnum = '260'">
        <xsl:text>_Cant create address book !</xsl:text>&nbsp;
      </xsl:when>
      <xsl:when test="$err/@errnum = '133'">
       &nbsp;
      </xsl:when>
      <xsl:otherwise>
        <xsl:text>_Unknown error (</xsl:text>
        <xsl:value-of select="$err/@errnum" /> 
        <xsl:text>)</xsl:text>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:if test="$err/@rawmsg">
      <br/>
      <xsl:value-of select="$err/@rawmsg" />&nbsp;
    </xsl:if> 
  </xsl:template> 

<!--
*******************************************************************************
* Translate an element name into a field name understable by user
* @param eltName The name of the element to translate
*******************************************************************************
-->
  <xsl:template name="elementName-to-fieldName">
    <xsl:param name="eltName"/>
    <xsl:if test="string-length($eltName) > 0">
      <xsl:choose>
        <xsl:when test="$eltName = 'displayname'">
          <xsl:text>_Address Book Name</xsl:text>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$eltName" /> 
        </xsl:otherwise>
      </xsl:choose> 
    </xsl:if> 
  </xsl:template> 


</xsl:stylesheet>
