<?xml version="1.0"?>
<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>

<xsl:stylesheet version='1.0' xmlns:xsl='http://www.w3.org/1999/XSL/Transform'>
  
  <xsl:output method="html" version="4" encoding="UTF-8"/>

  <xsl:include href="commonattributes.xsl"/>
  <xsl:include href="commonattributes-hidden.xsl"/>
  <xsl:include href="commonattributes-list.xsl"/>
  <xsl:include href="common-uielements.xsl"/>
  <xsl:include href="commonimages.xsl"/>
  <xsl:include href="search-template.xsl"/>
  <xsl:include href="search-images.xsl"/>
  <xsl:include href="commonjavascript.xsl"/>
  <xsl:include href="context.xsl"/>
  <xsl:include href="css-select.xsl"/>


  <!--
  *******************************************************************************
  * Core of the template stylesheet addtogroup-popup.xsl
  *******************************************************************************
  -->
  <xsl:template match="/">
    <xsl:variable name="selectedBook" select="/xslui/iab/booklist/book[entry/@entryID = /xslui/iab/pagedsearch/searchresult/@bookid]"/>
    <html>
      <head>
        <title>
          <xsl:text>_iPlanet Address Book - Add to Group</xsl:text>
        </title>
        <link type="text/css" rel="stylesheet" href="{$commonCSS.css}"/> 

        <xsl:call-template name="styleSheetSelector">
          <xsl:with-param name="htmlprefs" select="/xslui/profileinfo/xmlprofile/htmlprefs"/>     
        </xsl:call-template>
        <xsl:call-template name="fontMaker">
          <xsl:with-param name="htmlprefs" select="/xslui/profileinfo/xmlprofile/htmlprefs"/>     
        </xsl:call-template>
        <script language="javascript" src="../absjs/common.js"/>
        <script language="Javascript">
          <xsl:call-template name="commonjavascript"/>
          <xsl:call-template name="search-popup-javascript"/>
          function cancel() {
            document.iabform.stopsearch.value = "1";
            goToUsingForm('closesearchpopup.xml');
          }

          function addToGroup(alreadyAdded, id, text) {
            memberOf  = eval("window.opener.document.iabform."+window.opener.document.iabform.prefix.value+"memberOfPIGroup");
            idsToAdd  = window.opener.document.iabform.idstoadd;
            if (memberOf != null) {
              if (alreadyAdded[id] == null) {
                if ((memberOf.options.length == 1) &#38;&#38; (memberOf.options[0].value == "")) memberOf.options.length --;
                memberOf.options.length++;
                memberOf.options[memberOf.options.length-1].value = id;
                memberOf.options[memberOf.options.length-1].text  = text;
                alreadyAdded[id] = "1";
              }
            }
          }

          function buildHashTableFromSelected(hash, checkBoxName, fieldName)
          {
            var selectedTable = eval("document.iabform."+checkBoxName);
            var nbEntries = selectedTable.length;
            var selectedEntry = null;
            if (nbEntries != null) {
              selectedEntry = selectedTable[0];
            }
            else {
              nbEntries = 1;
              selectedEntry = selectedTable;
            }
            for (var i = 0;i &lt; nbEntries; i++) {
              if (nbEntries == 1)
                selectedEntry = selectedTable;
              else
                selectedEntry = selectedTable[i];

              if (selectedEntry.checked) {
                obj = document.iabform["id_" + selectedEntry.value + "_" + fieldName];
                if (obj != null) {
                  if ((obj.length != null) &amp;&amp; (obj.length > 0)) {
                    hash[selectedEntry.value] = obj[0].value;
                  }
                  else
                    hash[selectedEntry.value] = obj.value;
                }
                else 
                  hash[selectedEntry.value] = "";
              }
            }
          }

          function ok() {
            accept();
            document.iabform.stopsearch.value = "1";
            <!-- Seems to be mandatory to avoid a bug with IE local XSLT transformation -->
            timerID = setTimeout("goToUsingForm('closesearchpopup.xml')", 2000);
          }

        </script>
        <xsl:call-template name="search-template-javascript"/>
      </head>

      <body leftmargin="0" topmargin="0" rightmargin="0" marginwidth="0" marginheight="0" >

      <form method="post" name="iabform" action="">
        <xsl:call-template name="contextKeeper">
          <xsl:with-param name="pagedSearch" select="/xslui/iab/pagedsearch"/>
        </xsl:call-template>

        <table width="100&#37;" cellspacing="0" cellpadding="0" border="0">
          <tr class="first-strip"> 
            <td>
              <img src="{$spacer.gif}" width="1" height="6"/>
            </td>
          </tr>
          <tr> 
            <td>
              <img src="{$spacer.gif}" width="1" height="12"/>
            </td>
          </tr>
          <tr> 
            <td>
              <table border="0" cellspacing="0" cellpadding="0">
                <tr>
                  <td width="17">
                    <img src="{$spacer.gif}" width="7" height="1"/>
                  </td>
                  <td>
                    <b class="large-font">Add to Group</b>
                  </td>
                </tr>
              </table>
            </td>
          </tr>
          <tr>
            <td>
              <img src="{$spacer.gif}" width="1" height="12"/>
            </td>
          </tr>
          <tr class="first-strip">
            <td>
              <img src="{$spacer.gif}" width="1" height="6"/>
            </td>
          </tr>
          <tr class="fourth-strip">
            <td> 
              <table border="0" cellspacing="0" cellpadding="0">
                <tr> 
                  <td width="17">
                    <img src="{$spacer.gif}" width="17" height="1"/>
                  </td>
                  <td class="areatitle">Group List</td>
                </tr>
              </table>
            </td>
          </tr>
          <tr class="second-strip"> 
            <td>
              <img src="{$spacer.gif}" width="1" height="6"/>
            </td>
          </tr>
          <tr>
            <td> 
              <table border="0" cellspacing="0" cellpadding="0" width="100&#37;">
                <tr class="second-strip"> 
                  <td width="2&#37;" height="25">&nbsp;</td>
                  <td width="10&#37;" align="center">
                    <p class="colheader">
                      <xsl:text>_Select</xsl:text>
                    </p>
                  </td>
                  <td width="2&#37;">&nbsp;</td>
                  <td width="30&#37;">
                    <p class="colheader">
                      <xsl:text>_Name</xsl:text>
                    </p>
                  </td>
                  <td width="2&#37;">&nbsp;</td>
                  <td width="50&#37;">
                    <p class="colheader">
                      <xsl:text>_Description</xsl:text>
                    </p>
                  </td>
                  <td width="4&#37;">&nbsp;</td>
                </tr>
                <tr class="fourth-strip"> 
                  <td colspan="7">
                    <img src="{$spacer.gif}" width="1" height="1"/>
                  </td>
                </tr>

                <tr> 
                  <td height="28">&nbsp;</td>
                  <td>&nbsp;</td>
                  <td>&nbsp;</td>
                  <td colspan="3"> 
                    <table border="0" cellspacing="0" cellpadding="0">
                      <tr> 
                        <td>
                          <img src="{$cur_addr_book_24.gif}" width="19" height="21">
                            <xsl:attribute name="alt">
                              <xsl:value-of select="$selectedBook/entry/displayname" /> 
                            </xsl:attribute> 
                          </img>
                        </td>
                        <td width="5">&nbsp;</td>
                        <td>
                          <p class="bold">
                            <xsl:value-of select="$selectedBook/entry/displayname" />
                          </p>
                        </td>
                      </tr>
                    </table>
                  </td>
                  <td>&nbsp;</td>
                </tr>

                <xsl:for-each select="/xslui/iab/pagedsearch/searchresult/group">
                  <xsl:variable name="rowClass">
                    <xsl:choose>
                      <xsl:when test="position() mod 2 = 0">
                        <xsl:text>third-strip</xsl:text>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:text>white-strip</xsl:text>
                      </xsl:otherwise>
                    </xsl:choose> 
                  </xsl:variable>      
                  
                  <tr class="{$rowClass}"> 
                    <td colspan="7">
                      <img src="{$spacer.gif}" width="1" height="6"/>
                    </td>
                  </tr>
                  <tr class="{$rowClass}"> 
                    <td height="30">&nbsp;</td>
                    <xsl:call-template name="displaySelect"/>
                    <td>&nbsp;</td>
                    <td>
                      <span class="normal">
                        <xsl:value-of select="entry/displayname"/>
                      </span>
                    </td>
                    <td>&nbsp;</td>
                    <td>
                      <span class="normal">
                        <xsl:value-of select="entry/description"/>&nbsp;
                      </span>
                    </td>
                    <td>&nbsp;</td>
                  </tr>
                </xsl:for-each> 

              </table>
            </td>
          </tr>
          <tr class="fourth-strip"> 
            <td colspan="9">
              <img src="{$spacer.gif}" width="1" height="1"/>
            </td>
          </tr>
          <tr class="second-strip"> 
            <td colspan="9">
              <img src="{$spacer.gif}" width="1" height="18"/>
            </td>
          </tr>
          <tr class="first-strip"> 
            <td colspan="9">
              <img src="{$spacer.gif}" width="1" height="2"/>
            </td>
          </tr>
          <tr>
            <td colspan="9">
              <img src="{$spacer.gif}" width="1" height="14"/>
            </td>
          </tr>
          <tr>
            <td colspan="9">
              <xsl:call-template name="ok-cancel-help-bar"/>
            </td>
          </tr>
        </table>
        <xsl:apply-templates select="/xslui/iab/pagedsearch/searchresult/group" mode="hidden"/>
        
      </form>
      </body>
    </html>
  </xsl:template>


  <!--
*******************************************************************************
* This template displays the check mark for the already selected items in the list
*******************************************************************************
-->
<xsl:template name="displaySelect">
  <xsl:variable name="id" select="entry/@entryID" />

  <td align="center">
    <xsl:choose>
      <xsl:when test="/xslui/iab/alreadymembers/entry[@entryID = $id]">
        <img src="{$checkmark_skinny.gif}" width="12" height="18">
          <xsl:attribute name="alt">
            <xsl:text>_Already in group</xsl:text>
          </xsl:attribute>
        </img>
      </xsl:when>
      <xsl:otherwise>
        <input name="selectedentry">
          <xsl:attribute name="type">
            <xsl:choose>
              <xsl:when test="/xslui/iab/entrycontext[@formentryname='select']/select">
                <xsl:value-of select="/xslui/iab/entrycontext[@formentryname='select']/select/@type" /> 
              </xsl:when>
              <xsl:otherwise>
                <xsl:value-of select="'checkbox'"/>
              </xsl:otherwise>
            </xsl:choose> 
          </xsl:attribute> 
          
          <xsl:attribute name="value">
            <xsl:value-of select="$id"/>
          </xsl:attribute>
        </input>
      </xsl:otherwise>
    </xsl:choose> 
  </td>
</xsl:template>


</xsl:stylesheet>