<?xml version="1.0"?>
<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>
<xsl:stylesheet version='1.0' xmlns:xsl='http://www.w3.org/1999/XSL/Transform'>
<xsl:output method="html" version="4" encoding="UTF-8"/>
<xsl:variable name="valueSeparator" select="';'"/>

<xsl:include href="banner.xsl"/>
<xsl:include href="commonimages.xsl"/>
<xsl:include href="commonattributes.xsl"/>
<xsl:include href="common-uielements.xsl"/>
<xsl:include href="commonjavascript.xsl"/>
<xsl:include href="commonattributes-hidden.xsl"/>
<xsl:include href="commonattributes-list.xsl"/>
<xsl:include href="errors.xsl"/>
<xsl:include href="search-template.xsl"/>
<xsl:include href="search-images.xsl"/>
<xsl:include href="css-select.xsl"/>

<xsl:template match="displayname" mode="print">
  <tr>
	<td class="IndexHeader" colspan="4" height="22" align="center">
		<span class="SectionHeader"> 
			<xsl:value-of select="."/>
        </span>
     </td>
  </tr>
  <tr> 
   <td colspan="4" height="5"></td>
  </tr>
</xsl:template>

<xsl:template match="displayname" mode="grpprint">
  <xsl:value-of select="."/>
</xsl:template>

<xsl:template match="email" mode="membergrpprint">
     (<xsl:value-of select="."/>)
  </xsl:template>

<xsl:template match="company" mode="print">
<tr> 
   <td width="5"></td>
   <td colspan="3"><font size="2"><xsl:text>_Company</xsl:text>&nbsp;<xsl:value-of select="."/></font></td>
</tr>
</xsl:template>

<xsl:template match="title" mode="print">
<tr> 
 <td width="5"></td>
   <td colspan="3"><font size="2"><xsl:text>_Title</xsl:text>&nbsp;<xsl:value-of select="."/></font></td>
</tr>
<tr> 
  <td colspan="4" height="5"></td>
</tr>
</xsl:template>

<xsl:template match="phone" mode="print">
  <td>&nbsp;</td>
  <td><xsl:attribute name="nowrap"/><font size="2"><xsl:value-of select="."/></font></td>
</xsl:template>
  
 <xsl:template match="email" mode="print">
     <td width="5">&nbsp;</td>
     <td><xsl:attribute name="nowrap"/><font size="2"><xsl:value-of select="."/></font></td>
 </xsl:template>

<xsl:template match="email" mode="grpprint">
     <td>&nbsp;</td>
     <td colspan="3"><xsl:value-of select="."/></td>
  </xsl:template>

 <xsl:template match="im" mode="print">
     <td colspan="3"><font size="2"><xsl:text>_IM Nickname</xsl:text>&nbsp;<xsl:value-of select="."/></font></td>
  </xsl:template>

<xsl:template match="urladdr" mode="print">
  <xsl:variable name="url">
    	<xsl:value-of select="."/>
  </xsl:variable>
  <xsl:choose>
   <xsl:when test="starts-with($url,'http:')">
      <xsl:value-of select="." />
   </xsl:when>
  <xsl:otherwise>
    <xsl:choose>
      <xsl:when test="starts-with($url,'https:')">
        <xsl:value-of select="." />
      </xsl:when>
  <xsl:otherwise>
  <xsl:text>http:&#47;&#47;</xsl:text>
      <xsl:value-of select="." />
  </xsl:otherwise>
  </xsl:choose>
  </xsl:otherwise>
  </xsl:choose>
 </xsl:template>

<xsl:template match="street" mode="print">
    <td>&nbsp;</td>
    <td>
    	<font size="2">
    		<xsl:value-of select="."/>
    	</font>
    </td>
  </xsl:template>

<xsl:template match="city" mode="print">
    <td>&nbsp;</td>
    <td>
    	<font size="2">
    		<xsl:value-of select="."/>
    	</font>
    </td>
  </xsl:template>

<xsl:template match="postalcode" mode="print">
    <td>&nbsp;</td>
    <td>
    	<font size="2">
    		<xsl:value-of select="."/>
    	</font>
    </td>
  </xsl:template>

<xsl:template match="state" mode="print">
    <td>&nbsp;</td>
    <td>
    	<font size="2">
    		<xsl:value-of select="."/>
    	</font>
    </td>
  </xsl:template>

<xsl:template match="country" mode="print">
	<td>&nbsp;</td>
    <td>
    	<font size="2">
    		<xsl:value-of select="."/>
    	</font>
    </td>
  </xsl:template>
  
<xsl:template match="description" mode="print">
<tr> 
  <td width="5"></td>
  <td colspan="3"><xsl:value-of select="."/></td>
</tr>
</xsl:template>

<xsl:template match="group" mode="print">
    <xsl:variable name="groupid">
    	<xsl:value-of select="entry/@entryID"/>
    </xsl:variable>
    <tr> 
      <td colspan="4" height="5"></td>
    </tr>
    <tr> 
     <td width="5"></td>
     <td colspan="3"><font size="2"><b><xsl:text>_Description</xsl:text></b></font></td>
    </tr>
    <xsl:apply-templates mode="print" select="entry/description"/>    
    <tr> 
     <td colspan="4" height="5"></td>
    </tr>
    <tr> 
     <td>&nbsp;</td>
     <td colspan="3"><font size="2"><b><xsl:text>_Email</xsl:text></b></font></td>
    </tr>
    <tr>
    	<xsl:apply-templates mode="print" select="email[@priority=1]"/>
    </tr>
    <tr> 
     <td colspan="4" height="5"></td>
    </tr>
    <tr> 
     <td>&nbsp;</td>
     <td colspan="3"><b><xsl:text>_Web Address</xsl:text></b></td>
     </tr>
     <tr>
        <td>&nbsp;</td>
        <td valign="top" colspan="3">
        	<xsl:apply-templates mode="print" select="weburl[@priority=1]/urladdr"/>
        </td>
     </tr>
    <tr>
       <td>&nbsp;</td>
       <td colspan="3"><b><xsl:text>_Members</xsl:text></b></td>
    </tr>
    <xsl:for-each select="/xslui/iab/simplesearch/searchresult/*">
    <xsl:choose>
    <xsl:when test="memberofgroup = $groupid">
	    <tr> 
	    	<td>&nbsp;</td>
	        <td colspan="3">&nbsp;
	    	<xsl:apply-templates mode="grpprint" select="entry/displayname"/>    
	    	<xsl:apply-templates mode="membergrpprint" select="email[@type='work']"/>
	    	</td>
	    </tr>
    </xsl:when>
    </xsl:choose>
    </xsl:for-each>
    <tr> 
     <td colspan="4" height="5"></td>
   </tr>
</xsl:template>

<xsl:template match="abperson" mode="print">
	<xsl:apply-templates mode="print" select="organization/company"/>
                  	 <xsl:apply-templates mode="print" select="organization/title"/>
                  	 <tr> 
                       <td>&nbsp;</td>
                          <td colspan="3"><font size="2"><b><xsl:text>_Phone</xsl:text></b></font></td>
                     </tr>
                     <tr>
                     	  <td>&nbsp;</td>
                          <td valign="top"> 
                            <table border="0" cellspacing="0" cellpadding="0">
                              <tr> 
        						<td><font size="2"><xsl:text>_(Primary)</xsl:text></font></td>
                        		<xsl:apply-templates mode="print" select="phone[@type='work']"/>
                     		  </tr>
                     		  <tr> 
        						<td><font size="2"><xsl:text>_Mobile</xsl:text></font></td>
                         		<xsl:apply-templates mode="print" select="phone[@type='mobile']"/>
                     		  </tr>
                     		  <tr> 
        						<td><font size="2"><xsl:text>_Home</xsl:text></font></td>
                          		<xsl:apply-templates mode="print" select="phone[@type='home']"/>
                     		  </tr>
                     		</table>
                   		  </td>
                   		  <td width="5">&nbsp;</td>
                          <td valign="top"> 
                          <table border="0" cellspacing="0" cellpadding="0">
                              <tr> 
        				         <td><font size="2"><xsl:text>_Fax</xsl:text></font></td>
                                 <xsl:apply-templates mode="print" select="phone[@type='fax']"/>
                              </tr>
                              <tr> 
        				         <td><font size="2"><xsl:text>_Pager</xsl:text></font></td>
                                 <xsl:apply-templates mode="print" select="phone[@type='pager']"/>
                              </tr>
                            </table>
                         </td>
                        </tr>
                        <tr> 
                          <td colspan="4" height="5"></td>
                        </tr>
                        <tr> 
                          <td>&nbsp;</td>
                          <td colspan="3"><font size="2"><b><xsl:text>_Email</xsl:text></b></font><font size="2"></font></td>
                        </tr>
                        <tr> 
                          <td>&nbsp;</td>
                          <td valign="top" colspan="3"> 
                            <table border="0" cellspacing="0" cellpadding="0">
                              <tr> 
                                <td><font size="2"><xsl:text>_(Primary)</xsl:text></font></td>
                        		<xsl:apply-templates mode="print" select="email[@type='work']"/>
 							  </tr>                       
                        	  <tr> 
                                <td><font size="2"><xsl:text>_Home</xsl:text></font></td>
                        		<xsl:apply-templates mode="print" select="email[@type='home']"/>
 							  </tr>
 							  <tr>
 							  	<xsl:apply-templates mode="print" select="im[@priority=1]"/>
 							  </tr>                      
							  </table>
                          </td>
                        </tr>
                        <tr> 
                          <td colspan="4" height="5"></td>
                        </tr>
                        <tr> 
                          <td>&nbsp;</td>
                          <td><font size="2"><b><xsl:text>_Work Address</xsl:text></b></font></td>
                          <td>&nbsp;</td>
                          <td><font size="2"><b><xsl:text>_Home Address</xsl:text></b></font></td>
                        </tr>
                        <tr>
                        	<xsl:apply-templates mode="print" select="postaladdress[@type='work']/street"/>
                        	<xsl:apply-templates mode="print" select="postaladdress[@type='home']/street"/>
                        </tr>
                        <tr>
                        	<xsl:apply-templates mode="print" select="postaladdress[@type='work']/city"/>
                        	<xsl:apply-templates mode="print" select="postaladdress[@type='home']/city"/>
                        </tr>
                        <tr>
                        	<xsl:apply-templates mode="print" select="postaladdress[@type='work']/state"/>
                        	<xsl:apply-templates mode="print" select="postaladdress[@type='home']/state"/>
                       </tr>
                       <tr>
                        	<xsl:apply-templates mode="print" select="postaladdress[@type='work']/country"/>
                        	<xsl:apply-templates mode="print" select="postaladdress[@type='home']/country"/>
                        </tr>
                        <tr>
                        	<xsl:apply-templates mode="print" select="postaladdress[@type='work']/postalcode"/>
                        	<xsl:apply-templates mode="print" select="postaladdress[@type='home']/postalcode"/>
                        </tr>
                        <tr> 
                          <td colspan="4" height="5"></td>
                        </tr>
                        <tr> 
                          <td>&nbsp;</td>
                          <td colspan="3"><b><font size="2"><xsl:text>_On-line Information</xsl:text></font></b></td>
                        </tr>
                        <tr> 
                        	<td>&nbsp;</td>
     						<td colspan="3"><font size="2"><xsl:text>_Web Address</xsl:text>&nbsp;<xsl:apply-templates mode="print" select="weburl[@priority=1]/urladdr"/>
                            </font>
                            </td>
                        </tr>
                        
                        <tr> 
                        	<td>&nbsp;</td>
     						<td colspan="3"><font size="2"><xsl:text>_Calendar Address</xsl:text>&nbsp;<xsl:apply-templates mode="print" select="calendar[@type='calendar']/urladdr"/>
                            </font>
                            </td>
                        </tr>
                        <tr> 
                        	<td>&nbsp;</td>
     						<td colspan="3"><font size="2"><xsl:text>_Availability Address</xsl:text>&nbsp;<xsl:apply-templates mode="print" select="calendar[@type='freebusy']/urladdr"/>
                            </font>
                            </td>
                        </tr>
                        <tr> 
                          <td>&nbsp;</td>
                          <td valign="top"> 
                            <table border="0" cellspacing="0" cellpadding="0">
 							</table>
                          </td>
                        </tr>
</xsl:template>


<!--
*******************************************************************************
* Core of the template stylesheet search.xsl
*******************************************************************************
-->
<xsl:template match="/">
<html>
<head>
<title>
  <xsl:text>_Print</xsl:text>
</title>

<script language="Javascript" src="../absjs/common.js"/><noscript></noscript>
<script language="Javascript" src="../absjs/contact.js"/><noscript></noscript>
<script language="Javascript" src="../absjs/integration.js"/><noscript></noscript>
<script language="Javascript" src="../absjs/define_images.js"/><noscript></noscript>
<xsl:call-template name="search-template-javascript"/>
<script src="../absjs/browserVersion.js"></script><noscript></noscript>
<script>      
self.focus();
    if (is_ie5up) // IE5
    {    
     document.write('&lt;link type="text/css" rel="stylesheet" href="../absimx/ab_css_ie5win.css"&gt;');
    }
    else if (is_gecko) // Netscape 6/7 or Mozilla
    {
      document.write('&lt;link type="text/css" rel="stylesheet" href="../absimx/ab_css_ns6up.css"&gt;');
    }
    else  // All others
    {
     document.write('&lt;link type="text/css" rel="stylesheet" href="../absimx/ab_css_ns6up.css"&gt;');
    }
</script><noscript></noscript>
<script language="Javascript">        
  <xsl:call-template name="commonjavascript"/>
  <xsl:call-template name="bannerScripts"/>
</script><noscript></noscript>
</head>
<!-- Body starting here -->

<body bgcolor="#FFFFFF" leftmargin="0" rightmargin="0" topmargin="0" marginheight="0" marginwidth="0">
<form method="post" name="iabform" action="abprnlist.xml" onsubmit="return false">
  <br/>
  <div align="center">
    <table width="100%" border="0" cellspacing="0" cellpadding="0">
      <tr>
        <td align="center"> 
          <table width="100%" border="0" cellspacing="0" cellpadding="4">
            <tr>
              <td class="SectionHeader" width="84%"><span class="SectionHeader"><xsl:value-of select="/xslui/iab/booklist/book[entry/@entryID=/xslui/iab/simplesearch/searchresult/@bookid]/entry/displayname" />&nbsp; 
                <xsl:text>_for</xsl:text>&nbsp;<xsl:value-of select="xslui/usersession/@displayname"/></span></td>
              <td class="SectionHeader" width="13%">
                <div align="right"><a class="toolbar-link" href="javascript: void(0)" onClick="window.close()"><xsl:text>_Close Window</xsl:text></a></div>
              </td>
              <td align="right" width="1%"><img src="{$spacer.gif}" width="10" height="1" alt=""/></td>
            </tr>
        </table>
   
  <table border="0" cellpadding="3" cellspacing="3" width="650">
 	<xsl:for-each select="/xslui/iab/simplesearch/searchresult/*">
 	<xsl:choose>
    	<xsl:when test="position() mod 2 != 0">
        	<xsl:text disable-output-escaping="yes" >&lt;tr&gt;</xsl:text>
        </xsl:when>
    </xsl:choose>
        	<td class="cardBorder" valign="top" width="325">
        	<table border="0" width="100%" cellspacing="0" cellpadding="0">
            	<tr>
                   <td>
                     <xsl:apply-templates mode="print" select="entry/displayname"/>
                     <xsl:apply-templates mode="print" select="."/>
               		</td>
               	   </tr>
               	 </table>
          </td>
        <xsl:choose>
    		<xsl:when test="position() mod 2 = 0">
        		<xsl:text disable-output-escaping="yes" >&lt;/tr&gt;</xsl:text>
        	</xsl:when>
    	</xsl:choose>
      </xsl:for-each> 
    </table>
   </td>
   </tr>
  </table>
  </div>
</form>
</body>
</html>
</xsl:template>

<!--
*******************************************************************************
* This prints the error messages on the search page
* @param err The error element from which to extract the error code
*******************************************************************************
-->
<xsl:template name="error-message">
  <xsl:param name="err" select="." />

  <xsl:text>_Unknown error (</xsl:text>
  <xsl:value-of select="$err/@errnum" /> 
  <xsl:text>)</xsl:text>
  <xsl:if test="$err/@rawmsg">
    <br/>
    <xsl:value-of select="$err/@rawmsg" />&nbsp;
  </xsl:if> 
</xsl:template> 

</xsl:stylesheet>
