<?xml version="1.0"?>
<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>

<xsl:stylesheet version='1.0' xmlns:xsl='http://www.w3.org/1999/XSL/Transform'>

  <xsl:output method="html" version="4" encoding="UTF-8"/>

  <xsl:include href="banner.xsl"/>
  <xsl:include href="common-uielements.xsl"/>
  <xsl:include href="commonattributes.xsl"/>
  <xsl:include href="commonjavascript.xsl"/>
  <xsl:include href="context.xsl"/>
  <xsl:include href="commonattributes-hidden.xsl"/>
  <xsl:include href="css-select.xsl"/>
  <xsl:include href="commonimages.xsl"/>


  <!--
  *******************************************************************************
  * Core of the template stylesheet search.xsl
  *******************************************************************************
  -->
  <xsl:template match="/">
    <html>
      <head>
        <title>
          <xsl:text>_iPlanet Address Book - Address books</xsl:text>
        </title>
        <xsl:call-template name="fontMaker">
          <xsl:with-param name="htmlprefs" select="/xslui/profileinfo/xmlprofile/htmlprefs"/>     
        </xsl:call-template>
        <link type="text/css" rel="stylesheet" href="{$commonCSS.css}"/> 

        <xsl:call-template name="styleSheetSelector">
          <xsl:with-param name="htmlprefs" select="/xslui/profileinfo/xmlprofile/htmlprefs"/>     
        </xsl:call-template>

        <script language="javascript" src="../absjs/common.js"/><noscript></noscript>
        <script language="javascript" src="../absjs/search.js"/><noscript></noscript>
        <script language="javascript" src="../absjs/entries.js"/><noscript></noscript>
        <script language="Javascript">
          <xsl:call-template name="commonjavascript"/>
          <xsl:call-template name="bannerScripts"/>
          function goBack() {
            goToUsingForm("search.xml")
          }
          function editAB(id) {
            document.iabform.entryid.value = unescape(id);
            document.iabform.bookid.value  = '<xsl:value-of select="/xslui/iab/booklist/book[@bookurl != ''][1]/entry/@entryID"/>';
            document.iabform.action        = 'editab.xml';
            submitForm('');
          }
        </script>
      </head>

      <body leftmargin="0" topmargin="0" rightmargin="0" marginwidth="0" marginheight="0" >

      <form method="post" name="iabform" action="search.xml">
        <input type="hidden" name="j_encoding" value="{/xslui/@charset}"/>
        <input type="hidden" name="uiaction" value=""/>
        <input type="hidden" name="entryid" value=""/>

        <xsl:call-template name="contextKeeper">
          <xsl:with-param name="pagedSearch" select="/xslui/iab/pagedsearch"/>
        </xsl:call-template>

        <xsl:call-template name="banner"/>

        <xsl:call-template name="contextBanner">
          <xsl:with-param name="text">
            <xsl:text>_Address Books</xsl:text>
          </xsl:with-param>
        </xsl:call-template>

        <table width="100&#37;" cellspacing="0" cellpadding="0" border="0">
          <tr class="second-strip"> 
            <td> 
              <table border="0" cellspacing="0" cellpadding="0">
                <tr> 
                  <td colspan="4">
                    <img src="{$spacer.gif}" width="1" height="6"/>
                  </td>
                </tr>

                <tr> 
                  <td width="17">
                    <img src="{$spacer.gif}" width="17" height="1"/>
                  </td>
                  <td align="center">
                    <a href="javascript:goToUsingForm('addab.xml')">
                      <img src="{$new_book.gif}" width="21" height="21" border="0">
                        <xsl:attribute name="alt">
                          <xsl:text>_New Address Book</xsl:text>
                        </xsl:attribute> 
                      </img>
                    </a>
                  </td>
                  <td width="17">
                    <img src="{$spacer.gif}" width="17" height="1"/>
                  </td>
                  <td align="center">
                    <a href="javascript:void(0)">
                      <img src="{$search_24.gif}" width="24" height="24" border="0">
                        <xsl:attribute name="alt">
                          <xsl:text>_Search for Address Book</xsl:text>                        
                        </xsl:attribute> 
                      </img>
                    </a>
                  </td>
                </tr>
                <tr> 
                  <td colspan="4">
                    <img src="{$spacer.gif}" width="1" height="6"/>
                  </td>
                </tr>
                <tr> 
                  <td>&nbsp;</td>
                  <td align="center">
                    <a href="javascript:goToUsingForm('addab.xml')" class="toolbar-link">
                      <xsl:text>_New Address Book</xsl:text>
                    </a>
                  </td>
                  <td>&nbsp;</td>
                  <td align="center">
                    <a href="" class="toolbar-link">
                      <xsl:text>Search for Address Book</xsl:text>
                    </a>
                  </td>
                </tr>
                <tr> 
                  <td colspan="4">
                    <img src="{$spacer.gif}" width="1" height="6"/>
                  </td>
                </tr>
              </table>
            </td>
          </tr>
          <xsl:apply-templates select="/xslui/errormessages/error" mode="plain" />  
          <tr>
            <td align="center">
              <xsl:call-template name="close-help-bar"/>
            </td>
          </tr>
          <tr class="first-strip"> 
            <td>
              <img src="{$spacer.gif}" width="1" height="4"/>
            </td>
          </tr>
        </table>

        <table width="100&#37;" cellspacing="0" cellpadding="0" border="0">
          <tr class="second-strip"> 
            <td width="17">
              <img src="{$spacer.gif}" width="17" height="25"/>
            </td>
            <td>
              <p class="label">
                <xsl:text>_Name</xsl:text>
              </p>
            </td>
            <td width="10">
              <img src="{$spacer.gif}" width="10" height="25"/>
            </td>
            <td>
              <p class="label">
                <xsl:text>Description</xsl:text>
              </p>
            </td>
            <td width="5">
              <img src="{$spacer.gif}" width="5" height="25"/>
            </td>
            <td>&nbsp;</td>
            <td width="10">
              <img src="{$spacer.gif}" width="10" height="25"/>
            </td>
            <td>&nbsp;</td>
            <td width="17">
              <img src="{$spacer.gif}" width="17" height="25"/>
            </td>
          </tr>
          <tr> 
            <td colspan="9" class="fourth-strip">
              <img src="{$spacer.gif}" width="1" height="1"/>
            </td>
          </tr>
          <xsl:for-each select="/xslui/iab/booklist/book">
            <xsl:variable name="rowClass">
              <xsl:choose>
                <xsl:when test="position() mod 2 = 0">
                  <xsl:text>third-strip</xsl:text>
                </xsl:when>
                <xsl:otherwise>
                  <xsl:text>white-strip</xsl:text>
                </xsl:otherwise>
              </xsl:choose> 
            </xsl:variable> 
            
            <xsl:variable name="bgColorIndex">
              <xsl:choose>
                <xsl:when test="position() mod 2 = 0">
                  <xsl:value-of select="'h'" /> 
                </xsl:when>
                <xsl:otherwise>
                  <xsl:value-of select="'w'" /> 
                </xsl:otherwise>
              </xsl:choose> 
            </xsl:variable> 
            <tr class="{$rowClass}"> 
              <td height="25">&nbsp;</td>
              <td>
                <a class="pagelink" target="_top">
                  <xsl:attribute name="href">javascript:switchBook(&apos;<xsl:value-of select="entry/@entryID"/>&apos;)</xsl:attribute> 
                  <xsl:value-of select="entry/displayname" /> 
                </a>
              </td>
              <td>&nbsp;</td>
              <td>
                <span class="normal">
                  <xsl:call-template name="break-new-lines">
                    <xsl:with-param name="text" select="entry/description"/>
                  </xsl:call-template>&nbsp;
                </span>
              </td>
              <td>&nbsp;</td>
              <td> 
                <xsl:call-template name="button">
                  <xsl:with-param name="label">
                    <xsl:text>_Edit</xsl:text>
                  </xsl:with-param>
                  <xsl:with-param name="href">javascript:editAB('<xsl:value-of select="entry/@entryID"/>')</xsl:with-param> 
                  <xsl:with-param name="bgColorIndex" select="$bgColorIndex"/>
                </xsl:call-template>
              </td>
              <td>&nbsp;</td>
              <td> 
                <xsl:choose>
                  <xsl:when test="./@bookremoteurl">
                    <xsl:call-template name="button">
                      <xsl:with-param name="label">
                        <xsl:text>_Unsubscribe</xsl:text>
                      </xsl:with-param>
                      <xsl:with-param name="href">javascript:unsubscribe('<xsl:value-of select="entry/@entryID"/>','<xsl:value-of select="/xslui/iab/profileinfo/xmlprofile/defaultbook/@bookid"/>')</xsl:with-param> 
                      <xsl:with-param name="bgColorIndex" select="$bgColorIndex"/>
                    </xsl:call-template>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:call-template name="button">
                      <xsl:with-param name="label">
                        <xsl:text>_Delete</xsl:text>
                      </xsl:with-param>
                      <xsl:with-param name="href">javascript:deleteAB('<xsl:value-of select="entry/@entryID"/>','<xsl:value-of select="/xslui/iab/profileinfo/xmlprofile/defaultbook/@bookid"/>')</xsl:with-param> 
                      <xsl:with-param name="bgColorIndex" select="'disabled-button'"/>
                      <xsl:with-param name="bgColorIndex" select="$bgColorIndex"/>
                    </xsl:call-template>
                  </xsl:otherwise>
                </xsl:choose> 
              </td>
              <td>&nbsp;</td>
            </tr>
          </xsl:for-each> 
          <tr class="fourth-strip"> 
            <td colspan="9">
              <img src="{$spacer.gif}" width="1" height="1"/>
            </td>
          </tr>
          <tr class="second-strip"> 
            <td colspan="9">
              <img src="{$spacer.gif}" width="1" height="18"/>
            </td>
          </tr>
          <tr class="first-strip"> 
            <td colspan="9">
              <img src="{$spacer.gif}" width="1" height="2"/>
            </td>
          </tr>
        </table>
        <xsl:for-each select="/xslui/iab/alreadyselected/*">
          <input type="hidden" name="selectedentry" value="{entry/@entryID}"/>
        </xsl:for-each>

        <xsl:apply-templates select="/xslui/iab/alreadyselected" mode="hidden"/>

      </form>
      </body>
    </html>
  </xsl:template>
  <!--
  *******************************************************************************
  * This prints the error messages on the search page
  * @param err The error element from which to extract the error code
  *******************************************************************************
  -->
  <xsl:template name="error-message">
    <xsl:param name="err" select="." />

    <xsl:choose>
      <xsl:when test="$err/@errnum='274'">
        <xsl:text>_There was an database error while trying to delete address book</xsl:text>
      </xsl:when> 
      <xsl:when test="$err/@errnum='275'">
        <xsl:text>_There was an unknown error while trying to delete address book</xsl:text>      	
      </xsl:when> 
      <xsl:when test="$err/@errnum='276'">
        <xsl:text>_The book was not found in the database: incorrect book ID</xsl:text>      	
      </xsl:when> 
      <xsl:otherwise>
        <xsl:text>_Unknown error (</xsl:text>
        <xsl:value-of select="$err/@errnum" /> 
        <xsl:text>)</xsl:text>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:if test="$err/@rawmsg">
      <br/>
      <xsl:value-of select="$err/@rawmsg" />&nbsp;
    </xsl:if> 
  </xsl:template> 
</xsl:stylesheet>
