<?xml version="1.0"?>
<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>

<xsl:stylesheet version='1.0' xmlns:xsl='http://www.w3.org/1999/XSL/Transform'>

<xsl:output method="text" encoding="UTF-8" omit-xml-declaration="yes"/>

<!--
*******************************************************************************
* This template formats an exports an address book in a ldif format.
*******************************************************************************
-->
<xsl:template match="/">
  <xsl:variable name="user-lang">
    <xsl:text>_languagepath</xsl:text>
  </xsl:variable>    
  <xsl:for-each select="/searchresult/abperson">
    <xsl:text>BEGIN:VCARD</xsl:text>
    <xsl:text>&#xA;</xsl:text>
    <xsl:text>VERSION:2.1</xsl:text>
    <xsl:text>&#xA;</xsl:text>    
    <xsl:text>FN</xsl:text>
    <xsl:text>:</xsl:text>
    <xsl:value-of select="entry/displayname"/>
    <xsl:text>&#xA;</xsl:text>
    <xsl:text>N:</xsl:text>
    <xsl:value-of select="person/surname"/>
    <xsl:text>;</xsl:text>
    <xsl:value-of select="person/givenname"/>
    <xsl:text>;</xsl:text>
    <xsl:value-of select="person/middlename"/>
    <xsl:text>&#xA;</xsl:text>
    <xsl:if test="organization/company">
      <xsl:text>ORG:</xsl:text>
      <xsl:value-of select="organization/company"/>
      <xsl:text>&#xA;</xsl:text>
    </xsl:if>
    <xsl:if test="organization/title">
      <xsl:text>TITLE:</xsl:text>
      <xsl:value-of select="organization/title"/>
      <xsl:text>&#xA;</xsl:text>
    </xsl:if>    
    <xsl:if test="phone[@type='work']">
      <xsl:text>TEL;WORK;VOICE:</xsl:text>
      <xsl:value-of select="phone[@type='work']"/>
      <xsl:text>&#xA;</xsl:text>
    </xsl:if>
    <xsl:if test="phone[@type='home']">
      <xsl:text>TEL;HOME;VOICE:</xsl:text>
      <xsl:value-of select="phone[@type='home']"/>
      <xsl:text>&#xA;</xsl:text>
    </xsl:if>
    <xsl:if test="phone[@type='mobile']">
      <xsl:text>TEL;CELL;VOICE:</xsl:text>
      <xsl:value-of select="phone[@type='mobile']"/>
      <xsl:text>&#xA;</xsl:text>
    </xsl:if>
    <xsl:if test="phone[@type='pager']">
      <xsl:text>TEL;PAGER;VOICE:</xsl:text>
      <xsl:value-of select="phone[@type='pager']"/>
      <xsl:text>&#xA;</xsl:text>
    </xsl:if>
    <xsl:if test="phone[@type='fax']">
    <xsl:text>TEL;WORK;FAX:</xsl:text>
      <xsl:value-of select="phone[@type='fax']"/>
      <xsl:text>&#xA;</xsl:text>
    </xsl:if>
    <xsl:if test="person/date[@type='anniversary']">
      <xsl:text>ANNIVERSARYDATE:</xsl:text>
      <xsl:value-of select="person/date[@type='anniversary']"/>
      <xsl:text>&#xA;</xsl:text>
    </xsl:if> 
    <xsl:if test="person/date[@type='birthday']"> 
      <xsl:text>BDAY:</xsl:text>
      <xsl:value-of select="person/date[@type='birthday']"/>
      <xsl:text>&#xA;</xsl:text>
    </xsl:if>
    <xsl:if test="email[@priority='1']">
      <xsl:text>EMAIL;PREF;INTERNET:</xsl:text>
      <xsl:value-of select="email[@priority='1']"/>
      <xsl:text>&#xA;</xsl:text>
      <xsl:text>X-EMAIL-PREF-TYPE:</xsl:text>
      <xsl:value-of select="email[@priority='1']/@type"/>
      <xsl:text>&#xA;</xsl:text>
    </xsl:if>
    <xsl:if test="email[@priority='2']">
      <xsl:text>EMAIL;INTERNET;PREF1:</xsl:text>
      <xsl:value-of select="email[@priority='2']"/>
      <xsl:text>&#xA;</xsl:text>
      <xsl:text>X-EMAIL-2-TYPE:</xsl:text>
      <xsl:value-of select="email[@priority='2']/@type"/>
      <xsl:text>&#xA;</xsl:text>
    </xsl:if>
    <xsl:if test="email[@priority='3']">
      <xsl:text>EMAIL;INTERNET;PREF2:</xsl:text>
      <xsl:value-of select="email[@priority='3']"/>
      <xsl:text>&#xA;</xsl:text>
      <xsl:text>X-EMAIL-3-TYPE:</xsl:text>
      <xsl:value-of select="email[@priority='3']/@type"/>
      <xsl:text>&#xA;</xsl:text>
    </xsl:if>
    <xsl:if test="postaladdress[@type='home']">
      <xsl:text>ADR;HOME:;;</xsl:text>
      <xsl:value-of select="postaladdress[@type='home']/street"/>
      <xsl:text>;</xsl:text>
      <xsl:value-of select="postaladdress[@type='home']/city"/>
      <xsl:text>;</xsl:text>
      <xsl:value-of select="postaladdress[@type='home']/state"/>
      <xsl:text>;</xsl:text>
      <xsl:value-of select="postaladdress[@type='home']/postalcode"/>
      <xsl:text>;</xsl:text>
      <xsl:value-of select="postaladdress[@type='home']/country"/>
      <xsl:text>&#xA;</xsl:text>
    </xsl:if>
    <xsl:if test="postaladdress[@type='work']">
      <xsl:text>ADR;WORK:;;</xsl:text>
      <xsl:value-of select="postaladdress[@type='work']/street"/>
      <xsl:text>;</xsl:text>
      <xsl:value-of select="postaladdress[@type='work']/city"/>
      <xsl:text>;</xsl:text>
      <xsl:value-of select="postaladdress[@type='work']/state"/>
      <xsl:text>;</xsl:text>
      <xsl:value-of select="postaladdress[@type='work']/postalcode"/>
      <xsl:text>;</xsl:text>
      <xsl:value-of select="postaladdress[@type='work']/country"/>
      <xsl:text>&#xA;</xsl:text>
    </xsl:if>
    <xsl:if test="entry/description">
      <xsl:text>NOTE:</xsl:text>
      <xsl:value-of select="entry/description"/>
      <xsl:text>&#xA;</xsl:text>
    </xsl:if>
    <xsl:if test="weburl[@priority='1']/urladdr">
      <xsl:text>URL;HOME:</xsl:text>
      <xsl:value-of select="weburl[@priority='1']/urladdr"/>
      <xsl:text>&#xA;</xsl:text>
    </xsl:if>
    <xsl:if test="weburl[@priority='2']/urladdr">
      <xsl:text>URL;WORK:</xsl:text>
      <xsl:value-of select="weburl[@priority='2']/urladdr"/>
      <xsl:text>&#xA;</xsl:text>
    </xsl:if>
    <xsl:if test="im[@priority='1']">
      <xsl:text>X-IMADDR1:</xsl:text>
      <xsl:value-of select="im[@priority='1']"/>
      <xsl:text>&#xA;</xsl:text>
      <xsl:text>X-IMSERVICE1:</xsl:text>
      <xsl:value-of select="im[@priority='1']/@service"/>
      <xsl:text>&#xA;</xsl:text>
    </xsl:if>    
    <xsl:if test="im[@priority='2']">
      <xsl:text>X-IMADDR2:</xsl:text>
      <xsl:value-of select="im[@priority='2']"/>
      <xsl:text>&#xA;</xsl:text>
      <xsl:text>X-IMSERVICE2:</xsl:text>
      <xsl:value-of select="im[@priority='2']/@service"/>
      <xsl:text>&#xA;</xsl:text>
    </xsl:if>
    <xsl:if test="calendar[@type='calendar']">
      <xsl:text>CALURI:</xsl:text>
      <xsl:value-of select="calendar[@type='calendar']"/>
      <xsl:text>&#xA;</xsl:text>
    </xsl:if>
    <xsl:if test="calendar[@type='freebusy']">
      <xsl:text>FBURL:</xsl:text>
      <xsl:value-of select="calendar[@type='freebusy']"/>
      <xsl:text>&#xA;</xsl:text>
    </xsl:if>
    <xsl:text>END:VCARD</xsl:text>
    <xsl:text>&#xA;</xsl:text>
    <xsl:text>&#xA;</xsl:text>
  </xsl:for-each>
</xsl:template>
</xsl:stylesheet>
