#!/bin/sh

# Copyright 12/23/04 Sun Microsystems, Inc. All Rights Reserved.
#pragma ident "@(#)gui-archivetool-functions.sh	1.41 04/12/23 Sun Microsystems"

######################################################
# Gloabal functions
# The file is sourced by all gui Wizard backend scripts
# 
######################################################


# Performs same job as getSourceDirectoryAndVersion
# It takes inputs from tmpGUI.properties instead of user

getSourceDirectoryAndVersionFromFile()
{
	AUTOCONFIG_RUNFILE1="$AGENT_UPDATE_DIR/tmpGUI.properties"
	SRC_DIR=`getAutoConfig1 "SRC_DIR"`
        # Evaluate the string to remove additional chars addded by GUI 
        # in the properties file to take care of special characters
        # SRC_DIR=`$CMD_ECHO "$SRC_DIR" | $CMD_SED -e 's/\\\//g'`
        SRC_DIR=`eval $CMD_ECHO "$SRC_DIR"`
	SOURCE_IMAGE=`getAutoConfig1 "SOURCE_IMAGE"`
        if [ "$SOURCE_IMAGE" = "DEFAULT" ] ; then
            LOCALE_CONFIG_FILE="$SRC_DIR/${BASE_PRODUCT_DIR}/.locales"
        fi

}

# Performs same job as getRemoteTargetDirectory
# It takes inputs from tmpGUI.properties instead of user

getRemoteTargetDirectoryFromFile()
{
	AUTOCONFIG_RUNFILE1="$AGENT_UPDATE_DIR/tmpGUI.properties"
	TARGET_DIR=`getAutoConfig1 "TARGET_DIR"`
	REMOTE_TARGET_DIR=`getAutoConfig1 "REMOTE_TARGET_DIR"`
}

# gets the locales to be archived from file

getLocalesFromFile()
{
	AUTOCONFIG_RUNFILE1="$AGENT_UPDATE_DIR/tmpGUI.properties"
	INSTALL_LOCALES=`getAutoConfig1 "INSTALL_LOCALES"`
}

# Performs same job as getArchiveTargetDirectory
# It takes inputs from tmpGUI.properties instead of user

getArchiveTargetDirectoryFromFile()
{
	AUTOCONFIG_RUNFILE1="$AGENT_UPDATE_DIR/tmpGUI.properties"
	TARGET_DIR=`getAutoConfig1 "TARGET_DIR"`
	ARCHIVE_TARGET_DIRNAME=`getAutoConfig1 "ARCHIVE_TARGET_DIRNAME"`
        $CMD_MKDIR -p $TARGET_DIR
        echolog 'Product images will be created in: $2' "$TARGET_DIR"
        echolog ''
        echolog '$2' "$SCREEN_LINE"
        echolog ''
        TARGET_DIR_WITHOUT_RELOC="$ORIGINAL_TARGET_DIR"
        TARGET_DIR_WITH_RELOC="$TARGET_DIR"
}

# sets the policy file variable
# The base policy section is not really used anymore

getPolicyFileNamesFromFile()
{
	AUTOCONFIG_RUNFILE1="$AGENT_UPDATE_DIR/tmpGUI.properties"

        BASE_POLICY_FILE=`getAutoConfig1 "BASE_POLICY_FILE"`
        
	tmp_file=`$CMD_BASENAME "$BASE_POLICY_FILE"`

        tmp_ext=`$CMD_ECHO "$tmp_file" | $CMD_CUT -d. -f2`
        [ "$tmp_ext" != "xml" ] && BASE_POLICY_FILE="${BASE_POLICY_FILE}.xml"
        BASE_POLICY_FILE_NAME=`$CMD_BASENAME "$BASE_POLICY_FILE"`

        UPGRADE_POLICY_FILE="$SMART_UPDATE_DIR/upgrade-policy.xml"

        tmp_file=`$CMD_BASENAME "$UPGRADE_POLICY_FILE"`

        tmp_ext=`$CMD_ECHO "$tmp_file" | $CMD_CUT -d. -f2`
        [ "$tmp_ext" != "xml" ] && UPGRADE_POLICY_FILE="${UPGRADE_POLICY_FILE}.x
ml"
        UPGRADE_POLICY_FILE_NAME=`$CMD_BASENAME "$UPGRADE_POLICY_FILE"`

        $API_CREATE_DOC $BASE_POLICY_FILE base-policy 2>/dev/null
        $API_CREATE_DOC $UPGRADE_POLICY_FILE upgrade-policy 2>/dev/null

        $API_INSERT_TAG $UPGRADE_POLICY_FILE products=SunMC 2>/dev/null
}


#########Begin Section 1 ###################################################
#
# This section defines some functions to go through all the
# available or selected product keys under selected OS version directories
# and make a unique list to be presented on the GUI selection panel
#
#####

getUniqAvailableKeysWithNames()
{
	TMP_NAMELIST=""
	for each_key in `$CMD_ECHO "$UNIQ_AVAILABLE_KEYS" | $CMD_AWK -F ' ' '{ for (i = 1; i <= NF; i++) print $i }'`
	do
	    for TMP_OS in `$CMD_ECHO "$SELECTED_OS" | $CMD_AWK -F ',' '{ for (i = 1; i<= NF; i++) print $i }'`
	    do
		resetSourceList $TMP_OS
		TMP_NAME=`getProductAttr "$SOURCE_LIST" "$each_key" "NAME"`
		if [ ! -z "$TMP_NAME" ]; then
		    TMP_NAMELIST="$TMP_NAMELIST@${each_key}:${TMP_NAME}"
		    break
		fi
	    done
	done

	$CMD_ECHO "$TMP_NAMELIST"
}

saveUniqOptionalComponentsWithNames()
{
    OLD_AUTOCONFIG_SAVEFILE1="$AUTOCONFIG_SAVEFILE1"

    AUTOCONFIG_SAVEFILE1="$AGENT_UPDATE_DIR/opt_comp.properties"
    ALL_OPTIONAL_COMPONENTS_NOSPACE=`$CMD_ECHO "$ALL_OPTIONAL_COMPONENTS" | $CMD_SED "s/ /%/g"`

    for each_string in `$CMD_ECHO "$ALL_OPTIONAL_COMPONENTS_NOSPACE" | $CMD_AWK -F '@' '{ for(i=1; i<=NF; i++) print $(i) }'`
    do
	product_key=`$CMD_ECHO "$each_string" | $CMD_CUT -d# -f1 | $CMD_CUT -d= -f2`
	TMP_SRCDIR=`getProductAttr "$SOURCE_LIST" "$product_key" "SOURCE_DIR"`
	TMP_FILE="${SRC_DIR}/Addons/${TMP_SRCDIR}/Solaris_$OSVERS/installation.properties"
	components=`$CMD_ECHO "$each_string" | $CMD_CUT -d# -f2 | $CMD_CUT -d= -f2`
	for each_component in `$CMD_ECHO "$components" | $CMD_AWK -F '%' '{ for(i=1; i<=NF; i++) print $(i) }'`
	do
	    if [ ! -z "$each_component" -a "$each_component" != " " ]; then
		TMP_NAME=`getProperty "$each_component" "$TMP_FILE"`
		saveAutoConfig1 "$each_component" "$TMP_NAME"
	    fi
	done
    done

    AUTOCONFIG_SAVEFILE1="$OLD_AUTOCONFIG_SAVEFILE1"
	
}

getUniqOptionalPackages()
{
	GUI_TMP_PKGLIST=""
		
	for each_key in `$CMD_ECHO "$UNIQ_AVAILABLE_KEYS" | $CMD_AWK -F ' ' '{ for (i = 1; i <= NF; i++) print $i }'`
	do
	    opt_pkg=""
	    tmp_opt_pkg=""
	    comp_list=`getProductAttr "$SOURCE_LIST" "$each_key" "ALL_COMPONENTS"`
	    for each_comp_list in `$CMD_ECHO "$comp_list" | $CMD_AWK -F ' ' '{ for (i = 1; i <= NF; i++) print $i }'`
	    do
	   	tmp_opt_pkg=`$CMD_ECHO "$each_comp_list" | $CMD_CUT -d: -f4`
	   	tmp_comp=`$CMD_ECHO "$each_comp_list" | $CMD_CUT -d: -f1`
		[ ! -z "$tmp_opt_pkg" ] && opt_pkg="${tmp_comp}%${tmp_opt_pkg},$opt_pkg"
	    done
	    [ ! -z "$opt_pkg" ] && GUI_TMP_PKGLIST="$GUI_TMP_PKGLIST@$each_key:$opt_pkg"
	done

	$CMD_ECHO "$GUI_TMP_PKGLIST"
}

#########  End Section 1 ###################################################


#########Begin Section 2 ###################################################
#
# This section defines some functions that will save or restore
# all global and environment variables into or from files.
# This should be done between intermediate stages of Wizard.
# When one back end script completes it's operations and 
# user inputs have to be taken at the GUI level.
# Or When necessary user inputs have been taken and a back end
# script should be started 
#####

saveAllVariables()
{
AUTOCONFIG_SAVEFILE1="$AGENT_UPDATE_DIR/tmpGUI.properties"
/bin/rm -rf $AUTOCONFIG_SAVEFILE1

saveAutoConfig1 "AGENT_UPDATE_DIR" "$AGENT_UPDATE_DIR"
saveAutoConfig1 "PROGNAME" "$PROGNAME"

saveAutoConfig1 "PREV_DIR" "$PREV_DIR"
saveAutoConfig1 "SCRIPT_DIR" "$SCRIPT_DIR"
saveAutoConfig1 "TOOLS_DIR" "$TOOLS_DIR"

saveAutoConfig1 "AUTOCONFIG_SAVEFILE" "$AUTOCONFIG_SAVEFILE"
saveAutoConfig1 "AUTOCONFIG_RUNFILE" "$AUTOCONFIG_RUNFILE"
saveAutoConfig1 "REMOTE_TARGET_DIR" "$REMOTE_TARGET_DIR"
saveAutoConfig1 "INSTALL_LOCALES" "$INSTALL_LOCALES"

saveAutoConfig1 "UPGRADE_POLICY_FILE" "$UPGRADE_POLICY_FILE"
saveAutoConfig1 "UPGRADE_POLICY_FILE_NAME" "$UPGRADE_POLICY_FILE_NAME"
saveAutoConfig1 "BASE_POLICY_FILE" "$BASE_POLICY_FILE"
saveAutoConfig1 "BASE_POLICY_FILE_NAME" "$BASE_POLICY_FILE_NAME"

saveAutoConfig1 "API_DIR" "$API_DIR"
saveAutoConfig1 "LIB_DIR" "$LIB_DIR"

saveAutoConfig1 "ARCHIVE_BASE_FLAG" "$ARCHIVE_BASE_FLAG"
saveAutoConfig1 "ARCHIVE_ADDON_FLAG" "$ARCHIVE_ADDON_FLAG"
saveAutoConfig1 "ARCHIVE_PATCHES_FLAG" "$ARCHIVE_PATCHES_FLAG"
saveAutoConfig1 "ARCHIVE_PRODUCT_SELECTION" "$ARCHIVE_PRODUCT_SELECTION"
saveAutoConfig1 "SPLIT_SIZE" "$SPLIT_SIZE"
saveAutoConfig1 "DEFAULT_SPLIT_SIZE" "$DEFAULT_SPLIT_SIZE"

saveAutoConfig1 "SETUP_RESPONSE_FILE" "$SETUP_RESPONSE_FILE"
saveAutoConfig1 "INSTALL_RESPONSE_FILE" "$INSTALL_RESPONSE_FILE"
saveAutoConfig1 "PROTO_FILE" "$PROTO_FILE"
saveAutoConfig1 "RUNTIME_PKG" "$RUNTIME_PKG"
saveAutoConfig1 "PATCHES_TO_ARCHIVE" "$PATCHES_TO_ARCHIVE"
saveAutoConfig1 "ALL_AVAILABLE_PATCHES" "$ALL_AVAILABLE_PATCHES"

saveAutoConfig1 "ARCHIVE_TOOL_CURRENT_CD" "$ARCHIVE_TOOL_CURRENT_CD"
saveAutoConfig1 "WAITING_FOR_NEXT_CD" "$WAITING_FOR_NEXT_CD"
saveAutoConfig1 "CD_MOUNTED" "$CD_MOUNTED"
saveAutoConfig1 "SMARTUPDATE_COMPATIBLE_PRODUCTS" "$SMARTUPDATE_COMPATIBLE_PRODUCTS"
saveAutoConfig1 "PROGRESS_FILE" "$PROGRESS_FILE"
saveAutoConfig1 "ARCHIVE_PROGRESS_FILE" "$ARCHIVE_PROGRESS_FILE"
saveAutoConfig1 "OS_FOR_AVAILABLE_KEYS" "$OS_FOR_AVAILABLE_KEYS"
saveAutoConfig1 "ALL_SUPPORTED_OS" "$ALL_SUPPORTED_OS"
saveAutoConfig1 "SELECTED_OS" "$SELECTED_OS"
saveAutoConfig1 "REQUIRED_SPACE_FORARCHIVES" "$REQUIRED_SPACE_FORARCHIVES"
saveAutoConfig1 "COMMON_PACKAGES" "$COMMON_PACKAGES"

saveAutoConfig1 "IMAGETOOL_ARCHPREFIX" "$IMAGETOOL_ARCHPREFIX"
saveAutoConfig1 "IMAGETOOL_PATHPREFIX" "$IMAGETOOL_PATHPREFIX"
saveAutoConfig1 "IMAGETOOL_ARCH" "$IMAGETOOL_ARCH"

# The source image processing will create 4 source lists. One for each OS. 
# Declaring required variables.

saveAutoConfig1 "INSTALL_SCRIPT_DIR" "$INSTALL_SCRIPT_DIR"
saveAutoConfig1 "ARCHIVE_TOOL_SCRIPT_DIR" "$ARCHIVE_TOOL_SCRIPT_DIR"

    saveAutoConfig1 "BASE_ONLY" "$BASE_ONLY"
    saveAutoConfig1 "VAR_CURRENT_CD" "$VAR_CURRENT_CD"
    saveAutoConfig1 "LAST_CD" "$LAST_CD"
    saveAutoConfig1 "ROOT" "$ROOT"
    saveAutoConfig1 "ETC" "$ETC"
    saveAutoConfig1 "CFGINFOFILE_SETTING" "$CFGINFOFILE_SETTING"
    saveAutoConfig1 "EOL" "$EOL"
    saveAutoConfig1 "INSTALL_COMPONENTS" "$INSTALL_COMPONENTS"
    saveAutoConfig1 "INSTALL_COMPONENTS_LOG" "$INSTALL_COMPONENTS_LOG"
    saveAutoConfig1 "INSTALL_PACKAGES" "$INSTALL_PACKAGES"
    saveAutoConfig1 "INSTALLATION_INFO" "$INSTALLATION_INFO"
    saveAutoConfig1 "INSTALLATION_PROPERTIES" "$INSTALLATION_PROPERTIES"
    saveAutoConfig1 "LOGFILE" "$LOGFILE"
    saveAutoConfig1 "SRC_PKGVER" "$SRC_PKGVER"
    saveAutoConfig1 "INSTALLED_PKGVER" "$INSTALLED_PKGVER"
    saveAutoConfig1 "ORIGINAL_TARGET_DIR" "$ORIGINAL_TARGET_DIR"
    saveAutoConfig1 "TARGET_DIR" "$TARGET_DIR"
    saveAutoConfig1 "READ_RESPONSE_ONCE" "$READ_RESPONSE_ONCE"
    saveAutoConfig1 "SOURCE_IMAGE" "$SOURCE_IMAGE"
    saveAutoConfig1 "VAR_ADDON_PRODUCT" "$VAR_ADDON_PRODUCT"
    saveAutoConfig1 "CURRENT_INSTALL_TYPE" "$CURRENT_INSTALL_TYPE"
    saveAutoConfig1 "BASE_PRODUCT_DIR" "$BASE_PRODUCT_DIR"
    saveAutoConfig1 "BASE_PRODUCT_KEY" "$BASE_PRODUCT_KEY"
    saveAutoConfig1 "COMPONENTS_NOT_TO_BE_INSTALLED" "$COMPONENTS_NOT_TO_BE_INSTALLED"
    saveAutoConfig1 "FAIL_LIST" "$FAIL_LIST"
    saveAutoConfig1 "FAILED_PACKAGES" "$FAILED_PACKAGES"
    saveAutoConfig1 "MISMATCH_LIST" "$MISMATCH_LIST"
    saveAutoConfig1 "EXIT_FLAG" "$EXIT_FLAG"
    saveAutoConfig1 "ALL_SELECTED_OPTIONALS" "$ALL_SELECTED_OPTIONALS"
    saveAutoConfig1 "ALL_SELECTED_OPTIONAL_PACKAGES" "$ALL_SELECTED_OPTIONAL_PACKAGES"
    saveAutoConfig1 "REJECT_PACKAGE_LIST" "$REJECT_PACKAGE_LIST"
    saveAutoConfig1 "TMP_DIR" "$TMP_DIR"

saveAutoConfig1 "SPLIT_SIZE" "$SPLIT_SIZE"

saveAutoConfig1 "API_CREATE_DOC" "$API_CREATE_DOC"
saveAutoConfig1 "API_INSERT_TAG" "$API_INSERT_TAG"
saveAutoConfig1 "API_SET_ATTRIBUTE" "$API_SET_ATTRIBUTE"
saveAutoConfig1 "API_QUERY_XML" "$API_QUERY_XML"

saveAutoConfig1 "ADDON_SETUP_INFO_COMPLETED" "$ADDON_SETUP_INFO_COMPLETED"

checkOSVersion
set_commondirs

AGENT_ONLY=1
INSTALL_LAYERS="LAYER.AGENT"
INSTALL_TYPE="BASE"
LOCALE_CODE=C
L10N_CODE=en

#setArchiveLogdir
initializeRegistry 	# Required for install-functions

checkOSVersion

saveSpecialVariables

saveAutoConfig1 "SRC_DIR" "$SRC_DIR"
saveAutoConfig1 "TARGET_DIR" "$TARGET_DIR"
saveAutoConfig1 "ARCHIVE_TARGET_DIRNAME" "$ARCHIVE_TARGET_DIRNAME"
saveAutoConfig1 "TARGET_ARCHIVE_DIR" "$TARGET_ARCHIVE_DIR"
saveAutoConfig1 "SMART_UPDATE_DIR" "$SMART_UPDATE_DIR"

UNIQ_KEYS_FILE="$AGENT_UPDATE_DIR/uniq_keys.dat"
UNIQ_NAME_FILE="$AGENT_UPDATE_DIR/uniq_names.dat"
UNIQ_OPTC_FILE="$AGENT_UPDATE_DIR/uniq_optional_comp.dat"
UNIQ_OPTP_FILE="$AGENT_UPDATE_DIR/uniq_optional_pkg.dat"

[ -f "$UNIQ_KEYS_FILE" ] && $CMD_RM -f "$UNIQ_KEYS_FILE"
echo "$UNIQ_AVAILABLE_KEYS" >> "$UNIQ_KEYS_FILE"

[ -f "$UNIQ_NAME_FILE" ] && $CMD_RM -f "$UNIQ_NAME_FILE"
echo "$AVAILABLE_KEYS_WITH_NAMES" >> "$UNIQ_NAME_FILE"

[ -f "$UNIQ_OPTC_FILE" ] && $CMD_RM -f "$UNIQ_OPTC_FILE"
echo "$ALL_OPTIONAL_COMPONENTS" >> "$UNIQ_OPTC_FILE"

[ -f "$UNIQ_OPTP_FILE" ] && $CMD_RM -f "$UNIQ_OPTP_FILE"
echo "$UNIQ_OPTIONAL_PACKAGES_LIST" >> "$UNIQ_OPTP_FILE"

}

restoreAllVariables()
{
AGENT_UPDATE_DIR="$AGENT_UPDATE_DIR"
AUTOCONFIG_RUNFILE1="$AGENT_UPDATE_DIR/tmpGUI.properties"

PROGNAME=`getAutoConfig1 "PROGNAME"`
# Will not read the current process as it is write only variable.

PREV_DIR=`getAutoConfig1 "PREV_DIR"`
SCRIPT_DIR=`getAutoConfig1 "SCRIPT_DIR"`
TOOLS_DIR=`getAutoConfig1 "TOOLS_DIR"`

REMOTE_TARGET_DIR=`getAutoConfig1 "REMOTE_TARGET_DIR"`
INSTALL_LOCALES=`getAutoConfig1 "INSTALL_LOCALES"`

UPGRADE_POLICY_FILE=`getAutoConfig1 "UPGRADE_POLICY_FILE"`
UPGRADE_POLICY_FILE_NAME=`getAutoConfig1 "UPGRADE_POLICY_FILE_NAME"`
BASE_POLICY_FILE=`getAutoConfig1 "BASE_POLICY_FILE"`
BASE_POLICY_FILE_NAME=`getAutoConfig1 "BASE_POLICY_FILE_NAME"`

API_DIR=`getAutoConfig1 "API_DIR"`
LIB_DIR=`getAutoConfig1 "LIB_DIR"`

AUTOCONFIG_RUNFILE=`getAutoConfig1 "AUTOCONFIG_RUNFILE"`
AUTOCONFIG_SAVEFILE=`getAutoConfig1 "AUTOCONFIG_SAVEFILE"`

ARCHIVE_BASE_FLAG=`getAutoConfig1 "ARCHIVE_BASE_FLAG"`
ARCHIVE_ADDON_FLAG=`getAutoConfig1 "ARCHIVE_ADDON_FLAG"`
ARCHIVE_PRODUCT_SELECTION=`getAutoConfig1 "ARCHIVE_PRODUCT_SELECTION"`
SPLIT_SIZE=`getAutoConfig1 "SPLIT_SIZE"`
DEFAULT_SPLIT_SIZE=`getAutoConfig1 "DEFAULT_SPLIT_SIZE"`

SETUP_RESPONSE_FILE=`getAutoConfig1 "SETUP_RESPONSE_FILE"`
INSTALL_RESPONSE_FILE=`getAutoConfig1 "INSTALL_RESPONSE_FILE"`
PROTO_FILE=`getAutoConfig1 "PROTO_FILE"`
RUNTIME_PKG=`getAutoConfig1 "RUNTIME_PKG"`
PATCHES_TO_ARCHIVE=`getAutoConfig1 "PATCHES_TO_ARCHIVE"`
ALL_AVAILABLE_PATCHES=`getAutoConfig1 "ALL_AVAILABLE_PATCHES"`
ARCHIVE_TOOL_CURRENT_CD=`getAutoConfig1 "ARCHIVE_TOOL_CURRENT_CD"`
WAITING_FOR_NEXT_CD=`getAutoConfig1 "WAITING_FOR_NEXT_CD"`
CD_MOUNTED=`getAutoConfig1 "CD_MOUNTED"`
SMARTUPDATE_COMPATIBLE_PRODUCTS=`getAutoConfig1 "SMARTUPDATE_COMPATIBLE_PRODUCTS"`
PROGRESS_FILE=`getAutoConfig1 "PROGRESS_FILE"`
ARCHIVE_PROGRESS_FILE=`getAutoConfig1 "ARCHIVE_PROGRESS_FILE"`
ALL_SUPPORTED_OS=`getAutoConfig1 "ALL_SUPPORTED_OS"`
SELECTED_OS=`getAutoConfig1 "SELECTED_OS"`
REQUIRED_SPACE_FORARCHIVES=`getAutoConfig1 "REQUIRED_SPACE_FORARCHIVES"`
COMMON_PACKAGES=`getAutoConfig1 "COMMON_PACKAGES"`
OS_FOR_AVAILABLE_KEYS=`getAutoConfig1 "OS_FOR_AVAILABLE_KEYS"`
RESPONSE_FILE_LIST=`getSpecialVariable "RESPONSE_FILE_LIST"`
COMPONENT_SCRIPT_LIST=`getSpecialVariable "COMPONENT_SCRIPT_LIST"`

# The source image processing will create 4 source lists. One for each OS. 
# Declaring required variables.

SOURCE_LIST_6=`getSpecialVariable "SOURCE_LIST_6"`
SOURCE_LIST_7=`getSpecialVariable "SOURCE_LIST_7"`
SOURCE_LIST_8=`getSpecialVariable "SOURCE_LIST_8"`
SOURCE_LIST_9=`getSpecialVariable "SOURCE_LIST_9"`
SOURCE_LIST_10=`getSpecialVariable "SOURCE_LIST_10"`

SELECTED_KEYS_6=`getSpecialVariable "SELECTED_KEYS_6"`
SELECTED_KEYS_7=`getSpecialVariable "SELECTED_KEYS_7"`
SELECTED_KEYS_8=`getSpecialVariable "SELECTED_KEYS_8"`
SELECTED_KEYS_9=`getSpecialVariable "SELECTED_KEYS_9"`
SELECTED_KEYS_10=`getSpecialVariable "SELECTED_KEYS_10"`

AVAILABLE_KEYS_6=`getSpecialVariable "AVAILABLE_KEYS_6"`
AVAILABLE_KEYS_7=`getSpecialVariable "AVAILABLE_KEYS_7"`
AVAILABLE_KEYS_8=`getSpecialVariable "AVAILABLE_KEYS_8"`
AVAILABLE_KEYS_9=`getSpecialVariable "AVAILABLE_KEYS_9"`
AVAILABLE_KEYS_10=`getSpecialVariable "AVAILABLE_KEYS_10"`

ALL_OPTIONAL_COMPONENTS_6=`getSpecialVariable "ALL_OPTIONAL_COMPONENTS_6"`
ALL_OPTIONAL_COMPONENTS_7=`getSpecialVariable "ALL_OPTIONAL_COMPONENTS_7"`
ALL_OPTIONAL_COMPONENTS_8=`getSpecialVariable "ALL_OPTIONAL_COMPONENTS_8"`
ALL_OPTIONAL_COMPONENTS_9=`getSpecialVariable "ALL_OPTIONAL_COMPONENTS_9"`
ALL_OPTIONAL_COMPONENTS_10=`getSpecialVariable "ALL_OPTIONAL_COMPONENTS_10"`

SORTED_COMPONENTS_LIST_6=`getSpecialVariable "SORTED_COMPONENTS_LIST_6"`
SORTED_COMPONENTS_LIST_7=`getSpecialVariable "SORTED_COMPONENTS_LIST_7"`
SORTED_COMPONENTS_LIST_8=`getSpecialVariable "SORTED_COMPONENTS_LIST_8"`
SORTED_COMPONENTS_LIST_9=`getSpecialVariable "SORTED_COMPONENTS_LIST_9"`
SORTED_COMPONENTS_LIST_10=`getSpecialVariable "SORTED_COMPONENTS_LIST_10"`

COMPONENT_FILTERS_LIST_6=`getSpecialVariable "COMPONENT_FILTERS_LIST_6"`
COMPONENT_FILTERS_LIST_7=`getSpecialVariable "COMPONENT_FILTERS_LIST_7"`
COMPONENT_FILTERS_LIST_8=`getSpecialVariable "COMPONENT_FILTERS_LIST_8"`
COMPONENT_FILTERS_LIST_9=`getSpecialVariable "COMPONENT_FILTERS_LIST_9"`
COMPONENT_FILTERS_LIST_10=`getSpecialVariable "COMPONENT_FILTERS_LIST_10"`

COMP_NAMES_6=`getSpecialVariable "COMP_NAMES_6"`
COMP_NAMES_7=`getSpecialVariable "COMP_NAMES_7"`
COMP_NAMES_8=`getSpecialVariable "COMP_NAMES_8"`
COMP_NAMES_9=`getSpecialVariable "COMP_NAMES_9"`
COMP_NAMES_10=`getSpecialVariable "COMP_NAMES_10"`

INIT_COMP_DETAILS_6=`getSpecialVariable "INIT_COMP_DETAILS_6"`
INIT_COMP_DETAILS_7=`getSpecialVariable "INIT_COMP_DETAILS_7"`
INIT_COMP_DETAILS_8=`getSpecialVariable "INIT_COMP_DETAILS_8"`
INIT_COMP_DETAILS_9=`getSpecialVariable "INIT_COMP_DETAILS_9"`
INIT_COMP_DETAILS_10=`getSpecialVariable "INIT_COMP_DETAILS_10"`

UNIQUE_SELECTED_KEYS=`getSpecialVariable "UNIQUE_SELECTED_KEYS"`
UNIQ_AVAILABLE_KEYS=`getSpecialVariable "UNIQ_AVAILABLE_KEYS"`
UNIQ_OPTIONAL_COMPONENTS_LIST=`getSpecialVariable "UNIQ_OPTIONAL_COMPONENTS_LIST"`
UNIQ_OPTIONAL_PACKAGES_LIST=`getSpecialVariable "UNIQ_OPTIONAL_COMPONENTS_LIST"`
ALL_CDS=`getSpecialVariable "ALL_CDS"`
AVAILABLE_KEYS=`getSpecialVariable "AVAILABLE_KEYS"`
ALL_OPTIONAL_COMPONENTS=`getSpecialVariable "ALL_OPTIONAL_COMPONENTS"`

INSTALL_SCRIPT_DIR=`getAutoConfig1 "INSTALL_SCRIPT_DIR"`
ARCHIVE_TOOL_SCRIPT_DIR=`getAutoConfig1 "ARCHIVE_TOOL_SCRIPT_DIR"`

    BASE_ONLY=`getAutoConfig1 "BASE_ONLY"`
    VAR_CURRENT_CD=`getAutoConfig1 "VAR_CURRENT_CD"`
    LAST_CD=`getAutoConfig1 "LAST_CD"`
    ROOT=`getAutoConfig1 "ROOT"`
    ETC=`getAutoConfig1 "ETC"`
    CFGINFOFILE_SETTING=`getAutoConfig1 "CFGINFOFILE_SETTING"`
    EOL=`getAutoConfig1 "EOL"`
    INSTALL_COMPONENTS=`getAutoConfig1 "INSTALL_COMPONENTS"`
    INSTALL_COMPONENTS_LOG=`getAutoConfig1 "INSTALL_COMPONENTS_LOG"`
    INSTALL_PACKAGES=`getAutoConfig1 "INSTALL_PACKAGES"`
    INSTALLATION_INFO=`getAutoConfig1 "INSTALLATION_INFO"`
    INSTALLATION_PROPERTIES=`getAutoConfig1 "INSTALLATION_PROPERTIES"`
    LOGFILE=`getAutoConfig1 "LOGFILE"`
    SRC_PKGVER=`getAutoConfig1 "SRC_PKGVER"`
    INSTALLED_PKGVER=`getAutoConfig1 "INSTALLED_PKGVER"`
    ORIGINAL_TARGET_DIR=`getAutoConfig1 "ORIGINAL_TARGET_DIR"`
    TARGET_DIR=`getAutoConfig1 "TARGET_DIR"`
    READ_RESPONSE_ONCE=`getAutoConfig1 "READ_RESPONSE_ONCE"`
    SOURCE_IMAGE=`getAutoConfig1 "SOURCE_IMAGE"`
    VAR_ADDON_PRODUCT=`getAutoConfig1 "VAR_ADDON_PRODUCT"`
    CURRENT_INSTALL_TYPE=`getAutoConfig1 "CURRENT_INSTALL_TYPE"`
    COMPONENTS_NOT_TO_BE_INSTALLED=`getAutoConfig1 "COMPONENTS_NOT_TO_BE_INSTALLED"`
    FAIL_LIST=`getAutoConfig1 "FAIL_LIST"`
    SOURCE_LIST=`getSpecialVariable "SOURCE_LIST"`
    COMPONENT_FILTERS_LIST=`getSpecialVariable "COMPONENT_FILTERS_LIST"`
    COMP_NAMES=`getSpecialVariable "COMP_NAMES"`
    INIT_COMP_DETAILS=`getSpecialVariable "INIT_COMP_DETAILS"`
    FAILED_PACKAGES=`getAutoConfig1 "FAILED_PACKAGES"`
    MISMATCH_LIST=`getAutoConfig1 "MISMATCH_LIST"`
    EXIT_FLAG=`getAutoConfig1 "EXIT_FLAG"`
    ALL_SELECTED_OPTIONALS=`getAutoConfig1 "ALL_SELECTED_OPTIONALS"`
    ALL_SELECTED_OPTIONAL_PACKAGES=`getAutoConfig1 "ALL_SELECTED_OPTIONAL_PACKAGES"`
    REJECT_PACKAGE_LIST=`getAutoConfig1 "REJECT_PACKAGE_LIST"`
    TMP_DIR=`getAutoConfig1 "TMP_DIR"`
    
SPLIT_SIZE=`getAutoConfig1 "SPLIT_SIZE"`

API_CREATE_DOC=`getAutoConfig1 "API_CREATE_DOC"`
API_INSERT_TAG=`getAutoConfig1 "API_INSERT_TAG"` 
API_SET_ATTRIBUTE=`getAutoConfig1 "API_SET_ATTRIBUTE"`
API_QUERY_XML=`getAutoConfig1 "API_QUERY_XML"`

ADDON_SETUP_INFO_COMPLETED=`getAutoConfig1 "ADDON_SETUP_INFO_COMPLETED"`

checkOSVersion
set_commondirs

AGENT_ONLY=1
INSTALL_LAYERS="LAYER.AGENT"
INSTALL_TYPE="BASE"
BASE_PRODUCT_DIR="PE"
BASE_PRODUCT_KEY="PRODUCT.PE"
LOCALE_CODE=C
L10N_CODE=en

setArchiveLogdir
initializeRegistry 	# Required for install-functions

checkOSVersion

SRC_DIR=`getAutoConfig1 "SRC_DIR"`
SRC_DIR=`eval $CMD_ECHO "$SRC_DIR"`
TARGET_DIR=`getAutoConfig1 "TARGET_DIR"`
ARCHIVE_TARGET_DIRNAME=`getAutoConfig1 "ARCHIVE_TARGET_DIRNAME"`
TARGET_ARCHIVE_DIR=`getAutoConfig1 "TARGET_ARCHIVE_DIR"`
SMART_UPDATE_DIR=`getAutoConfig1 "SMART_UPDATE_DIR"`

IMAGETOOL_ARCHPREFIX=`getAutoConfig1 "IMAGETOOL_ARCHPREFIX"`
IMAGETOOL_PATHPREFIX=`getAutoConfig1 "IMAGETOOL_PATHPREFIX"`
IMAGETOOL_ARCH=`getAutoConfig1 "IMAGETOOL_ARCH"`

}


getAutoConfig1()
{
   if [ "$AUTOCONFIG_RUNFILE1" = "" ] ; then
        echo ""
    else
        tmp_getautoconfig=`$CMD_GREP "^${1}=" "$AUTOCONFIG_RUNFILE1"`
        if [ "$tmp_getautoconfig" = "" ] ; then
            echo ""
        else
            echo `$CMD_EXPR $tmp_getautoconfig : "${1}\(.*\)" | $CMD_CUT -d= -f2 `
        fi
    fi
}

# Parameter: $1 = the key
# Parameter: $2 = the file
# Return: $MSG
getProperty() {
    MSG=""
    if [ -f "$2" ] ; then
    MSG=`$CMD_AWK "/^\s*$1=/" $2 | $CMD_SED -e "s/^\s*$1=//"
`
    fi
    [ -z "$MSG" ] && MSG="$1"
    $CMD_ECHO "$MSG"
}


saveAutoConfig1()
{
    [ "$AUTOCONFIG_SAVEFILE1" = "" ] && return
    /usr/bin/grep -w "\<${1}=${2}\>" $AUTOCONFIG_SAVEFILE1 > /dev/null 2>&1 # smart-update
    [ $? -eq 0 ] && return                              # smart-update
    echo "${1}=${2}" >> "$AUTOCONFIG_SAVEFILE1"

}

putSpecialVariable()
{
	echo "<BEGIN:$1>" >> "$SPECIAL_VARIABLE_FILE"
	echo "$2" >> "$SPECIAL_VARIABLE_FILE"
	echo "<END:$1>" >> "$SPECIAL_VARIABLE_FILE"
}

saveSpecialVariables()
{
	SPECIAL_VARIABLE_FILE=$AGENT_UPDATE_DIR/special-vars.dat

	[ -f "$SPECIAL_VARIABLE_FILE" ] && $CMD_RM -f "$SPECIAL_VARIABLE_FILE"
	putSpecialVariable "SOURCE_LIST" "$SOURCE_LIST"
	putSpecialVariable "SOURCE_LIST_6" "$SOURCE_LIST_6"
	putSpecialVariable "SOURCE_LIST_7" "$SOURCE_LIST_7"
	putSpecialVariable "SOURCE_LIST_8" "$SOURCE_LIST_8"
	putSpecialVariable "SOURCE_LIST_9" "$SOURCE_LIST_9"
	putSpecialVariable "SOURCE_LIST_10" "$SOURCE_LIST_10"

	putSpecialVariable "AVAILABLE_KEYS_6" "$AVAILABLE_KEYS_6"
	putSpecialVariable "AVAILABLE_KEYS_7" "$AVAILABLE_KEYS_7"
	putSpecialVariable "AVAILABLE_KEYS_8" "$AVAILABLE_KEYS_8"
	putSpecialVariable "AVAILABLE_KEYS_9" "$AVAILABLE_KEYS_9"
	putSpecialVariable "AVAILABLE_KEYS_10" "$AVAILABLE_KEYS_10"
	
	putSpecialVariable "SELECTED_KEYS_6" "$SELECTED_KEYS_6"
	putSpecialVariable "SELECTED_KEYS_7" "$SELECTED_KEYS_7"
	putSpecialVariable "SELECTED_KEYS_8" "$SELECTED_KEYS_8"
	putSpecialVariable "SELECTED_KEYS_9" "$SELECTED_KEYS_9"
	putSpecialVariable "SELECTED_KEYS_10" "$SELECTED_KEYS_10"

	putSpecialVariable "ALL_OPTIONAL_COMPONENTS_6" "$ALL_OPTIONAL_COMPONENTS_6"
	putSpecialVariable "ALL_OPTIONAL_COMPONENTS_7" "$ALL_OPTIONAL_COMPONENTS_7"
	putSpecialVariable "ALL_OPTIONAL_COMPONENTS_8" "$ALL_OPTIONAL_COMPONENTS_8"
	putSpecialVariable "ALL_OPTIONAL_COMPONENTS_9" "$ALL_OPTIONAL_COMPONENTS_9"
	putSpecialVariable "ALL_OPTIONAL_COMPONENTS_10" "$ALL_OPTIONAL_COMPONENTS_10"

	putSpecialVariable "SORTED_COMPONENTS_LIST_6" "$SORTED_COMPONENTS_LIST_6"
	putSpecialVariable "SORTED_COMPONENTS_LIST_7" "$SORTED_COMPONENTS_LIST_7"
	putSpecialVariable "SORTED_COMPONENTS_LIST_8" "$SORTED_COMPONENTS_LIST_8"
	putSpecialVariable "SORTED_COMPONENTS_LIST_9" "$SORTED_COMPONENTS_LIST_9"
	putSpecialVariable "SORTED_COMPONENTS_LIST_10" "$SORTED_COMPONENTS_LIST_10"

	putSpecialVariable "COMPONENT_FILTERS_LIST" "$COMPONENT_FILTERS_LIST"
	putSpecialVariable "COMPONENT_FILTERS_LIST_6" "$COMPONENT_FILTERS_LIST_6"
	putSpecialVariable "COMPONENT_FILTERS_LIST_7" "$COMPONENT_FILTERS_LIST_7"
	putSpecialVariable "COMPONENT_FILTERS_LIST_8" "$COMPONENT_FILTERS_LIST_8"
	putSpecialVariable "COMPONENT_FILTERS_LIST_9" "$COMPONENT_FILTERS_LIST_9"
	putSpecialVariable "COMPONENT_FILTERS_LIST_10" "$COMPONENT_FILTERS_LIST_10"

	putSpecialVariable "COMP_NAMES" "$COMP_NAMES"
	putSpecialVariable "COMP_NAMES_6" "$COMP_NAMES_6"
	putSpecialVariable "COMP_NAMES_7" "$COMP_NAMES_7"
	putSpecialVariable "COMP_NAMES_8" "$COMP_NAMES_8"
	putSpecialVariable "COMP_NAMES_9" "$COMP_NAMES_9"
	putSpecialVariable "COMP_NAMES_10" "$COMP_NAMES_10"

	putSpecialVariable "INIT_COMP_DETAILS" "$INIT_COMP_DETAILS"
	putSpecialVariable "INIT_COMP_DETAILS_6" "$INIT_COMP_DETAILS_6"
	putSpecialVariable "INIT_COMP_DETAILS_7" "$INIT_COMP_DETAILS_7"
	putSpecialVariable "INIT_COMP_DETAILS_8" "$INIT_COMP_DETAILS_8"
	putSpecialVariable "INIT_COMP_DETAILS_9" "$INIT_COMP_DETAILS_9"
	putSpecialVariable "INIT_COMP_DETAILS_10" "$INIT_COMP_DETAILS_10"

	putSpecialVariable "RESPONSE_FILE_LIST" "$RESPONSE_FILE_LIST"
	putSpecialVariable "COMPONENT_SCRIPT_LIST" "$COMPONENT_SCRIPT_LIST"
	putSpecialVariable "UNIQUE_SELECTED_KEYS" "$UNIQUE_SELECTED_KEYS"
	putSpecialVariable "ALL_CDS" "$ALL_CDS"
	putSpecialVariable "UNIQ_AVAILABLE_KEYS" "$UNIQ_AVAILABLE_KEYS"
	putSpecialVariable "UNIQ_OPTIONAL_COMPONENTS_LIST" "$UNIQ_OPTIONAL_COMPONENTS_LIST"
	putSpecialVariable "UNIQ_OPTIONAL_PACKAGES_LIST" "$UNIQ_OPTIONAL_PACKAGES_LIST"
	putSpecialVariable "AVAILABLE_KEYS" "$AVAILABLE_KEYS"
	putSpecialVariable "ALL_OPTIONAL_COMPONENTS" "$ALL_OPTIONAL_COMPONENTS"
}

getSpecialVariable()
{
	SPECIAL_VARIABLE_FILE=$AGENT_UPDATE_DIR/special-vars.dat

	[ ! -f "$SPECIAL_VARIABLE_FILE" ] && return 1
	
	LINENUM_START=`$CMD_GREP -n -e "<BEGIN:$1>" $SPECIAL_VARIABLE_FILE | $CMD_SED -e "s/:.*/ /"`
        if [ -z "$LINENUM_START" ] ; then
            echolog 'Error: Cannot find key $2.' "$1"
	    return 
        fi
	LINENUM=`$CMD_EXPR $LINENUM_START + 1`

	retValue=`$CMD_HEAD -${LINENUM} $SPECIAL_VARIABLE_FILE | $CMD_TAIL -1`
	echo "$retValue"
}

#########  End Section 2 ###################################################


# This is to take care of "Back" button in GUI
# When product selection is done, it updates response file with
# selected products. The GUI puts a dummy Key PSELSTART 
# Script puts PSELEND here to make sure it is appended at the end.
# Otherwise Java sorts it and puts it somewhere in the middle
# If user clicks Back Next and modifies the selection,
# The dummy keys are used to delete the old key value pairs
# and rewrite whole thing again.

updateInstallResponseFile()
{
	GUI_RESPONSE_FILE="$AGENT_UPDATE_DIR/gui-response.cfg"
	AUTOCONFIG_BAKFILE=${AUTOCONFIG_SAVEFILE}.bak

        $CMD_ECHO "PRODUCT.DUMMY=PSELEND" >> $GUI_RESPONSE_FILE

	LINENUM_START=`$CMD_GREP -n -e "PSELSTART" $AUTOCONFIG_SAVEFILE | $CMD_SED -e "s/:.*/ /"`
        LINENUM_END=`$CMD_GREP -n -e "PSELEND" $AUTOCONFIG_SAVEFILE | $CMD_SED -e "s/:.*/ /"`

	if [ ! -z "$LINENUM_START" ]; then
	    TOTAL_LINES=`$CMD_WC -l $AUTOCONFIG_SAVEFILE`
	    LINE_COUNT=`$CMD_ECHO $TOTAL_LINES | $CMD_CUT -d" " -f1`
	
            HEAD_LINENUM=`$CMD_EXPR $LINENUM_START - 1   2>/dev/null`
	    TAIL_LINENUM=`$CMD_EXPR $LINE_COUNT - $LINENUM_END  2>/dev/null`

	    $CMD_TOUCH "$AUTOCONFIG_BAKFILE"
	    $CMD_HEAD -${HEAD_LINENUM} $AUTOCONFIG_SAVEFILE > $AUTOCONFIG_BAKFILE
            $CMD_TAIL -${TAIL_LINENUM} $AUTOCONFIG_SAVEFILE >> $AUTOCONFIG_BAKFILE
	    $CMD_RM "$AUTOCONFIG_SAVEFILE"
	    $CMD_MV "$AUTOCONFIG_BAKFILE" "$AUTOCONFIG_SAVEFILE"
        fi

	/usr/bin/cat $GUI_RESPONSE_FILE | $CMD_SED "s/\\\//g" >> $AUTOCONFIG_SAVEFILE
}


# This does similar job as that of askBaseSetupQuestions
# it takes inputs from text file

getBaseSetupAnswers()
{
        if [ -f $SMART_UPDATE_DIR/disk1/image/PE/$SETUP_RESPONSE_FILE ]; then
	    $CMD_RM -rf $SMART_UPDATE_DIR/disk1/image/PE/$SETUP_RESPONSE_FILE
	fi

	OLD_AUTOCONFIG_RUNFILE="$AUTOCONFIG_RUNFILE"
	AUTOCONFIG_RUNFILE="$AGENT_UPDATE_DIR/gui-setup.cfg"

	answer=`getAutoConfig "agent_OPTIONAL_PORT"`

        if [ -z "$answer" ]; then
                AGENT_PORT="DEFAULT"
        else
                validate_port "$answer"
                if [ $? -eq 0 ]; then
                        AGENT_PORT="$answer"
                fi
        fi

        HOSTNAME=`$CMD_UNAME -n`

	STOP_SNMPDX=`getAutoConfig "STOP_SNMPDX"`

        $CMD_ECHO "SUNMC_SERVER=$HOSTNAME" >> $SMART_UPDATE_DIR/disk1/image/PE/$SETUP_RESPONSE_FILE
        $CMD_ECHO "agent_OPTIONAL_PORT=$AGENT_PORT" >> $SMART_UPDATE_DIR/disk1/image/PE/$SETUP_RESPONSE_FILE
	updateSetupResponseForNoBase "$STOP_SNMPDX"
	
	CONTINUE_IF_SMA_PRESENT=`getAutoConfig "CONTINUE_IF_SMA_PRESENT"`
	if [ -n "$CONTINUE_IF_SMA_PRESENT" ]; then
		$CMD_ECHO "CONTINUE_IF_SMA_PRESENT=$CONTINUE_IF_SMA_PRESENT" >> $SMART_UPDATE_DIR/disk1/image/PE/$SETUP_RESPONSE_FILE
	fi

	AUTOCONFIG_RUNFILE="$OLD_AUTOCONFIG_RUNFILE"
}

getSelectedPatchesFromFile()
{
	AUTOCONFIG_RUNFILE1="$AGENT_UPDATE_DIR/gui-patch.dat"
	PATCHES_TO_ARCHIVE=`getAutoConfig1 "SELECTED_PATCHES"`
}


# This is to setup a progress update file
# Gui reads this as a property file and provides dynamic status updates

setupArchiveProgressFile()
{
    [ -z "$ARCHIVE_PROGRESS_FILE" ] && return
    [ -f "${ARCHIVE_PROGRESS_FILE}" ] && $CMD_RM -f ${ARCHIVE_PROGRESS_FILE}

    temp_dirname=`$CMD_DIRNAME $ARCHIVE_PROGRESS_FILE`
    [ "$temp_dirname" = "." ] && temp_dirname=`$CMD_PWD`
    temp_filename=`$CMD_BASENAME ${ARCHIVE_PROGRESS_FILE}`
    ARCHIVE_PROGRESS_FILE=${temp_dirname}/${temp_filename}

    $CMD_TOUCH ${ARCHIVE_PROGRESS_FILE}
    export ARCHIVE_PROGRESS_FILE
}


# This is again to take care of Back button

backup_runtime_data()
{
	cd $AGENT_UPDATE_DIR
	$CMD_CP -f special-vars.dat special-vars.dat.bak
	$CMD_CP -f tmpGUI.properties tmpGUI.properties.bak
}

restore_runtime_data()
{
	cd $AGENT_UPDATE_DIR
	if [ -f "./special-vars.dat.bak" ]; then 
	    $CMD_CP -f special-vars.dat.bak special-vars.dat
	fi
	if [ -f "./tmpGUI.properties.bak" ]; then 
	    $CMD_CP -f tmpGUI.properties.bak tmpGUI.properties
	fi
}


# This is called before starting the wizard
# If user clicks STOP
# and at the end of the wizard

cleanupGuiData()
{
	AUTOCONFIG_RUNFILE1="$AGENT_UPDATE_DIR/process.dat"
	PROC_ID=`getAutoConfig1 "CURRENT_PROCESS" 2>/dev/null`

        if [ "$1" != "and_exit" ]; then
            if [ ! -z "$PROC_ID" ]; then
                kill -9 "$PROC_ID" 2>/dev/null
            fi
        fi

	cd $AGENT_UPDATE_DIR
	$CMD_RM -f gui-response.cfg
	$CMD_RM -f gui-setup.cfg
	$CMD_RM -f special-vars.dat
	$CMD_RM -f tmpGUI.properties
	$CMD_RM -f opt_comp.properties
	$CMD_RM -f uniq_keys.dat
	$CMD_RM -f uniq_names.dat
	$CMD_RM -f uniq_optional_comp.dat
	$CMD_RM -f uniq_optional_pkg.dat
	$CMD_RM -f process.dat
	$CMD_RM -f gui-progress.properties
	$CMD_RM -f gui-archive-progress.properties
	$CMD_RM -f gui-progress.properties.old
	$CMD_RM -f gui-archive-progress.properties.old
	$CMD_RM -f gui-patch.dat
	$CMD_RM -f special-vars.dat.bak
	$CMD_RM -f tmpGUI.properties.bak
}

