#!/bin/sh

# Copyright 02/11/05 Sun Microsystems, Inc. All Rights Reserved.
#pragma ident "@(#)gui-archivetool-archiving.sh	1.27 05/02/11 Sun Microsystems"

###########################################################
# Main 
PROGNAME="archive-tool"

PREV_DIR=`/usr/bin/pwd`
SCRIPT_DIR=`/usr/bin/dirname $PROGNAME`

AGENT_UPDATE_DIR="/var/opt/SUNWsymon/agentupdate/"

INSTALL_SCRIPTS_DIR=`/usr/bin/pkgparam SUNWescom BASEDIR`/SUNWsymon/lib/sbin
ES_COMMON_DIR=`/usr/bin/pkgparam SUNWescom BASEDIR`/SUNWsymon/sbin
ARCHIVE_TOOL_SCRIPT_DIR=`/usr/bin/pkgparam SUNWescom BASEDIR`/SUNWsymon/lib/sbin

. ${ES_COMMON_DIR}/es-common.sh
. ${INSTALL_SCRIPTS_DIR}/script-errors.sh
. ${INSTALL_SCRIPTS_DIR}/install-functions.sh
. ${ARCHIVE_TOOL_SCRIPT_DIR}/archive-tool-functions.sh
. ${ARCHIVE_TOOL_SCRIPT_DIR}/gui-archivetool-functions.sh

CURRENT_PROCESS=$$
$CMD_RM -f $AGENT_UPDATE_DIR/process.dat
echo "CURRENT_PROCESS=$CURRENT_PROCESS" > $AGENT_UPDATE_DIR/process.dat

restoreAllVariables
PROGRESS_FILE="$AGENT_UPDATE_DIR/gui-progress.properties"
ARCHIVE_PROGRESS_FILE="$AGENT_UPDATE_DIR/gui-archive-progress.properties"
setupProgressFile
setupArchiveProgressFile

getLastCD

setAPIDirs
API_CREATE_DOC="$API_DIR/createDocument"
API_INSERT_TAG="$API_DIR/insertTag"
API_SET_ATTRIBUTE="$API_DIR/setAttribute"
API_QUERY_XML="$API_DIR/queryXml"

initial_run=0

BASE_PROD_ONLY=0
CALLED_FROM_GUI=1

if [ "$ARCHIVE_BASE_FLAG" = "1" -a "$ARCHIVE_ADDON_FLAG" = "0" ]; then
    BASE_PROD_ONLY=1
fi

if [ "$SOURCE_IMAGE" = "PATCH_ONLY" ]; then
    getLastCD

    # This is just to set the IMAGETOOL_ARCH variable again
    detect_patch_arch

    $CMD_MKDIR -p "$TARGET_ARCHIVE_DIR"
    echolog 'Adding patches...'
    DEFAULT_SPLIT_SIZE=1024
    check_split_size

    makeDirectories "PE"
    updateResponseForPatchOnly
    updateSetupResponseForNoBase "1"

    init_policy_file
    updatePolicyForBaseProduct

    update_protofile
    update_proto_for_client
    [ "$RUNTIME_PKG" != "DONE" ] && make_runtime_package

    archiveEssentialPatches
    echolog "$PATCHES_TO_ARCHIVE"
    $CMD_ECHO "$PATCHES_TO_ARCHIVE" > $AGENT_UPDATE_DIR/gui-summary.dat
    cleanupGuiData and_exit
    exit 0
fi

if [ "$WAITING_FOR_NEXT_CD" = "FALSE" ]; then

    echolog 'Starting image creation. Please wait...'
    echolog '$2' "$SCREEN_LINE"
    echolog ''


    update_protofile
    update_proto_for_client

    updatePolicyForBaseProduct
    if [ "$ARCHIVE_BASE_FLAG" = "1" ]; then
        echolog "Adding base product"
        archiveBaseProduct
        initial_run=1
    fi

    echolog "Adding Addons "
    getAllCDs
    updateSourceDirectories
fi

if [ ${BASE_PROD_ONLY} -eq 0 -o ${initial_run} -eq 1 ]; then
for each_cd in $ALL_CDS
do
    # Get the file system type of the image dir before changing SRC_DIR
    image_fstype=`$CMD_DF -n "$SRC_DIR" | $CMD_CUT -d: -f2 | $CMD_SED -e 's/^ *\([^    ]*\) *$/\1/' 2>/dev/null`
    if [ "$each_cd" != "1" ];then
        # check for disk image
	if [ "$WAITING_FOR_NEXT_CD" != "TRUE" ]; then
            SRC_DIR="$SRC_DIR/${IMAGETOOL_PATHPREFIX}../../disk$each_cd/${IMAGETOOL_ARCHPREFIX}/image"
            SRC_DIR=`getPathName $SRC_DIR`
	fi
    fi
    if [ ! -d "$SRC_DIR" ]; then
        # The image path is probably from CDROM

        if [ "$image_fstype" = "hsfs" ]; then
            /usr/bin/eject -q cd 2> /dev/null
            [ $? -eq 0 ] && /usr/bin/eject cdrom0
            [ $? -ne 0 ] && echolog "Not able to eject the CDROM"
        fi

        echolog 'Cannot proceed without disk $each_cd'
	ARCHIVE_TOOL_CURRENT_CD=$each_cd
	echolog 'Writing to properties file'
	WAITING_FOR_NEXT_CD="TRUE"
	CD_MOUNTED="FALSE"
	saveAllVariables
	exit 1
    fi
    echolog 'Installation files source directory: $2' "$SRC_DIR"
    archiveAddons $each_cd
    [ "$RUNTIME_PKG" != "DONE" ] && make_runtime_package
    ALL_CDS=`$CMD_ECHO "$ALL_CDS" | $CMD_SED "s/$each_cd//g"`
done
fi

WAITING_FOR_NEXT_CD="FALSE"	# re setting the value to notify GUI.
[ $initial_run -eq 0 ] && [ ${BASE_PROD_ONLY} -eq 1 ] && WAITING_FOR_NEXT_CD="TRUE"

echolog 'Adding patches...'
archivePatches

echolog 'Writing summary..'
echolog ''

if [ -f "$UPGRADE_POLICY_FILE" ]; then
        PRODUCT_LIST=`$API_QUERY_XML "$UPGRADE_POLICY_FILE" product name`
        echolog "$PRODUCT_LIST"
        $CMD_ECHO "$PRODUCT_LIST" > $AGENT_UPDATE_DIR/gui-summary.dat
fi
cleanupGuiData and_exit

exit 0

