#!/bin/sh

# Copyright 08/18/05 Sun Microsystems, Inc. All Rights Reserved.
#pragma ident  "@(#)sm_setup_server.sh	1.116 05/08/18 Sun Microsystems"
#
# Note:  This script is used internally by Sun Enterprise SyMON,
# and is not intended to be called directly by users.
# It should not be modified.
#
#############################################################################
# Functions used by this script
#############################################################################

# Sets help location  for Sun Management Center help
# Input   : $1 => New help location
# Returns : None
#
set_help_location() {
    help_url="$1"
    help_url_file="$BASEDIR/classes/base/console/cfg/help-server-j.x"
    tmp_help_url_file="$TMP_DIR/help-server-j.x"
    /usr/bin/rm -rf "$tmp_help_url_file" 

    if [ ! -f "$help_url_file" ] ; then
	echolog 'WARNING : Could not locate Sun Management Center Console help configuration file.'
        echolog 'Sun Management Center help will not be accessible from console.'	
        echolog ''
    else
       /usr/bin/cat $help_url_file | /usr/bin/grep -v "detail-help" > "$tmp_help_url_file"
       /usr/bin/echo "detail-help = $help_url" >> "$tmp_help_url_file" 
       /usr/bin/mv -f "$tmp_help_url_file" "$help_url_file"
       /usr/bin/rm -rf "$tmp_help_url_file"
       echologverbose ''
       echologverbose 'The base URL has been set to $2' "$help_url"
    fi
    unset help_url help_url_file tmp_help_url_file
}


# Input   : $1 = group name
#         : $2 = user name
# Returns : Sets help location  for SunMC help
#
add_user_to_group() {

    grpline=`/usr/bin/grep -i "$1" /etc/group`
    if [ $? -ne 0 ] ; then
	echolog ''
	multiline_echolog 'Could not find group $2. You will have to set up\nthe groups manually. You must add $3 to group $4' $1 $2 $1
	echolog ''
	return
    fi

    echo "$grpline" | /usr/bin/grep -i "$2" >/dev/null
    [ $? -eq 0 ] && return 0

    len=`echo "$grpline" | /usr/bin/awk '{print length}'`
    lastc=`echo "$grpline" | /usr/bin/cut -c"$len"`

    if [ "$lastc" = ":" ] ; then
	newline="$grpline$2"
    else
	newline="$grpline,$2"
    fi

   /usr/bin/sed s/"$grpline"/"$newline"/ /etc/group >> /etc/newgrp.$$ 

   /usr/bin/mv /etc/newgrp.$$ /etc/group
}


# Validates  groups in /etc/group
# Input   : None
# Returns : None
#
validate_groups()
{
    # Make sure that the group name has :: after it
    results=`/usr/bin/cat /etc/group`
    for each_result in $results
    do
        tmp_key=`/usr/bin/expr $each_result : '\(.*\)::.*'`
        if [ "$tmp_key" = "" ]; then
            tmp_key=`echo $each_result | /usr/bin/cut -d: -f1`
            tmp_value=`/usr/bin/expr $each_result : "$tmp_key:\(.*\)"`
            each_result="$tmp_key::$tmp_value"
        fi
        echo $each_result >> /etc/newgrp.$$
    done

    /usr/bin/mv /etc/newgrp.$$ /etc/group
}


# Adds users to group
# Input   : $1 = group to copy users from
# Returns : None
#
add_group_members() {

    userlist=`/usr/bin/grep "^$1" /etc/group | /usr/bin/cut -f4 -d:`
    [ $? -ne 0 ] && return 0

    msg_written=0
    OLDIFS=$IFS
    IFS=,
    for each_user in $userlist
    do
	/usr/bin/id $each_user >/dev/null 2>&1
	if [ $? -ne 0 ] ; then
	    echologverbose 'User $3 in group $2 is not a valid user.  Leaving it out of the esusers file.' $1 $each_user
	    msg_written=1
	    continue
	fi
        /usr/bin/grep "\<$each_user\>" $VARDIR/esusers >/dev/null
	if [ $? -ne 0 ] ; then
	    echologverbose 'Adding user $2 from group $3 to esusers' $each_user $1
	    echo "$each_user" | /usr/bin/cat >> "$VARDIR/esusers"
	    msg_written=1
	fi
    done
    IFS=$OLDIFS
    #[ $msg_written -eq 1 ] && echolog ''

}

# Configures file related to esusers
# Input   : None ( reads globals )
# Returns : None
#
setup_esusers() {

    /usr/bin/grep "$ESPRIVATEID" ${VARDIR}/esusers >/dev/null 2>&1
    [ $? -ne 0 ] && echo "$ESPRIVATEID" >> ${VARDIR}/esusers

    /usr/bin/grep "$ESPUBLICID" ${VARDIR}/esusers >/dev/null 2>&1
    [ $? -ne 0 ] && echo "$ESPUBLICID" >> ${VARDIR}/esusers

    admusers=`/usr/bin/grep "^esadm" /etc/group | /usr/bin/cut -f4 -d:`
    domusers=`/usr/bin/grep "^esdomadm" /etc/group | /usr/bin/cut -f4 -d:`

    add_group_members esadm
    add_group_members esops
    add_group_members esdomadm

    if [ -n "$admusers" ] && [ -n "$domusers" ] ; then
	multiline_echologverbose 'It appears that you already have some users ($2)\nconfigured as Sun Management Center administrators. Leaving these users in place.' $admusers
	return 0
    fi
    echolog ''
    echolog "You need to setup a user as a Sun Management Center administrator."
    echolog "This person will be added to the esadm and esdomadm groups."
    

    retcode=1
    READ_RESPONSE_ONCE=0
    while [ $retcode -ne 0 ]; do
   
      fetch_response_text "TAG=SUNMC_USERNAME" "You must enter a valid username: " 
      if [ $? -gt 0 ] ; then
            exit "$INVALID_USER_ERROR"          
      fi
         
      [ "$answer" = "_none_" ] && return 0

      /usr/bin/id "$answer" >/dev/null 2>&1
      retcode=$?

      [ $retcode -gt 0 ] && echolog 'Invalid username.' 

   done

   SYM_ADM="$answer"
   
   saveAutoConfig "SUNMC_USERNAME" "$SYM_ADM"


   /usr/bin/grep -i "$SYM_ADM" ${VARDIR}/esusers >/dev/null 2>&1
   [ $? -ne 0 ] && echo "$SYM_ADM" | /usr/bin/cat >> ${VARDIR}/esusers

   add_user_to_group esadm "$SYM_ADM"
   add_user_to_group esdomadm "$SYM_ADM"
}


# Creats new group
# Input $1 = Group Name
# Returns - Failure staus 0/1
#
create_group() {
    groupname="$1"
    groupid=1000
    gidfound="FALSE"
    GroupIdList=`/usr/bin/cat /etc/group | /usr/bin/cut -f 3 -d :`
    GroupNameList=`/usr/bin/cat /etc/group | /usr/bin/cut -f 1 -d :`
    echo "$GroupNameList" | /usr/bin/grep -w $groupname > /dev/null 2>&1
    if [ $? -eq 0 ] ; then
        #group is already present so go ahead
        echologverbose ""
        echologverbose 'The group $2 already exists on your system.' $1
        echologverbose ""
        return 0
    fi

    echologverbose 'Creating the group $2 that contains Sun Management Center $3 Users.' $1 "$2"
    echologverbose ""
    #echolog "/usr/sbin/groupadd $1"
    #addout=`/usr/sbin/groupadd $1 2>&1`
    # 
    # Check the return value here.
    #
    while [ $gidfound = "FALSE" ]
    do
	 echo "$GroupIdList" | /usr/bin/grep -w $groupid > /dev/null 2>&1
	 if [ $? -eq 0 ] ; then
	     groupid=`/usr/bin/expr $groupid + 1`
	     continue
	 else
	     gidfound="TRUE"
	     echo "$groupname::$groupid:" >> /etc/group
             #
             # Store create group in registry so that we can remove this
             # group at the time of uninstallation.
             #
             createdgroups=`$API_QUERY_REGISTRY "$REGISTRY" "category=Installation" "layer=LAYER.SERVER" "groups_added"` 2> /dev/null
             $API_SET_ATTRIBUTE "$REGISTRY" "category=Installation" "layer=LAYER.SERVER" "groups_added=$groupname $createdgroups" 2> /dev/null

	 fi
    done

}

# Verifies that a string can be found in a file.
#
# Input   : $1 is string to search for
#           $2 is file to search
# Returns : - Exits if not found 
#
verify_string() {
    /usr/bin/grep $1 $2 >/dev/null 2>&1
    if [ $? -ne 0 ] ; then
	echologverbose ""
	echologverbose 'Could not find $2 in $3' $1 $2
	echologverbose ""
	exit "$FILE_READ_ERROR"
    fi
}

# Upgrade configuration files only in case of setup on backup server.
#
setup_HA_server() {

   # Create the necessary user groups (if needed)
   #
   create_group esadm Admin
   create_group esdomadm "Domain Admin"
   create_group esops Operator
   setup_esusers
   validate_groups

   # take logical host name from user and update the
   # domain-config.x by replacing by logical host name.
   #
   $XPUT "${VARDIR}/domain-config.x" \
      trap.trapServer "$HA_SERVER" \
      event.eventServer "$HA_SERVER" \
      agent.agentServer "$HA_SERVER" \
      platform.platformServer "$HA_SERVER" \
      topology.topologyServer "$HA_SERVER" \
      metadata.metadataServer "$HA_SERVER" \
      cfgserver.cfgserverServer "$HA_SERVER" \
      cstservice.cstserviceServer "$HA_SERVER"

   if [ $? -ne 0 ] ; then
      echolog ''
      echolog 'Unable to set $2 values.' "$VARDIR/domain-config.x"
      echolog ''
      exit "$XPUT_ERROR"
   fi


   # Create hastart.cfg/hastop.cfg files in case of cluster installation
   #
   echologverbose 'Generating HA configuration files...'
   #/usr/bin/rm -f ${VAROPTDIR}/cfg/hastart.cfg
   /usr/bin/echo "$BASEDIR/sbin/es-start -d" > ${VAROPTDIR}/cfg/hastart.cfg 
   /usr/bin/echo "$BASEDIR/sbin/es-start -t" >> ${VAROPTDIR}/cfg/hastart.cfg 
   /usr/bin/echo "$BASEDIR/sbin/es-start -f" >> ${VAROPTDIR}/cfg/hastart.cfg 
   /usr/bin/echo "$BASEDIR/sbin/es-start -m" >> ${VAROPTDIR}/cfg/hastart.cfg 
   /usr/bin/echo "$BASEDIR/sbin/es-start -p" >> ${VAROPTDIR}/cfg/hastart.cfg 
   /usr/bin/echo "$BASEDIR/sbin/es-start -e" >> ${VAROPTDIR}/cfg/hastart.cfg 
   /usr/bin/echo "$BASEDIR/sbin/es-start -s" >> ${VAROPTDIR}/cfg/hastart.cfg 
   /usr/bin/echo "$BASEDIR/sbin/es-start -w" >> ${VAROPTDIR}/cfg/hastart.cfg
   /usr/bin/echo "$BASEDIR/sbin/es-start -g" >> ${VAROPTDIR}/cfg/hastart.cfg
   #/usr/bin/rm -f ${VAROPTDIR}/cfg/hastop.cfg
   /usr/bin/echo "$BASEDIR/sbin/es-stop -S" > ${VAROPTDIR}/cfg/hastop.cfg
   
   # Update javaserver.properties
   #
   if [ -f $VARDIR/javaserver.properties ] ; then
      echologverbose 'Updating javaserver.properties for logical hostname...'
      /usr/bin/mv -f ${VAROPTDIR}/cfg/javaserver.properties ${VAROPTDIR}/cfg/javaserver.properties.non_HA
      /usr/bin/cat ${VAROPTDIR}/cfg/javaserver.properties.non_HA | /usr/bin/sed s/"#AlternateRmiHosts ="/"AlternateRmiHosts = $HA_SERVER:2099"/g > ${VAROPTDIR}/cfg/javaserver.properties
      /usr/bin/chmod 600 ${VAROPTDIR}/cfg/javaserver.properties
   else
      echolog 'javaserver.properties does not exist. You must perform setup on primary node first.'
      exit 1
   fi
   # generate seeds only if user is not doing an upgrade
   #
   if [ "$UPGRADE_DONE" != "YES" ]; then
      if [ "$generate_security_keys" = "1" ]; then
         generate_keys server $do_default "$security_seed" "$SNMPV1_STRING"
         configure_community_string_file metadata
         configure_community_string_file topology
         configure_community_string_file cfgserver
         configure_community_string_file event
         configure_community_string_file cstservice
         configure_community_string_file trap
      fi
   fi

   echologverbose ''
   echologverbose 'Completing Sun Management Center HA-Server Component setup.'
   echologverbose ''

}

# Get a free port
#
# Input:  $1 = default lookup_service port
#         $2 = TAG in RS file
#         $3 = Name of service/component for which port belongs
# Returns $free_port
#
get_free_port() {
   free_port="$1"
   port_busy=0
   /usr/bin/netstat -an | /usr/bin/grep "\*\.$1 " >/dev/null
   [ $? -eq 0 ] && port_busy=1
   
   L_ALL_SUNMC_PORTS=`$XGET ${TMP_DIR}/sunmc_ports.x  ALL_SUNMC_PORTS 2> /dev/null`
   /usr/bin/echo "$L_ALL_SUNMC_PORTS" | /usr/bin/grep -w $1  > /dev/null
   [ $? -eq 0 ] && port_busy=1 # Port already occupied by other sunmc proc

   if [ $port_busy -eq 1 -o "$2" = "HTTP_SERVER_OPTIONAL_PORT" ] ; then

      if [  "$2" = "HTTP_SERVER_OPTIONAL_PORT" ] ; then  
         echolog 'Configure Sun Management Center $2 port. Default port is 8080' "$3"
      else
         #echolog "------------------------  WARNING  ------------------------"
         echolog 'It appears that $2 $3 is already in use.' "$3 port" "$1"
         echolog 'Sun Management Center $2 may not be able to run due to this conflict.' "$3"
         echolog "There are two ways to correct this conflict:"
         echolog "  1. Reconfigure the port that Sun Management Center uses."
         echolog "  2. Stop the process that is using the port."
         echolog ''
      fi

      echolog 'Press RETURN to force default port.'
      retcode=1
      READ_RESPONSE_ONCE=0
      while [ $retcode -ne 0 ]; do

         fetch_response_text "TAG=$2" "Enter port you would like to use [ 1100 to 65535 ]:"
         [ $? -gt 0 ] && exit_SunMC "$SUMMARY_READ_ERROR"
         
         [ -z "$answer" ] && answer="s" && break
         [ $answer = "DEFAULT" ] && answer="s" && break

         /usr/bin/expr $answer + 1  1> /dev/null  2>&1 
         retcode=$?
         if [ $retcode -ne 0 ] ; then
            echolog 'Port $2 is not a valid port number. Try again.' "$answer"
            continue
         fi

         if [ $answer -lt 1100 -o $answer -gt 65535 ] ; then
            echolog 'Invalid port. Try again.'
            if [ "$flash_questions_to_console" = "0" ]; then
               answer="s"
               break
            fi 
            retcode=1
            continue
         fi         
      
         L_ALL_SUNMC_PORTS=`$XGET ${TMP_DIR}/sunmc_ports.x  ALL_SUNMC_PORTS 2> /dev/null`
         /usr/bin/echo "$L_ALL_SUNMC_PORTS" | /usr/bin/grep -w $answer  > /dev/null
         if [ $? -ne 0 ]; then # Not used by other sunmc process
            /usr/bin/netstat -an | /usr/bin/grep "\*\.$answer " >/dev/null
            retcode=$?
            [ $retcode -gt 0 ] && break
            retcode=1
         else
            retcode=1
         fi
         echolog 'The port you entered is busy. Try again.'
      done

      free_port="$answer"

      if [ "$free_port" = "s" ] ; then
         free_port="$1"
      fi
      
      echolog ''
      saveAutoConfig "$2" "$free_port"
      
   fi

   # If selected, add it to L_ALL_SUNMC_PORTS
   # 
   L_ALL_SUNMC_PORTS=`$XGET ${TMP_DIR}/sunmc_ports.x  ALL_SUNMC_PORTS 2> /dev/null`
   L_ALL_SUNMC_PORTS="$L_ALL_SUNMC_PORTS<$free_port>"
   $XPUT "${TMP_DIR}/sunmc_ports.x" "ALL_SUNMC_PORTS" "$L_ALL_SUNMC_PORTS"
    
}


# Smart Update server setup
smartupdate_server_setup()
{
    /bin/rm -rf $BASEDIR/web/agentupdate
    /usr/bin/mkdir -p /var/opt/SUNWsymon/agentupdate > /dev/null 2>&1
    /usr/bin/chmod -R go-w /var/opt/SUNWsymon/agentupdate > /dev/null 2>&1

    /usr/bin/ln -s /var/opt/SUNWsymon/agentupdate $BASEDIR/web/ > /dev/null 2>&1

     # InstallServer.log
    /usr/bin/mkdir -p /var/opt/SUNWsymon/log
    /usr/bin/touch /var/opt/SUNWsymon/log/InstallServer.log
    get_webserver_user
    /usr/bin/chown -f $WEB_USER /var/opt/SUNWsymon/log/InstallServer.log
    /usr/bin/chmod -f u=rw,go=r /var/opt/SUNWsymon/log/InstallServer.log

    return 0
}


copy_smartupdate_task()
{
   SERVICES_DIR="${BASEDIR}/AdvancedServices/services/agentupdate"
   VAROPT_SVCDIR="${VAROPTDIR}/AdvancedServices/services/agentupdate"
   TASKS_DIR="${BASEDIR}/AdvancedServices/tasks/agentupdate"
   VAROPT_TASKSDIR="${VAROPTDIR}/AdvancedServices/tasks/agentupdate"

   /usr/bin/mkdir -p $VAROPT_SVCDIR
   /usr/bin/mkdir -p $VAROPT_TASKSDIR

   /usr/bin/cp $SERVICES_DIR/* $VAROPT_SVCDIR
   /usr/bin/cp $TASKS_DIR/* $VAROPT_TASKSDIR
}


get_webserver_user ()
{
    WEB_USER=noaccess

    if [ -f $VARDIR/javaserver.properties ]; then
        # Get any user defined in the properties file and strip blanks.
        user=`/usr/bin/grep -w sunmc.server.webserver.user $VARDIR/javaserver.properties | /usr/bin/cut -f2 -d= | /usr/bin/sed 's/ //g'` 
        [ -n "$user" ] && WEB_USER=$user
    fi
}


#####################################################################################
#  Main entry point
#####################################################################################

PROGNAME="$0"; export PROGNAME
BASEDIR=`/usr/bin/pkgparam SUNWescom BASEDIR`
SCRIPT_DIR=${BASEDIR}/SUNWsymon/sbin
TOOLS_DIR=${SCRIPT_DIR}/../lib/sbin

. ${SCRIPT_DIR}/es-common.sh
. ${TOOLS_DIR}/setup-functions.sh
. ${TOOLS_DIR}/script-errors.sh
. ${TOOLS_DIR}/es-keys.sh

VERBOSE=OFF
do_default=0
setup_HA_flag=0
while getopts Hdvs: OPT
do
    case $OPT in
        H)  setup_HA_flag=1
            ;;
	d)
	    do_default=1
	    ;;
	v)
	    VERBOSE=ON
	    ;;
        s)
            security_seed="$OPTARG"
            #echologverbose 'Using security seed $2 for Sun Management Center server' "$security_seed"
            ;;

	*)
	    exit "$ARGUMENTS_ERROR"
    esac
done

set_commondirs
set_basedir

PROGNAME="$0"; export PROGNAME
check_root
check_logfile setup

check_osver
set_xput

echologverbose ""
echologverbose "This part of the setup process does the Sun Management Center Server Component setup."

[ "$setup_HA_flag" = "1" ] && setup_HA_server && exit 0

# Create the necessary user groups (if needed)
#
create_group esadm Admin
create_group esdomadm "Domain Admin"
create_group esops Operator

setup_esusers
validate_groups

# Create the backgrounds directory
#
[ ! -d "$VARDIR/backgrounds" ] && /usr/bin/mkdir "$VARDIR/backgrounds"
/usr/bin/cp -r "$BASEDIR/classes/base/console/cfg/backgrounds" "$VARDIR"

current_host=`/usr/bin/hostname`

# Setup domain-config.x
# First check the settings used by Agent Component
#


# The following block is redundant as NAT setup is moved to es-config
#

#if [ "$LOGICAL_ADDRESS_MODE" = "name" ] ; then
#
#    echolog ""
#    multiline_echolog 'Note: the hostname entered below must be present in the hostmaps\nof all machines that must communicate with this host through a NAT.'
#    echolog ""
#
#    returncode=255
#    READ_RESPONSE_ONCE=0
#    while [ $returncode -ne 0 ]
#    do
#        fetch_response_text "TAG=SUNMC_SERVER" 'Enter the Sun Management Center Server Hostname [ $3 ] : ' "$current_host"
#        if [ "$answer" = "" ] ; then
#            answer="$current_host"
#        fi 
#
#        isIpAddress "$answer"
#        if [ $? -eq 1 ] ; then
#            echolog "You must enter a valid hostname, IP addresses are invalid when in name mode"
#        else
#
#            validate_host "$answer"
#            if [ $? -ne 0 ] ; then
#                echolog 'Host $2 not pingable. Try again.' "$answer"
#            else
#                returncode=0
#            fi
#        fi
#        echolog ""
#    done
#
#    current_host="$answer"
#fi

echolog ""

#
agent_port=""
platform_port=""
if [ -f ${VARDIR}/domain-config.x ] ; then
    agent_port=`$XGET ${VARDIR}/domain-config.x agent.snmpPort`
    platform_port=`$XGET ${VARDIR}/domain-config.x platform.snmpPort`
fi

$XPUT "${VARDIR}/domain-config.x" agent.agentServer "$current_host" \
	trap.trapServer "$current_host" event.eventServer "$current_host" \
	platform.platformServer "$current_host" 

if [ -z "$agent_port" ] ; then
    $XPUT "${VARDIR}/domain-config.x" agent.snmpPort 161 trap.snmpPort 162 event.snmpPort 163 
    if [ $? -ne 0 ] ; then
	echolog ''
	echolog 'Unable to set $2 values.' "$VARDIR/domain-config.x"
	echolog ''
	exit "$XPUT_ERROR"
    fi
else
    echologverbose ""
    echologverbose 'agent.snmpPort is already configured in $2' "$VARDIR/domain-config.x"
    echologverbose ""
fi

#
# setup metadata component domain-config section
#
metadata_port=`$XGET ${VARDIR}/domain-config.x metadata.snmpPort`
$XPUT "${VARDIR}/domain-config.x" metadata.metadataServer "$current_host"
if [ -z "$metadata_port" ] ; then
   $XPUT "${VARDIR}/domain-config.x" metadata.snmpPort 168 

   if [ $? -ne 0 ] ; then
      echolog ''
      echolog 'Unable to set $2/domain-config.x values.' $VARDIR
      echolog ''
      exit "$XPUT_ERROR"
   fi
else
   echologverbose ""
   echologverbose 'metadata.snmpPort is already configured in $2' "$VARDIR//domain-config.x"
   echologverbose ""
fi

[ -z "$platform_port" ] && $XPUT "${VARDIR}/domain-config.x" platform.snmpPort 166

# Now check the settings used by Server Component
#
topo_port=`$XGET ${VARDIR}/domain-config.x topology.snmpPort`
$XPUT "${VARDIR}/domain-config.x" topology.topologyServer "$current_host" \
   cfgserver.cfgserverServer "$current_host" cstservice.cstserviceServer "$current_host"

if [ -z "$topo_port" ] ; then
   $XPUT "${VARDIR}/domain-config.x" \
      topology.snmpPort 164 cfgserver.snmpPort 165 cstservice.snmpPort 167 

   if [ $? -ne 0 ] ; then
      echolog ''
      echolog 'Unable to set $2/domain-config.x values.' $VARDIR
      echolog ''
      exit "$XPUT_ERROR"
   fi
else
   echologverbose ""
   echologverbose 'topology.snmpPort is already configured in $2' "$VARDIR//domain-config.x"
   echologverbose ""
fi

check_port topology.snmpPort topology
check_port cfgserver.snmpPort cfgserver
check_port event.snmpPort event
check_port cstservice.snmpPort cstservice
check_port trap.snmpPort trap
check_port metadata.snmpPort metadata

# write logical addressing mode to domain-config.x
#
$XPUT $VARDIR/domain-config.x "topology.logicalAddressMode" "$LOGICAL_ADDRESS_MODE"
$XPUT $VARDIR/domain-config.x "cfgserver.logicalAddressMode" "$LOGICAL_ADDRESS_MODE"
$XPUT $VARDIR/domain-config.x "event.logicalAddressMode" "$LOGICAL_ADDRESS_MODE"
$XPUT $VARDIR/domain-config.x "cstservice.logicalAddressMode" "$LOGICAL_ADDRESS_MODE"
$XPUT $VARDIR/domain-config.x "trap.logicalAddressMode" "$LOGICAL_ADDRESS_MODE"
$XPUT $VARDIR/domain-config.x "metadata.logicalAddressMode" "$LOGICAL_ADDRESS_MODE"


#
#  Setup server-config.x
#
if [ ! -f ${VARDIR}/server-config.x ] ; then
    /usr/bin/cp "$BASEDIR"/classes/base/server/cfg/server-config.x \
	${VARDIR}/server-config.x
    #/usr/bin/chmod u+w ${VARDIR}/server-config.x
fi

get_server_rmi_port

check_port_number rmiReceptor.rmiPort server $port

[ -f "$VARDIR/cfgserver-oids-d.dat" ] && /usr/bin/rm "$VARDIR/cfgserver-oids-d.dat"
[ -f "$VARDIR/event-oids-d.dat" ] && /usr/bin/rm "$VARDIR/event-oids-d.dat"
[ -f "$VARDIR/cstservice-oids-d.dat" ] && /usr/bin/rm "$VARDIR/cstservice-oids-d.dat"
[ -f "$VARDIR/topology-oids-d.dat" ] && /usr/bin/rm "$VARDIR/topology-oids-d.dat"
[ -f "$VARDIR/trap-oids-d.dat" ] && /usr/bin/rm "$VARDIR/trap-oids-d.dat"
[ -f "$VARDIR/metadata-oids-d.dat" ] && /usr/bin/rm "$VARDIR/metadata-oids-d.dat"

#
# Create the javaserver.properties before calling the base-usm-seed script.
# That script now may change the javaserver.properties file
#

# Check for lookup_service_port & put it in javaserver.properties files
# sets service_port
# 
get_free_port "5600" "LOOKUP_SERVICE_OPTIONAL_PORT" "lookup service"
service_port="$free_port"

# Setup javaserver.properties
#
if [ -f $BASEDIR/classes/base/server/cfg/javaserver.properties ] ; then
   [ ! -d $VAROPTDIR/cfg ] && /bin/mkdir $VAROPTDIR/cfg
   [ -f ${VAROPTDIR}/cfg/javaserver.properties ] && /usr/bin/mv -f ${VAROPTDIR}/cfg/javaserver.properties ${VAROPTDIR}/cfg/javaserver.properties.old
   /usr/bin/cp $BASEDIR/classes/base/server/cfg/javaserver.properties /tmp/javaserver.properties
   /usr/bin/cat /tmp/javaserver.properties | /usr/bin/grep -v "ServiceRegistryPort" > ${VAROPTDIR}/cfg/javaserver.properties
   /usr/bin/echo  "ServiceRegistryPort = $service_port\n" >> ${VAROPTDIR}/cfg/javaserver.properties
   /usr/bin/chmod 600 ${VAROPTDIR}/cfg/javaserver.properties
   /usr/bin/rm -f /tmp/javaserver.properties

#Creating Properties file for webconsole login
   if [ -f  ${VAROPTDIR}/cfg/weblogin.properties ] ; then
       /usr/bin/rm -rf  ${VAROPTDIR}/cfg/weblogin.properties
   fi
   /usr/bin/touch ${VAROPTDIR}/cfg/weblogin.properties
   /usr/bin/cat ${VAROPTDIR}/cfg/javaserver.properties | /usr/bin/grep "^RmiHost" >> ${VAROPTDIR}/cfg/weblogin.properties
   /usr/bin/cat ${VAROPTDIR}/cfg/javaserver.properties | /usr/bin/grep "^RmiPort" >> ${VAROPTDIR}/cfg/weblogin.properties


fi

# generate seeds only if user is not doing an upgrade
#
if [ "$UPGRADE_DONE" != "YES" ]
then
    if [ "$generate_security_keys" = "1" ]; then
       generate_keys server $do_default "$security_seed" "$SNMPV1_STRING"
       configure_community_string_file metadata
       configure_community_string_file topology
       configure_community_string_file cfgserver
       configure_community_string_file event
       configure_community_string_file cstservice
       configure_community_string_file trap
    fi
fi

fix_metadata_modules
fix_topology_modules
fix_cfgserver_modules
fix_trap_modules
fix_event_modules
fix_cstservice_modules

# Copy ServerOverrideBundle.properties files to /var$BASEDIR/classes
#
if [ -f $BASEDIR/classes/ServerOverrideBundle.properties ] ; then
    [ ! -d $VAROPTDIR/classes ] && /bin/mkdir $VAROPTDIR/classes
    /usr/bin/cp $BASEDIR/classes/ServerOverrideBundle* $VAROPTDIR/classes
fi

# Setup host-apps-j.x
#
if [ ! -f ${VARDIR}/host-apps-j.x ] ; then
	/usr/bin/touch ${VARDIR}/host-apps-j.x 
	/usr/bin/chmod u+w ${VARDIR}/host-apps-j.x 
fi
 
#  Setup javaservice.properties
#
if [ -f $BASEDIR/classes/base/server/cfg/javaservice.properties ] ; then
   [ ! -d $VAROPTDIR/cfg ] && /bin/mkdir $VAROPTDIR/cfg
   [ -f ${VAROPTDIR}/cfg/javaservice.properties ] && /usr/bin/mv -f ${VAROPTDIR}/cfg/javaservice.properties ${VAROPTDIR}/cfg/javaservice.properties.old
   /usr/bin/cp $BASEDIR/classes/base/server/cfg/javaservice.properties /tmp/javaservice.properties
   /usr/bin/cat /tmp/javaservice.properties | /usr/bin/grep -v "ServiceRegistryPort"  > ${VAROPTDIR}/cfg/javaservice.properties
   /usr/bin/echo  "ServiceRegistryPort = $service_port\n" >> ${VAROPTDIR}/cfg/javaservice.properties
   /usr/bin/rm -f /tmp/javaservice.properties
fi

# Setup server-ddl.properties
#
if [ -f $BASEDIR/classes/base/server/cfg/server-ddl.properties ] ; then
    [ ! -d $VAROPTDIR/cfg ] && /bin/mkdir $VAROPTDIR/cfg
    /usr/bin/cp $BASEDIR/classes/base/server/cfg/server-ddl.properties $VAROPTDIR/cfg
    /usr/bin/chmod u+w ${VAROPTDIR}/cfg/server-ddl.properties
fi
  

# Setup Web server
#

echologverbose 'Setting up web server...'


# Task 1 fetch Cu info and put in registry
#
#
echolog ''
multiline_echolog 'An encrypted security key is needed for the Sun Management Center web server.\nThe key is generated based on the organization and location you provide.'
retcode=1

READ_RESPONSE_ONCE=0
while [ 1 ]; do
     fetch_response_text "TAG=CUSTOMER_ORGANIZATION" "Enter the name of your organization : " 
     [ $? -gt 0 ] && exit "$INVALID_USER_ERROR"          
     [ ! -z "$answer" ] && break
done

ORGANIZATION="$answer"

key_char_count=`/usr/bin/echo "$ORGANIZATION" | /usr/bin/wc -c`
[ $key_char_count -gt 31 ] && ORGANIZATION=`/usr/bin/echo "$ORGANIZATION"  | /usr/bin/cut -c1-30`

saveAutoConfig "CUSTOMER_ORGANIZATION" "$ORGANIZATION"

retcode=1
READ_RESPONSE_ONCE=0
while [ 1 ]; do
     fetch_response_text "TAG=CUSTOMER_LOCATION" "Enter the geographical location of this host :" 
     [ $? -gt 0 ] && exit "$INVALID_USER_ERROR"          
     [ ! -z "$answer" ] && break
done

LOCATION="$answer"

key_char_count=`/usr/bin/echo "$LOCATION" | /usr/bin/wc -c`
[ $key_char_count -gt 31 ] && LOCATION=`/usr/bin/echo "$LOCATION"  | /usr/bin/cut -c1-30`

saveAutoConfig "CUSTOMER_LOCATION" "$LOCATION"

# Put this info in registry
#
$API_SET_ATTRIBUTE "$REGISTRY" "category=Installation" "customer_organization=${ORGANIZATION}" > /dev/null 2>&1    
$API_SET_ATTRIBUTE "$REGISTRY" "category=Installation" "customer_location=${LOCATION}" > /dev/null 2>&1    

# Now rename the keystore file.
# This is in order to delete but have a backup. 
# Bugfix 4854167

KEYSTORE="$VAROPTDIR/web/keystore"
[ -f "${KEYSTORE}.old" ] && $CMD_RM "${KEYSTORE}.old"
[ -f "$KEYSTORE" ] && $CMD_MV "$KEYSTORE" "${KEYSTORE}.old"

# MultiIP configuration
#
/usr/bin/pkginfo -qi SUNWessrv > /dev/null 2>&1
if [ $? -eq 0 ] ; then
   echolog ''
   ${SCRIPT_DIR}/esmultiip
else
   echolog 'WARNING:package $2 is not installed correctly. Multi-IP support not enabled.' "SUNWessrv"
fi


# Task 2 Configure port for http and https
#
#
web_server_error=0

HOSTNAME=`/usr/bin/hostname`
SERVER_HOST="http://$HOSTNAME:80"

check_webserver
if [ $? -eq 0 ] ; then
   # Returns $free_port
   
   get_free_port "8080" "HTTP_SERVER_OPTIONAL_PORT" "web server"
   http_free_port="$free_port"
  
   get_free_port "8443" "HTTPS_SERVER_OPTIONAL_PORT" "web server"
   https_free_port="$free_port"

   /usr/bin/mkdir -p "${VAROPTDIR}/web/"
   /usr/bin/mkdir -p "${VAROPTDIR}/web/logs"
   /usr/bin/mkdir -p "${VAROPTDIR}/web/work"
   /usr/bin/chmod 755 "${VAROPTDIR}/web/work" >/dev/null 2>&1 
   /usr/bin/chmod 755 "${VAROPTDIR}/web/logs" >/dev/null 2>&1 

   /usr/bin/chown nobody:nobody "${VAROPTDIR}/web/work" >/dev/null 2>&1  # As run by nobody.
   /usr/bin//chown nobody:nobody "${VAROPTDIR}/web/logs" >/dev/null 2>&1  # As run by nobody.

   /usr/bin/ln -s "${VAROPTDIR}/web/logs" "$BASEDIR/web/logs" >/dev/null 2>&1
   /usr/bin/ln -s "${VAROPTDIR}/web/work" "$BASEDIR/web/work" >/dev/null 2>&1
   
   if [ -f ${BASEDIR}/web/conf/webserver-config.xml ]; then

       # Force copy of fresh config file.
       # This is must to keep relibility of sed operations on this xml file
       # During base setup , all configuration will be forced.
       #
       /usr/bin/cp -f ${BASEDIR}/web/conf/webserver-config.xml ${BASEDIR}/web/conf/server.xml

       # Enable DE SDK help if DE is installed
       #
       if [ "$no_DE_EXPORTED" = "0" ]; then
           /usr/bin/sed "s/!--SDKSTART//"  ${BASEDIR}/web/conf/server.xml > ${BASEDIR}/web/conf/server.xml.tmp
           /usr/bin/sed "s/SDKEND--/> <\/Context/"  ${BASEDIR}/web/conf/server.xml.tmp > ${BASEDIR}/web/conf/server.xml
           /usr/bin/rm -f ${BASEDIR}/web/conf/server.xml.tmp
       fi
        
       /usr/bin/sed "s/port=\"8080\"/port=\"$http_free_port\"/"  ${BASEDIR}/web/conf/server.xml > ${BASEDIR}/web/conf/server.xml.tmp
       /usr/bin/sed "s/port=\"8443\"/port=\"$https_free_port\"/"  ${BASEDIR}/web/conf/server.xml.tmp > ${BASEDIR}/web/conf/server.xml
       /usr/bin/rm -f ${BASEDIR}/web/conf/server.xml.tmp

       #begin set web server index.html
       update_index_page "$http_free_port"
  
       [ -f "${BASEDIR}/web/conf/generic-web.xml" ] && /usr/bin/cp -f "${BASEDIR}/web/conf/generic-web.xml" "${BASEDIR}/web/conf/web.xml"
 
       /usr/bin/mkdir -p "${BASEDIR}/web/help/WEB-INF"
       [ -f "${BASEDIR}/web/conf/help-web.xml" ] && /usr/bin/cp -f "${BASEDIR}/web/conf/help-web.xml" "${BASEDIR}/web/help/WEB-INF/web.xml"

       /usr/bin/rm -rf "${BASEDIR}/web/help/locale"
       /usr/bin/ln -s "$BASEDIR/lib/locale" "${BASEDIR}/web/help/locale" > /dev/null 2>&1
      
       HOSTNAME=`/usr/bin/hostname`
       SERVER_HOST="http://$HOSTNAME:$http_free_port"
       [ -f "${VAROPTDIR}/web/server_hosts" ] && /usr/bin/mv -f ${VAROPTDIR}/web/server_hosts ${VAROPTDIR}/web/server_hosts.old
       /usr/bin/echo  "$SERVER_HOST" > ${VAROPTDIR}/web/server_hosts
       
       CATALINA_BASE="$BASEDIR/web"
       export CATALINA_BASE
       
       # Setup help url  
       # 
       set_help_location ":$http_free_port/help/"
   else
      echolog ''
      echolog 'Error in web server setup.'
      echolog 'Web Server may not function properly.'
      echolog ''
   fi
else
   echolog ''
   echolog 'WARNING: Web Server package is not installed correctly.'
   echolog 'Skipping Web Server setup...'
fi

#
# Setup Web console
#
/usr/bin/pkginfo -qi SUNWesweb > /dev/null 2>&1
if [ $? -eq 0 ]; then
   $TOOLS_DIR/sunmc-webconsole-setup.sh -setup
fi

#
# Setup Grouping service
#
/usr/bin/pkginfo -qi SUNWessvc > /dev/null 2>&1
if [ $? -ne 1 ]; then
    $BASEDIR/lib/sbin/sunmc-grouping-setup.sh
fi

#
# Setup MCP
#
/usr/bin/pkginfo -qi SUNWesmcp > /dev/null 2>&1
if [ $? -ne 1 ]; then
    $BASEDIR/lib/sbin/sm_setup_mcp.sh Server
fi

#
# Smart Update Setup
#

smartupdate_server_setup
copy_smartupdate_task

echologverbose ''
echologverbose 'Completing Sun Management Center Server Component setup.'
echologverbose ''

exit "$NO_ERROR"

