#!/bin/sh
#=============================================================================
# pragma ident  "@(#)gui-setup-port.sh	1.10 04/12/16 Sun Microsystems"
#
# This script checks the port for the GUI setup. Returns 0 if the port is OK
# and 1 if port is busy
#=============================================================================
#
#
#
#  $1 = domain-config.x parameter to check
#  $2 = process to check
#  $3 = PORT
check_port_number() {

    /usr/bin/netstat -an | /usr/bin/grep "\*\.$3 " >/dev/null
    [ $? -ne 0 ] && return 0
    #
    #  Make sure it isn't in use by one of the SyMON processes!
    #
    numproc=`/usr/bin/ps -aef | /usr/bin/grep 'esd - init $2' | \
    /usr/bin/grep -v /usr/bin/grep | /usr/bin/wc -l`
    numproc=`echo $numproc`
    [ "$numproc" -eq 0 ] && return 1

    return 0
}

#Main Program starts here
VAROPTDIR="/var/opt/SUNWsymon"

. ${VAROPTDIR}/install/port-file #Source the file which is set by the GUI Wizard with the appropriate variables

check_port_number $DOMAIN_CONFIG_VARIABLE $SERVICE $PORT
ret=$?
if [ -f "${VAROPTDIR}/install/port-file" ] ; then 
  /usr/bin/rm -rf ${VAROPTDIR}/install/port-file
fi
if [ $ret -ne 0 ]; then
    echo 0 && exit
fi
# Special check for port 161 on Solaris 10
# Even though port 161 is not occupied
# check if this is Solaris 10 and
# SMA is configured to run on port 161
osrev=`/bin/uname -r|/bin/cut -d"." -f2`
if [ $PORT -eq 161 -a $osrev -gt 9 ]; then
    cfgfile=/etc/sma/snmp/snmpd.conf
    /bin/grep -wi agentaddress $cfgfile > /dev/null 2>&1
    if [ $? -eq 1 ]; then
	echo 0 && exit
    else 
	/bin/grep -wi agentaddress $cfgfile | /bin/grep -w 161 > /dev/null 2>&1
	[ $? -eq 0 ] && echo 0 && exit
    fi
fi

# Port 161 can be used by SunMC without problem
echo 1  && exit
