<%--
  Copyright 2003 Sun Microsystems, Inc. All rights reserved 
  Use is subject to license terms.
 --%>
<%-- EditGlobalProperty.jsp --%>

<%@page info="EditProperty" language="java"%>
<%@taglib uri="/WEB-INF/jato.tld" prefix="jato"%>
<%@taglib uri="/WEB-INF/console.tld" prefix="console"%>

<jato:useViewBean 
    className="com.sun.portal.desktop.admin.EditGlobalPropertiesViewBean"
    fireChildDisplayEvents="true"> 


<html>
<head>
    <title><jato:text name="titleHtmlPage" /></title>
    <link rel="stylesheet" href="../console/css/adminstyle.css">
    <link rel="stylesheet" href="../ps/css/psadminstyle.css">
    <script language="javascript" src="../console/js/consolecomp.js"></script>
</head>

<body bgcolor="#ffffff" leftMargin="0" rightMargin="0" topMargin="0" 
  marginheight="0" marginwidth="0">
<script language="javascript">
    var pageLoaded = 0;
    var pageModified = 0;
    var currentCategory = 0;
    parent.headerFrame.helpDocURL = "<jato:text name="helpDocURL"/>";
    parent.headerFrame.helpPage = "<jato:text name="helpAnchorTag"/>";

    function setModified() {
        pageModified = 1;
    }

    function ask() {
      return confirm("<jato:text name="jsPageModMsg"/>");
    }

    function editCollection(name) {
      var url = 'EditGlobalProperties.EditCollection=' + name;
      var frmName = 'EditGlobalProperties';
      var frm = document.forms[frmName];

      if (frm != null) {
        var url = "?" + url;
        var frmAction = frm.action;
        var idx = frmAction.indexOf('?');
        if (idx != -1) {
          frmAction = frmAction.substring(0, idx);
        }
        frm.action = frmAction + url;
      }

      if(pageModified) {
        if(ask()){
          frm.submit();
        }
      } else {
        frm.submit();
      }
    }

    function checkModified() {
      if(pageModified) {
        if(!ask()){
          pageLoaded = 0;
          setTimeout("setPageLoaded()", 2000);
        }
      }
    }

    function applyFilter(filter) {
      var frmName = 'EditGlobalProperties';
      var frm = document.forms[frmName];
      if(pageModified) {
        if(ask()){
          frm.submit();
        } else {
          filter.selectedIndex = currentCategory;
        }
      } else {
          frm.submit();
      }
    }

    function setCurrentCategory(index) {
      currentCategory = index;
    }
</script>

  <!-- Begin table for breadcrumbs -->
  <table width="100%" border="0" cellpadding="0" cellspacing="0">
    <tr class="breadcrumb-row"> 
      <td colspan="3" nowrap> 
        <div class="page-title-text">
          <jato:text name="DesktopLinkLabel"/>
          <jato:text name="PageTitle"/>
        </div>
      </td>
    </tr>
    <tr> 
      <td colspan="3" nowrap><img alt="" border="0" height="3" width="1" 
          src="../console/images/spacer.gif"></td>
    </tr>
    <!--Begin Parentage paths for container and collection-->
    <tr>
      <td width="1%"><img alt="" border="0" height="1" width="10"
               src="../console/images/spacer.gif"></td>
      <td width="1%" nowrap>
        <div class="path-breadcrumb-text">
          <jato:text name="ContainerPathLabel"/>:&nbsp;
        </div>
      </td>
      <td width="99%" nowrap>
        <console:href name="TopLink">
          <b><jato:text name="TopLinkLabel"/></b>
        </console:href>
      </td>
    </tr>
    <jato:content name="CollectionPathBlock">
    <tr>
      <td colspan="3" nowrap>
         <img alt="" border="0" height="1" width="10"
              src="../console/images/spacer.gif"></td>
    </tr>
    <tr>
      <td width="1%"><img alt="" border="0" height="1" width="10"
               src="../console/images/spacer.gif"></td>
      <td width="1%" nowrap>
        <div class="path-breadcrumb-text">
          <jato:text name="CollectionPathLabel"/>:&nbsp;
        </div>
      </td>
      <td width="99%" nowrap>
        <console:parentagepath name="CollectionPath" bgColor="white"/>
      </td>
    </tr>
    </jato:content>
    <!--End Parentage paths for container and collection-->
    <tr>
      <td colspan="3" nowrap><img alt="" border="0" height="3" width="1"
          src="../console/images/spacer.gif"></td>
    </tr>
    <tr>
      <td colspan="3" bgcolor="000000"><img alt="" border="0" height="1" width="1" 
          src="../console/images/spacer.gif"></td>
    </tr>
    <tr>
      <td colspan="3" nowrap><img alt="" border="0" height="15" width="1"
          src="../console/images/spacer.gif"></td>
    </tr>
  </table>
  <!-- End table for breadcrumbs -->

  <console:form name="EditGlobalProperties" method="post" defaultCommandChild="/FilterBtn">

  <console:messagebox name="MessageBox" imageURI="../console/images" />

  <!--  Buttons -->
  <!-- Begin table containing Save and Reset Buttons -->
  <table border="0" cellpadding="0" cellspacing="0" width="100%">
    <tr>
      <td colspan="2" align="right">
        <table border="0" cellpadding="0" cellspacing="0">
          <tr>
            <td>
              <console:button name="Save"/>
            </td>
            <td><img src="../console/images/spacer.gif" width="5"
                  height="1" alt=""></td>
            <td>
              <console:button name="Reset"/>
            </td>
          </tr>
        </table>
      </td>
    </tr>
    <tr>
      <td nowrap colspan="2"><img alt="" border="0" height="10" width="1"
          src="../console/images/spacer.gif"></td>
    </tr>
  </table>
  <!-- End table containing Save and Cancel Buttons -->

  <!-- set 10 pixel right margin for everything below -->
  <div class="sub-body-margin">

  <!-- Begin the properties table with 2 cols-->
  <table border="0" cellspacing="0" cellpadding="0" width="100%">
  <tr>
    <!-- this col gives the 10 pixel left margin -->
    <td width="10"><img src="../console/images/spacer.gif" width="10" height="1"></td>
    <td>
      <div align="left" class="table-title-text">
         <jato:text name="TableTitle"/> -- <jato:text name="ChannelName"/>
      </div>
    </td>
  </tr>
  <tr>
    <!-- this col gives the 10 pixel left margin -->
    <td width="10"><img src="../console/images/spacer.gif" width="10" height="1"></td>
    <td><!-- Begin Add../Delete props buttons -->
      <table border="0" cellspacing="0" cellpadding="0">
        <tr>
          <td>
            <console:button name="New" type="mini" onClick="checkModified()"/>
          </td>
          <td><img alt="" border="0" height="1" width="5" src="../console/images/spacer.gif"></td>
          <td>
            <console:button name="Delete" type="mini" fireDisplayEvents="true" onClick="checkModified()"/>
          </td>
          <td><img alt="" height="20" width="24" src="../ps/images/dividerbar.gif"></td>
          <td><span class="table-action-label"><jato:text name="FilterLabel"/>:</span></td>
          <td><img alt="" height="1" width="5" src="../console/images/spacer.gif"></td>
          <td><jato:combobox name="Filter" elementId="EditGlobalProperties.Filter"
              onChange="this.form.elements['jato.defaultCommand'].value='FilterBtn';applyFilter(this);" onClick="setCurrentCategory(this.selectedIndex)"/>
          </td>
        </tr>
      </table><!-- End Add../Delete props buttons -->
    </td>
  </tr>
  <tr> <!-- spacer row -->
    <td colspan="2"><img src="../console/images/spacer.gif" width="1" height="10" border="0"></td>
  </tr>
  <tr>
    <!-- this col gives the 10 pixel left margin -->
    <td width="10"><img src="../console/images/spacer.gif" width="10" height="1"></td>
    <td>
      <!-- Begin outer part of data table with 1 col-->
      <table class="table-frame" border="0" cellspacing="0" cellpadding="1" width="100%">
      <tr>
        <td align="left"> 
          <!-- Begin inner table with 11 cols -->
          <table class="table-content" border="0" cellpadding="0" cellspacing="0" width="100%">
            <!-- Top row containing the column headers -->
            <tr class="table-header-row"> 
              <th><img border="0" height="8" width="8" src="../console/images/spacer.gif"></th>
              <th nowrap>&nbsp;</th>
              <th><img border="0" height="1" width="10" src="../console/images/spacer.gif"></th>
              <jato:content name="NameColumn">
              <th><div class="table-header-text"><jato:text name="NameColLabel"/></div></th>
              <th><img border="0" height="1" width="15" src="../console/images/spacer.gif"></th>
              <th><div class="table-header-text"><jato:text name="ValueColLabel"/></div></th>
              </jato:content>
              <jato:content name="NoNameColumn">
              <th colspan="3"><div class="table-header-text"><jato:text name="ValueColLabel"/></div></th>
              </jato:content>              
              <th><img border="0" height="1" width="15" src="../console/images/spacer.gif"></th>
              <th><div class="table-header-text"><jato:text name="CategoryColLabel"/></div></th>
              <th><img border="0" height="1" width="15" src="../console/images/spacer.gif"></th>
              <th><div class="table-header-text"><jato:text name="StateColLabel"/></div></th>
              <th><img border="0" height="1" width="10" src="../console/images/spacer.gif"></th>
            </tr>

            <jato:content name="NoPropertiesBlock">
            <tr>
              <td align="center" colspan="11">
                <jato:text name="NoPropertiesMsg"/>  
              </td>
            <tr>
            </jato:content>

            <!-- Begin table tiledview for props -->
            <jato:tiledView name="PropertiesTiledView"
                type="com.sun.portal.desktop.admin.PropertiesTiledView">
            <tr>
                <td class="table-separator-row" colspan="11"><img src="../console/images/spacer.gif" width="1" height="1" border="0"></td>
            </tr>
            <tr>
                <td>&nbsp;</td>
                <td valign="top" align="center"><jato:checkbox name="SelectProperty"/></td>
                <td valign="top">&nbsp;
                  <jato:hidden name="HiddenPropertyName"/>
                </td>
                <jato:content name="NameColumn">
                <td valign="top">
                  <div class="table-normal-text">
                    <a href="javascript:editCollection('<jato:text name="HiddenPropertyName"/>')">
                      <jato:text name="NestedPropertyName"/>
                    </a>
                    <jato:text name="PropertyName"/>
                  </div>
                </td>
                <td>&nbsp;</td>
                <td valign="top">
                </jato:content>
                <jato:content name="NoNameColumn">
                <td valign="top" colspan="3">
                </jato:content>
                  <div class="table-normal-text">
                    <jato:textField name="StringValue" onChange="setModified()"/>
                    <jato:textField name="IntValue" size="4" onChange="setModified()"/>
                    <jato:checkbox name="BoolValue" onChange="setModified()"/>
                  </div></td>
                <td>&nbsp;</td>
                <td valign="top">
                  <div class="table-normal-text">
                    <jato:text name="Category"/>
                  </div>
                </td>
                <td>&nbsp;</td>
                <td valign="top">
                  <div class="table-normal-text">
                    <jato:text name="State"/>
                  </div>
                </td>
                <td>&nbsp;</td>
            </tr>
            </jato:tiledView>
          </table>
          <!-- End inner table -->
        </td>
      </tr>
      </table>
      <!-- End outer part of data table -->
    </td>
  </tr>
  </table>
  <!-- End properties table -->

  <jato:hidden name="LastRead" defaultValue="-1"/>

  <!-- end 10 pixel right margin -->
  </div>

</console:form>
</body>
<script language="javascript">
pageLoaded = 1;
</script>
</html>
</jato:useViewBean>
