/*======================================================================
	Logic is used to validate required fields.  Checks form 
        elements to make sure that they are NOT empty before allowing 
        the form submission to proceed.  Functions also check for proper formatting.   
        
        In the JSP you need to customize the "validateForm" function to make calls 
        to the following functions with your form fields.   
        validateCheckBoxes(form,message) -- makes sure the user selected at least one checkbox
        validateCheckBoxesTwo(form,message) -- makes sure there is at least one checkbox unselected and at least one checkbox selected
        validRequired(formField, fieldLabel) -- checks for a field being empty
        validEmail(formField, fieldLabel, required) -- checks for a correctly formatted email address
        validNum(formField, fieldLabel, required) -- checks for a valid number (a string where all the characters are digits)
        validInt(formField, fieldLabel, required) -- checks for a number (integer) that can be correctly parsed with the function parseInt
        validDate(formField, fieldLabel, required) -- checks for a correctly formatted date 
        confirmSubmit(msg) -- requests user to confirm before proceeding with actions
	validIPAddress(formField, fieldLabel) - checks for the validity of IP Address format and value
====================================================================== */
 function checkAll(form)
{
       for (i = 0; i < form.elements.length; i++) {
            if (form.elements[i].type=="checkbox")
            {
                form.elements[i].checked = true;

            }
        } 

}

function uncheckAll(form)
{
       for (i = 0; i < form.elements.length; i++) { 
            if (form.elements[i].type=="checkbox")
            {
                form.elements[i].checked = false;

            }
        }
} 

function validateCheckBoxes(form,message)
{
       //var result = true;
       var CheckboxProceed = 0;
       var CheckboxType = 0;
        //looping through checkboxes
       for (i = 0; i < form.elements.length; i++) {
            if (form.elements[i].type=="checkbox")
            {
                CheckboxType = 1;
                if(form.elements[i].checked)
                {
                    CheckboxProceed = 1;
                }
            }
        }
     
        if (CheckboxType == 1 && CheckboxProceed == 0)
        {
            alert("Please select "+ message+"!");
            return false;
        }	
        else if(CheckboxType == 0) 
        {
            alert("No "+message+" to delete!");
            return false;
        }
        else
        {
            //empty else.
        }
	return true;
}

function validateCheckBoxesTwo(form,message)
{
       //var result = true;
       var Proceed = 0;
       var CheckboxProceedSelect = 0;
       var CheckboxType = 0;
        //looping through checkboxes
       for (i = 0; i < form.elements.length; i++) {
            if (form.elements[i].type=="checkbox")
            {
               CheckboxType = 1;
               if (form.elements[i].checked == false)
               {
                   Proceed = 1;
               }
               if (form.elements[i].checked == true)
               {
                   CheckboxProceedSelect = 1
               }               
            } 
        }
        if (CheckboxType == 1 && Proceed == 0)
        {
            alert("You cannot delete all "+ message+", please unselect at least one!");
            return false;
        }	
        else if (CheckboxType == 1 && CheckboxProceedSelect == 0) 
        {
            alert("Please make selection!");
            return false;
        } else if (CheckboxType == 0) {
            alert("No "+message+" to delete!");
            return false;
        }
	return true;
}

function validateVSCheckBox(form, message)
{
    var CheckboxProceedSelect = 0;
    for (i = 0; i < form.elements.length; i++) {
            if (form.elements[i].type=="checkbox") {
                if(form.elements[i].name.indexOf("Vir") > 0 && form.elements[i].checked) {
                    return true;
                }
                    
            }
                
   }
   alert("Please select a Virtual Server to associate with this "+message);
   return false;
}
function submitForm()
{
	return false;
}

function isWhitespace (s)
{   var i;

    // Is s empty?
    //if (isEmpty(s)) return true;
    var whitespace = " \t\n\r";
    // Search through string's characters one by one
    // until we find a non-whitespace character.
    // When we do, return false; if we don't, return true.

    for (i = 0; i < s.length; i++)
    {   
        // Check that current character isn't whitespace.
        var c = s.charAt(i);

        if (whitespace.indexOf(c) == -1) return false;
    }

    // All characters are whitespace.
    return true;
}

function isEmailAddr(email)
{
  var result = false;
  var theStr = new String(email);
  var index = theStr.indexOf("@");
  if (index > 0)
  {
    var pindex = theStr.indexOf(".",index);
    if ((pindex > index+1) && (theStr.length > pindex+1))
	result = true;
  }
  return result;
}
 
function validRequired(formField,fieldLabel)
{
	var result = true;
	
	if (((formField.type=="text"||formField.type=="textarea")&&formField.value==''))
	{
		alert("Please enter a value for "+fieldLabel);
		formField.focus();
		result = false;
	}

	if (((formField.type=="text"||formField.type=="textarea")&&formField.value!=''))
	{
            if (isWhitespace(formField.value)) 
            {
		alert("Please enter a value for "+fieldLabel);
		formField.focus();
		result = false; 
            }
	}

        if ((formField.type.toString().charAt(0)=="s"&&formField.selectedIndex==0))
        {
		alert("Please select value for "+fieldLabel);
		formField.focus();
		result = false;
        }
	
	return result;
}

function validPassword(passwd1, passwd2)
{
        var result = true;

        if (passwd1.value=='')
        {
                alert("Please enter a valid password!");
                passwd1.focus();
                result = false;
        }

        if (passwd1.value!='')
        {
            if (isWhitespace(passwd1.value))
            {
                alert("Please enter a valid password!");
                passwd1.focus();
                result = false;
            }
        }

        if (passwd1.value != passwd2.value) {
            alert("Passwords do not match!")
            passwd1.focus();
            result = false;
        }

        return result;
}

function allDigits(str)
{
	return inValidCharSet(str,"0123456789");
}

function inValidCharSet(str,charset)
{
	var result = true;

	// Note: doesn't use regular expressions to avoid early Mac browser bugs	
	for (var i=0;i<str.length;i++)
		if (charset.indexOf(str.substr(i,1))<0)
		{
			result = false;
			break;
		}
	
	return result;
}

function validEmail(formField,fieldLabel,required)
{
	var result = true;
	
	if (required && !validRequired(formField,fieldLabel))
		result = false;

	if (result && ((formField.value.length < 3) || !isEmailAddr(formField.value)) )
	{
		alert("Please enter a complete email address in the form: yourname@yourdomain.com");
		formField.focus();
		result = false;
	}
   
  return result;

}

function validNum(formField,fieldLabel,required)
{
	var result = true;

	if (required && !validRequired(formField,fieldLabel))
		result = false;
  
 	if (result)
 	{
 		if (!allDigits(formField.value))
 		{
 			alert("Please enter a number for "+ fieldLabel);
			formField.focus();		
			result = false;
		}
	} 
	
	return result;
}


function validInt(formField,fieldLabel,required)
{
	var result = true;

	if (required && !validRequired(formField,fieldLabel))
		result = false;
  
 	if (result)
 	{
 		var num = parseInt(formField.value);
 		if (isNaN(num))
 		{
 			alert("Please enter a number for "+ fieldLabel);
			formField.focus();		
			result = false;
		} else if (num != formField.value) 
		{
                        alert("Please enter an integer value for "+ fieldLabel);
                        formField.focus();
                        result = false;
                }
	} 
	
	return result;
}


// Begin 4681962 - Admin_GUI: Port Number Validation - Allowed range is 1-65535

function validPort (formField)
{       
	var result = true; 
		        
	if (formField.value < 1 || formField.value > 65535) {
		alert(formField.value + " is not a valid port number. Allowed values are 1-65535.");
		formField.focus();
		result = false;
	}

	return result;
}

// End 4681962


//Begin 4685308
function validPositiveInt(formField,fieldLabel,required)
{
	var result = true;

	if (required && !validRequired(formField,fieldLabel))
		result = false;

 	if (result)
 	{
 		var num = parseInt(formField.value);
 		if (isNaN(num))
 		{
 			alert("Please enter a positive number for "+ fieldLabel);
			formField.focus();
			result = false;
		}
                else if(num < 0)
                {
                        alert("Please enter a positive number for "+ fieldLabel);
			formField.focus();
			result = false;


                }
	}

	return result;
}

//End 4685308

function validDate(formField,fieldLabel,required)
{
	var result = true;

	if (required && !validRequired(formField,fieldLabel))
		result = false;
  
 	if (result)
 	{
 		var elems = formField.value.split("/");
 		
 		result = (elems.length == 3); // should be three components
 		
 		if (result)
 		{
 			var month = parseInt(elems[0]);
  			var day = parseInt(elems[1]);
 			var year = parseInt(elems[2]);
			result = allDigits(elems[0]) && (month > 0) && (month < 13) &&
					 allDigits(elems[1]) && (day > 0) && (day < 32) &&
					 allDigits(elems[2]) && ((elems[2].length == 2) || (elems[2].length == 4));
 		}
 		
  		if (!result)
 		{
 			alert("Please enter a date in the format MM/DD/YYYY for the "+ fieldLabel);
			formField.focus();		
		}
	} 
	
	return result;
}

function validCertificateNickName(formField)
{
    var result = true;

	if(formField.selectedIndex==0) {
		result = false;
	}
    return result;
}
/*======================================================================
	Logic is used in "Create" and "Update" screens to submit form values as href.
====================================================================== */
function okButtonClicked() {
  if (validateForm()) {
    document.forms[0].action='../module1/'+document.forms[0].name+'?'+document.forms[0].name+'.Ok=&jato.pageSession=';
    document.forms[0].submit();
    return false;
  }
}

function cancelButtonClicked() {
    document.forms[0].action='../module1/'+document.forms[0].name+'?'+document.forms[0].name+'.Cancel=&jato.pageSession=';
    document.forms[0].submit();
  return false;
}

function saveButtonClicked() {
  if (validateForm()) {
    document.forms[0].action='../module1/'+document.forms[0].name+'?'+document.forms[0].name+'.Save=&jato.pageSession=';
    document.forms[0].submit();
    return false;
  }
}

function revertButtonClicked() {
    document.forms[0].action='../module1/'+document.forms[0].name+'?'+document.forms[0].name+'.Revert=&jato.pageSession=';
    document.forms[0].submit();
    return false;
}

function editPropsButtonClicked() {
    document.forms[0].action='../module1/'+document.forms[0].name+'?'+document.forms[0].name+'.EditAttributes=&jato.pageSession=';
    document.forms[0].submit();
    return false;
}

function deleteButtonClicked() {
    if (validateForm()) {
    document.forms[0].action='../module1/'+document.forms[0].name+'?'+document.forms[0].name+'.Delete=&jato.pageSession=';
    document.forms[0].submit();
    return false;
    }
}
/*======================================================================
	confirmSubmit() is used to request confirmation before continuing with action(i.e. delete).
====================================================================== */
function confirmSubmit(msg)
{
    var agree=confirm(msg);
    if (agree)
       return true ;
    else
       return false ;
    return true;
} 

//4674875 
/*======================================================================
 LTrim: Returns a String containing a copy of a specified 
        string without leading spaces 
====================================================================== */
function LTrim(String)
{
	var i = 0;
	var j = String.length - 1;

	if (String == null)
		return (false);

	for (i = 0; i < String.length; i++)
	{
		if (String.substr(i, 1) != ' ' &&
		    String.substr(i, 1) != '\t')
			break;
	}

	if (i <= j)
		return (String.substr(i, (j+1)-i));
	else
		return ('');
}

/*======================================================================
 RTrim: Returns a String containing a copy of a specified 
        string without trailing spaces 
====================================================================== */
function RTrim(String)
{
	var i = 0;
	var j = String.length - 1;

	if (String == null)
		return (false);

	for(j = String.length - 1; j >= 0; j--)
	{
		if (String.substr(j, 1) != ' ' &&
			String.substr(j, 1) != '\t')
		break;
	}

	if (i <= j)
		return (String.substr(i, (j+1)-i));
	else
		return ('');
}

/*======================================================================
 RTrim: Returns a String containing a copy of a specified 
        string without both leading and trailing spaces 
====================================================================== */
function Trim(String)
{
	if (String == null)
		return (false);

	return RTrim(LTrim(String));
}

/*======================================================================
validateForWhiteSpaces: Returns  false if the field contains leading/tailing white spaces 
====================================================================== */

function validateForWhiteSpaces(formField,fieldLabel)
{
	var result = true;

 	if (Trim(formField.value) != "" && formField.value != Trim(formField.value))
 		{      
 			alert("No leading/tailing white spaces allowed in "+ fieldLabel);
			formField.focus();		
			result = false;
		}
	
	return result;
}

/*======================================================================
====================================================================== */

function getPrimaryHighlightColor() {
    return "#ccccff";
}

function getSecondaryHighlightColor() {
    return "#99cccc";
}

function findFrameRecursive( winOrFrame, frameName ) {
  // 1. CHECK THIS FRAME (winOrFrame)
  if ( winOrFrame.name && (winOrFrame.name == frameName) )
		return winOrFrame;

  // 2. SEARCH SUBFRAMES.  note: when there are no sub-frames,
  // the frames array has 1 entry which is this frame,
  // hense this check for 2+ subframes
  if ( winOrFrame.frames.length < 2 )
    return null;

  // recurse
  for ( i= 0 ; i < winOrFrame.frames.length ; i++ ) {
    var x= findFrameRecursive( winOrFrame.frames[i], frameName );
    if ( x )
      return x;
  }
  return null;
}

function findFrame( frameName ) {
	return findFrameRecursive( top, frameName );
}

function refreshTree() {
    var treeFrame = findFrame("index");
    if (treeFrame == null)
        return true;
    treeFrame.document.forms[0].submit();
    refreshMastHead();
    return true;
}
function refreshMastHead() {
    synchronizeLeft();
    var headerFrame = findFrame("header");
    if (headerFrame == null)
        return true;
    if (headerFrame.document == null)
        return true;
    if (headerFrame.document.forms == null)
        return true;
    if (headerFrame.document.forms[0] == null)
        return true;
    headerFrame.document.forms[0].submit();
    return true;
}

function updateStatus() {
    var f= findFrame( "content" );
    if ( !f ) {
        f= findFrame( "main" );
        if ( !f ) {
            f= findFrame( "main-header");
            if ( !f ) {
                return true;
            }
        }
    }
    form = f.document.forms[0];
    if (!form) {
        defaultStatus="";
        return true;
    }
    st = form.elements["status"];
    if ( !st ) {
        defaultStatus="";
        return true;
    }
    defaultStatus = st.value;
    return true;
}

function synchronizeLeft() {
    var treeFrame= findFrame( "index" );
    var contentFrame = findFrame( "main-header" );
    if (contentFrame == null) {
        contentFrame = findFrame( "main" );
    }
    if (treeFrame == null || contentFrame == null) {
        //alert("cant find frames");
        return true;
    }
    var form = contentFrame.document.forms[0];
    if (!form){
        //alert("no form:"+contentFrame);
        return true;
    }
    hlid = form.elements["highlightid"];
    if (!hlid) {
        //alert("no highligh id");
        return true;
    }
    //alert("hlid="+hlid.value);
    if (treeFrame.highlightNode) {
      var path = hlid.value;
      if (path == null)
        return true;
      var arr = path.split(".");
      if (arr == null)
        return true;
      var i = 0;
      var color = getPrimaryHighlightColor();
      while (treeFrame.highlightNode(arr[i], color) == false) {
        i++;
        if (i == arr.length)
          break;
        color = getSecondaryHighlightColor();
      }
    }
    return true;
}

function skipOverTree() {
    var f= findFrame( "content" );  // 1st search for iWS content frame
    if ( !f ) //
    f= findFrame( "main" )  // then search for iAS content frame
    if ( !f )
        return;
    f.focus();
}

function openInHelpWindow( newURL ) {
	win= window.open("../help/index.html?"+newURL, "HelpWindow" );
	win.focus();
}  

function validIPAddress(formField, fieldLabel) {
        // Pattern: Possible white space & then dot followed by possible white space
	var result = true;
        pattern = /\s*\.\s*/;
        pattern2 = /\s*\:\s*/;
        addrList = formField.value.split (pattern);
        ipv6Addr = formField.value.split(pattern2);
        
   if (formField.value.indexOf(":")!= -1){
        var valid = '0123456789ABCDEFabcdef.';
        var address = "";
        for (i=0; i < ipv6Addr.length; i++){
            var values = ipv6Addr[i];
            address += values; 
        }
        for (i=0; i < address.length; i++){
            if (valid.indexOf(address.charAt(i)) == -1) {
                alert('IP Address is invalid');
                formField.focus();
                result = false;
                break;
            }
        }
   } 
   else if ((formField.value == "any") || (formField.value == "ANY") || (formField.value == "INADDR_ANY"))  {
        result = true;
   } 
   else {
        if (addrList.length != 4){
            alert("IP Address is invalid");
            formField.focus();
            result = false;
        }
        else {
            var addr = "";
            for ( i = 0; i < addrList.length; i++) {
                var num = parseInt(addrList[i]);
                if (isNaN(num))
                {
                        alert("Please enter a number for "+ fieldLabel);
                        formField.focus();
                        result = false;
                        exit;
                }
                else {
                    if (addrList[i] < 0 || addrList[i] > 255) {
                        alert("IP Address is invalid");
                        formField.focus();
                        result = false;
                        exit;
                    } else {
                        addr += num;
                        if (i < 3) addr += ".";
                        result = true;
                    }
                }
            }

            if (result == true) {
                formField.value = addr;
            }
        }
   }
   return result;
}
function enableSSL2Ciphers(theForm, ssl2field) {
    var rc4 = theForm.name+".SSLContainerView.rc4";
    var rc4export = theForm.name+".SSLContainerView.rc4export";
    var rc2 = theForm.name+".SSLContainerView.rc2";
    var rc2export = theForm.name+".SSLContainerView.rc2export";
    var idea = theForm.name+".SSLContainerView.idea";
    var des = theForm.name+".SSLContainerView.des";
    var desede3 = theForm.name+".SSLContainerView.desede3";

    for(i = 0; i < theForm.elements.length; i++) {
       if(ssl2field.checked) {
        if(theForm.elements[i].name == rc4||theForm.elements[i].name == rc4export || 
            theForm.elements[i].name == desede3){
                theForm.elements[i].checked = true;
        }
       }
       else {
        if(theForm.elements[i].name == rc4||theForm.elements[i].name == rc4export ||
            theForm.elements[i].name == desede3 || theForm.elements[i].name == rc2 ||
            theForm.elements[i].name == rc2export || theForm.elements[i].name == idea ||
            theForm.elements[i].name == des){
                theForm.elements[i].checked = false;
        }
       }
    }
    return true;
}
function enableSSLTLSCiphers(theForm, ssltlsfield) {
    var rc4md5128 = theForm.name+".SSLContainerView.rsa_rc4_128_md5";
    var rsa3des = theForm.name+".SSLContainerView.rsa_3des_sha";
    var rsades = theForm.name+".SSLContainerView.rsa_des_sha";
    var rc4md540 = theForm.name+".SSLContainerView.rsa_rc4_40_md5";
    var rc2md540 = theForm.name+".SSLContainerView.rsa_rc2_40_md5";
    var rsanull = theForm.name+".SSLContainerView.rsa_null_md5";
    var rsarc456sha = theForm.name+".SSLContainerView.rsa_rc4_56_sha";
    var rsa56dessha = theForm.name+".SSLContainerView.rsa_des_56_sha";
    var tlsfieldname = theForm.name+".SSLContainerView.TLSEnable";
    var ssl3fieldname = theForm.name+".SSLContainerView.SSL3Enable";
    var tlsfield;
    var ssl3field;

    for(i = 0; i < theForm.elements.length; i++) {
       if(theForm.elements[i].name == tlsfieldname) {
        tlsfield = theForm.elements[i];
       }
       if(theForm.elements[i].name == ssl3fieldname) {
        ssl3field = theForm.elements[i];
       }
    }

    for(i = 0; i < theForm.elements.length; i++) {
       if(ssltlsfield.checked) {
        if(theForm.elements[i].name == rc4md5128||theForm.elements[i].name == rsa3des || 
            theForm.elements[i].name == rsarc456sha||theForm.elements[i].name == rsades||
            theForm.elements[i].name == rsa56dessha) {
                theForm.elements[i].checked = true;
        }
       }
       else {
        if(theForm.elements[i].name == rc4md5128||theForm.elements[i].name == rsa3des||
            theForm.elements[i].name == rc4md540||theForm.elements[i].name == rc2md540|| 
            theForm.elements[i].name == rsanull||theForm.elements[i].name == rsarc456sha||
            theForm.elements[i].name == rsades||theForm.elements[i].name == rsa56dessha){
                if(!(ssl3field.checked) && !(tlsfield.checked))
                    theForm.elements[i].checked = false;
        }
       }
    }
    return true;
}

/*function enableTLSCiphers(theForm, tlsfield) {
    var rsa56sha = theForm.name+".SSLContainerView.rsa_des_56_sha";
    var rsarc456sha = theForm.name+".SSLContainerView.rsa_rc4_56_sha";
    var ssl3fieldname = theForm.name+".SSLContainerView.SSL3Enable";
    var ssl3field;
    
    for(i = 0; i < theForm.elements.length; i++) {
       if(theForm.elements[i].name == ssl3fieldname) {
        ssl3field = theForm.elements[i];
        break;
       }
    }

    for(i = 0; i < theForm.elements.length; i++) {
       if(tlsfield.checked) {
        if(theForm.elements[i].name == rsa56sha||theForm.elements[i].name == rsarc456sha) {
                theForm.elements[i].checked = true;
        }
       }
       else {
        if(theForm.elements[i].name == rsa56sha) {
                theForm.elements[i].checked = false;        
        }
        if(theForm.elements[i].name == rsarc456sha && !(ssl3field.checked)){
            theForm.elements[i].checked = false;
        }
       }
    }
    return true;
}*/
function validSSLTLS(theForm)
{
    var result = false;
    var ssl2field = theForm.name+".SSLContainerView.SSL2Enable";
    var ssl3field = theForm.name+".SSLContainerView.SSL3Enable";
    var tlsfield = theForm.name+".SSLContainerView.TLSEnable";

    for(i = 0; i < theForm.length; i++) {
        if(theForm.elements[i].name == ssl2field || theForm.elements[i].name == ssl3field ||
            theForm.elements[i].name == tlsfield) {
            if(theForm.elements[i].checked) {
                result = true;
                break;
            }
	}
    }
    return result;  
}
function checkSSL3TLSCiphers(theForm) {
    var rc4md5128 = theForm.name+".SSLContainerView.rsa_rc4_128_md5";
    var rsa3des = theForm.name+".SSLContainerView.rsa_3des_sha";
    var rsades = theForm.name+".SSLContainerView.rsa_des_sha";
    var rc4md540 = theForm.name+".SSLContainerView.rsa_rc4_40_md5";
    var rc2md540 = theForm.name+".SSLContainerView.rsa_rc2_40_md5";
    var rsanull = theForm.name+".SSLContainerView.rsa_null_md5";
    var rsarc456sha = theForm.name+".SSLContainerView.rsa_rc4_56_sha";
    var rsarcdes56sha = theForm.name+".SSLContainerView.rsa_des_56_sha";
    var result = false;
    
    for(i = 0; i < theForm.elements.length; i++) { 
        if(theForm.elements[i].name == rc4md5128||theForm.elements[i].name == rsa3des ||
            theForm.elements[i].name == rsades || theForm.elements[i].name == rc4md540 ||
            theForm.elements[i].name == rc2md540 || theForm.elements[i].name == rsanull ||
            theForm.elements[i].name == rsarcdes56sha){
                if(theForm.elements[i].checked) {
                    result = true;
                    break;
                }
        }
         
    }
    return result;
}
function checkSSL2Ciphers(theForm) {
    var rc4 = theForm.name+".SSLContainerView.rc4";
    var rc4export = theForm.name+".SSLContainerView.rc4export";
    var rc2 = theForm.name+".SSLContainerView.rc2";
    var rc2export = theForm.name+".SSLContainerView.rc2export";
    var idea = theForm.name+".SSLContainerView.idea";
    var des = theForm.name+".SSLContainerView.des";
    var desede3 = theForm.name+".SSLContainerView.desede3";
    var result = false;

    for(i = 0; i < theForm.elements.length; i++) {
       
        if(theForm.elements[i].name == rc4||theForm.elements[i].name == rc4export ||
            theForm.elements[i].name == desede3 || theForm.elements[i].name == rc2 ||
            theForm.elements[i].name == rc2export || theForm.elements[i].name == idea ||
            theForm.elements[i].name == des){
                if(theForm.elements[i].checked) {
                    result = true;
                    break;
               }
        }
    }
    return result;
}

function checkSSL2(ssl2field) {
    var theForm = document.forms[0];
    enableSSL2Ciphers(theForm, ssl2field);
    return true;
}

function checkSSL3(ssl3field) {
    var theForm = document.forms[0];
    enableSSLTLSCiphers(theForm, ssl3field);
    return true;
}

function checkTLS(tlsfield) {
    var theForm = document.forms[0];
    enableSSLTLSCiphers(theForm, tlsfield);
    return true;
}
/*======================================================================
 Determines browser version and writes appropriate stylesheet reference
====================================================================== */
//<!--
// Ultimate client-side JavaScript client sniff. Version 3.03
// (C) Netscape Communications 1999.  Permission granted to reuse and distribute.
// Revised 17 May 99 to add is_nav5up and is_ie5up (see below).
// Revised 20 Dec 00 to add is_gecko and change is_nav5up to is_nav6up
//                      also added support for IE5.5 Opera4&5 HotJava3 AOLTV
// Revised 22 Feb 01 to correct Javascript Detection for IE 5.x, Opera 4, 
//                      correct Opera 5 detection
//                      add support for winME and win2k
//                      synch with browser-type-oo.js
// Revised 26 Mar 01 to correct Opera detection
// Revised 02 Oct 01 to add IE6 detection

// Everything you always wanted to know about your JavaScript client
// but were afraid to ask. Creates "is_" variables indicating:
// (1) browser vendor:
//     is_nav, is_ie, is_opera, is_hotjava, is_webtv, is_TVNavigator, is_AOLTV
// (2) browser version number:
//     is_major (integer indicating major version number: 2, 3, 4 ...)
//     is_minor (float   indicating full  version number: 2.02, 3.01, 4.04 ...)
// (3) browser vendor AND major version number
//     is_nav2, is_nav3, is_nav4, is_nav4up, is_nav6, is_nav6up, is_gecko, is_ie3,
//     is_ie4, is_ie4up, is_ie5, is_ie5up, is_ie5_5, is_ie5_5up, is_ie6, is_ie6up, is_hotjava3, is_hotjava3up,
//     is_opera2, is_opera3, is_opera4, is_opera5, is_opera5up, is_aol3, is_aol4, is_aol5, is_aol6
// (4) JavaScript version number:
//     is_js (float indicating full JavaScript version number: 1, 1.1, 1.2 ...)
// (5) OS platform and version:
//     is_win, is_win16, is_win32, is_win31, is_win95, is_winnt, is_win98, is_winme, is_win2k
//     is_os2
//     is_mac, is_mac68k, is_macppc
//     is_unix
//     is_sun, is_sun4, is_sun5, is_suni86
//     is_irix, is_irix5, is_irix6
//     is_hpux, is_hpux9, is_hpux10
//     is_aix, is_aix1, is_aix2, is_aix3, is_aix4
//     is_linux, is_sco, is_unixware, is_mpras, is_reliant
//     is_dec, is_sinix, is_freebsd, is_bsd
//     is_vms
//
// See http://www.it97.de/JavaScript/JS_tutorial/bstat/navobj.html and
// http://www.it97.de/JavaScript/JS_tutorial/bstat/Browseraol.html
// for detailed lists of userAgent strings.
//
// Note: you don't want your Nav4 or IE4 code to "turn off" or
// stop working when new versions of browsers are released, so
// in conditional code forks, use is_ie5up ("IE 5.0 or greater") 
// is_opera5up ("Opera 5.0 or greater") instead of is_ie5 or is_opera5
// to check version in code which you want to work on future
// versions.

    // convert all characters to lowercase to simplify testing
    var agt=navigator.userAgent.toLowerCase();

    // *** BROWSER VERSION ***
    // Note: On IE5, these return 4, so use is_ie5up to detect IE5.
    var is_major = parseInt(navigator.appVersion);
    var is_minor = parseFloat(navigator.appVersion);

    // Note: Opera and WebTV spoof Navigator.  We do strict client detection.
    // If you want to allow spoofing, take out the tests for opera and webtv.
    var is_nav  = ((agt.indexOf('mozilla')!=-1) && (agt.indexOf('spoofer')==-1)
                && (agt.indexOf('compatible') == -1) && (agt.indexOf('opera')==-1)
                && (agt.indexOf('webtv')==-1) && (agt.indexOf('hotjava')==-1));
    var is_nav2 = (is_nav && (is_major == 2));
    var is_nav3 = (is_nav && (is_major == 3));
    var is_nav4 = (is_nav && (is_major == 4));
    var is_nav4up = (is_nav && (is_major >= 4));
    var is_navonly      = (is_nav && ((agt.indexOf(";nav") != -1) ||
                          (agt.indexOf("; nav") != -1)) );
    var is_nav6 = (is_nav && (is_major == 5));
    var is_nav6up = (is_nav && (is_major >= 5));
    var is_gecko = (agt.indexOf('gecko') != -1);


    var is_ie     = ((agt.indexOf("msie") != -1) && (agt.indexOf("opera") == -1));
    var is_ie3    = (is_ie && (is_major < 4));
    var is_ie4    = (is_ie && (is_major == 4) && (agt.indexOf("msie 4")!=-1) );
    var is_ie4up  = (is_ie && (is_major >= 4));
    var is_ie5    = (is_ie && (is_major == 4) && (agt.indexOf("msie 5.0")!=-1) );
    var is_ie5_5  = (is_ie && (is_major == 4) && (agt.indexOf("msie 5.5") !=-1));
    var is_ie5up  = (is_ie && !is_ie3 && !is_ie4);
    var is_ie5_5up =(is_ie && !is_ie3 && !is_ie4 && !is_ie5);
    var is_ie6    = (is_ie && (is_major == 4) && (agt.indexOf("msie 6.")!=-1) );
    var is_ie6up  = (is_ie && !is_ie3 && !is_ie4 && !is_ie5 && !is_ie5_5);

    // KNOWN BUG: On AOL4, returns false if IE3 is embedded browser
    // or if this is the first browser window opened.  Thus the
    // variables is_aol, is_aol3, and is_aol4 aren't 100% reliable.
    var is_aol   = (agt.indexOf("aol") != -1);
    var is_aol3  = (is_aol && is_ie3);
    var is_aol4  = (is_aol && is_ie4);
    var is_aol5  = (agt.indexOf("aol 5") != -1);
    var is_aol6  = (agt.indexOf("aol 6") != -1);

    var is_opera = (agt.indexOf("opera") != -1);
    var is_opera2 = (agt.indexOf("opera 2") != -1 || agt.indexOf("opera/2") != -1);
    var is_opera3 = (agt.indexOf("opera 3") != -1 || agt.indexOf("opera/3") != -1);
    var is_opera4 = (agt.indexOf("opera 4") != -1 || agt.indexOf("opera/4") != -1);
    var is_opera5 = (agt.indexOf("opera 5") != -1 || agt.indexOf("opera/5") != -1);
    var is_opera5up = (is_opera && !is_opera2 && !is_opera3 && !is_opera4);

    var is_webtv = (agt.indexOf("webtv") != -1); 

    var is_TVNavigator = ((agt.indexOf("navio") != -1) || (agt.indexOf("navio_aoltv") != -1)); 
    var is_AOLTV = is_TVNavigator;

    var is_hotjava = (agt.indexOf("hotjava") != -1);
    var is_hotjava3 = (is_hotjava && (is_major == 3));
    var is_hotjava3up = (is_hotjava && (is_major >= 3));

    // *** JAVAscript VERSION CHECK ***
    var is_js;
    if (is_nav2 || is_ie3) is_js = 1.0;
    else if (is_nav3) is_js = 1.1;
    else if (is_opera5up) is_js = 1.3;
    else if (is_opera) is_js = 1.1;
    else if ((is_nav4 && (is_minor <= 4.05)) || is_ie4) is_js = 1.2;
    else if ((is_nav4 && (is_minor > 4.05)) || is_ie5) is_js = 1.3;
    else if (is_hotjava3up) is_js = 1.4;
    else if (is_nav6 || is_gecko) is_js = 1.5;
    // NOTE: In the future, update this code when newer versions of JS
    // are released. For now, we try to provide some upward compatibility
    // so that future versions of Nav and IE will show they are at
    // *least* JS 1.x capable. Always check for JS version compatibility
    // with > or >=.
    else if (is_nav6up) is_js = 1.5;
    // NOTE: ie5up on mac is 1.4
    else if (is_ie5up) is_js = 1.3

    // HACK: no idea for other browsers; always check for JS version with > or >=
    else is_js = 0.0;

    // *** PLATFORM ***
    var is_win   = ( (agt.indexOf("win")!=-1) || (agt.indexOf("16bit")!=-1) );
    // NOTE: On Opera 3.0, the userAgent string includes "Windows 95/NT4" on all
    //        Win32, so you can't distinguish between Win95 and WinNT.
    var is_win95 = ((agt.indexOf("win95")!=-1) || (agt.indexOf("windows 95")!=-1));

    // is this a 16 bit compiled version?
    var is_win16 = ((agt.indexOf("win16")!=-1) || 
               (agt.indexOf("16bit")!=-1) || (agt.indexOf("windows 3.1")!=-1) || 
               (agt.indexOf("windows 16-bit")!=-1) );  

    var is_win31 = ((agt.indexOf("windows 3.1")!=-1) || (agt.indexOf("win16")!=-1) ||
                    (agt.indexOf("windows 16-bit")!=-1));

    var is_winme = ((agt.indexOf("win 9x 4.90")!=-1));
    var is_win2k = ((agt.indexOf("windows nt 5.0")!=-1));

    // NOTE: Reliable detection of Win98 may not be possible. It appears that:
    //       - On Nav 4.x and before you'll get plain "Windows" in userAgent.
    //       - On Mercury client, the 32-bit version will return "Win98", but
    //         the 16-bit version running on Win98 will still return "Win95".
    var is_win98 = ((agt.indexOf("win98")!=-1) || (agt.indexOf("windows 98")!=-1));
    var is_winnt = ((agt.indexOf("winnt")!=-1) || (agt.indexOf("windows nt")!=-1));
    var is_win32 = (is_win95 || is_winnt || is_win98 || 
                    ((is_major >= 4) && (navigator.platform == "Win32")) ||
                    (agt.indexOf("win32")!=-1) || (agt.indexOf("32bit")!=-1));

    var is_os2   = ((agt.indexOf("os/2")!=-1) || 
                    (navigator.appVersion.indexOf("OS/2")!=-1) ||   
                    (agt.indexOf("ibm-webexplorer")!=-1));

    var is_mac    = (agt.indexOf("mac")!=-1);
    // hack ie5 js version for mac
    if (is_mac && is_ie5up) is_js = 1.4;
    var is_mac68k = (is_mac && ((agt.indexOf("68k")!=-1) || 
                               (agt.indexOf("68000")!=-1)));
    var is_macppc = (is_mac && ((agt.indexOf("ppc")!=-1) || 
                                (agt.indexOf("powerpc")!=-1)));

    var is_sun   = (agt.indexOf("sunos")!=-1);
    var is_sun4  = (agt.indexOf("sunos 4")!=-1);
    var is_sun5  = (agt.indexOf("sunos 5")!=-1);
    var is_suni86= (is_sun && (agt.indexOf("i86")!=-1));
    var is_irix  = (agt.indexOf("irix") !=-1);    // SGI
    var is_irix5 = (agt.indexOf("irix 5") !=-1);
    var is_irix6 = ((agt.indexOf("irix 6") !=-1) || (agt.indexOf("irix6") !=-1));
    var is_hpux  = (agt.indexOf("hp-ux")!=-1);
    var is_hpux9 = (is_hpux && (agt.indexOf("09.")!=-1));
    var is_hpux10= (is_hpux && (agt.indexOf("10.")!=-1));
    var is_aix   = (agt.indexOf("aix") !=-1);      // IBM
    var is_aix1  = (agt.indexOf("aix 1") !=-1);    
    var is_aix2  = (agt.indexOf("aix 2") !=-1);    
    var is_aix3  = (agt.indexOf("aix 3") !=-1);    
    var is_aix4  = (agt.indexOf("aix 4") !=-1);    
    var is_linux = (agt.indexOf("inux")!=-1);
    var is_sco   = (agt.indexOf("sco")!=-1) || (agt.indexOf("unix_sv")!=-1);
    var is_unixware = (agt.indexOf("unix_system_v")!=-1); 
    var is_mpras    = (agt.indexOf("ncr")!=-1); 
    var is_reliant  = (agt.indexOf("reliantunix")!=-1);
    var is_dec   = ((agt.indexOf("dec")!=-1) || (agt.indexOf("osf1")!=-1) || 
           (agt.indexOf("dec_alpha")!=-1) || (agt.indexOf("alphaserver")!=-1) || 
           (agt.indexOf("ultrix")!=-1) || (agt.indexOf("alphastation")!=-1)); 
    var is_sinix = (agt.indexOf("sinix")!=-1);
    var is_freebsd = (agt.indexOf("freebsd")!=-1);
    var is_bsd = (agt.indexOf("bsd")!=-1);
    var is_unix  = ((agt.indexOf("x11")!=-1) || is_sun || is_irix || is_hpux || 
                 is_sco ||is_unixware || is_mpras || is_reliant || 
                 is_dec || is_sinix || is_aix || is_linux || is_bsd || is_freebsd);

    var is_vms   = ((agt.indexOf("vax")!=-1) || (agt.indexOf("openvms")!=-1));


  if (is_gecko | is_ie5up) // Netscape6/Mozilla or IE5
  {
   document.write("<LINK href='../html/css_ie5win.css' type='text/css' rel='stylesheet'>") 
  }
  else if (is_nav4 && is_win) // Netscape 4 Windows
  {
   document.write("<LINK href='../html/css_ns4win.css' type='text/css' rel='stylesheet'>") 
  }
  else if (is_nav4 && is_sun) // Netscape 4 Solaris
  {
   document.write("<LINK href='../html/css_ns4sol.css' type='text/css' rel='stylesheet'>") 
  }
  else  // All others
  {
   document.write("<LINK href='../html/css_generic.css' type='text/css' rel='stylesheet'>") 
  }

//--> end hide JavaScript
