/* $Id: CookieExample.java,v 1.1.2.3.4.1 2004/03/02 23:58:43 svbld Exp $
 *
 */

package samples.webapps.simple.servlet;

import java.io.*;
import java.text.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;

/**
 * Example servlet showing cookie handling
 *
 * @author James Duncan Davidson <duncan@eng.sun.com>
 */

public class CookieExample extends HttpServlet {

    public void doGet(HttpServletRequest request,
                      HttpServletResponse response)
        throws IOException, ServletException
    {
        ResourceBundle rb =
            ResourceBundle.getBundle("LocalStrings",request.getLocale());
        response.setContentType("text/html");

        PrintWriter out = response.getWriter();
        out.println("<html>");
        out.println("<body bgcolor=\"white\">");
        out.println("<head>");

        String title = rb.getString("cookies.title");
        out.println("<title>" + title + "</title>");
        out.println("</head>");
        out.println("<body>");

	// relative links

        out.println("<a href=\"" + request.getContextPath() + "/servlets/cookies.html\">");
        out.println("<img src=\"" + request.getContextPath() + "/images/code.gif\" height=24 " +
                    "width=24 align=right border=0 alt=\"view code\"></a>");
        out.println("<a href=\"" + request.getContextPath() + "/servlets/index.html\">");
        out.println("<img src=\"" + request.getContextPath() + "/images/return.gif\" height=24 " +
                    "width=24 align=right border=0 alt=\"return\"></a>");

        out.println("<h3>" + title + "</h3>");

        Cookie[] cookies = request.getCookies();
        if ((cookies != null) && (cookies.length > 0)) {
            out.println(rb.getString("cookies.cookies") + "<br>");
            for (int i = 0; i < cookies.length; i++) {
                Cookie cookie = cookies[i];
                out.print("Cookie Name: " + cookie.getName() + "<br>");
                out.println("  Cookie Value: " + cookie.getValue() +
			    "<br><br>");
            }
        } else {
            out.println(rb.getString("cookies.no-cookies"));
        }

        // Encode cookie name and values to avoid potential XSS attack at the client
        String cookieName = Encoder.encode(request.getParameter("cookiename"));
        String cookieValue = Encoder.encode(request.getParameter("cookievalue"));
        if (cookieName != null && cookieValue != null) {
          if ((!cookieName.trim().equals("")) && (isAlphaNumeric(cookieName)) && (!cookieValue.trim().equals(""))) {
            Cookie cookie = new Cookie(cookieName, cookieValue);
            response.addCookie(cookie);
            out.println("<P>");
            out.println(rb.getString("cookies.set") + "<br>");
            out.print(rb.getString("cookies.name") + "  " + cookieName +
		      "<br>");
            out.print(rb.getString("cookies.value") + "  " + cookieValue);
          }
        }
        
        out.println("<P>");
        out.println(rb.getString("cookies.make-cookie") + "<br>");
        out.print("<form action=\"");
        out.println("CookieExample\" method=POST>");
        out.print(rb.getString("cookies.name") + "  ");
        out.println("<input type=text length=20 name=cookiename><br>");
        out.print(rb.getString("cookies.value") + "  ");
        out.println("<input type=text length=20 name=cookievalue><br>");
        out.println("<input type=submit></form>");
            
            
        out.println("</body>");
        out.println("</html>");
    }

    public void doPost(HttpServletRequest request,
                      HttpServletResponse response)
        throws IOException, ServletException
    {
        doGet(request, response);
    }

    public boolean isAlphaNumeric(String input) {
        if (input == null)
            return false;

        StringBuffer inputsb = new StringBuffer(input);

        for (int i = 0; i < inputsb.length(); i++) {
            if (!Character.isLetterOrDigit(inputsb.charAt(i))) {
                return false;
            }
        }
        return true;
    }

}


